/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.awt.Component;
import java.awt.Container;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DefaultNameGenerator;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DBReservedWords;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.i18n.text.OraUnicodeProperty;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockableView;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.PropertyInspector;
import oracle.ideimpl.inspector.InspectorWindowImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;

public class StringUtils {
    private static final Logger LOGGER = Logger.getLogger(StringUtils.class.getName());
    static final char DOLLAR_SIGN = '$';
    static final char POUND_SIGN = '#';
    static final char UNERSCORE = '_';
    static final char DOUBLE_QUOTE = '\"';
    static final char SINGLE_QUOTE = '\"';
    static final char DOT = '.';
    static final String ROWID = "ROWID";
    static final String SQL_SCRIPT_ESCAPE_CHAR = "\\";
    public static final int MAX_DISPLAYBALE_STRING_LENGTH = 40;
    static final String DB_CHAR_LENGTH_ANONYMOUS_BLOCK = "DECLARE\n  v_length_string integer := 0;\n  v_sql_stmt      VARCHAR2(32627);\nBEGIN\n  v_sql_stmt := 'SELECT LENGTHB(''<INPUT_STRING>'') FROM DUAL';\n  EXECUTE IMMEDIATE v_sql_stmt INTO v_length_string;\n  --DBMS_OUTPUT.PUT_LINE ('Length of string : ' || v_length_string );\n  ? := v_length_string;\nEND;";
    public static final String EMPTY = "";
    private static volatile BlockingComponent overLayPanel = null;
    private static final String LINE_SEPARATOR_PATTERN = "\r\n|[\n\r\u2028\u2029\u0085]";

    public static char stripFirstCharFromString(String string) {
        char c = 'Z';
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0) {
            c = stringBuffer.charAt(0);
        }
        return c;
    }

    public static boolean isDoubleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public static String addSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "'" + string + "'";
    }

    public static String addDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "\"" + string + "\"";
    }

    public static String trimDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isSingleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("'") && string.endsWith("'") && string.length() > 1;
    }

    public static boolean isGreater32BytesInDB(String string, ConnectionManager connectionManager) {
        return !StringUtils.checkStringDBLengthMax(string, connectionManager, 30, false);
    }

    public static String trimSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String removeBlankLines(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replaceAll("\n{2,}", "\n");
        string2 = string2.replaceAll("\r\n{2,}", "\r\n");
        string2 = string2.replaceAll("\r{2,}", "\r");
        return string2;
    }

    public static String removeLineSeparator(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replaceAll(LINE_SEPARATOR_PATTERN, EMPTY);
        return string2;
    }

    public static String getReplacedString(String string, String string2, String string3) {
        if (string == null) {
            return EMPTY;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.length() > 0) {
            int n2 = string.indexOf(string2, n);
            while (n2 >= 0) {
                stringBuilder.append(string.substring(n, n2));
                stringBuilder.append(string3);
                n = n2 + string2.length();
                n2 = string.indexOf(string2, n);
            }
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public static String escapeCharacterForSQLScript(String string, String string2) {
        return StringUtils.getReplacedString(string, string2, SQL_SCRIPT_ESCAPE_CHAR + string2);
    }

    public static String escapeSingleQuotesForSQL(String string) {
        return StringUtils.getReplacedString(string, "'", "''");
    }

    public static String processQuotedName(String string) {
        String string2 = StringUtils.trimDoubleQuotes(string);
        string2 = StringUtils.getReplacedString(string2, "'", "''");
        return string2;
    }

    public static String stripDataSource(String string) {
        try {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() > 0 && (n = string.lastIndexOf("FROM")) >= 0) {
                stringBuffer.append(string.substring(0, n + 4));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getTargetUserFromProxyTNSUser(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() > 0) {
                int n = 0;
                int n2 = 0;
                n = string.lastIndexOf("[");
                n2 = string.lastIndexOf("]");
                if (n > 0 && n2 > 0 && n < n2 && n2 + 1 == string.length()) {
                    stringBuffer.append(string.subSequence(n + 1, n2));
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static ArrayList<String> chopString(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3;
            for (n3 = Math.min(n + i, n2); n3 < n2 - 1 && string.charAt(n3 + 1) == '\''; ++n3) {
            }
            String string2 = string.substring(i, n3);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean checkStringLength(String string, int n) {
        if (string == null) {
            return false;
        }
        return string.length() <= n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkStringDBLengthLong(String string, ConnectionManager connectionManager) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.length() == 0) {
            return n;
        }
        SQLHelper sQLHelper = new SQLHelper();
        CLOB cLOB = null;
        try {
            sQLHelper.conn = connectionManager.getConnection();
            cLOB = StringUtils.getTempClob(string, sQLHelper.conn);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("begin ? := ODMR_UTIL.get_clob_byte_length(?); end;");
            sQLHelper.cstmt.registerOutParameter(1, 4);
            sQLHelper.cstmt.setClob(2, (Clob)cLOB);
            sQLHelper.cstmt.execute();
            n = sQLHelper.cstmt.getInt(1);
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        finally {
            try {
                if (cLOB != null) {
                    cLOB.freeTemporary();
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
            }
            sQLHelper.close();
        }
        return n;
    }

    public static CLOB getTempClob(String string, Connection connection) {
        CLOB cLOB = null;
        try {
            cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            cLOB.open(1);
            Writer writer = cLOB.setCharacterStream(0L);
            writer.write(string);
            writer.flush();
            writer.close();
            cLOB.close();
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINEST, " Error creating temporary clob to hold a string : " + exception.toString());
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkStringDBLength(String string, ConnectionManager connectionManager, boolean bl) {
        int n = 0;
        String string2 = "select LENGTHB(?) from DUAL";
        if (string == null) {
            return n;
        }
        if (bl) {
            try {
                if (DbMetadataUtils.isMultiByteDatabase((ConnectionManager)connectionManager)) {
                    string2 = "select LENGTH(?) from DUAL";
                }
            }
            catch (ODMrDAOException oDMrDAOException) {
                throw new DataMinerException(oDMrDAOException);
            }
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string2);
            sQLHelper.opstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                n = sQLHelper.rs.getInt(1);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createOverLayPanel(JComponent jComponent) {
        if (overLayPanel != null) return;
        Class<StringUtils> clazz = StringUtils.class;
        synchronized (StringUtils.class) {
            if (overLayPanel != null) return;
            JComponent jComponent2 = (JComponent)StringUtils.getChildOfClass(PropertyInspector.class, jComponent);
            Container container = jComponent2.getParent();
            overLayPanel = new BlockingComponent(jComponent2);
            container.add(overLayPanel.getBlockingComponent());
            overLayPanel.setState(BlockingComponent.State.BLOCKED);
            container.validate();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void displayOverLayPanel(Context context) {
        if (InspectorManager.getInspectorManager() != null) {
            for (Object e : InspectorManager.getInspectorManager().getViews()) {
                DockableView dockableView = (DockableView)e;
                if (!dockableView.isVisible() || !(dockableView instanceof InspectorWindowImpl)) continue;
                StringUtils.displayOverLayPanel((JComponent)dockableView.getGUI(), BlockingComponent.Message.BUSY, context);
                JComponent jComponent = (JComponent)StringUtils.getChildOfClass(PropertyInspector.class, (JComponent)dockableView.getGUI());
                dockableView.getGUI().validate();
                dockableView.getGUI().update(dockableView.getGUI().getGraphics());
            }
        }
    }

    public static void displayOverLayPanel(JComponent jComponent, BlockingComponent.Message message, Context context) {
        if (overLayPanel == null) {
            StringUtils.createOverLayPanel(jComponent);
        } else {
            overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        overLayPanel.setMessage(message);
        WorkflowEditor.setEnabledWFEditorOverLayPanel(message, true, context);
    }

    public static void hideOverLayPanel(Context context) {
        if (overLayPanel != null) {
            overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
        WorkflowEditor.setEnabledWFEditorOverLayPanel(null, false, context);
    }

    public static void updatePropertyInspector(Context context, PropertyModel propertyModel) {
        if (InspectorManager.getInspectorManager() != null) {
            for (Object e : InspectorManager.getInspectorManager().getViews()) {
                DockableView dockableView = (DockableView)e;
                if (!dockableView.isVisible() || !(dockableView instanceof InspectorWindowImpl)) continue;
                JComponent jComponent = (JComponent)StringUtils.getChildOfClass(PropertyInspector.class, (JComponent)dockableView.getGUI());
                PropertyInspector propertyInspector = (PropertyInspector)jComponent;
                propertyInspector.updatePropertyEditors(propertyModel);
            }
        }
    }

    public static Component getChildOfClass(Class<?> clazz, JComponent jComponent) {
        if (jComponent == null || clazz == null) {
            return null;
        }
        Component component = null;
        for (Component component2 : jComponent.getComponents()) {
            if (clazz.isInstance(component2)) {
                component = component2;
                break;
            }
            component = StringUtils.getChildOfClass(clazz, (JComponent)component2);
            if (component != null) break;
        }
        return component;
    }

    public static boolean checkDataLossWithMsg(Context context, String string, String string2) {
        return StringUtils.checkDataLossWithMsg(context, string, string2, false);
    }

    public static boolean checkDataLossWithMsg(Context context, String string, String string2, boolean bl) {
        ConnectionFolder connectionFolder;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            StringUtils.displayOverLayPanel(context);
        }
        if (StringUtils.checkDataLoss(connectionFolder = ConnectionFolder.getConnectionFolder(context), string, stringBuffer)) {
            String string3 = MessageFormat.format(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_CONTAINS_SUPPORTED_CHARS"), stringBuffer);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string2, null);
            bl2 = true;
        }
        if (bl) {
            StringUtils.hideOverLayPanel(context);
        }
        return bl2;
    }

    public static String checkDataLossWithNoMsg(Context context, String string) {
        return StringUtils.checkDataLossWithNoMsg(context, string, false);
    }

    public static String checkDataLossWithNoMsg(Context context, String string, boolean bl) {
        ConnectionFolder connectionFolder;
        String string2 = EMPTY;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            StringUtils.displayOverLayPanel(context);
        }
        if (StringUtils.checkDataLoss(connectionFolder = ConnectionFolder.getConnectionFolder(context), string, stringBuffer)) {
            string2 = MessageFormat.format(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_CONTAINS_SUPPORTED_CHARS"), stringBuffer);
        }
        if (bl) {
            StringUtils.hideOverLayPanel(context);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDataLoss(ConnectionManager connectionManager, String string, StringBuffer stringBuffer) {
        if (string == null) {
            return false;
        }
        String string2 = "select TO_CHAR(?) from DUAL";
        String string3 = EMPTY;
        try (SQLHelper sQLHelper = new SQLHelper();){
            int n;
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next() && (string3 = sQLHelper.rs.getString(1)) == null) {
                string3 = EMPTY;
            }
            stringBuffer.setLength(0);
            for (n = 0; n < string.length(); n += 1) {
                char c = string.charAt(n);
                if (c == string3.charAt(n)) continue;
                boolean bl = false;
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    if (c != stringBuffer.charAt(i)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringBuffer.append(c);
            }
            n = string.compareTo(string3) != 0 ? 1 : 0;
            return n != 0;
        }
        return false;
    }

    public static boolean checkStringDBLengthMax(String string, ConnectionManager connectionManager, int n, boolean bl) {
        return StringUtils.checkStringDBLength(string, connectionManager, bl) <= n;
    }

    public static boolean checkStringDBLengthMaxLong(String string, ConnectionManager connectionManager, int n) {
        return StringUtils.checkStringDBLengthLong(string, connectionManager) <= n;
    }

    public static char getMnemonic(String string) {
        assert (string.length() == 1) : "Mnemonic key length not equal to 1.";
        return string.charAt(0);
    }

    public static String createFullyQualifiedName(String string, String string2) {
        String string3 = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string));
        String string4 = string3 + "." + StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string2));
        return string4;
    }

    public static String createNonQuotedCompliantName(String string) {
        String string2 = string.trim();
        char[] cArray = string2.toUpperCase().toCharArray();
        char[] cArray2 = new char[string2.length()];
        cArray2[0] = !Character.isLetter(cArray[0]) ? 65 : cArray[0];
        char c = ' ';
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            cArray2[i] = cArray[i];
            if (!Character.isLetterOrDigit(c)) {
                if (c == '$' || c == '#' || c == '_') continue;
                cArray2[i] = 95;
                continue;
            }
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            cArray2[i] = 95;
        }
        String string3 = new String(cArray2);
        StringBuilder stringBuilder = new StringBuilder(string3);
        while (StringUtils.isDBReservedWord(stringBuilder.toString())) {
            stringBuilder.append("1");
        }
        return stringBuilder.toString();
    }

    public static boolean isDBReservedWord(String string) {
        return DBReservedWords.isReservedWord(string);
    }

    public static boolean isValidNonQuotedDBObjectName(String string) {
        boolean bl = true;
        boolean bl2 = bl = !StringUtils.isDBReservedWord(string);
        if (bl) {
            bl = StringUtils.containsOnlyValidDBNameCharacters(string);
        }
        return bl;
    }

    public static boolean isValidQuotedDBObjectName(String string) {
        boolean bl = true;
        boolean bl2 = bl = !StringUtils.isDBReservedWord(string);
        if (bl) {
            bl = StringUtils.containsNoDoubleQuotes(string);
        }
        return bl;
    }

    public static boolean isEqualToROWID(String string) {
        boolean bl = false;
        if (string.equals(ROWID)) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsNoDoubleQuotes(String string) {
        int n = 32;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 34) continue;
            return false;
        }
        return true;
    }

    public static boolean containsDoubleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf(34) != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsSingleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf(34) != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsNoDot(String string) {
        int n = 32;
        for (int i = 1; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 46) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMultibyteCharactes(String string) {
        boolean bl = false;
        char c = ' ';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (!StringUtils.isMultibyteChar(c)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isMultibyteChar(char c) {
        boolean bl = false;
        char[] cArray = new char[]{c};
        int n = Character.codePointAt(cArray, 0);
        OraUnicodeProperty oraUnicodeProperty = OraUnicodeProperty.getInstance();
        try {
            int n2 = oraUnicodeProperty.getDisplayWidth(n, "EN_US", false);
            if (n2 != 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean containsOnlyValidDBNameCharacters(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            return bl;
        }
        bl = Character.isLetter(string.charAt(0));
        if (bl) {
            char c = ' ';
            for (int i = 1; i < string.length() && bl; ++i) {
                c = string.charAt(i);
                if (StringUtils.isValidDBNameCharacter(c)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isValidDBNameCharacter(char c) {
        boolean bl = true;
        if (!Character.isLetterOrDigit(c)) {
            if (c != '$' && c != '#' && c != '_') {
                bl = false;
            }
        } else if (Character.isLetter(c) && Character.isLowerCase(c)) {
            bl = false;
        }
        return bl;
    }

    public static String generateUniqueName(String string, HashMap hashMap) {
        String string2 = string;
        if (string2.length() > 26) {
            string2 = string2.substring(0, 26);
        }
        String string3 = string2;
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(string3, EMPTY, false);
        string2 = defaultNameGenerator.nextName();
        boolean bl = true;
        do {
            boolean bl2;
            if (bl2 = hashMap.containsKey(string2)) {
                String string4;
                string2 = string4 = defaultNameGenerator.nextName();
                continue;
            }
            bl = false;
        } while (bl);
        return string2;
    }

    public static final boolean isEmpty(String string) {
        return string == null || EMPTY.equals(string);
    }

    public static final boolean isNotEmpty(String string) {
        return string != null && !EMPTY.equals(string);
    }

    public static final boolean isNullOrEmpty(String string) {
        return string == null || EMPTY.equals(string);
    }

    public static final String toSqlList(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(20 * stringArray.length);
        for (String string : stringArray) {
            stringBuilder.append("'");
            stringBuilder.append(string);
            stringBuilder.append("',");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static String join(String string, List<String> list) {
        if (list == null || list.isEmpty()) {
            return EMPTY;
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (StringUtils.isNullOrEmpty(string2)) continue;
            if (!bl) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY;
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (StringUtils.isNullOrEmpty(string2)) continue;
            if (!bl) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String getAbbreviatedText(String string) {
        String string2 = string.length() > 40 ? string.substring(0, 40) + "..." : string;
        return string2;
    }
}

