/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import javax.swing.Icon;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.runner.SchedulePanel;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;

public final class ScheduleTasksWindow
extends DockableWindow {
    public static final String SCHEDULE_WINDOW_ID = "ScheduleManager";
    public static final ViewId VIEW_ID = new ViewId("SCHEDULE_VIEW_TYPE", "ScheduleManager");
    private static volatile ScheduleTasksWindow _instance = null;
    private SchedulePanel schedulePanel;

    public ScheduleTasksWindow() {
        super("SCHEDULE_VIEW_TYPE.ScheduleManager");
        this.setType(32);
    }

    public void dockableShown(DockableEvent dockableEvent) {
        super.dockableShown(dockableEvent);
        if (null == this.getConnectionName()) {
            return;
        }
        this.schedulePanel.switchConnection(true);
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        super.dockableHidden(dockableEvent);
        this.schedulePanel.clearTasks();
    }

    public Toolbar getToolbar() {
        return this.schedulePanel.getToolbar();
    }

    public String getConnectionName() {
        return this.schedulePanel.getConnectionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduleTasksWindow getInstance() {
        if (_instance != null) return _instance;
        Class<ScheduleTasksWindow> clazz = ScheduleTasksWindow.class;
        synchronized (ScheduleTasksWindow.class) {
            if (_instance != null) return _instance;
            _instance = new ScheduleTasksWindow();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public void refresh() {
        this.schedulePanel.switchConnection(true);
    }

    void shutDown() {
        this.schedulePanel.saveSettings();
    }

    public Component getGUI() {
        if (this.schedulePanel == null) {
            this.schedulePanel = new SchedulePanel(this);
        }
        return this.schedulePanel;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_schedulewindow_html");
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public String getTabName() {
        return RunManagerLrb.get("SCHEDULE_WINDOW_TITLE");
    }

    public Icon getTabIcon() {
        return DataMinerIcons.get(Icons.QUEUED);
    }

    public String getTitleName() {
        return RunManagerLrb.get("SCHEDULE_WINDOW_TITLE");
    }

    void clearTasks() {
        this.schedulePanel.clearTasks();
    }
}

