/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SortOrder;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.FeatureCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.FeatureItemsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.GetFeatureAttributesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.GetMaxCoefficientQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.esa.ESACoefStatsQuery;
import oracle.dmt.dataminer.core.model.clas.common.FilterSetting;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.common.build.ColumnFilter;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.model.fe.common.FeatureCoefficient;
import oracle.dmt.dataminer.core.model.fe.common.FeatureItemSet;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.model.filter.WhereSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelDetails;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.jdbc.OraclePreparedStatement;

public class FeatureExtraction
extends Model
implements ModelDetails {
    private static final Logger LOGGER = Logger.getLogger(Model.class.getName());
    public static final String MAXIMUM_ABS_COEFFICIENT_VALUE = "MAXIMUM_ABS_COEFFICIENT_VALUE";
    public static final String TOTAL_COEFFICIENTS = "TOTAL_COEFFICIENTS";
    private static final String FEATURE_ID = "FEATURE_ID";
    private static final String MAPPED_FEATURE_ID = "MAPPED_FEATURE_ID";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.mapped_feature_id IN(:target_values)  ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION_PARTITION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name,:partitionId)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.mapped_feature_id IN(:target_values)  ";
    private static final String QUERY_MIN_MAX = "SELECT  MAX(coefficient) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_nmf('<model_name>')) t, TABLE(t.attribute_set) s";
    private static final String QUERY_MIN_MAX_PARTITION = "SELECT  MAX(coefficient) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_nmf('<model_name>', '<partitionId>')) t, TABLE(t.attribute_set) s";
    private static final String _TARGET_CONDITION = "  WHERE t.mapped_feature_id = <target_value> \n";
    private static final String QUERY_COEFFICIENTS_ALL = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT \n<select_stmt>\n\tfrom ( \tSELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n\t      r.attribute_name || '.' ||  r.attribute_subname \n\t     ELSE r.attribute_name \n\t     END \"attribute_name_subname\", \n\t  r.attribute_name \"attribute_name\", \n\t  r.attribute_value \"attribute_value\", \n\t  r.feature_id \"feature_id\", \n\t  r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(<model_name>)) t, \n   TABLE(t.attribute_set) s \n<target_condition> ) r ) \n<name_filter_condition><group_by>) <order> \n) <rownum> \n";
    private static final String QRY_FEATURE_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"feature_id\", \"mapped_feature_id\", \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\", \n       r.feature_id \"feature_id\",  \n       r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n) <order> \n) <rownum> \n";
    private static final String QRY_FEATURE_COEFFICIENTS_PARTITION = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"feature_id\", \"mapped_feature_id\", \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\", \n       r.feature_id \"feature_id\",  \n       r.mapped_feature_id \"mapped_feature_id\" \n  FROM (SELECT t.feature_id, t.mapped_feature_id, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_nmf(:model_name, :partitionId)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n) <order> \n) <rownum> \n";
    public static final String ALTER_REVERSE_EXPRESSION_FEATURE_ID = "when value = [FEATURE_ID] then ";
    public static final String ALTER_REVERSE_EXPRESSION_CASE_RENAME = "'[NEW_NAME]'\n";
    public static final String ALTER_REVERSE_EXPRESSION_CASE_KEEP_OLD = "'[OLD_NAME]'\n";
    public static final String ALTER_REVERSE_EXPRESSION_CASE_END = "                else TO_CHAR(value) end";
    public static final String ALTER_REVERSE_EXPRESSION_FINAL = "BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n";
    private static final String QRY_FEATURE_COEFFICIENTS_FEATURE_ID = " t.mapped_feature_id = :target_value";
    protected Map<Integer, String> featureIDToLabelMap = new HashMap<Integer, String>();

    public FeatureExtraction(ConnectionManager connectionManager, String string, String string2) {
        super(connectionManager, string, string2);
    }

    public List<TargetPriorsPredictionSet> getTargetValuePredictionSet(PartitionVO partitionVO) throws Exception {
        String string = this.getTargetsValueQuery(partitionVO);
        String string2 = this.getBFILEColumns();
        String string3 = StringUtils.getReplacedString((String)string, (String)"<bfile_workaround>", (String)string2);
        ArrayList<TargetPriorsPredictionSet> arrayList = new ArrayList<TargetPriorsPredictionSet>();
        SQLHelper sQLHelper = new SQLHelper();
        String string4 = null;
        try {
            string4 = DatabaseMetadataUtils.createUniqueTableName("ODMR$", this.connectionManager, "");
            String string5 = "CREATE TABLE " + string4 + " AS " + string3;
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string5);
            sQLHelper.pstmt.executeUpdate();
            string5 = "SELECT FEATURE_ID, VALUE FROM " + string4;
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string5);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = sQLHelper.rs.getMetaData();
            int n = resultSetMetaData.getColumnType(1);
            while (sQLHelper.rs.next()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = null;
                Object object = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object = sQLHelper.rs.getBigDecimal(FEATURE_ID);
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object = sQLHelper.rs.getString(FEATURE_ID);
                } else {
                    throw new ODMrDAOException("Unexpected target data type. Expected either a number or string.");
                }
                targetPriorsPredictionSet = new TargetPriorsPredictionSet(object, n, sQLHelper.rs.getDouble("VALUE"));
                arrayList.add(targetPriorsPredictionSet);
            }
            sQLHelper.close();
            this.initFeatures();
        }
        catch (Exception exception) {
            throw new ODMrDAOException((Throwable)exception);
        }
        finally {
            sQLHelper.close();
            DatabaseMetadataUtils.dropTable(this.connectionManager, null, string4);
        }
        return arrayList;
    }

    private String getTargetsValueQuery(PartitionVO partitionVO) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select FEATURE_ID, VALUE from table(FEATURE_SET( ");
        stringBuilder.append(Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
        if (partitionVO != null && StringUtils.isNotEmpty((String)partitionVO.getPartitionID())) {
            stringBuilder.append(" using ");
            List list = partitionVO.getColumns();
            Function<PartitionColumn, String> function = partitionColumn -> String.format("'%s' as %s", partitionColumn.getValue(), partitionColumn.getColumnName());
            String string = StringUtils.joinElementsByComma((List)list, function);
            stringBuilder.append(string);
            stringBuilder.append(")) ORDER BY FEATURE_ID");
        } else {
            stringBuilder.append(" using <bfile_workaround>))");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFeatures() throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT t.feature_id, t.mapped_feature_id FROM TABLE(dbms_data_mining.get_model_details_nmf('");
        stringBuilder.append(Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
        if (this.modelDescriptor.isPartitioned()) {
            stringBuilder.append("','\"");
            stringBuilder.append(this.modelDescriptor.getPartitionId());
            stringBuilder.append("\"");
        }
        stringBuilder.append("'))");
        stringBuilder.append(" t ORDER BY feature_id");
        try {
            this.featureIDToLabelMap.clear();
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuilder.toString());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt(FEATURE_ID);
                String string = sQLHelper.rs.getString(MAPPED_FEATURE_ID);
                this.featureIDToLabelMap.put(n, string);
            }
        }
        finally {
            sQLHelper.close();
        }
    }

    public TargetPriorsPredictionSet findMostCommonTargetValue(List<TargetPriorsPredictionSet> list) {
        Double d = 0.0;
        Object object = null;
        TargetPriorsPredictionSet targetPriorsPredictionSet = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet2 : list) {
            if (!(d <= targetPriorsPredictionSet2.getProbability())) continue;
            d = targetPriorsPredictionSet2.getProbability();
            object = targetPriorsPredictionSet2.getPrediction();
            targetPriorsPredictionSet = targetPriorsPredictionSet2;
        }
        assert (object != null) : "Unable to find a target value with a prob value >= 0";
        return targetPriorsPredictionSet;
    }

    public Double getMaximumCoefficient(Class<? extends ModelType> clazz) throws ODMrDAOException {
        GetMaxCoefficientQuery getMaxCoefficientQuery = new GetMaxCoefficientQuery(this.connectionManager.getDbVersion(), this.modelDescriptor, clazz);
        Double d = this.dao.readItem((Query)getMaxCoefficientQuery).orElse(0.0);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getMaxValue() {
        String string;
        SQLHelper sQLHelper = new SQLHelper();
        Double d = null;
        if (this.modelDescriptor.isPartitioned()) {
            string = StringUtils.getReplacedString((String)QUERY_MIN_MAX_PARTITION, (String)"<model_name>", (String)Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
            string = StringUtils.getReplacedString((String)string, (String)"<partitionId>", (String)('\"' + this.modelDescriptor.getPartitionId() + '\"'));
        } else {
            string = StringUtils.getReplacedString((String)QUERY_MIN_MAX, (String)"<model_name>", (String)Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
        }
        try {
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            if (sQLHelper.rs.next()) {
                d = sQLHelper.rs.getDouble(1);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            d = null;
        }
        finally {
            sQLHelper.close();
        }
        return d;
    }

    private static String createInternalWhereClause(FilterSetting filterSetting, String string, String string2, String string3) {
        StringBuilder stringBuilder = null;
        if (null != filterSetting.getTargetValue()) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("   WHERE ");
            stringBuilder.append(QRY_FEATURE_COEFFICIENTS_FEATURE_ID);
        }
        if (string != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string);
        }
        if (string != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string);
        }
        if (string2 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string3);
        }
        return StringUtils.toString((Object)stringBuilder);
    }

    private String prepareCoefficientSQL(FilterSetting filterSetting) {
        Object object;
        assert (filterSetting != null) : "FilterSetting can't be null";
        String string = QRY_FEATURE_COEFFICIENTS;
        if (this.modelDescriptor.isPartitioned()) {
            string = QRY_FEATURE_COEFFICIENTS_PARTITION;
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        StringBuilder stringBuilder = new StringBuilder();
        Double d = null;
        Double d2 = null;
        List list = null;
        if (filterSetting.isUseFilterSpecification()) {
            object = filterSetting.getMaxCoefficient();
            if (object != null) {
                d = ((BigDecimal)object).doubleValue();
            }
            if ((object = filterSetting.getMinCoefficient()) != null) {
                d2 = ((BigDecimal)object).doubleValue();
            }
        }
        list = filterSetting.getSortSpecification();
        string2 = "s.coefficient";
        if (d != null) {
            string5 = " AND s.coefficient <= " + d;
        }
        if (d2 != null) {
            string6 = " AND s.coefficient >= " + d2;
        }
        if (filterSetting.getFetchSize() > 0) {
            string3 = " where rownum <= " + filterSetting.getFetchSize();
        }
        if (list != null && list.size() > 0) {
            stringBuilder.append("order by ");
            object = list.iterator();
            while (object.hasNext()) {
                SortSpec sortSpec = (SortSpec)object.next();
                if (!sortSpec.isUseIt()) continue;
                stringBuilder.append("\"" + sortSpec.getAttributeName() + "\" ");
                if (sortSpec.isAscending()) {
                    stringBuilder.append("ASC ");
                } else {
                    stringBuilder.append("DESC NULLS LAST ");
                }
                if (!object.hasNext()) continue;
                stringBuilder.append(",");
            }
            if (stringBuilder.substring(stringBuilder.length() - 1, stringBuilder.length()).equalsIgnoreCase(",")) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        }
        string = StringUtils.getReplacedString((String)string, (String)"<coefficient_value>", (String)string2);
        string = StringUtils.getReplacedString((String)string, (String)"<internal_where_clause>", (String)FeatureExtraction.createInternalWhereClause(filterSetting, string4, string5, string6));
        string = StringUtils.getReplacedString((String)string, (String)"<order>", (String)stringBuilder.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)string3);
        return string;
    }

    private List<AttributeBiCoefficient> invokeCoefficientQuery(String string, String string2) throws SQLException {
        ArrayList<AttributeBiCoefficient> arrayList = new ArrayList<AttributeBiCoefficient>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string2);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false));
            sQLHelper.opstmt.setStringAtName("target_value", string);
            if (this.modelDescriptor.isPartitioned()) {
                sQLHelper.opstmt.setStringAtName("partitionId", '\"' + this.modelDescriptor.getPartitionId() + '\"');
            }
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3;
                String string4 = sQLHelper.rs.getString("attribute_name_subname");
                if (string4 == null) {
                    string4 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string3 = sQLHelper.rs.getString("attribute_value")) == null) {
                    string3 = "";
                }
                Double d = sQLHelper.rs.getDouble("coefficient");
                AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string4, string3, d);
                arrayList.add(attributeBiCoefficient);
            }
        }
        return arrayList;
    }

    public List<AttributeBiCoefficient> getCoefficients(FilterSetting filterSetting) throws SQLException {
        String string = this.prepareCoefficientSQL(filterSetting);
        List<AttributeBiCoefficient> list = this.invokeCoefficientQuery(StringUtils.toString((Object)filterSetting.getTargetValue()), string);
        return list;
    }

    public List<FeatureCoefficient> getFeatureCoefficients(Class<? extends ModelType> clazz, List<SortSpec> list, int n, String ... stringArray) throws ODMrDAOException {
        List list2 = Arrays.stream(stringArray).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        FeatureCoefficientsQuery featureCoefficientsQuery = new FeatureCoefficientsQuery(this.connectionManager.getDbVersion(), clazz, list, this.modelDescriptor).setFeatureIds(list2).setFetchSize(n);
        return this.dao.readItems((Query)featureCoefficientsQuery);
    }

    public List<FeatureCoefficient> getFeatureCoefficients(Class<? extends ModelType> clazz, List<ColumnFilter> list, List<SortSpec> list2, ColumnFilter.Match match, int n, String ... stringArray) throws ODMrDAOException {
        List list3 = Arrays.stream(stringArray).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        FeatureCoefficientsQuery featureCoefficientsQuery = new FeatureCoefficientsQuery(this.connectionManager.getDbVersion(), clazz, list2, this.modelDescriptor).setFeatureIds(list3).setFilterList(list).setMatchType(match).setFetchSize(n);
        return this.dao.readItems((Query)featureCoefficientsQuery);
    }

    public List<FeatureItemSet> getFeatureItemSets(Class<? extends ModelType> clazz, List<ColumnFilter> list, ColumnFilter.Match match, SortOrder sortOrder, int n, int n2) throws ODMrDAOException {
        FeatureItemsQuery featureItemsQuery = new FeatureItemsQuery(this.connectionManager.getDbVersion(), clazz, this.modelDescriptor).setFilterList(list).setMatchType(match).setSortOrder(sortOrder).setFetchSize(Integer.valueOf(n)).setItemSetSize(Integer.valueOf(n2));
        return this.dao.readItems((Query)featureItemsQuery);
    }

    public List<String> getAvailableAttributes(Class<? extends ModelType> clazz) throws ODMrDAOException {
        GetFeatureAttributesQuery getFeatureAttributesQuery = new GetFeatureAttributesQuery(this.connectionManager.getDbVersion(), clazz, this.modelDescriptor);
        return this.dao.readItems((Query)getFeatureAttributesQuery);
    }

    private Map<String, Object> invokeCoefficientsStatisticsQuery(List<Object> list) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SQLHelper sQLHelper = new SQLHelper();
        boolean bl = list.get(0) instanceof String;
        String string = Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), false);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Object object : list) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            if (bl) {
                stringBuilder.append("'");
                stringBuilder.append(object.toString());
                stringBuilder.append("'");
                continue;
            }
            stringBuilder.append(object.toString());
        }
        try {
            sQLHelper.conn = this.connectionManager.getConnection();
            if (this.modelDescriptor.isPartitioned()) {
                sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION_PARTITION);
                sQLHelper.opstmt.setStringAtName("partitionId", '\"' + this.modelDescriptor.getPartitionId() + '\"');
            } else {
                sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION);
            }
            sQLHelper.opstmt.setStringAtName("model_name", string);
            sQLHelper.opstmt.setStringAtName("target_values", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                Object object;
                Integer n = sQLHelper.rs.getInt(TOTAL_COEFFICIENTS);
                hashMap.put(TOTAL_COEFFICIENTS, n);
                object = sQLHelper.rs.getDouble(MAXIMUM_ABS_COEFFICIENT_VALUE);
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, object);
            } else {
                hashMap.put(TOTAL_COEFFICIENTS, 0);
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, 0.0);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public Map<String, Object> getCoefficientStatistics(List<Object> list) throws Exception {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Map<String, Object> map = this.invokeCoefficientsStatisticsQuery(list);
        return map;
    }

    public Map<String, Object> getESACoefficientStatistics(List<Object> list) throws ODMrDAOException {
        Map<String, Object> map;
        assert (list != null && !list.isEmpty()) : "Must provide at least one target value";
        List list2 = list.stream().filter(object -> object != null).map(object -> object.toString()).collect(Collectors.toList());
        if (list2.isEmpty()) {
            map = new HashMap<String, Object>();
            map.put(TOTAL_COEFFICIENTS, 0);
            map.put(MAXIMUM_ABS_COEFFICIENT_VALUE, 0.0);
        } else {
            ESACoefStatsQuery eSACoefStatsQuery = new ESACoefStatsQuery(this.connectionManager.getDbVersion(), this.modelDescriptor).setFeatureIds(list2);
            map = this.dao.readItem((Query)eSACoefStatsQuery).orElse(Collections.emptyMap());
        }
        return map;
    }

    private String prepareCoefficientSQLAll(FilterSetting filterSetting) {
        String string = QUERY_COEFFICIENTS_ALL;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        String string3 = null;
        String string4 = "";
        StringBuilder stringBuilder2 = null;
        String string5 = null;
        if (filterSetting != null) {
            Object object;
            SortSpec sortSpec;
            Object object2;
            List list;
            if (filterSetting.getFetchSize() > 0) {
                string2 = " WHERE rownum <= " + filterSetting.getFetchSize();
            }
            if ((list = filterSetting.getSortSpecification()) != null && list.size() > 0) {
                stringBuilder.append("order by ");
                object2 = list.iterator();
                while (object2.hasNext()) {
                    sortSpec = (SortSpec)object2.next();
                    if (!sortSpec.isUseIt()) continue;
                    object = sortSpec.getAttributeName();
                    if (((String)object).equals("attribute_name_subname")) {
                        string3 = "\"attribute_name_subname\", max(\"attribute_name\") \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string4 = "GROUP BY \"attribute_name_subname\"";
                        stringBuilder.append("\"attribute_name_subname\"");
                    } else if (((String)object).equals("attribute_name")) {
                        string3 = "max(\"attribute_name_subname\") \"attribute_name_subname\", \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string4 = "GROUP BY \"attribute_name\"";
                        stringBuilder.append("\"attribute_name\"");
                    } else if (((String)object).equals("attribute_value")) {
                        string3 = "\"attribute_name_subname\", \"attribute_name\", \"attribute_value\"";
                        stringBuilder.append("\"attribute_value\"");
                    }
                    if (sortSpec.isAscending()) {
                        stringBuilder.append(" ASC ");
                    } else {
                        stringBuilder.append(" DESC NULLS LAST ");
                    }
                    if (!object2.hasNext()) continue;
                    stringBuilder.append(",");
                }
                if (stringBuilder.substring(stringBuilder.length() - 1, stringBuilder.length()).equalsIgnoreCase(",")) {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
            }
            if ((object2 = filterSetting.getWhereSpecification()) != null && object2.size() > 0) {
                sortSpec = object2.iterator();
                while (sortSpec.hasNext()) {
                    object = (WhereSpec)sortSpec.next();
                    if (!object.isUseIt()) continue;
                    if (stringBuilder2 == null) {
                        stringBuilder2 = new StringBuilder(" WHERE ");
                    }
                    stringBuilder2.append(" \"" + object.getLeftSideObject() + "\" ");
                    switch (object.getCondition()) {
                        case 1: {
                            stringBuilder2.append(" LIKE ");
                            break;
                        }
                        case 2: {
                            stringBuilder2.append(" NOT LIKE ");
                            break;
                        }
                        default: {
                            stringBuilder2.append(" LIKE ");
                            assert (false) : "Unrecognized Where Action: " + object.getCondition();
                            break;
                        }
                    }
                    stringBuilder2.append("'%" + object.getRightSideObject() + "%' \n");
                }
            }
            string5 = null != filterSetting.getTargetValue() ? StringUtils.getReplacedString((String)_TARGET_CONDITION, (String)"<target_value>", (String)("'" + filterSetting.getTargetValue().toString() + "'")) : "";
        }
        string = StringUtils.getReplacedString((String)string, (String)"<select_stmt>", string3);
        string = StringUtils.getReplacedString((String)string, (String)"<model_name>", (String)("'" + Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true) + "'"));
        if (stringBuilder2 == null) {
            stringBuilder2 = new StringBuilder();
        }
        string = StringUtils.getReplacedString((String)string, (String)"<name_filter_condition>", (String)stringBuilder2.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<target_condition>", (String)string5);
        string = StringUtils.getReplacedString((String)string, (String)"<order>", (String)stringBuilder.toString());
        string = StringUtils.getReplacedString((String)string, (String)"<group_by>", (String)string4);
        string = StringUtils.getReplacedString((String)string, (String)"<rownum>", (String)string2);
        return string;
    }

    private List<AttributeBiCoefficient> invokeItemPickerQuery(String string) throws SQLException {
        ArrayList<AttributeBiCoefficient> arrayList = new ArrayList<AttributeBiCoefficient>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.stmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string);
            while (sQLHelper.rs.next()) {
                String string2;
                String string3 = sQLHelper.rs.getString("attribute_name_subname");
                if (string3 == null) {
                    string3 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string2 = sQLHelper.rs.getString("attribute_value")) == null) {
                    string2 = "";
                }
                AttributeBiCoefficient attributeBiCoefficient = new AttributeBiCoefficient(string3, string2, null, null);
                arrayList.add(attributeBiCoefficient);
            }
        }
        return arrayList;
    }

    public List<AttributeBiCoefficient> getAllCoefficients(FilterSetting filterSetting) throws SQLException {
        String string = this.prepareCoefficientSQLAll(filterSetting);
        List<AttributeBiCoefficient> list = this.invokeItemPickerQuery(string);
        return list;
    }

    public boolean isFeatureUnique(String string) {
        return !this.featureIDToLabelMap.containsValue(string);
    }

    public void renameFeature(String string, String string2) throws Exception {
        Integer n = this.getFeatureIdOrNull(string2);
        StringBuilder stringBuilder = new StringBuilder("case ");
        for (Map.Entry<Integer, String> entry : this.featureIDToLabelMap.entrySet()) {
            Integer n2 = entry.getKey();
            String string3 = entry.getValue();
            StringBuilder stringBuilder2 = new StringBuilder();
            String string4 = StringUtils.getReplacedString((String)ALTER_REVERSE_EXPRESSION_FEATURE_ID, (String)"[FEATURE_ID]", (String)n2.toString());
            stringBuilder2.append(string4);
            if (n2.equals(n)) {
                this.featureIDToLabelMap.put(n2, string);
                string4 = StringUtils.getReplacedString((String)ALTER_REVERSE_EXPRESSION_CASE_RENAME, (String)"[NEW_NAME]", (String)string);
            } else {
                string4 = StringUtils.getReplacedString((String)ALTER_REVERSE_EXPRESSION_CASE_KEEP_OLD, (String)"[OLD_NAME]", (String)string3);
            }
            stringBuilder2.append(string4);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append(ALTER_REVERSE_EXPRESSION_CASE_END);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(ALTER_REVERSE_EXPRESSION_FINAL);
            sQLHelper.opstmt.setQueryTimeout(5);
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        }
    }

    private Integer getFeatureIdOrNull(String string) {
        Optional<Integer> optional = this.featureIDToLabelMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(string)).map(Map.Entry::getKey).findAny();
        return optional.orElse(null);
    }
}

