/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.server.model.PartitionModelAttributeInfo;
import oracle.dmt.dataminer.utils.SQLHelper;

public class PartitionModelViewerAttributes {
    private static final String PARTITION_MODEL_ATTRIBUTES = "SELECT t1.owner, t1.model_name, t1.partition_name, t1.position, t1.column_name, t1.column_value,      t2.data_type, t2.attribute_type,       NVL(      (SELECT x.expression                  FROM all_mining_model_xforms x                  WHERE x.OWNER = t1.owner and                        x.MODEL_NAME = t1.model_name and                        x.ATTRIBUTE_NAME = t1.column_name), '') as expression,        NVL(     (SELECT x.reverse                  FROM all_mining_model_xforms x                  WHERE x.OWNER = t1.owner and                        x.MODEL_NAME = t1.model_name and                        x.ATTRIBUTE_NAME = t1.column_name), '') as reverse_expression FROM ALL_MINING_MODEL_PARTITIONS t1, ALL_MINING_MODEL_ATTRIBUTES t2 WHERE t1.OWNER = ? and       t1.MODEL_NAME = ? and       t1.PARTITION_NAME= ? and       t1.owner = t2.owner and       t1.model_name = t2.model_name and       t1.column_name = t2.attribute_name";
    private static final String _PARTITION_NAME = "PARTITION_NAME";
    private static final String _POSITION = "POSITION";
    private static final String _COLUMN_NAME = "COLUMN_NAME";
    private static final String _DATA_TYPE = "DATA_TYPE";
    private static final String _EXPRESSION = "EXPRESSION";
    private static final String _REVERSE_EXPRESSION = "REVERSE_EXPRESSION";
    private static final String _COLUMN_VALUE = "COLUMN_VALUE";
    private static Map<String, String> _columns = new HashMap<String, String>();
    private String _owner;
    private String _modelName;
    private String _partitionName;
    private Map<String, PartitionModelAttributeInfo> _attributes;

    public PartitionModelViewerAttributes(String string, String string2, String string3) {
        this._owner = string;
        this._modelName = string2;
        this._partitionName = string3;
    }

    public static PartitionModelViewerAttributes getPartitionModelViewerAttributes(ConnectionManager connectionManager, String string, String string2, String string3) throws ODMrDAOException {
        PartitionModelViewerAttributes partitionModelViewerAttributes = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(PARTITION_MODEL_ATTRIBUTES);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setString(2, string3);
            sQLHelper.pstmt.setString(3, string2);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            partitionModelViewerAttributes = new PartitionModelViewerAttributes(string, string3, string2);
            partitionModelViewerAttributes._attributes = new Hashtable<String, PartitionModelAttributeInfo>();
            while (sQLHelper.rs.next()) {
                PartitionModelAttributeInfo partitionModelAttributeInfo = new PartitionModelAttributeInfo();
                String string4 = (String)PartitionModelViewerAttributes.getAttribute(sQLHelper.rs, _COLUMN_NAME);
                partitionModelAttributeInfo.setPartitionKeyName(string4);
                partitionModelAttributeInfo.setPartitionKeyValue((String)PartitionModelViewerAttributes.getAttribute(sQLHelper.rs, _COLUMN_VALUE));
                partitionModelAttributeInfo.setDataType((String)PartitionModelViewerAttributes.getAttribute(sQLHelper.rs, _DATA_TYPE));
                partitionModelAttributeInfo.setExpression((StringBuilder)PartitionModelViewerAttributes.getAttribute(sQLHelper.rs, _EXPRESSION));
                partitionModelAttributeInfo.setPartitionName((String)PartitionModelViewerAttributes.getAttribute(sQLHelper.rs, _PARTITION_NAME));
                partitionModelAttributeInfo.setPosition((BigDecimal)PartitionModelViewerAttributes.getAttribute(sQLHelper.rs, _POSITION));
                partitionModelAttributeInfo.setRevExpression((String)PartitionModelViewerAttributes.getAttribute(sQLHelper.rs, _REVERSE_EXPRESSION));
                partitionModelViewerAttributes._attributes.put(string4, partitionModelAttributeInfo);
            }
        }
        return partitionModelViewerAttributes;
    }

    private static Object getAttribute(ResultSet resultSet, String string) throws SQLException {
        Object object = null;
        String string2 = _columns.get(string);
        if (string2 == null) {
            return null;
        }
        if (string2.equals("NUMBER")) {
            object = resultSet.getBigDecimal(string);
        } else if (string2.equals("VARCHAR2")) {
            object = resultSet.getString(string);
        } else if (string2.equals("CLOB")) {
            Clob clob = resultSet.getClob(string);
            object = DbMetadataUtils.clobToStringBuilder((Clob)clob);
        }
        return object;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getOwner() {
        return this._owner;
    }

    public List<PartitionModelAttributeInfo> getAttributes() {
        if (this._attributes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<PartitionModelAttributeInfo>(this._attributes.values());
    }

    static {
        _columns.put(_PARTITION_NAME, "VARCHAR2");
        _columns.put(_POSITION, "NUMBER");
        _columns.put(_COLUMN_NAME, "VARCHAR2");
        _columns.put(_DATA_TYPE, "VARCHAR2");
        _columns.put(_EXPRESSION, "CLOB");
        _columns.put(_REVERSE_EXPRESSION, "VARCHAR2");
        _columns.put(_COLUMN_VALUE, "VARCHAR2");
    }
}

