/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenPreferences;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ODMrGraphOutputPanel
extends JPanel
implements ClipboardOwner {
    private String _xmlString = null;
    private BufferedImage _imageSrc = null;
    private BufferedImage _image = null;
    private boolean _isDirty = false;
    private static String BITMAP_FILTER_DESC = "Bitmap (*.bmp)";
    private static String BITMAP_FILTER_EXT = "bmp";
    private static String JPEG_FILTER_DESC = "JPEG (*.jpeg; *.jpg)";
    private static String JPEG_FILTER_EXT = "jpeg";
    private static String JPEG_FILTER_EXT2 = "jpg";
    private static String PNG_FILTER_DESC = "PNG (*.png)";
    private static String PNG_FILTER_EXT = "png";
    private static String IMAGE_FILTER_DESC = "Image File";
    private JLabel jLabel;

    public ODMrGraphOutputPanel(String string) {
        this.initComponents();
        this._xmlString = string;
        this.jLabel.setText(DataLrb.get("DATA_VIEWER_EDITOR_LOADING"));
        LoadXMLString loadXMLString = new LoadXMLString(this._xmlString);
        loadXMLString.execute();
    }

    public void reset(String string) {
        this.jLabel.setText(DataLrb.get("DATA_VIEWER_EDITOR_LOADING"));
        this._xmlString = string;
        this._image = null;
        this._isDirty = true;
    }

    public void refresh() {
        if (this._isDirty) {
            LoadXMLString loadXMLString = new LoadXMLString(this._xmlString);
            loadXMLString.execute();
        } else {
            this.updateUI();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setClipboardContents() {
        TransferableImage transferableImage = new TransferableImage(this._image);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(transferableImage, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile() {
        File file;
        String string;
        boolean bl;
        block12: {
            Object object;
            String string2;
            block11: {
                int n;
                bl = false;
                String string3 = "Untitled";
                string = "png";
                Preferences preferences = Preferences.getPreferences();
                CodeGenPreferences codeGenPreferences = CodeGenPreferences.getInstance((PropertyStorage)preferences);
                URLFileChooser uRLFileChooser = new URLFileChooser();
                String string4 = codeGenPreferences.getCodeLocation();
                if (string4 != null && !string4.equals("")) {
                    uRLFileChooser.setCurrentDirectory(new File(string4));
                }
                String string5 = string3;
                uRLFileChooser.setSelectedFile(new File(string5 + "." + string));
                uRLFileChooser.setFileFilter((FileFilter)new FileNameExtensionFilter(IMAGE_FILTER_DESC, BITMAP_FILTER_EXT, JPEG_FILTER_EXT, JPEG_FILTER_EXT2, PNG_FILTER_EXT));
                string2 = "";
                boolean bl2 = false;
                boolean bl3 = true;
                while (bl3) {
                    n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
                    if (!n) {
                        string2 = uRLFileChooser.getSelectedFile().getAbsolutePath();
                        if (string2.trim().length() == 0) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CodeGenLrb.get("GENERATE_CODE_EMPTY_FILE_NAME"), (String)CodeGenLrb.get("GENERATE_CODE_TITLE"), null);
                            continue;
                        }
                        bl3 = false;
                        object = new File(string2);
                        codeGenPreferences.setCodeLocation(((File)object).getParent());
                        continue;
                    }
                    bl3 = false;
                    bl2 = true;
                }
                if (!bl2) break block11;
                n = 1;
                return n != 0;
            }
            file = new File(string2);
            object = file.getName();
            if (!FileHelper.isFileNameWithSuffix((String)object)) {
                String string6 = string2 + ".jpg";
                file = new File(string6);
            }
            if (file == null || !file.exists() || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataLrb.get("DATA_VIEWER_SAVE_FILE_OVERWRITE"), (String)DataLrb.get("DATA_VIEWER_SAVE_DLG_TITLE"), null, (boolean)true)) break block12;
            boolean bl4 = true;
            return bl4;
        }
        try {
            ImageIO.write((RenderedImage)this._image, string, file);
            bl = true;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage scaleBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.clearRect(0, 0, n, n2);
            graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    private void showBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        this._image = this.scaleBufferedImage(bufferedImage, n, n2);
        this.jLabel.setIcon(new ImageIcon(this._image));
        this.jLabel.setFocusable(true);
        this.jLabel.requestFocusInWindow();
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jLabel.setText(null);
        this.jLabel.setFocusable(true);
        this.jLabel.requestFocusInWindow();
        final JPopupMenu jPopupMenu = new JPopupMenu("Option");
        JMenuItem jMenuItem = new JMenuItem(DataLrb.get("DATA_VIEWER_RDATA_GRAPH_COPY"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODMrGraphOutputPanel.this.setClipboardContents();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(DataLrb.get("DATA_VIEWER_RDATA_GRAPH_SAVE"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ODMrGraphOutputPanel.this.saveToFile();
            }
        });
        jPopupMenu.add(jMenuItem);
        this.jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ODMrGraphOutputPanel.this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
                ODMrGraphOutputPanel.this.jLabel.setFocusable(true);
                ODMrGraphOutputPanel.this.jLabel.requestFocusInWindow();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                int n = ODMrGraphOutputPanel.this.getWidth();
                int n2 = ODMrGraphOutputPanel.this.getHeight();
                int n3 = mouseEvent.getPoint().x;
                int n4 = mouseEvent.getPoint().y;
                int n5 = 10;
                int n6 = n - 10;
                int n7 = 10;
                int n8 = n2 - 10;
                if (n3 >= n5 && n3 <= n6 && n4 >= n7 && n4 <= n8) {
                    return;
                }
                ODMrGraphOutputPanel.this.setBorder(BorderFactory.createEmptyBorder());
                ODMrGraphOutputPanel.this.jLabel.setFocusable(true);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPop(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPop(mouseEvent);
                }
            }

            private void doPop(MouseEvent mouseEvent) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.jLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (67 == keyEvent.getKeyCode() && keyEvent.isControlDown()) {
                    ODMrGraphOutputPanel.this.setClipboardContents();
                }
                if (83 == keyEvent.getKeyCode() && keyEvent.isControlDown()) {
                    ODMrGraphOutputPanel.this.saveToFile();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ODMrGraphOutputPanel.this.formComponentResized(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.jLabel.setText(DataLrb.get("DATA_VIEWER_EDITOR_LOADING"));
        this.jLabel.setMaximumSize(new Dimension(0, 0));
        this.jLabel.setMinimumSize(new Dimension(0, 0));
        this.jLabel.setPreferredSize(new Dimension(0, 0));
        this.add((Component)this.jLabel, "Center");
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        if (this._imageSrc != null) {
            int n = componentEvent.getComponent().getHeight();
            int n2 = componentEvent.getComponent().getWidth();
            if (n > 0 && n2 > 0) {
                this.showBufferedImage(this._imageSrc, n2, n);
            }
        }
    }

    private static class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image image) {
            this.i = image;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavor.equals(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }
    }

    private class LoadXMLString
    extends SwingWorker {
        private Exception _ex = null;
        private boolean _success = false;
        private String _xmlString = null;

        public LoadXMLString(String string) {
            this._xmlString = string;
        }

        private BufferedImage getBufferedImage(String string) {
            BufferedImage bufferedImage = null;
            try {
                if (string != null) {
                    InputSource inputSource = new InputSource(new StringReader(string));
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
                    NodeList nodeList = document.getElementsByTagName("img");
                    Element element = (Element)nodeList.item(0);
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    Node node = namedNodeMap.getNamedItem("src");
                    String string2 = node.getNodeValue();
                    if (string2.contains("pngbase64") || string2.contains("gifbase64") || string2.contains("jpegbase64") || string2.contains("bmpbase64") || string2.contains("wbmpbase64")) {
                        String string3 = element.getTextContent();
                        byte[] byArray = DatatypeConverter.parseBase64Binary((String)string3);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        bufferedImage = ImageIO.read(byteArrayInputStream);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bufferedImage;
        }

        protected Object doInBackground() throws Exception {
            try {
                ODMrGraphOutputPanel.this._imageSrc = this.getBufferedImage(this._xmlString);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._xmlString;
        }

        @Override
        protected void done() {
            super.done();
            try {
                int n = ODMrGraphOutputPanel.this.getWidth();
                int n2 = ODMrGraphOutputPanel.this.getHeight();
                if (n2 > 0 && n > 0) {
                    ODMrGraphOutputPanel.this.showBufferedImage(ODMrGraphOutputPanel.this._imageSrc, n, n2);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
            }
        }
    }
}

