/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.text.MessageFormat;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphPreferences;
import oracle.dmt.dataminer.teditor.graph.GraphQueryBuilder;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.teditor.graph.HistogramQueryBuilder;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.ide.Context;

class BarGraphQueryBuilder
extends HistogramQueryBuilder {
    public static GraphQueryBuilder getQueryGraphBuilder(Context context, String string, GraphSettingsType graphSettingsType) throws Exception {
        return GraphQueryBuilder.getQueryGraphBuilder(BarGraphQueryBuilder.class, context, string, graphSettingsType, GraphPreferences.getInstance());
    }

    @Override
    public String buildGraphQuery() throws Exception {
        String string;
        this.init(this.yattribute.getName(), this.yattribute.getName());
        this.query = "WITH BINNING_INTERVALS AS (  SELECT     <yattr>,     <grouping_clause><gcomma>     <bin_id_clause><xbincomma>    <bin_label_clause>  FROM <table> <nulls> ), <binned_data><allBinsClause> select * from <source>";
        if (GraphUtils.isCategoricalType(this.xattribute.getDataType()) && this.isGroupByEnabled) {
            string = "  count_calc as (    select <aggfnc> (<yattr>) as <yattr>, <gattr>, <xattr> from binning_intervals group by <gattr>, <xattr>),  total_calc as (    select sum(<yattr>) TOTAL, <xattr> from count_calc GROUP BY <xattr>),  binned_data as (    select total_calc.total, count_calc.<yattr>, count_calc.<xattr>, <gattr>    from count_calc, total_calc     where count_calc.<xattr> = total_calc.<xattr>    order by total desc, <xattr>, <gattr> desc  )";
        } else {
            string = "BINNED_DATA AS ( SELECT    <aggfnc> (<yattr>) as <yattr>,    <binidattr><xbincomma> <xattr><gcomma> <gattr>   FROM BINNING_INTERVALS   GROUP BY <binidattr><xbincomma> <xattr><gcomma> <gattr>      <orderby> )";
            if (GraphUtils.isCategoricalType(this.xattribute.getDataType()) && !this.isGroupByEnabled) {
                this.orderBy = "order by <yattr> desc";
            }
        }
        this.query = StringUtils.getReplacedString(this.query, "<binned_data>", string);
        this.query = StringUtils.getReplacedString(this.query, "<orderby>", this.orderBy);
        this.query = StringUtils.getReplacedString(this.query, "<binidattr>", this.binIdAttr);
        this.query = StringUtils.getReplacedString(this.query, "<xbincomma>", this.xBinComma);
        this.query = StringUtils.getReplacedString(this.query, "<grouping_clause>", this.groupingClause);
        this.query = StringUtils.getReplacedString(this.query, "<bin_id_clause>", this.binIdsClause);
        this.query = StringUtils.getReplacedString(this.query, "<bin_label_clause>", this.binLabelsClause);
        this.query = StringUtils.getReplacedString(this.query, "<nulls>", this.nullsClause);
        this.query = StringUtils.getReplacedString(this.query, "<table>", this.fqCacheTableName);
        this.query = StringUtils.getReplacedString(this.query, "<xattr>", StringUtils.addDoubleQuotes(StringUtils.processQuotedName(this.xAttributeName)));
        this.query = StringUtils.getReplacedString(this.query, "<allBinsClause>", this.allBinsClause);
        this.query = StringUtils.getReplacedString(this.query, "<gattr>", this.qGAttributeName);
        this.query = StringUtils.getReplacedString(this.query, "<gcomma>", this.gcomma);
        this.query = StringUtils.getReplacedString(this.query, "<aggfnc>", this.aggfnc);
        this.query = StringUtils.getReplacedString(this.query, "<yattr>", this.qYAttributeName);
        this.query = StringUtils.getReplacedString(this.query, "<source>", this.allBinsClause.length() != 0 ? "ALL_BINS" : "BINNED_DATA");
        if (this.isGroupByEnabled) {
            this.columnTitles.add(this.gAttributeName);
        } else {
            this.columnTitles.add(this.xattribute.getName());
        }
        this.columnTitles.add(this.xattribute.getName());
        Object[] objectArray = new Object[]{this.aggfnc, this.yAttributeName};
        String string2 = MessageFormat.format(GraphLrb.get("GRAPH_DATA_BOX_AGGFN"), objectArray);
        this.columnTitles.add(string2);
        return this.query;
    }
}

