/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.navigator.AbstractTestNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.WorkflowContextMenu;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class AbstractTestEditor
extends DataMinerEditor {
    protected static final Logger theLogger = Logger.getLogger(AbstractTestEditor.class.getName());
    protected long lastUpdatedTime;
    private BaseTreeNode projectFolder;
    private BaseTreeNode connectionFolder;
    private BaseTreeNode connectionsFolder;
    private WorkflowNode wfNode;
    protected SharedTestEditorState sharedState;

    @Override
    public void open() {
        Context context = this.getContext();
        BaseTreeNode baseTreeNode = (BaseTreeNode)context.getNode();
        if (baseTreeNode instanceof AbstractTestNode) {
            if (((AbstractTestNode)baseTreeNode).getContext() != null) {
                this.attach();
            } else {
                this.detach();
            }
        }
    }

    public void reloadEditor() {
        this.initSharedTestEditorState(this.getContext());
        this._gui.reload();
    }

    @Override
    public void refresh() {
        super.refresh();
        LoadClassCompare loadClassCompare = new LoadClassCompare();
        loadClassCompare.execute();
    }

    @Override
    public void close() {
        super.close();
        this.detach();
    }

    private void attach() {
        AbstractTestNode abstractTestNode = (AbstractTestNode)this.getContext().getNode();
        if (!(this.wfNode instanceof WorkflowNode)) {
            return;
        }
        this.wfNode = (WorkflowNode)abstractTestNode.getContext().getNode();
        TNode tNode = this.wfNode.getParent();
        this.projectFolder = (BaseTreeNode)tNode.getData();
        this.connectionFolder = (BaseTreeNode)tNode.getAncestor(ConnectionFolder.class, true);
        this.connectionsFolder = (BaseTreeNode)tNode.getAncestor(Connections.class, true);
        this.projectFolder.attach((Observer)this);
        this.connectionFolder.attach((Observer)this);
        this.connectionsFolder.attach((Observer)this);
    }

    private void detach() {
        if (this.projectFolder != null) {
            this.projectFolder.detach((Observer)this);
            this.projectFolder = null;
        }
        if (this.connectionFolder != null) {
            this.connectionFolder.detach((Observer)this);
            this.connectionFolder = null;
        }
        if (this.connectionsFolder != null) {
            this.connectionsFolder.detach((Observer)this);
            this.connectionsFolder = null;
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List list = updateMessage.getRemoveObjects();
            if (list.contains(this.projectFolder) || list.contains(this.connectionFolder) || list.contains(this.connectionsFolder) || list.contains(this.wfNode)) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
            if (object == this.connectionFolder) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            if (this.getGUI().isShowing()) {
                this.refresh();
            } else {
                this.setNeedsRefresh(true);
            }
        }
    }

    public Component getCurrentGUI() {
        return this._gui;
    }

    public Container getParent() {
        return this._gui.getParent();
    }

    protected void initSharedTestEditorState(Context context) {
        Node node = context.getNode();
        assert (node != null) : "Tree Node is null";
        this.sharedState = new SharedTestEditorState(node);
        this.lastUpdatedTime = this.sharedState.getLastUpdateTime();
    }

    public SharedTestEditorState getCachedLegendState() {
        return this.sharedState;
    }

    public void setCachedLegendState(Object object) {
        this.sharedState = (SharedTestEditorState)object;
    }

    protected boolean isReloadDueToUpdates() {
        if (this.sharedState == null) {
            return true;
        }
        return this.lastUpdatedTime != this.sharedState.getLastUpdateTime();
    }

    private class LoadClassCompare
    extends ODMrSwingWorker<Void, Void> {
        public LoadClassCompare() {
            super(null);
        }

        @Override
        protected Void doInBackground() throws Exception {
            WorkflowNode workflowNode = WorkflowNode.findParentWorkflowNode(AbstractTestEditor.this.getContext());
            WorkflowModel workflowModel = workflowNode.getWorkflowModel();
            Node node = AbstractTestEditor.this.getContext().getNode();
            if (node instanceof AbstractTestNode) {
                ((AbstractTestNode)node).prepareForRefresh();
            }
            if (node instanceof TestCompareNode) {
                this.processTestCompareNode((TestCompareNode)node, workflowModel, workflowNode);
            } else {
                this.processTestResultNode((TestResultNode)node, workflowModel, workflowNode);
            }
            AbstractTestEditor.this.lastUpdatedTime = System.currentTimeMillis();
            return null;
        }

        private void processTestCompareNode(TestCompareNode testCompareNode, WorkflowModel workflowModel, WorkflowNode workflowNode) throws Exception {
            TestCompareNode testCompareNode2 = null;
            AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(testCompareNode.getParentNodeId());
            if (abstractNode instanceof AbstractBuildNode) {
                AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
                MiningFunctionType miningFunctionType = abstractBuildNode.getMiningFunctionType();
                BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
                List<ClassificationResultType> list = null;
                if (MiningFunctionType.CLASSIFICATION.equals((Object)miningFunctionType)) {
                    list = this.getClassificationResults(buildNodeType);
                    testCompareNode2 = WorkflowContextMenu.createClassTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, buildNodeType, list);
                } else if (MiningFunctionType.REGRESSION.equals((Object)miningFunctionType)) {
                    list = this.getRegressionResults(buildNodeType);
                    testCompareNode2 = WorkflowContextMenu.createRegressTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, buildNodeType, list);
                }
            } else if (abstractNode instanceof TestNode) {
                TestNode testNode = (TestNode)abstractNode;
                TestNodeType testNodeType = (TestNodeType)testNode.getData();
                if (this.hasClassificationResults(testNodeType)) {
                    testCompareNode2 = WorkflowContextMenu.createClassTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, testNodeType, (List<? extends MiningResultType>)testNodeType.getResults().getClassificationResult());
                } else if (this.hasRegressionResults(testNodeType)) {
                    ArrayList<MiningResultType> arrayList = new ArrayList<MiningResultType>();
                    for (MiningResultType miningResultType : testNodeType.getResults().getRegressionResult()) {
                        if (miningResultType.getCreationDate() == null) continue;
                        arrayList.add(miningResultType);
                    }
                    testCompareNode2 = WorkflowContextMenu.createRegressTestCompareNode(AbstractTestEditor.this.getContext(), workflowNode, testNodeType, arrayList);
                }
            }
            AbstractTestEditor.this.getContext().setNode(testCompareNode2);
        }

        private boolean hasClassificationResults(TestNodeType testNodeType) {
            boolean bl;
            boolean bl2 = bl = testNodeType != null && testNodeType.getResults() != null;
            if (bl) {
                return !testNodeType.getResults().getClassificationResult().isEmpty();
            }
            return false;
        }

        private boolean hasRegressionResults(TestNodeType testNodeType) {
            boolean bl;
            boolean bl2 = bl = testNodeType != null && testNodeType.getResults() != null;
            if (bl) {
                return !testNodeType.getResults().getRegressionResult().isEmpty();
            }
            return false;
        }

        private void processTestResultNode(TestResultNode testResultNode, WorkflowModel workflowModel, WorkflowNode workflowNode) throws Exception {
            String string = workflowNode.getConnectionFolder().getUserAccountName();
            TestResultNode testResultNode2 = null;
            AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByMetadataId(testResultNode.getParentClassificationNodeId());
            TestResult testResult = (TestResult)testResultNode.getRepositoryData();
            String string2 = testResult.getName();
            if (abstractNode instanceof AbstractBuildNode) {
                AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
                BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
                MiningFunctionType miningFunctionType = abstractBuildNode.getMiningFunctionType();
                if (MiningFunctionType.CLASSIFICATION.equals((Object)miningFunctionType)) {
                    testResultNode2 = this.createClassificationTestResult(workflowNode, string, buildNodeType, string2);
                } else if (MiningFunctionType.REGRESSION.equals((Object)miningFunctionType)) {
                    testResultNode2 = this.createRegressionTestResult(workflowNode, string, buildNodeType, string2);
                }
            } else if (abstractNode instanceof TestNode) {
                TestNode testNode = (TestNode)abstractNode;
                TestNodeType testNodeType = (TestNodeType)testNode.getData();
                if (testResultNode.getRepositoryData() instanceof ClassTestResult) {
                    ClassificationResultType classificationResultType = null;
                    for (ClassificationResultType classificationResultType2 : testNodeType.getResults().getClassificationResult()) {
                        if (!classificationResultType2.getName().equals(string2)) continue;
                        classificationResultType = classificationResultType2;
                        break;
                    }
                    testResultNode2 = WorkflowContextMenu.createClassTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string2, testNodeType, classificationResultType);
                } else if (testResultNode.getRepositoryData() instanceof RegressTestResult) {
                    RegressionResultType regressionResultType = null;
                    for (RegressionResultType regressionResultType2 : testNodeType.getResults().getRegressionResult()) {
                        if (!regressionResultType2.getName().equals(string2)) continue;
                        regressionResultType = regressionResultType2;
                        break;
                    }
                    testResultNode2 = WorkflowContextMenu.createRegressTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string2, testNodeType, regressionResultType);
                }
            }
            AbstractTestEditor.this.getContext().setNode(testResultNode2);
        }

        private TestResultNode createClassificationTestResult(WorkflowNode workflowNode, String string, BuildNodeType buildNodeType, String string2) throws IllegalAccessException, InstantiationException {
            List<ClassificationResultType> list = this.getClassificationResults(buildNodeType);
            MiningResultType miningResultType = this.findResultByName(list, string2);
            TestResultNode testResultNode = WorkflowContextMenu.createClassTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string2, buildNodeType, miningResultType);
            return testResultNode;
        }

        private List<ClassificationResultType> getClassificationResults(BuildNodeType buildNodeType) {
            if (buildNodeType instanceof ClassificationBuildNodeType) {
                ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
                return classificationBuildNodeType.getResults().getClassificationResult();
            }
            if (buildNodeType instanceof ExtensibleBuildNodeType) {
                ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)buildNodeType;
                return extensibleBuildNodeType.getResults().getClassificationResult();
            }
            return new ArrayList<ClassificationResultType>();
        }

        private MiningResultType findResultByName(List<? extends MiningResultType> list, String string) {
            MiningResultType miningResultType = null;
            if (list == null || list.isEmpty()) {
                return miningResultType;
            }
            for (MiningResultType miningResultType2 : list) {
                if (!miningResultType2.getName().equals(string)) continue;
                miningResultType = miningResultType2;
                break;
            }
            return miningResultType;
        }

        private TestResultNode createRegressionTestResult(WorkflowNode workflowNode, String string, BuildNodeType buildNodeType, String string2) throws IllegalAccessException, InstantiationException {
            List<RegressionResultType> list = this.getRegressionResults(buildNodeType);
            MiningResultType miningResultType = this.findResultByName(list, string2);
            TestResultNode testResultNode = WorkflowContextMenu.createRegressTestResultNode(AbstractTestEditor.this.getContext(), workflowNode, string, string2, buildNodeType, miningResultType);
            return testResultNode;
        }

        private List<RegressionResultType> getRegressionResults(BuildNodeType buildNodeType) {
            if (buildNodeType instanceof RegressionBuildNodeType) {
                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
                return regressionBuildNodeType.getResults().getRegressionResult();
            }
            if (buildNodeType instanceof ExtensibleBuildNodeType) {
                ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)buildNodeType;
                return extensibleBuildNodeType.getResults().getRegressionResult();
            }
            return new ArrayList<RegressionResultType>();
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            AbstractTestEditor.this.reloadEditor();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
        }
    }
}

