/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.BaseTestViewerState;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCData;
import oracle.dmt.dataminer.tviewer.roc.ROCTableModel;
import oracle.dmt.dataminer.tviewer.roc.ROCTuneTableModel;
import oracle.dmt.dataminer.tviewer.roc.StatisticsData;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;

public class ROCTabPanelState
extends BaseTestViewerState {
    public static final String CUSTOM_THRESHOLD_OP_HIT_RATIO = "CUSTOM_THRESHOLD_OP_HIT_RATIO";
    public static final String CUSTOM_THRESHOLD_OP_FALSE_ALARM = "CUSTOM_THRESHOLD_OP_FALSE_ALARM";
    public static final String CUSTOM_THRESHOLD_OP_FALSE_RATIO = "CUSTOM_THRESHOLD_OP_FALSE_RATIO";
    private Map<String, Map<String, List<ROCData>>> rocdata = new HashMap<String, Map<String, List<ROCData>>>();
    private Map<String, Map<String, StatisticsData>> statdata = new HashMap<String, Map<String, StatisticsData>>();
    private Map<String, Map<String, Integer>> confusionMatrix = new HashMap<String, Map<String, Integer>>();
    private String customThresholdOption = "CUSTOM_THRESHOLD_OP_HIT_RATIO";
    private double customThresholdValue = 0.0;
    private ROCTableModel rocTableModel;
    private DefaultGraphDataModel rocGraphModel;
    private static String QRY_CM_VALUES_PARTITIONED = "select actual_target_value, value from <confusion_matrix_table> where <partition_clause> and actual_target_value = predicted_target_value";
    private static int HIGH_RES_MIN_FRACTION = 10;
    private static int MAX_SAMPLE_SIZE = 3000;
    private static String QRY_ROC_RESULTS_PARTITIONED = "SELECT TRUNC(PROBABILITY,25) PROBABILITY, TRUNC(TRUE_POSITIVE_FRACTION," + HIGH_RES_MIN_FRACTION + ") \nTRUE_POSITIVE_FRACTION, TRUNC(FALSE_POSITIVE_FRACTION," + HIGH_RES_MIN_FRACTION + ") FALSE_POSITIVE_FRACTION, \nTRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES \nFROM (SELECT t.*, ROWNUM RNUM FROM <ROCTable> t) \nWHERE " + "<partition_clause>" + "\nAND ORA_HASH(RNUM,((SELECT COUNT(*) FROM <ROCTable>)-1),12345) < " + MAX_SAMPLE_SIZE + " \nORDER BY FALSE_POSITIVE_FRACTION , TRUE_POSITIVE_FRACTION ";

    public ROCTabPanelState(SharedTestEditorState sharedTestEditorState) {
        super(sharedTestEditorState);
        this.testResults = sharedTestEditorState.getTestResults();
        this.rocGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
        this.rocGraphModel.setX1(TestViewerLrb.get("FALSE_POSITIVE_FRACTION"), 1.0);
        this.rocGraphModel.setY1(TestViewerLrb.get("TRUE_POSITIVE_FRACTION"), 1.0);
    }

    public void load(boolean bl) throws ODMrDAOException {
        this.targetValues.clear();
        this.testResults = this.parentState.getTestResults();
        for (TestResult testResult : this.testResults) {
            if (!((ClassTestResult)testResult).rocResultExists(bl)) continue;
            List<String> list = ((ClassTestResult)testResult).getTargetValues(bl);
            for (String string : list) {
                if (this.targetValues.contains(string)) continue;
                this.targetValues.add(string);
            }
        }
        Object object = null;
        object = bl ? ((ClassTestResult)this.testResults.get(0)).getLeastTargetValue(true, this.parentState.getSelectedPartition()) : ((ClassTestResult)this.testResults.get(0)).getLeastTargetValue(false, null);
        if (object == null || !this.targetValues.contains(object)) {
            object = (String)this.targetValues.get(0);
        }
        this.setSelectedTargetValue((String)object);
        if (bl) {
            this.loadROCPartitioned();
        } else {
            this.loadROC();
        }
        this.loadROCGraph();
    }

    public void refreshROCStatData(boolean bl) throws ODMrDAOException {
        if (bl) {
            this.loadROCPartitioned();
        } else {
            this.loadROC();
        }
        this.loadROCGraph();
    }

    private void loadROC() throws ODMrDAOException {
        String string = this.getSelectedTargetValue();
        TreeMap<String, List<ROCData>> treeMap = new TreeMap<String, List<ROCData>>();
        TreeMap<String, StatisticsData> treeMap2 = new TreeMap<String, StatisticsData>();
        for (TestResult testResult : this.testResults) {
            Object object;
            Map<String, Object> map;
            Object object2;
            String string2;
            String string3 = testResult.toString();
            Map<String, Integer> map2 = this.confusionMatrix.get(string3);
            if (map2 == null) {
                map2 = new HashMap<String, Integer>();
                string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
                object2 = "select actual_target_value, value from " + string2 + " where actual_target_value = predicted_target_value";
                map = new SQLHelper();
                try {
                    ((SQLHelper)((Object)map)).conn = this.connManager.getConnection();
                    ((SQLHelper)((Object)map)).pstmt = ((SQLHelper)((Object)map)).conn.prepareStatement((String)object2);
                    ((SQLHelper)((Object)map)).rs = ((SQLHelper)((Object)map)).pstmt.executeQuery();
                    while (((SQLHelper)((Object)map)).rs.next()) {
                        object = ((SQLHelper)((Object)map)).rs.getString("actual_target_value");
                        int n = ((SQLHelper)((Object)map)).rs.getInt("value");
                        map2.put((String)object, n);
                    }
                    this.confusionMatrix.put(string3, map2);
                }
                catch (SQLException sQLException) {
                    throw new ODMrDAOException((Throwable)sQLException);
                }
                finally {
                    ((SQLHelper)((Object)map)).close();
                }
            }
            string2 = ((ClassTestResult)testResult).geRocResultTable(string, false);
            object2 = ((ClassTestResult)testResult).getRocAreaUnderCurveNonPartitioned(string);
            map = this.rocdata.get(string);
            if (map == null) {
                map = new HashMap<String, Object>();
                this.rocdata.put(string, map);
            }
            if ((object = map.get(string3)) == null) {
                object = new ArrayList<ROCData>();
                ((ArrayList)object).ensureCapacity(MAX_SAMPLE_SIZE);
                String string4 = "SELECT TRUNC(PROBABILITY,25) PROBABILITY, TRUNC(TRUE_POSITIVE_FRACTION," + HIGH_RES_MIN_FRACTION + ") TRUE_POSITIVE_FRACTION, TRUNC(FALSE_POSITIVE_FRACTION," + HIGH_RES_MIN_FRACTION + ") FALSE_POSITIVE_FRACTION, TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES FROM (SELECT t.*, ROWNUM RNUM FROM " + string2 + " t) WHERE ORA_HASH(RNUM,((SELECT COUNT(*) FROM " + string2 + ")-1),12345) < " + MAX_SAMPLE_SIZE + " ORDER BY FALSE_POSITIVE_FRACTION , TRUE_POSITIVE_FRACTION ";
                try (SQLHelper sQLHelper = new SQLHelper();){
                    sQLHelper.conn = this.connManager.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
                    sQLHelper.pstmt.setFetchSize(MAX_SAMPLE_SIZE);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        int n = sQLHelper.rs.getInt("TRUE_POSITIVES");
                        int n2 = sQLHelper.rs.getInt("FALSE_NEGATIVES");
                        int n3 = sQLHelper.rs.getInt("FALSE_POSITIVES");
                        int n4 = sQLHelper.rs.getInt("TRUE_NEGATIVES");
                        double d = sQLHelper.rs.getDouble("TRUE_POSITIVE_FRACTION");
                        double d2 = sQLHelper.rs.getDouble("FALSE_POSITIVE_FRACTION");
                        double d3 = sQLHelper.rs.getDouble("PROBABILITY");
                        ROCData rOCData = new ROCData(d3, n, n2, n3, n4, d, d2);
                        object.add(rOCData);
                    }
                    map.put(string3, object);
                }
            }
            this.loadStatisticsData(string3, (Double)object2, testResult.getMiningAlgorithm(), testResult.getCreationTime(), false);
            treeMap.put(string3, (List<ROCData>)object);
            StatisticsData statisticsData = this.statdata.get(this.getSelectedTargetValue()).get(string3);
            treeMap2.put(string3, statisticsData);
        }
        TuneState tuneState = (TuneState)this.context.getProperty("TUNE_STATE");
        this.rocTableModel = tuneState == null ? new ROCTableModel(treeMap2, treeMap, false) : new ROCTuneTableModel(tuneState, treeMap2, treeMap, false);
    }

    private void loadROCPartitioned() throws ODMrDAOException {
        String string = this.getSelectedTargetValue();
        SQLHelper sQLHelper = new SQLHelper();
        TreeMap<String, List<ROCData>> treeMap = new TreeMap<String, List<ROCData>>();
        TreeMap<String, StatisticsData> treeMap2 = new TreeMap<String, StatisticsData>();
        for (TestResult testResult : this.testResults) {
            List<ROCData> list;
            Object object;
            String string2;
            String string3 = testResult.toString();
            String string4 = this.parentState.getSelectedPartition();
            String string5 = SharedTestEditorState.setPartitionClause(QRY_CM_VALUES_PARTITIONED, string4);
            Map<String, Integer> map = this.confusionMatrix.get(string3);
            if (map == null) {
                map = new HashMap<String, Integer>();
                string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
                string5 = StringUtils.getReplacedString(string5, "<confusion_matrix_table>", string2);
                try {
                    sQLHelper.conn = this.connManager.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string5);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        object = sQLHelper.rs.getString("actual_target_value");
                        int n = sQLHelper.rs.getInt("value");
                        map.put((String)object, n);
                    }
                    this.confusionMatrix.put(string3, map);
                }
                catch (SQLException sQLException) {
                    throw new ODMrDAOException((Throwable)sQLException);
                }
                finally {
                    sQLHelper.close();
                }
            }
            string2 = ((ClassTestResult)testResult).geRocResultTable(string, true);
            string5 = StringUtils.getReplacedString(QRY_ROC_RESULTS_PARTITIONED, "<ROCTable>", string2);
            string5 = SharedTestEditorState.setPartitionClause(string5, string4);
            object = ((ClassTestResult)testResult).getRocAreaUnderCurvePartitioned(string, string4);
            Map<String, List<ROCData>> map2 = this.rocdata.get(string);
            if (map2 == null) {
                map2 = new HashMap<String, List<ROCData>>();
                this.rocdata.put(string, map2);
            }
            if ((list = map2.get(string3)) == null) {
                list = new ArrayList<ROCData>();
                ((ArrayList)list).ensureCapacity(MAX_SAMPLE_SIZE);
                try {
                    sQLHelper.conn = this.connManager.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string5);
                    sQLHelper.pstmt.setFetchSize(MAX_SAMPLE_SIZE);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        int n = sQLHelper.rs.getInt("TRUE_POSITIVES");
                        int n2 = sQLHelper.rs.getInt("FALSE_NEGATIVES");
                        int n3 = sQLHelper.rs.getInt("FALSE_POSITIVES");
                        int n4 = sQLHelper.rs.getInt("TRUE_NEGATIVES");
                        double d = sQLHelper.rs.getDouble("TRUE_POSITIVE_FRACTION");
                        double d2 = sQLHelper.rs.getDouble("FALSE_POSITIVE_FRACTION");
                        double d3 = sQLHelper.rs.getDouble("PROBABILITY");
                        ROCData rOCData = new ROCData(d3, n, n2, n3, n4, d, d2);
                        list.add(rOCData);
                    }
                    map2.put(string3, list);
                }
                catch (SQLException sQLException) {
                    throw new ODMrDAOException((Throwable)sQLException);
                }
                finally {
                    sQLHelper.close();
                }
            }
            this.loadStatisticsData(string3, (Double)object, testResult.getMiningAlgorithm(), testResult.getCreationTime(), true);
            treeMap.put(string3, list);
            StatisticsData statisticsData = this.statdata.get(this.getSelectedTargetValue()).get(string3);
            treeMap2.put(string3, statisticsData);
        }
        TuneState tuneState = (TuneState)this.context.getProperty("TUNE_STATE");
        this.rocTableModel = tuneState == null ? new ROCTableModel(treeMap2, treeMap, true) : new ROCTuneTableModel(tuneState, treeMap2, treeMap, true);
    }

    private void loadROCGraph() {
        List<ROCData> list;
        Object object;
        Map<String, List<ROCData>> map = this.rocdata.get(this.getSelectedTargetValue());
        Map<String, StatisticsData> map2 = this.statdata.get(this.getSelectedTargetValue());
        this.rocGraphModel.clear();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        int n2 = 0;
        for (TestResult testResult : this.testResults) {
            String string = testResult.toString();
            Object object2 = map.get(string);
            if (object2 != null && object2.size() > 0) {
                ++n;
                object = this.parentState.getTestResultGraphColors().get(n2);
                arrayList.add((Color)object);
            }
            ++n2;
        }
        Object[][] objectArray = new Object[n * 5][];
        Object[] objectArray2 = new Object[n * 5];
        Object[] objectArray3 = new Object[n * 5];
        int n3 = 0;
        int n4 = 0;
        for (Object object2 : this.testResults) {
            object = ((TestResult)object2).toString();
            list = map.get(object);
            if (list.size() > 0) {
                objectArray[n3] = new Object[list.size() * 2];
                n4 = 0;
                for (int i = 0; i < list.size(); ++i) {
                    objectArray[n3][n4++] = list.get(i).getFalsePositivesFraction();
                    objectArray[n3][n4++] = list.get(i).getTruePositivesFraction();
                }
            }
            if (objectArray2.length <= 0) continue;
            objectArray2[n3] = TestViewerLrb.get("RESULT_NAME") + ": " + (String)object;
            objectArray3[n3] = 0;
            ++n3;
        }
        if (objectArray.length == 0) {
            return;
        }
        for (Object object2 : this.testResults) {
            object = ((TestResult)object2).toString();
            list = map.get(object);
            StatisticsData statisticsData = map2.get(object);
            n4 = 0;
            objectArray[n3] = new Object[2];
            objectArray[n3][n4++] = list.get(statisticsData.getMaxOverallAccuracyIdx()).getFalsePositivesFraction();
            objectArray[n3][n4++] = list.get(statisticsData.getMaxOverallAccuracyIdx()).getTruePositivesFraction();
            objectArray2[n3] = TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 1;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            objectArray[n3][n4++] = list.get(statisticsData.getMaxAvgAccuracyIdx()).getFalsePositivesFraction();
            objectArray[n3][n4++] = list.get(statisticsData.getMaxAvgAccuracyIdx()).getTruePositivesFraction();
            objectArray2[n3] = TestViewerLrb.get("MAX_AVG_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 2;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            if (statisticsData.getCustomAccuracyIdx() >= 0) {
                objectArray[n3][n4++] = list.get(statisticsData.getCustomAccuracyIdx()).getFalsePositivesFraction();
                objectArray[n3][n4++] = list.get(statisticsData.getCustomAccuracyIdx()).getTruePositivesFraction();
            } else {
                objectArray[n3][n4++] = 0.0;
                objectArray[n3][n4++] = 0.0;
            }
            objectArray2[n3] = TestViewerLrb.get("CUSTOM_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 4;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            objectArray[n3][n4++] = list.get(statisticsData.getModelAccuracyIdx()).getFalsePositivesFraction();
            objectArray[n3][n4++] = list.get(statisticsData.getModelAccuracyIdx()).getTruePositivesFraction();
            objectArray2[n3] = TestViewerLrb.get("CURRENT_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 3;
            ++n3;
        }
        this.rocGraphModel.addRowLabels(objectArray2);
        this.rocGraphModel.addRowMarkerShapes(objectArray3);
        this.rocGraphModel.addGraphData(objectArray);
        this.rocGraphModel.addRowColors(arrayList.toArray(new Color[arrayList.size()]));
    }

    private void loadStatisticsData(String string, Double d, String string2, Date date, boolean bl) throws ODMrDAOException {
        String string3 = this.getSelectedTargetValue();
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        Map<String, List<ROCData>> map = this.rocdata.get(string3);
        Map<String, StatisticsData> map2 = this.statdata.get(string3);
        if (map2 == null) {
            map2 = new HashMap<String, StatisticsData>();
            this.statdata.put(string3, map2);
        }
        if (map2.get(string) == null) {
            Object object;
            double d4 = 0.0;
            Integer n5 = 0;
            Integer n6 = null;
            String string4 = null;
            if (bl) {
                string4 = this.parentState.getSelectedPartition();
            }
            Map<String, Integer> map3 = this.parentState.getBuildRowsCount(string4, bl);
            for (TestResult testResult : this.testResults) {
                object = (ClassTestResult)testResult;
                if (!((TestResult)object).toString().equals(string)) continue;
                BigDecimal bigDecimal = ((ClassTestResult)object).getAvgAccuracy(bl, string4);
                if (bigDecimal != null) {
                    d4 = bigDecimal.doubleValue();
                }
                if (!bl) continue;
                n5 = ((ClassTestResult)object).getTestRows(bl, string4);
                n6 = map3.get(testResult.getName());
            }
            List<ROCData> list = map.get(string);
            for (int i = 0; i < list.size(); ++i) {
                object = (ROCData)list.get(i);
                double d5 = ((ROCData)object).getProb();
                double d6 = ((ROCData)object).getAvgAccuracy();
                double d7 = 0.0;
                double d8 = 0.0;
                if (i < list.size() - 1) {
                    d7 = ((ROCData)list.get(i + 1)).getProb();
                    d8 = ((ROCData)list.get(i + 1)).getAvgAccuracy();
                }
                if (d5 >= 0.5 && d7 < 0.5) {
                    n3 = Math.abs(d4 - d6) < Math.abs(d4 - d8) ? i : i + 1;
                }
                if (d2 < ((ROCData)object).getAccuracy()) {
                    d2 = ((ROCData)object).getAccuracy();
                    n = i;
                }
                if (!(d3 < ((ROCData)object).getAvgAccuracy())) continue;
                d3 = ((ROCData)object).getAvgAccuracy();
                n2 = i;
            }
            map2.put(string, new StatisticsData(d != null ? d : 0.0, n, n2, n4, n3, n5 != null ? n5 : 0, n6 != null ? n6 : Integer.valueOf(0), string2, date));
        }
    }

    public void refreshCustomThresholdData() {
        String string = this.getSelectedTargetValue();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        Map<String, List<ROCData>> map = this.rocdata.get(string);
        Map<String, StatisticsData> map2 = this.statdata.get(string);
        for (Map.Entry<String, List<ROCData>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            List<ROCData> list = entry.getValue();
            for (int i = 0; i < list.size() - 1; ++i) {
                if (CUSTOM_THRESHOLD_OP_HIT_RATIO.equals(this.getCustomThresholdOption())) {
                    d = list.get(i).getTruePositivesFraction();
                    d2 = list.get(i + 1).getTruePositivesFraction();
                } else if (CUSTOM_THRESHOLD_OP_FALSE_ALARM.equals(this.getCustomThresholdOption())) {
                    d = list.get(i).getFalsePositivesFraction();
                    d2 = list.get(i + 1).getFalsePositivesFraction();
                } else if (CUSTOM_THRESHOLD_OP_FALSE_RATIO.equals(this.getCustomThresholdOption())) {
                    d = (double)list.get(i).getFalsePositives() / (double)list.get(i).getFalseNegatives();
                    d2 = (double)list.get(i + 1).getFalsePositives() / (double)list.get(i + 1).getFalseNegatives();
                }
                if (!(this.customThresholdValue >= d) || !(this.customThresholdValue <= d2)) continue;
                double d3 = this.customThresholdValue - d;
                double d4 = d2 - this.customThresholdValue;
                if (d3 <= d4) {
                    n = i;
                    break;
                }
                n = i + 1;
                break;
            }
            StatisticsData statisticsData = map2.get(string2);
            statisticsData.setCustomAccuracyIdx(n);
        }
    }

    public void setCustomThresholdOption(String string) {
        this.customThresholdOption = string;
    }

    public String getCustomThresholdOption() {
        return this.customThresholdOption;
    }

    public void setCustomThresholdValue(double d) {
        this.customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this.customThresholdValue;
    }

    public Map<String, List<ROCData>> getROCData() {
        return this.rocdata.get(this.getSelectedTargetValue());
    }

    public Map<String, StatisticsData> getStatisticsData() {
        return this.statdata.get(this.getSelectedTargetValue());
    }

    public ROCTableModel getRocTableModel() {
        return this.rocTableModel;
    }

    public DefaultGraphDataModel getRocGraphModel() {
        return this.rocGraphModel;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this.testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public int getMODEL() {
        return this.rocTableModel.getMODEL();
    }

    public int getTUNE() {
        return ((ROCTuneTableModel)this.rocTableModel).getTUNE();
    }

    public int getAREA_UNDER_CURVE() {
        return this.rocTableModel.getAREA_UNDER_CURVE();
    }

    public int getMAX_OVERALL() {
        return this.rocTableModel.getMAX_OVERALL();
    }

    public int getMAX_AVG() {
        return this.rocTableModel.getMAX_AVG();
    }

    public int getCUSTOM() {
        return this.rocTableModel.getCUSTOM();
    }

    public int getCURRENT() {
        return this.rocTableModel.getCURRENT();
    }

    public int getALGORITHM() {
        return this.rocTableModel.getALGORITHM();
    }

    public int getBUILD_ROWS() {
        return this.rocTableModel.getBUILD_ROWS();
    }

    public int getTEST_ROWS() {
        return this.rocTableModel.getTEST_ROWS();
    }

    public int getCREATION_DATE() {
        return this.rocTableModel.getCREATION_DATE();
    }
}

