/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCData;
import oracle.dmt.dataminer.tviewer.roc.ROCTableModel;
import oracle.dmt.dataminer.tviewer.roc.StatisticsData;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;

public class ROCTuneTableModel
extends ROCTableModel {
    private static final String TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
    private static final String TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
    private static final String TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
    private static final String TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
    private static final String TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
    private static final String TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
    private int _start = 0;
    private int MODEL = this._start++;
    private int TUNE = this._start++;
    private int AREA_UNDER_CURVE = this._start++;
    private int MAX_OVERALL = this._start++;
    private int MAX_AVG = this._start++;
    private int CUSTOM = this._start++;
    private int CURRENT = this._start++;
    private int ALGORITHM = this._start++;
    private int BUILD_ROWS = -1;
    private int TEST_ROWS = -1;
    private int CREATION_DATE = -1;
    private TuneState _tuneState;

    public ROCTuneTableModel(TuneState tuneState, Map<String, StatisticsData> map, Map<String, List<ROCData>> map2, boolean bl) {
        super(map, map2, bl);
        this.updateColumnIndices2(bl);
        this._tuneState = tuneState;
    }

    @Override
    public int getMODEL() {
        return this.MODEL;
    }

    public int getTUNE() {
        return this.TUNE;
    }

    @Override
    public int getAREA_UNDER_CURVE() {
        return this.AREA_UNDER_CURVE;
    }

    @Override
    public int getMAX_OVERALL() {
        return this.MAX_OVERALL;
    }

    @Override
    public int getMAX_AVG() {
        return this.MAX_AVG;
    }

    @Override
    public int getCUSTOM() {
        return this.CUSTOM;
    }

    @Override
    public int getCURRENT() {
        return this.CURRENT;
    }

    @Override
    public int getALGORITHM() {
        return this.ALGORITHM;
    }

    @Override
    public int getBUILD_ROWS() {
        return this.BUILD_ROWS;
    }

    @Override
    public int getTEST_ROWS() {
        return this.TEST_ROWS;
    }

    @Override
    public int getCREATION_DATE() {
        return this.CREATION_DATE;
    }

    @Override
    protected void updateColumnIndices(boolean bl) {
    }

    private void updateColumnIndices2(boolean bl) {
        if (bl) {
            this.BUILD_ROWS = this._start++;
            this.TEST_ROWS = this._start++;
        } else {
            this.CREATION_DATE = this._start++;
        }
    }

    @Override
    protected void createColumns(boolean bl) {
        this._columnNames = bl ? new String[]{TestViewerLrb.get("RESULT_NAME"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("CREATION_DATE")} : new String[]{TestViewerLrb.get("RESULT_NAME"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == this.getMODEL()) {
            return super.getValueAt(n, this.getMODEL());
        }
        if (n2 == this.getAREA_UNDER_CURVE()) {
            return super.getValueAt(n, this.getAREA_UNDER_CURVE());
        }
        if (n2 == this.getMAX_OVERALL()) {
            return super.getValueAt(n, this.getMAX_OVERALL());
        }
        if (n2 == this.getMAX_AVG()) {
            return super.getValueAt(n, this.getMAX_AVG());
        }
        if (n2 == this.getCUSTOM()) {
            return super.getValueAt(n, this.getCUSTOM());
        }
        if (n2 == this.getCURRENT()) {
            return super.getValueAt(n, this.getCURRENT());
        }
        if (n2 == this.getALGORITHM()) {
            return super.getValueAt(n, this.getALGORITHM());
        }
        if (n2 == this.getCREATION_DATE()) {
            return super.getValueAt(n, this.getCREATION_DATE());
        }
        if (n2 == this.getTUNE()) {
            if (this._statData != null) {
                Object[] objectArray = this._statData.keySet().toArray();
                String string = (String)objectArray[n];
                if (this._tuneState.isTuningNone(string)) {
                    return TUNE_NONE;
                }
                if (this._tuneState.isTuningBenefit(string)) {
                    return TUNE_BENEFIT;
                }
                if (this._tuneState.isTuningCost(string)) {
                    return TUNE_COST;
                }
                if (this._tuneState.isTuningCustomROC(string)) {
                    return TUNE_ROC;
                }
                if (this._tuneState.isTuningCustomLift(string)) {
                    return TUNE_LIFT;
                }
                if (this._tuneState.isTuningCustomProfit(string)) {
                    return TUNE_PROFIT;
                }
            }
        } else if (this._columnNames[n2].equals(TestViewerLrb.get("BUILD_ROWS")) || this._columnNames[n2].equals(TestViewerLrb.get("TEST_ROWS"))) assert (false) : "Shouldn't be here";
        return null;
    }
}

