/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.awt.Window;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.wizard.WizardLrb;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.ExceptionDialog;

public class WorkflowWizard
extends Wizard {
    private static final Logger theLogger = Logger.getLogger(WorkflowWizard.class.getName());

    public String getShortLabel() {
        return "Sample: SDM Flow Diagram";
    }

    public boolean invoke(final Context context) {
        Object object;
        String string = null;
        final ProjectFolder projectFolder = (ProjectFolder)NodeFactory.find((URL)WorkflowWizard.getRoot(context));
        try {
            object = WorkflowWizard.buildNewDiagramURL(context, "workflow", "");
            string = URLFileSystem.getName((URL)object);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        object = string;
        class CreateThread
        extends ProgressRunnable {
            private Workflow _workflowObj = null;
            private Timestamp _createTime = null;
            final /* synthetic */ String val$newName;

            CreateThread() {
                this.val$newName = string;
            }

            public Workflow getWorkflowObj() {
                return this._workflowObj;
            }

            public Timestamp getCreateTime() {
                return this._createTime;
            }

            protected Object doWork() throws Exception {
                Connection connection = ConnectionFolder.getConnection(context);
                try {
                    Timestamp[] timestampArray = new Timestamp[]{new Timestamp(0L)};
                    BigDecimal bigDecimal = Workflow.create(connection, projectFolder.getId(), this.val$newName, "", timestampArray);
                    if (bigDecimal != null) {
                        this._workflowObj = new Workflow(this.val$newName, bigDecimal, projectFolder.getId());
                        this._createTime = timestampArray[0];
                    }
                    Workflow workflow = this._workflowObj;
                    return workflow;
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    SQLHelper.close(connection);
                }
            }
        }
        CreateThread createThread = new CreateThread();
        createThread.setTitle(WorkflowEditorLrb.get("WIZARD_CREATING_ACT_TITLE"));
        createThread.setMessage(WorkflowEditorLrb.get("WIZARD_CREATING_ACT_MSG"));
        try {
            createThread.start(true);
            Workflow workflow = createThread.getWorkflowObj();
            if (workflow == null) {
                return false;
            }
            TreeExplorer treeExplorer = null;
            TNode tNode = null;
            DataMinerNode dataMinerNode = null;
            dataMinerNode = (DataMinerNode)context.getElement();
            treeExplorer = dataMinerNode.getParent().getOwner();
            tNode = this.findProjectFolderTNode(treeExplorer, dataMinerNode);
            WorkflowNode workflowNode = this.createWorkflowNode(tNode, workflow);
            workflowNode.setLastSavedOn(createThread.getCreateTime());
            this.addWorkflowNode(context, tNode, workflowNode);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)WizardLrb.get("WIZARD_FAILURE_TITLE"), (String)WizardLrb.get("WIZARD_FAILURE_MSG"));
            return false;
        }
        return true;
    }

    private void addWorkflowNode(Context context, TNode tNode, WorkflowNode workflowNode) {
        DefaultContainer defaultContainer = (DefaultContainer)tNode.getData();
        defaultContainer.add((Element)workflowNode, true);
        defaultContainer.markDirty(false);
        workflowNode.selectAndOpen(context);
    }

    private WorkflowNode createWorkflowNode(TNode tNode, Workflow workflow) {
        ProjectFolder projectFolder = (ProjectFolder)tNode.getData();
        WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(projectFolder.getURL().getPath() + "/" + workflow.getName(), true);
        workflowNode.setRepositoryData(workflow);
        workflowNode.setId(workflow.getId());
        workflowNode.setParent(tNode);
        return workflowNode;
    }

    private TNode findProjectFolderTNode(TreeExplorer treeExplorer, DataMinerNode dataMinerNode) {
        TNode tNode = null;
        if (!(dataMinerNode instanceof WorkflowNode)) {
            if (dataMinerNode instanceof ProjectFolder) {
                tNode = dataMinerNode.getParent().getAncestorTNode(ConnectionFolder.class, false);
                Enumeration enumeration = BaseDeferredFilter.getChildTreeNodes(tNode);
                while (enumeration.hasMoreElements()) {
                    ProjectFolder projectFolder;
                    TNode tNode2 = (TNode)enumeration.nextElement();
                    if (!(tNode2.getData() instanceof ProjectFolder) || (projectFolder = (ProjectFolder)tNode2.getData()) != dataMinerNode) continue;
                    tNode = tNode2;
                    break;
                }
                assert (tNode != null) : "Did not find TNode for ActivitiesFolder!";
            }
        } else {
            tNode = dataMinerNode.getParent().getAncestorTNode(ProjectFolder.class, false);
        }
        BaseDeferredFilter.getChildTreeNodes(tNode);
        return tNode;
    }

    public boolean isAvailable(Context context) {
        return context.getProject() != null;
    }

    public static URL buildNewDiagramURL(Context context, String string, String string2) throws Exception {
        URL uRL = WorkflowWizard.getRoot(context);
        String string3 = string + string2;
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)string3);
        int n = 1;
        while (URLFileSystem.exists((URL)uRL2)) {
            string3 = string + n++ + string2;
            uRL2 = URLFactory.newURL((URL)uRL, (String)string3);
        }
        if (URLFileSystem.getName((URL)uRL2).length() > 30) {
            String string4 = string.substring(0, 28);
            string3 = string + string2;
            uRL2 = URLFactory.newURL((URL)uRL, (String)string3);
            while (URLFileSystem.exists((URL)uRL2)) {
                string3 = string4 + n++ + string2;
                uRL2 = URLFactory.newURL((URL)uRL, (String)string3);
            }
        }
        return uRL2;
    }

    private static URL getRoot(Context context) {
        Node node = context.getNode();
        URL uRL = node.getURL();
        if (node instanceof WorkflowNode) {
            uRL = URLFileSystem.getParent((URL)node.getURL());
        }
        return uRL;
    }
}

