/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.javatools.icons.OracleIcons;

public class AttributeNameCellRenderer
extends DefaultTableCellRenderer {
    private Icon validIcon;
    private Icon invalidIcon;
    private Map<String, AttributeType> targets;
    private Map<String, AttributeType> keys;
    private Map<String, AttributeType> partitionKeys;

    public AttributeNameCellRenderer(Icon icon, Icon icon2) {
        this.validIcon = icon;
        this.invalidIcon = icon2;
        this.targets = new HashMap<String, AttributeType>();
        this.keys = new HashMap<String, AttributeType>();
    }

    public void setTargets(Map<String, AttributeType> map) {
        this.targets = map;
    }

    public void setKeys(Map<String, AttributeType> map) {
        this.keys = map;
    }

    public void setPartitionKeys(Map<String, AttributeType> map) {
        this.partitionKeys = map;
    }

    @Override
    public void setValue(Object object) {
        AttributeType attributeType = (AttributeType)object;
        this.setText(attributeType.getName());
        if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
            if (this.targets.containsKey(attributeType.getName())) {
                this.setIcon(OracleIcons.getIcon((String)"target.png"));
            } else if (this.keys.containsKey(attributeType.getName())) {
                this.setIcon(OracleIcons.getIcon((String)"key.png"));
            } else if (this.partitionKeys != null && this.partitionKeys.containsKey(attributeType.getName())) {
                this.setIcon(DataMinerIcons.get(Icons.PARTITION_KEY_ICON));
            } else {
                this.setIcon(this.validIcon);
            }
        } else {
            this.setIcon(this.invalidIcon);
        }
    }
}

