/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyModelsPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class ApplyOutputPanel
extends DialogDisplayer<ApplyNode> {
    private static final int MAXIMUM = 30;
    private static final int MAXIMUM_EX = 128;
    private static final String SELECT_A_NODE = DialogsLrb.get("APPLY_SELECT_NODE");
    private static final String SELECT_A_MODEL = DialogsLrb.get("APPLY_SELECT_MODEL");
    private static final String SELECT_A_FUNCTION = DialogsLrb.get("APPLY_SELECT_FUNCTION");
    private static final String MOST_LIKELY = DialogsLrb.get("APPLY_OPTION_MOST_LIKELY");
    private static final String TOPN_ALL = DialogsLrb.get("APPLY_OPTION_ALL");
    private static final BigInteger TOPN_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private ApplyOutputColumnsType _applyOutputColumns;
    private ApplyModelsPanel _parent;
    private boolean _editMode;
    private boolean _dirty = false;
    private ApplyOutputColumnsType.OutputColumn _output;
    private List<AbstractNode> _modelNodes;
    private AbstractNode _selectModelNode;
    private RefModelType _selectModel;
    private String _selectPredictionFunc;
    private ApplyNode.Parameters _selectFuncParameters;
    private boolean _loading = false;
    private boolean _is12gDB;
    private boolean _isDatabaseVersion12_2andUp = false;
    private JCheckBox jAutoGenCheckBox;
    private JCheckBox jBestNCheckBox;
    private JLabel jColumnLabel;
    private JTextField jColumnTextField;
    private NumberTextField jConfidenceField;
    private JLabel jConfidenceLabel;
    private JCheckBox jCutOffCheckBox;
    private JLabel jCutOffLabel;
    private NumberTextField jCutOffTextField;
    private JComboBox<String> jFunctionComboBox;
    private JLabel jFunctionLabel;
    private JComboBox<String> jModelComboBox;
    private JLabel jModelLabel;
    private JComboBox<String> jNValueComboBox;
    private JLabel jNValueLabel;
    private JComboBox<String> jNodeComboBox;
    private JLabel jNodeLabel;
    private JPanel jParamsPanel;
    private JComboBox<Object> jPredictionComboBox;
    private JLabel jPredictionLabel;
    private JComboBox<String> jSortComboBox;
    private JLabel jSortLabel;

    public ApplyOutputPanel(Context context, ApplyModelsPanel applyModelsPanel, ApplyOutputColumnsType applyOutputColumnsType, boolean bl) {
        super(context, applyModelsPanel.getData());
        Object object;
        assert (context != null) : "Context must not be null.";
        this._applyOutputColumns = applyOutputColumnsType;
        this._parent = applyModelsPanel;
        this._editMode = bl;
        if (this._editMode) {
            object = applyModelsPanel.getTable().getSelectedRowsInModel();
            int n = object[0];
            this._output = (ApplyOutputColumnsType.OutputColumn)this._applyOutputColumns.getOutputColumn().get(n);
        } else {
            this._output = new ApplyOutputColumnsType.OutputColumn();
        }
        object = (ApplyNode)applyModelsPanel.getData();
        this._modelNodes = ((ApplyNode)object).findApplyModelNodes();
        this._selectModelNode = null;
        this._selectModel = null;
        this._selectPredictionFunc = null;
        this._selectFuncParameters = null;
        Version version = ConfigUtils.getDatabaseVersion(context);
        this._is12gDB = DbVersionHelper.isDB121Up((Version)version);
        this._isDatabaseVersion12_2andUp = DbVersionHelper.isDB122Up((Version)version);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jColumnLabel, (Component)this.jColumnTextField, (String)DialogsLrb.get("APPLY_OUTPUT_COLUMN"));
        ResourceUtils.resButton((AbstractButton)this.jAutoGenCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_AUTO"));
        ResourceUtils.resLabel((JLabel)this.jNodeLabel, this.jNodeComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_NODE"));
        ResourceUtils.resLabel((JLabel)this.jModelLabel, this.jModelComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_MODEL"));
        ResourceUtils.resLabel((JLabel)this.jFunctionLabel, this.jFunctionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_FUNCTION"));
    }

    @Override
    public void initUI() {
        this._loading = true;
        this.jAutoGenCheckBox.setSelected(true);
        this.jColumnTextField.setEnabled(!this.jAutoGenCheckBox.isSelected());
        this.jNodeComboBox.setEnabled(!this._editMode);
        this.jModelComboBox.setEnabled(!this._editMode);
        if (this._editMode) {
            Object object;
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Iterator<AbstractNode> iterator = this._modelNodes.iterator();
            this._selectModelNode = null;
            while (iterator.hasNext()) {
                AbstractNode object2 = iterator.next();
                if (this._output.getModel().getNodeId().compareTo(object2.getData().getId()) != 0) continue;
                defaultComboBoxModel.addElement(object2.getData().getName());
                this._selectModelNode = object2;
                break;
            }
            this.jNodeComboBox.setModel(defaultComboBoxModel);
            this.jNodeComboBox.setSelectedItem(this._selectModelNode.getData().getName());
            List<RefModelType> object2 = this.getRefModels(this._selectModelNode);
            Iterator<RefModelType> iterator2 = object2.iterator();
            this._selectModel = null;
            defaultComboBoxModel = new DefaultComboBoxModel();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (!this._output.getModel().getName().equals(object.getName())) continue;
                if (this._parent.isShowSchema()) {
                    defaultComboBoxModel.addElement(object.getSchema() + "." + object.getName());
                } else {
                    defaultComboBoxModel.addElement(object.getName());
                }
                this._selectModel = object;
                break;
            }
            this.jModelComboBox.setModel(defaultComboBoxModel);
            object = null;
            object = this._parent.isShowSchema() ? this._selectModel.getSchema() + "." + this._selectModel.getName() : this._selectModel.getName();
            this.jModelComboBox.setSelectedItem(object);
            String[] stringArray = this.getPredictionFunctions(this._selectModel);
            defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
            this.jFunctionComboBox.setModel(defaultComboBoxModel);
            this._selectPredictionFunc = ServerConstants.ApplyPredictionFunctions.getUIFunctionName((String)ApplyNode.getPredictionFunction(this._output));
            this.jFunctionComboBox.setSelectedItem(this._selectPredictionFunc);
            this._selectFuncParameters = ApplyNode.getPredictionFunctionParameters(this.getContext(), this._output);
            this.jColumnTextField.setText(this._selectFuncParameters.getColumn());
            this.populateParamUI(this._selectFuncParameters);
        } else {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            if (this._modelNodes.size() > 1) {
                defaultComboBoxModel.addElement(SELECT_A_NODE);
            }
            for (AbstractNode abstractNode : this._modelNodes) {
                defaultComboBoxModel.addElement(abstractNode.getData().getName());
            }
            this.jNodeComboBox.setModel(defaultComboBoxModel);
            if (this._modelNodes.size() > 1) {
                this.jNodeComboBox.setSelectedItem(SELECT_A_NODE);
                defaultComboBoxModel = new DefaultComboBoxModel();
                defaultComboBoxModel.addElement(SELECT_A_MODEL);
                this.jModelComboBox.setModel(defaultComboBoxModel);
                this.jModelComboBox.setSelectedItem(SELECT_A_MODEL);
                defaultComboBoxModel = new DefaultComboBoxModel();
                defaultComboBoxModel.addElement(SELECT_A_FUNCTION);
                this.jFunctionComboBox.setModel(defaultComboBoxModel);
                this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
            } else {
                String[] stringArray;
                this._selectModelNode = this._modelNodes.get(0);
                List<RefModelType> list = this.getRefModels(this._selectModelNode);
                Iterator<RefModelType> iterator = list.iterator();
                defaultComboBoxModel = new DefaultComboBoxModel();
                if (list.size() > 1) {
                    defaultComboBoxModel.addElement(SELECT_A_MODEL);
                }
                while (iterator.hasNext()) {
                    stringArray = iterator.next();
                    if (this._parent.isShowSchema()) {
                        defaultComboBoxModel.addElement(stringArray.getSchema() + "." + stringArray.getName());
                        continue;
                    }
                    defaultComboBoxModel.addElement(stringArray.getName());
                }
                this.jModelComboBox.setModel(defaultComboBoxModel);
                if (list.size() > 1) {
                    this.jModelComboBox.setSelectedItem(SELECT_A_MODEL);
                    defaultComboBoxModel = new DefaultComboBoxModel();
                    defaultComboBoxModel.addElement(SELECT_A_FUNCTION);
                    this.jFunctionComboBox.setModel(defaultComboBoxModel);
                    this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
                } else {
                    this._selectModel = list.get(0);
                    stringArray = this.getPredictionFunctions(this._selectModel);
                    DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(stringArray);
                    if (stringArray.length > 1) {
                        defaultComboBoxModel2.insertElementAt(SELECT_A_FUNCTION, 0);
                    }
                    this.jFunctionComboBox.setModel(defaultComboBoxModel2);
                    if (stringArray.length > 1) {
                        this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
                    } else {
                        this._selectPredictionFunc = stringArray[0];
                        this._selectFuncParameters = this.getFunctionParameters(this._selectModel, this._selectPredictionFunc);
                        if (this.jAutoGenCheckBox.isSelected()) {
                            String string = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                            this.jColumnTextField.setText(string);
                        }
                        this.populateParamUI(this._selectFuncParameters);
                    }
                }
            }
            this.jParamsPanel.setVisible(false);
            this.revalidate();
        }
        this._loading = false;
    }

    private List<RefModelType> getRefModels(AbstractNode abstractNode) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
        List<RefModelType> list = modelProvider.getOutputModels();
        for (RefModelType refModelType : list) {
            if (!refModelType.isUseForOutput()) continue;
            arrayList.add(refModelType);
        }
        return arrayList;
    }

    private String[] getPredictionFunctions(RefModelType refModelType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION"));
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_PROBABILITY"));
            if (this._is12gDB) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_DETAILS"));
            }
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_SET"));
        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION"));
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_PROBABILITY"));
            if (ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType)) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_COST"));
            }
            if (this._is12gDB || refModelType.getMiningAlgorithm() == MiningAlgorithmType.DECISION_TREE) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_DETAILS"));
            }
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_SET"));
            if (refModelType.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_BOUNDS_LOWER"));
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_BOUNDS_UPPER"));
            }
        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"CLUSTER_ID"));
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"CLUSTER_PROBABILITY"));
            if (this._is12gDB) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"CLUSTER_DETAILS"));
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"CLUSTER_DISTANCE"));
            }
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"CLUSTER_SET"));
        } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"FEATURE_ID"));
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"FEATURE_VALUE"));
            if (this._is12gDB) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"FEATURE_DETAILS"));
            }
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"FEATURE_SET"));
        } else if (refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
            arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION"));
            if (this._is12gDB) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_DETAILS"));
            }
            if (refModelType.getMiningAlgorithm() == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_BOUNDS_LOWER"));
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_BOUNDS_UPPER"));
            }
        }
        if (this._isDatabaseVersion12_2andUp) {
            ApplyNode applyNode = (ApplyNode)this._parent.getData();
            List<AbstractNode> list = applyNode.findApplyModelNodes();
            for (AbstractNode abstractNode : list) {
                Object object;
                if (abstractNode.getData() instanceof ModelNodeType) {
                    object = (ModelNodeType)abstractNode.getData();
                    for (ModelNodeType.Models.Model model : object.getModels().getModel()) {
                        if (!model.getName().equals(refModelType.getName()) || model.getPartitionExpressions() == null || model.getPartitionExpressions().getPartitionExpression() == null || model.getPartitionExpressions().getPartitionExpression().size() <= 0 || ((PartitionExpressionType)model.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute() == null || ((PartitionExpressionType)model.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute().getName() == null || ((PartitionExpressionType)model.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute().getName().trim().equals("")) continue;
                        arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PARTITION_NAME"));
                    }
                    continue;
                }
                object = ApplyNode.isPartitionedModel((BuildNodeType)abstractNode.getData(), refModelType.getName());
                if (!((ApplyNode.PartitionResult)object).isModelFound()) continue;
                if (!((ApplyNode.PartitionResult)object).isModelPartitioned()) break;
                arrayList.add(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PARTITION_NAME"));
                break;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private ApplyNode.Parameters getFunctionParameters(RefModelType refModelType, String string) {
        ApplyNode.Parameters parameters = null;
        String string2 = ServerConstants.ApplyPredictionFunctions.toAlgorithm((String)string);
        if ("PREDICTION".equals(string2)) {
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                boolean bl = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType);
                parameters = new ApplyNode.Prediction(null, bl ? "Model" : "None", null);
            } else if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION || refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING || refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION || refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
                parameters = new ApplyNode.Prediction(null, "None", null);
            }
        } else if ("PREDICTION_DETAILS".equals(string2)) {
            boolean bl = false;
            if (this._is12gDB) {
                Vector<Object> vector = null;
                BigInteger bigInteger = new BigInteger("5");
                String string3 = "ABS";
                if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                    bl = true;
                    vector = new Vector<Object>();
                    vector.add(ApplyNode.TYPICAL_STR);
                    vector.add(ApplyNode.OUTLIER_STR);
                } else if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                    bl = true;
                    if (refModelType.isIsModelBuilt()) {
                        vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                    }
                } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                    bl = true;
                    if (refModelType.isIsModelBuilt()) {
                        vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
                    }
                } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                    bl = true;
                    if (refModelType.isIsModelBuilt()) {
                        vector = ApplyNode.getFeatureIds(this.getContext(), refModelType);
                    }
                }
                parameters = new ApplyNode.PredictionDetails(bl, null, vector, true, bigInteger, string3, null);
            } else {
                parameters = new ApplyNode.PredictionDetails(bl, null, null, false, null, null, null);
            }
        } else if ("CLUSTER_ID".equals(string2)) {
            parameters = new ApplyNode.ClusterId(null);
        } else if ("FEATURE_ID".equals(string2)) {
            parameters = new ApplyNode.FeatureId(null);
        } else if ("PARTITION_NAME".equals(string2)) {
            parameters = new ApplyNode.PartitionNameParameter(string2);
        } else if ("PREDICTION_BOUNDS_LOWER".equals(string2)) {
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                Vector<Object> vector = null;
                if (refModelType.isIsModelBuilt()) {
                    vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                }
                parameters = new ApplyNode.ClassPredictionLowerBounds(null, null, vector, null);
            } else {
                parameters = new ApplyNode.RegressPredictionLowerBounds(null, null);
            }
        } else if ("PREDICTION_BOUNDS_UPPER".equals(string2)) {
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                Vector<Object> vector = null;
                if (refModelType.isIsModelBuilt()) {
                    vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                }
                parameters = new ApplyNode.ClassPredictionUpperBounds(null, null, vector, null);
            } else {
                parameters = new ApplyNode.RegressPredictionUpperBounds(null, null);
            }
        } else if ("PREDICTION_COST".equals(string2)) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.PredictionCost(null, vector, null, "Model", null);
        } else if ("PREDICTION_PROBABILITY".equals(string2)) {
            Vector<Object> vector = null;
            if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                vector = new Vector<Object>();
                vector.add(ApplyNode.TYPICAL_STR);
                vector.add(ApplyNode.OUTLIER_STR);
            } else if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.PredictionProbability(null, vector, null);
        } else if ("PREDICTION_SET".equals(string2)) {
            boolean bl;
            BigInteger bigInteger = TOPN_VALUE;
            int n = 0;
            if (refModelType.isIsModelBuilt()) {
                Vector<Object> vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                n = vector.size();
            }
            parameters = new ApplyNode.PredictionSet(true, bigInteger, n, false, null, false, null, null, (bl = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType)) ? "Model" : "None", null);
        } else if ("CLUSTER_PROBABILITY".equals(string2)) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.ClusterProbability(null, vector, null);
        } else if ("CLUSTER_SET".equals(string2)) {
            BigInteger bigInteger = TOPN_VALUE;
            int n = 0;
            if (refModelType.isIsModelBuilt()) {
                Vector<Object> vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
                n = vector.size();
            }
            parameters = new ApplyNode.ClusterSet(true, bigInteger, n, false, null, null);
        } else if ("CLUSTER_DETAILS".equals(string2)) {
            Vector<Object> vector = null;
            BigInteger bigInteger = new BigInteger("5");
            String string4 = "ABS";
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.ClusterDetails(null, vector, true, bigInteger, string4, null);
        } else if ("CLUSTER_DISTANCE".equals(string2)) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
            }
            parameters = new ApplyNode.ClusterDistance(null, vector, null);
        } else if ("FEATURE_VALUE".equals(string2)) {
            Vector<Object> vector = null;
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getFeatureIds(this.getContext(), refModelType);
            }
            parameters = new ApplyNode.FeatureValue(null, vector, null);
        } else if ("FEATURE_SET".equals(string2)) {
            BigInteger bigInteger = TOPN_VALUE;
            int n = 0;
            if (refModelType.isIsModelBuilt()) {
                Vector<Object> vector = ApplyNode.getFeatureIds(this.getContext(), refModelType);
                n = vector.size();
            }
            parameters = new ApplyNode.FeatureSet(true, bigInteger, n, false, null, null);
        } else if ("FEATURE_DETAILS".equals(string2)) {
            Vector<Object> vector = null;
            BigInteger bigInteger = new BigInteger("5");
            String string5 = "ABS";
            if (refModelType.isIsModelBuilt()) {
                vector = ApplyNode.getFeatureIds(this.getContext(), refModelType);
            }
            parameters = new ApplyNode.FeatureDetails(null, vector, true, bigInteger, string5, null);
        }
        return parameters;
    }

    private String generateUniqueColumnName(String string, String string2, String string3) {
        String string4 = null;
        if (string != null) {
            String string5 = ServerConstants.ApplyPredictionFunctions.toAlgorithm((String)string);
            if ("PREDICTION".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PRED", string2, string3, false);
            } else if ("PREDICTION_BOUNDS_LOWER".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PBLW", string2, string3, false);
            } else if ("PREDICTION_BOUNDS_UPPER".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PBUP", string2, string3, false);
            } else if ("PREDICTION_PROBABILITY".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PROB", string2, string3, false);
            } else if ("PREDICTION_COST".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PCST", string2, string3, false);
            } else if ("PREDICTION_SET".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PSET", string2, string3, false);
            } else if ("PREDICTION_DETAILS".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PDET", string2, string3, false);
            } else if ("CLUSTER_ID".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("CLID", string2, string3, false);
            } else if ("CLUSTER_PROBABILITY".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PROB", string2, string3, false);
            } else if ("CLUSTER_SET".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("CSET", string2, string3, false);
            } else if ("CLUSTER_DETAILS".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("CDET", string2, string3, false);
            } else if ("CLUSTER_DISTANCE".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("CDST", string2, string3, false);
            } else if ("FEATURE_ID".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("FEID", string2, string3, false);
            } else if ("FEATURE_VALUE".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("FVAL", string2, string3, false);
            } else if ("FEATURE_SET".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("FSET", string2, string3, false);
            } else if ("FEATURE_DETAILS".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("FDET", string2, string3, false);
            } else if ("PARTITION_NAME".equals(string5)) {
                string4 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PARTNM", string2, string3, false);
            }
        }
        return string4;
    }

    private void populateParamUI(ApplyNode.Parameters parameters) {
        boolean bl = true;
        this.jPredictionLabel.setVisible(false);
        this.jPredictionComboBox.setVisible(false);
        this.jConfidenceLabel.setVisible(false);
        this.jConfidenceField.setVisible(false);
        this.jBestNCheckBox.setVisible(false);
        this.jNValueLabel.setVisible(false);
        this.jNValueComboBox.setVisible(false);
        this.jCutOffCheckBox.setVisible(false);
        this.jCutOffLabel.setVisible(false);
        this.jCutOffTextField.setVisible(false);
        this.jSortLabel.setVisible(false);
        this.jSortComboBox.setVisible(false);
        if (parameters instanceof ApplyNode.ClassPredictionLowerBounds || parameters instanceof ApplyNode.ClassPredictionUpperBounds || parameters instanceof ApplyNode.RegressPredictionLowerBounds || parameters instanceof ApplyNode.RegressPredictionUpperBounds) {
            this.jConfidenceLabel.setVisible(true);
            this.jConfidenceField.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jConfidenceLabel, (Component)this.jConfidenceField, (String)DialogsLrb.get("APPLY_OUTPUT_CONFIDENCE"));
            this.jConfidenceLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CONFIDENCE");
            Double d = ((ApplyNode.DefaultPredictionBounds)parameters).getConfidence();
            this.jConfidenceField.setSigned(false);
            this.jConfidenceField.setDataType(Double.class);
            this.jConfidenceField.setNumber((Number)(d * 100.0));
            this.jConfidenceField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_MOST_LIKELY_BOUNDS_CONFIDENCE_TIP"));
            if (parameters instanceof ApplyNode.ClassPredictionLowerBounds || parameters instanceof ApplyNode.ClassPredictionUpperBounds) {
                this.jPredictionLabel.setVisible(true);
                this.jPredictionComboBox.setVisible(true);
                ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
                this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                Vector<Object> vector = ((ApplyNode.ClassPredictionBounds)parameters).getTargetValues();
                if (vector != null) {
                    defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
                }
                defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
                this.jPredictionComboBox.setModel(defaultComboBoxModel);
                this.jPredictionComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ApplyOutputPanel.this._loading) {
                            return;
                        }
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Object object = jComboBox.getSelectedItem();
                        if (MOST_LIKELY.equals(object)) {
                            object = null;
                        }
                        if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                            String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                            ApplyOutputPanel.this.jColumnTextField.setText(string);
                        }
                    }
                });
                Object object = ((ApplyNode.ClassPredictionBounds)parameters).getSelectedTarget();
                if (object == null) {
                    this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
                } else {
                    ComboBoxModel<Object> comboBoxModel = this.jPredictionComboBox.getModel();
                    for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                        Object e = comboBoxModel.getElementAt(i);
                        if (!e.toString().equals(object)) continue;
                        this.jPredictionComboBox.setSelectedItem(e);
                        break;
                    }
                }
            }
        } else if (parameters instanceof ApplyNode.PredictionCost) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            Vector<Object> vector = ((ApplyNode.PredictionCost)parameters).getTargetValues();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.PredictionCost)parameters).getSelectedTarget();
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel<Object> comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (!e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof ApplyNode.PredictionProbability) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Vector<Object> vector = ((ApplyNode.PredictionProbability)parameters).getTargetValues();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (ApplyNode.TYPICAL_STR.equals(object)) {
                        object = ApplyNode.TYPICAL;
                    }
                    if (ApplyNode.OUTLIER_STR.equals(object)) {
                        object = ApplyNode.OUTLIER;
                    }
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.PredictionProbability)parameters).getSelectedTarget();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel<Object> comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (!e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof ApplyNode.DefaultPredictionDetails) {
            if (this._is12gDB) {
                Object object;
                Object object2;
                Vector<Object> vector;
                DefaultComboBoxModel<Object> defaultComboBoxModel;
                if (this._selectModel.getMiningFunction() != MiningFunctionType.REGRESSION) {
                    if (parameters instanceof ApplyNode.PredictionDetails) {
                        this.jPredictionLabel.setVisible(true);
                        this.jPredictionComboBox.setVisible(true);
                        ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_TARGET"));
                        this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_TARGET");
                    } else if (parameters instanceof ApplyNode.ClusterDetails) {
                        this.jPredictionLabel.setVisible(true);
                        this.jPredictionComboBox.setVisible(true);
                        ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_CLUSTER"));
                        this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CLUSTER");
                    } else if (parameters instanceof ApplyNode.FeatureDetails) {
                        this.jPredictionLabel.setVisible(true);
                        this.jPredictionComboBox.setVisible(true);
                        ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_FEATURE"));
                        this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_FEATURE");
                    }
                    defaultComboBoxModel = new DefaultComboBoxModel<String>();
                    vector = ((ApplyNode.DefaultPredictionDetails)parameters).getTargetValues();
                    if (vector != null) {
                        defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
                    }
                    defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
                    this.jPredictionComboBox.setModel(defaultComboBoxModel);
                    this.jPredictionComboBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (ApplyOutputPanel.this._loading) {
                                return;
                            }
                            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                            Object object = jComboBox.getSelectedItem();
                            if (ApplyNode.TYPICAL_STR.equals(object)) {
                                object = ApplyNode.TYPICAL;
                            }
                            if (ApplyNode.OUTLIER_STR.equals(object)) {
                                object = ApplyNode.OUTLIER;
                            }
                            if (MOST_LIKELY.equals(object)) {
                                object = null;
                            }
                            if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                                String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                                ApplyOutputPanel.this.jColumnTextField.setText(string);
                            }
                        }
                    });
                    object2 = ((ApplyNode.DefaultPredictionDetails)parameters).getSelectedTarget();
                    if (object2 == null) {
                        this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
                    } else {
                        object = this.jPredictionComboBox.getModel();
                        for (int i = 0; i < object.getSize(); ++i) {
                            Object e = object.getElementAt(i);
                            if (!e.toString().equals(object2)) continue;
                            this.jPredictionComboBox.setSelectedItem(e);
                            break;
                        }
                    }
                }
                this.jSortLabel.setVisible(true);
                this.jSortComboBox.setVisible(true);
                ResourceUtils.resLabel((JLabel)this.jSortLabel, this.jSortComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_SORT"));
                this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_SORT");
                defaultComboBoxModel = new DefaultComboBoxModel();
                vector = ((ApplyNode.DefaultPredictionDetails)parameters).getSortValues();
                if (vector != null) {
                    defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
                }
                this.jSortComboBox.setModel(defaultComboBoxModel);
                object2 = ((ApplyNode.DefaultPredictionDetails)parameters).getSort();
                if (object2 == null) {
                    this.jSortComboBox.setSelectedItem(ServerConstants.ApplyPredictionDetailsSort.toHuman((String)"ABS"));
                } else {
                    this.jSortComboBox.setSelectedItem(object2);
                }
                this.jCutOffCheckBox.setVisible(true);
                this.jCutOffLabel.setVisible(true);
                this.jCutOffTextField.setVisible(true);
                object = ((ApplyNode.DefaultPredictionDetails)parameters).getTopN();
                this.jCutOffCheckBox.setSelected(object != null && ((BigInteger)object).intValue() > 0);
                this.jCutOffCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ApplyOutputPanel.this.jCutOffTextField.setEnabled(ApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                    }
                });
                ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS"));
                this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_MAX_ATTRS");
                ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_VALUE"));
                this.jCutOffLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_MAX_ATTRS_VALUE");
                this.jCutOffTextField.setDataType(Integer.class);
                this.jCutOffTextField.setSigned(false);
                this.jCutOffTextField.setNumber((Number)object);
                this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
                this.jCutOffTextField.setToolTipText(DialogsLrb.get("APPLY_OUTPUT_MAX_ATTRS_TIP"));
            } else {
                bl = false;
            }
        } else if (parameters instanceof ApplyNode.PredictionSet) {
            this.jBestNCheckBox.setVisible(true);
            this.jNValueLabel.setVisible(true);
            this.jNValueComboBox.setVisible(true);
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            BigInteger bigInteger = ((ApplyNode.PredictionSet)parameters).getTopN();
            this.jBestNCheckBox.setSelected(bigInteger != null);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jNValueComboBox.setEnabled(ApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            ResourceUtils.resLabel((JLabel)this.jNValueLabel, this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            this.jNValueLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((ApplyNode.PredictionSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(TOPN_ALL);
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(i + "");
            }
            this.jNValueComboBox.setModel(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            this.jNValueComboBox.setSelectedItem(bigInteger.equals(TOPN_VALUE) ? TOPN_ALL : bigInteger.toString());
            Double d = null;
            String string = null;
            String string2 = null;
            if (((ApplyNode.PredictionSet)parameters).getUseCostType().compareTo("Model") == 0) {
                d = ((ApplyNode.PredictionSet)parameters).getCostCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_COST_VALUE_TIP");
            } else {
                d = ((ApplyNode.PredictionSet)parameters).getCutOff();
                string = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE");
                string2 = DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE_TIP");
            }
            boolean bl2 = d != null && d > 0.0;
            this.jCutOffCheckBox.setSelected(bl2);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jCutOffTextField.setEnabled(ApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)string);
            this.jCutOffLabel.getAccessibleContext().setAccessibleName(string);
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(string2);
        } else if (parameters instanceof ApplyNode.ClusterProbability) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_CLUSTER"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CLUSTER");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Vector<Object> vector = ((ApplyNode.ClusterProbability)parameters).getClusterIds();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.ClusterProbability)parameters).getClusterId();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel<Object> comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (!e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof ApplyNode.ClusterDistance) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_CLUSTER"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_CLUSTER");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Vector<Object> vector = ((ApplyNode.ClusterDistance)parameters).getClusterIds();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.ClusterDistance)parameters).getClusterId();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel<Object> comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (!e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof ApplyNode.ClusterSet) {
            this.jBestNCheckBox.setVisible(true);
            this.jNValueLabel.setVisible(true);
            this.jNValueComboBox.setVisible(true);
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            BigInteger bigInteger = ((ApplyNode.ClusterSet)parameters).getTopN();
            this.jBestNCheckBox.setSelected(bigInteger != null);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jNValueComboBox.setEnabled(ApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            ResourceUtils.resLabel((JLabel)this.jNValueLabel, this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            this.jNValueLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((ApplyNode.ClusterSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(TOPN_ALL);
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(i + "");
            }
            this.jNValueComboBox.setModel(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            this.jNValueComboBox.setSelectedItem(bigInteger.equals(TOPN_VALUE) ? TOPN_ALL : bigInteger.toString());
            Double d = ((ApplyNode.ClusterSet)parameters).getCutOff();
            this.jCutOffCheckBox.setSelected(d != null && d > 0.0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jCutOffTextField.setEnabled(ApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE"));
            this.jCutOffLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_PROB_VALUE");
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE_TIP"));
        } else if (parameters instanceof ApplyNode.FeatureValue) {
            this.jPredictionLabel.setVisible(true);
            this.jPredictionComboBox.setVisible(true);
            ResourceUtils.resLabel((JLabel)this.jPredictionLabel, this.jPredictionComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_FEATURE"));
            this.jPredictionLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_FEATURE");
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            Vector<Object> vector = ((ApplyNode.FeatureValue)parameters).getFeatureIds();
            if (vector != null) {
                defaultComboBoxModel = new DefaultComboBoxModel<Object>(vector);
            }
            defaultComboBoxModel.insertElementAt(MOST_LIKELY, 0);
            this.jPredictionComboBox.setModel(defaultComboBoxModel);
            this.jPredictionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ApplyOutputPanel.this._loading) {
                        return;
                    }
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Object object = jComboBox.getSelectedItem();
                    if (MOST_LIKELY.equals(object)) {
                        object = null;
                    }
                    if (ApplyOutputPanel.this.jAutoGenCheckBox.isSelected()) {
                        String string = ApplyOutputPanel.this.generateUniqueColumnName(ApplyOutputPanel.this._selectPredictionFunc, ApplyOutputPanel.this._selectModel.getName(), object != null ? object.toString() : null);
                        ApplyOutputPanel.this.jColumnTextField.setText(string);
                    }
                }
            });
            Object object = ((ApplyNode.FeatureValue)parameters).getFeatureId();
            if (object == null) {
                this.jPredictionComboBox.setSelectedItem(MOST_LIKELY);
            } else {
                ComboBoxModel<Object> comboBoxModel = this.jPredictionComboBox.getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object e = comboBoxModel.getElementAt(i);
                    if (!e.toString().equals(object)) continue;
                    this.jPredictionComboBox.setSelectedItem(e);
                    break;
                }
            }
        } else if (parameters instanceof ApplyNode.FeatureSet) {
            this.jBestNCheckBox.setVisible(true);
            this.jNValueLabel.setVisible(true);
            this.jNValueComboBox.setVisible(true);
            this.jCutOffCheckBox.setVisible(true);
            this.jCutOffLabel.setVisible(true);
            this.jCutOffTextField.setVisible(true);
            BigInteger bigInteger = ((ApplyNode.FeatureSet)parameters).getTopN();
            this.jBestNCheckBox.setSelected(bigInteger != null);
            this.jBestNCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jNValueComboBox.setEnabled(ApplyOutputPanel.this.jBestNCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jBestNCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_BEST_N"));
            this.jBestNCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_BEST_N");
            ResourceUtils.resLabel((JLabel)this.jNValueLabel, this.jNValueComboBox, (String)DialogsLrb.get("APPLY_OUTPUT_N_VALUE"));
            this.jNValueLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_N_VALUE");
            int n = ((ApplyNode.FeatureSet)parameters).getMaxN();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement(TOPN_ALL);
            for (int i = 1; i <= n; ++i) {
                defaultComboBoxModel.addElement(i + "");
            }
            this.jNValueComboBox.setModel(defaultComboBoxModel);
            this.jNValueComboBox.setEnabled(this.jBestNCheckBox.isSelected());
            this.jNValueComboBox.setSelectedItem(bigInteger.equals(TOPN_VALUE) ? TOPN_ALL : bigInteger.toString());
            Double d = ((ApplyNode.FeatureSet)parameters).getCutOff();
            this.jCutOffCheckBox.setSelected(d != null && d > 0.0);
            this.jCutOffCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplyOutputPanel.this.jCutOffTextField.setEnabled(ApplyOutputPanel.this.jCutOffCheckBox.isSelected());
                }
            });
            ResourceUtils.resButton((AbstractButton)this.jCutOffCheckBox, (String)DialogsLrb.get("APPLY_OUTPUT_USE_CUTOFF"));
            this.jCutOffCheckBox.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_USE_CUTOFF");
            ResourceUtils.resLabel((JLabel)this.jCutOffLabel, (Component)this.jCutOffTextField, (String)DialogsLrb.get("APPLY_OUTPUT_PROB_VALUE"));
            this.jCutOffLabel.getAccessibleContext().setAccessibleName("APPLY_OUTPUT_PROB_VALUE");
            this.jCutOffTextField.setDataType(Double.class);
            this.jCutOffTextField.setSigned(false);
            this.jCutOffTextField.setNumber((Number)d);
            this.jCutOffTextField.setEnabled(this.jCutOffCheckBox.isSelected());
            this.jCutOffTextField.setToolTipText(DialogsLrb.get("PAGE_OUTPUT_TOPN_CUTOFF_VALUE_TIP"));
        } else {
            bl = false;
        }
        this.jParamsPanel.setVisible(bl);
        this.revalidate();
    }

    private ApplyNode.Parameters getUserParameters(ApplyNode.Parameters parameters) throws ValidationException {
        String string = this.jColumnTextField.getText();
        if (parameters instanceof ApplyNode.Prediction) {
            parameters.setColumn(string);
            return parameters;
        }
        if (parameters instanceof ApplyNode.DefaultPredictionDetails) {
            Object object;
            ApplyNode.DefaultPredictionDetails defaultPredictionDetails = (ApplyNode.DefaultPredictionDetails)parameters;
            if (this.jPredictionComboBox != null) {
                object = this.jPredictionComboBox.getSelectedItem();
                if (object == MOST_LIKELY) {
                    object = null;
                }
                defaultPredictionDetails.setSelectedTarget(object);
            }
            object = (String)this.jSortComboBox.getSelectedItem();
            defaultPredictionDetails.setSort((String)object);
            defaultPredictionDetails.setColumn(string);
            Number number = null;
            boolean bl = this.jCutOffCheckBox.isSelected();
            if (bl) {
                number = this.jCutOffTextField.getNumber();
            }
            defaultPredictionDetails.setUseTopN(bl);
            defaultPredictionDetails.setTopN(bl && number != null ? BigInteger.valueOf(number.longValue()) : null);
            defaultPredictionDetails.validate();
            return defaultPredictionDetails;
        }
        if (parameters instanceof ApplyNode.ClassPredictionLowerBounds) {
            ApplyNode.ClassPredictionLowerBounds classPredictionLowerBounds = (ApplyNode.ClassPredictionLowerBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            classPredictionLowerBounds.setLowerBound(string);
            classPredictionLowerBounds.setConfidence(d != null ? Double.valueOf(d / 100.0) : null);
            classPredictionLowerBounds.setSelectedTarget(object);
            classPredictionLowerBounds.validate();
            return classPredictionLowerBounds;
        }
        if (parameters instanceof ApplyNode.ClassPredictionUpperBounds) {
            ApplyNode.ClassPredictionUpperBounds classPredictionUpperBounds = (ApplyNode.ClassPredictionUpperBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            classPredictionUpperBounds.setUpperBound(string);
            classPredictionUpperBounds.setConfidence(d != null ? Double.valueOf(d / 100.0) : null);
            classPredictionUpperBounds.setSelectedTarget(object);
            classPredictionUpperBounds.validate();
            return classPredictionUpperBounds;
        }
        if (parameters instanceof ApplyNode.RegressPredictionLowerBounds) {
            ApplyNode.RegressPredictionLowerBounds regressPredictionLowerBounds = (ApplyNode.RegressPredictionLowerBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            regressPredictionLowerBounds.setLowerBound(string);
            regressPredictionLowerBounds.setConfidence(d != null ? Double.valueOf(d / 100.0) : null);
            regressPredictionLowerBounds.validate();
            return regressPredictionLowerBounds;
        }
        if (parameters instanceof ApplyNode.RegressPredictionUpperBounds) {
            ApplyNode.RegressPredictionUpperBounds regressPredictionUpperBounds = (ApplyNode.RegressPredictionUpperBounds)parameters;
            Double d = (Double)this.jConfidenceField.getNumber();
            regressPredictionUpperBounds.setUpperBound(string);
            regressPredictionUpperBounds.setConfidence(d != null ? Double.valueOf(d / 100.0) : null);
            regressPredictionUpperBounds.validate();
            return regressPredictionUpperBounds;
        }
        if (parameters instanceof ApplyNode.PredictionCost) {
            ApplyNode.PredictionCost predictionCost = (ApplyNode.PredictionCost)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            predictionCost.setColumn(string);
            predictionCost.setSelectedTarget(object);
            return predictionCost;
        }
        if (parameters instanceof ApplyNode.PredictionProbability) {
            ApplyNode.PredictionProbability predictionProbability = (ApplyNode.PredictionProbability)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (object == MOST_LIKELY) {
                object = null;
            }
            predictionProbability.setColumn(string);
            predictionProbability.setSelectedTarget(object);
            return predictionProbability;
        }
        if (parameters instanceof ApplyNode.PredictionSet) {
            ApplyNode.PredictionSet predictionSet = (ApplyNode.PredictionSet)parameters;
            String string2 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string2 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl2 = this.jCutOffCheckBox.isSelected();
            if (bl2) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            predictionSet.setColumn(string);
            predictionSet.setUseTopN(bl);
            predictionSet.setTopN(bl ? (string2.equals(TOPN_ALL) ? TOPN_VALUE : new BigInteger(string2)) : null);
            if (predictionSet.getUseCostType().compareTo("None") == 0) {
                predictionSet.setUseCutOff(bl2);
                predictionSet.setCutOff(bl2 ? d : null);
            } else {
                predictionSet.setUseCostCutOff(bl2);
                predictionSet.setCostCutOff(bl2 ? d : null);
            }
            predictionSet.validate();
            return predictionSet;
        }
        if (parameters instanceof ApplyNode.ClusterId) {
            ApplyNode.ClusterId clusterId = (ApplyNode.ClusterId)parameters;
            clusterId.setColumn(string);
            return clusterId;
        }
        if (parameters instanceof ApplyNode.ClusterProbability) {
            ApplyNode.ClusterProbability clusterProbability = (ApplyNode.ClusterProbability)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (MOST_LIKELY.equals(object)) {
                object = null;
            }
            clusterProbability.setColumn(string);
            clusterProbability.setClusterId(object);
            return clusterProbability;
        }
        if (parameters instanceof ApplyNode.ClusterDistance) {
            ApplyNode.ClusterDistance clusterDistance = (ApplyNode.ClusterDistance)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (MOST_LIKELY.equals(object)) {
                object = null;
            }
            clusterDistance.setColumn(string);
            clusterDistance.setClusterId(object);
            return clusterDistance;
        }
        if (parameters instanceof ApplyNode.ClusterSet) {
            ApplyNode.ClusterSet clusterSet = (ApplyNode.ClusterSet)parameters;
            String string3 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string3 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl3 = this.jCutOffCheckBox.isSelected();
            if (bl3) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            clusterSet.setColumn(string);
            clusterSet.setUseTopN(bl);
            clusterSet.setTopN(bl ? (string3.equals(TOPN_ALL) ? TOPN_VALUE : new BigInteger(string3)) : null);
            clusterSet.setUseCutOff(bl3);
            clusterSet.setCutOff(bl3 ? d : null);
            clusterSet.validate();
            return clusterSet;
        }
        if (parameters instanceof ApplyNode.FeatureId) {
            ApplyNode.FeatureId featureId = (ApplyNode.FeatureId)parameters;
            featureId.setColumn(string);
            return featureId;
        }
        if (parameters instanceof ApplyNode.PartitionNameParameter) {
            ApplyNode.PartitionNameParameter partitionNameParameter = (ApplyNode.PartitionNameParameter)parameters;
            partitionNameParameter.setColumn(string);
            return partitionNameParameter;
        }
        if (parameters instanceof ApplyNode.FeatureValue) {
            ApplyNode.FeatureValue featureValue = (ApplyNode.FeatureValue)parameters;
            Object object = this.jPredictionComboBox.getSelectedItem();
            if (MOST_LIKELY.equals(object)) {
                object = null;
            }
            featureValue.setColumn(string);
            featureValue.setFeatureId(object);
            return featureValue;
        }
        if (parameters instanceof ApplyNode.FeatureSet) {
            ApplyNode.FeatureSet featureSet = (ApplyNode.FeatureSet)parameters;
            String string4 = null;
            boolean bl = this.jBestNCheckBox.isSelected();
            if (bl) {
                string4 = (String)this.jNValueComboBox.getSelectedItem();
            }
            Double d = null;
            boolean bl4 = this.jCutOffCheckBox.isSelected();
            if (bl4) {
                d = (Double)this.jCutOffTextField.getNumber();
            }
            featureSet.setColumn(string);
            featureSet.setUseTopN(bl);
            featureSet.setTopN(bl ? (string4.equals(TOPN_ALL) ? TOPN_VALUE : new BigInteger(string4)) : null);
            featureSet.setUseCutOff(bl4);
            featureSet.setCutOff(bl4 ? d : null);
            featureSet.validate();
            return featureSet;
        }
        return null;
    }

    private void initComponents() {
        this.jColumnLabel = new JLabel();
        this.jColumnTextField = new JTextField();
        this.jAutoGenCheckBox = new JCheckBox();
        this.jNodeLabel = new JLabel();
        this.jNodeComboBox = new JComboBox();
        this.jModelLabel = new JLabel();
        this.jModelComboBox = new JComboBox();
        this.jFunctionLabel = new JLabel();
        this.jFunctionComboBox = new JComboBox();
        this.jParamsPanel = new JPanel();
        this.jPredictionLabel = new JLabel();
        this.jPredictionComboBox = new JComboBox();
        this.jConfidenceLabel = new JLabel();
        this.jConfidenceField = new NumberTextField();
        this.jSortLabel = new JLabel();
        this.jSortComboBox = new JComboBox();
        this.jBestNCheckBox = new JCheckBox();
        this.jNValueLabel = new JLabel();
        this.jNValueComboBox = new JComboBox();
        this.jCutOffCheckBox = new JCheckBox();
        this.jCutOffLabel = new JLabel();
        this.jCutOffTextField = new NumberTextField();
        this.jColumnLabel.setLabelFor(this.jColumnTextField);
        this.jColumnLabel.setText("Column:");
        this.jColumnLabel.setName("jColumnLabel");
        this.jColumnTextField.setName("jColumnTextField");
        this.jAutoGenCheckBox.setText("Auto");
        this.jAutoGenCheckBox.setName("jAutoGenCheckBox");
        this.jAutoGenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jAutoGenCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNodeLabel.setLabelFor(this.jNodeComboBox);
        this.jNodeLabel.setText("Node:");
        this.jNodeLabel.setName("jNodeLabel");
        this.jNodeComboBox.setName("jNodeComboBox");
        this.jNodeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jNodeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jModelLabel.setLabelFor(this.jModelComboBox);
        this.jModelLabel.setText("Model:");
        this.jModelLabel.setName("jModelLabel");
        this.jModelComboBox.setName("jModelComboBox");
        this.jModelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jModelComboBoxActionPerformed(actionEvent);
            }
        });
        this.jFunctionLabel.setLabelFor(this.jFunctionComboBox);
        this.jFunctionLabel.setText("Function:");
        this.jFunctionLabel.setName("jFunctionLabel");
        this.jFunctionComboBox.setName("jFunctionComboBox");
        this.jFunctionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyOutputPanel.this.jFunctionComboBoxActionPerformed(actionEvent);
            }
        });
        this.jParamsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.jParamsPanel.setName("jParamsPanel");
        this.jPredictionLabel.setLabelFor(this.jPredictionComboBox);
        this.jPredictionLabel.setText("Prediction:");
        this.jPredictionLabel.setName("jPredictionLabel");
        this.jPredictionComboBox.setName("jPredictionComboBox");
        this.jConfidenceLabel.setLabelFor((Component)this.jConfidenceField);
        this.jConfidenceLabel.setText("Confidence (%):");
        this.jConfidenceLabel.setName("jConfidenceLabel");
        this.jConfidenceField.setName("jConfidenceField");
        this.jSortLabel.setLabelFor(this.jSortComboBox);
        this.jSortLabel.setText("Sort By Weight:");
        this.jSortLabel.setName("jSortLabel");
        this.jSortComboBox.setName("jSortComboBox");
        this.jBestNCheckBox.setText("Best N");
        this.jBestNCheckBox.setName("jBestNCheckBox");
        this.jNValueLabel.setLabelFor(this.jNValueComboBox);
        this.jNValueLabel.setText("N Value:");
        this.jNValueLabel.setName("jNValueLabel");
        this.jNValueComboBox.setName("jNValueComboBox");
        this.jCutOffCheckBox.setText("CutOff");
        this.jCutOffCheckBox.setName("jCutOffCheckBox");
        this.jCutOffLabel.setLabelFor((Component)this.jCutOffTextField);
        this.jCutOffLabel.setText("Prob Value:");
        this.jCutOffLabel.setName("jCutOffLabel");
        this.jCutOffTextField.setName("jCutOffTextField");
        GroupLayout groupLayout = new GroupLayout(this.jParamsPanel);
        this.jParamsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPredictionLabel).addComponent(this.jConfidenceLabel).addComponent(this.jSortLabel, -2, 82, -2).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNValueLabel).addComponent(this.jCutOffLabel, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPredictionComboBox, 0, 164, Short.MAX_VALUE).addComponent((Component)this.jConfidenceField, -1, 164, Short.MAX_VALUE).addComponent(this.jSortComboBox, 0, 164, Short.MAX_VALUE).addComponent(this.jNValueComboBox, 0, 164, Short.MAX_VALUE).addComponent((Component)this.jCutOffTextField, -1, 164, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCutOffCheckBox, -1, 250, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jBestNCheckBox, -1, 250, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this.jConfidenceLabel, this.jPredictionLabel, this.jSortLabel);
        groupLayout.linkSize(0, this.jCutOffLabel, this.jNValueLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPredictionLabel).addComponent(this.jPredictionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConfidenceLabel).addComponent((Component)this.jConfidenceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSortLabel).addComponent(this.jSortComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jBestNCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNValueLabel).addComponent(this.jNValueComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCutOffCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCutOffLabel).addComponent((Component)this.jCutOffTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jColumnLabel, -2, 55, -2).addComponent(this.jModelLabel, -2, 54, -2).addComponent(this.jFunctionLabel, -2, 54, -2).addComponent(this.jNodeLabel, -2, 53, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jParamsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jColumnTextField, GroupLayout.Alignment.TRAILING, -1, 282, Short.MAX_VALUE).addComponent(this.jNodeComboBox, GroupLayout.Alignment.TRAILING, 0, 282, Short.MAX_VALUE).addComponent(this.jModelComboBox, GroupLayout.Alignment.TRAILING, 0, 282, Short.MAX_VALUE).addComponent(this.jFunctionComboBox, GroupLayout.Alignment.TRAILING, 0, 282, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAutoGenCheckBox).addContainerGap()));
        groupLayout2.linkSize(0, this.jColumnLabel, this.jFunctionLabel, this.jModelLabel, this.jNodeLabel);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jColumnLabel).addComponent(this.jAutoGenCheckBox).addComponent(this.jColumnTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNodeLabel).addComponent(this.jNodeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelLabel).addComponent(this.jModelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFunctionLabel).addComponent(this.jFunctionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jParamsPanel, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jAutoGenCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.jAutoGenCheckBox.isSelected()) {
            Object object = this.jPredictionComboBox.getSelectedItem();
            String string = MOST_LIKELY.equals(object) ? null : object.toString();
            String string2 = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), string != null ? string : null);
            this.jColumnTextField.setText(string2);
        }
        this.jColumnTextField.setEnabled(!this.jAutoGenCheckBox.isSelected());
    }

    private void jNodeComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jNodeComboBox.getSelectedItem();
        if (!SELECT_A_NODE.equals(string)) {
            this.jNodeComboBox.removeItem(SELECT_A_NODE);
            for (AbstractNode object2 : this._modelNodes) {
                if (string.compareTo(object2.getData().getName()) != 0) continue;
                this._selectModelNode = object2;
                break;
            }
            List<RefModelType> list = this.getRefModels(this._selectModelNode);
            Iterator<RefModelType> iterator = list.iterator();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            if (list.size() > 1) {
                defaultComboBoxModel.addElement(SELECT_A_MODEL);
            }
            RefModelType refModelType = null;
            while (iterator.hasNext()) {
                refModelType = iterator.next();
                if (this._parent.isShowSchema()) {
                    defaultComboBoxModel.addElement(refModelType.getSchema() + "." + refModelType.getName());
                    continue;
                }
                defaultComboBoxModel.addElement(refModelType.getName());
            }
            this.jModelComboBox.setModel(defaultComboBoxModel);
            if (list.size() == 1) {
                this._selectModel = refModelType;
            } else {
                this.jModelComboBox.setSelectedItem(SELECT_A_MODEL);
                this._selectModel = null;
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel2 = null;
            this._selectPredictionFunc = null;
            this._selectFuncParameters = null;
            if (this._selectModel != null) {
                String[] stringArray = this.getPredictionFunctions(this._selectModel);
                defaultComboBoxModel2 = new DefaultComboBoxModel<String>(stringArray);
                if (stringArray.length > 1) {
                    defaultComboBoxModel2.insertElementAt(SELECT_A_FUNCTION, 0);
                }
                this.jFunctionComboBox.setModel(defaultComboBoxModel2);
                if (stringArray.length > 1) {
                    this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
                } else {
                    this._selectPredictionFunc = stringArray[0];
                    this._selectFuncParameters = this.getFunctionParameters(this._selectModel, this._selectPredictionFunc);
                }
                if (this.jAutoGenCheckBox.isSelected()) {
                    String string2 = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                    this.jColumnTextField.setText(string2);
                }
            } else {
                defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
                defaultComboBoxModel2.addElement(SELECT_A_FUNCTION);
                this.jFunctionComboBox.setModel(defaultComboBoxModel2);
            }
            this.populateParamUI(this._selectFuncParameters);
        }
    }

    private void jModelComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jModelComboBox.getSelectedItem();
        if (!SELECT_A_MODEL.equals(string)) {
            String[] stringArray;
            this.jModelComboBox.removeItem(SELECT_A_MODEL);
            List<RefModelType> list = this.getRefModels(this._selectModelNode);
            Iterator<RefModelType> iterator = list.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                stringArray = iterator.next();
                string2 = this._parent.isShowSchema() ? stringArray.getSchema() + "." + stringArray.getName() : stringArray.getName();
                if (string.compareTo(string2) != 0) continue;
                this._selectModel = stringArray;
                break;
            }
            stringArray = this.getPredictionFunctions(this._selectModel);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
            if (stringArray.length > 1) {
                defaultComboBoxModel.insertElementAt(SELECT_A_FUNCTION, 0);
            }
            this.jFunctionComboBox.setModel(defaultComboBoxModel);
            this._selectPredictionFunc = null;
            this._selectFuncParameters = null;
            if (stringArray.length > 1) {
                this.jFunctionComboBox.setSelectedItem(SELECT_A_FUNCTION);
            } else {
                this._selectPredictionFunc = stringArray[0];
                this._selectFuncParameters = this.getFunctionParameters(this._selectModel, this._selectPredictionFunc);
            }
            if (this.jAutoGenCheckBox.isSelected()) {
                String string3 = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                this.jColumnTextField.setText(string3);
            }
            this.populateParamUI(this._selectFuncParameters);
        }
    }

    private void jFunctionComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        String string = (String)this.jFunctionComboBox.getSelectedItem();
        if (!SELECT_A_FUNCTION.equals(string)) {
            this.jFunctionComboBox.removeItem(SELECT_A_FUNCTION);
            this._selectPredictionFunc = string;
            this._selectFuncParameters = this.getFunctionParameters(this._selectModel, string);
            if (this.jAutoGenCheckBox.isSelected()) {
                String string2 = this.generateUniqueColumnName(this._selectPredictionFunc, this._selectModel.getName(), null);
                this.jColumnTextField.setText(string2);
            }
            this.populateParamUI(this._selectFuncParameters);
        }
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        try {
            if (this._selectModel == null) {
                MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("APPLY_OUTPUT_MODEL_NOT_SELECTED"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (this._selectFuncParameters == null) {
                MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("APPLY_OUTPUT_FUNCTION_NOT_SELECTED"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            ApplyNode.Parameters parameters = this.getUserParameters(this._selectFuncParameters);
            String string = parameters.getColumn();
            boolean bl2 = SQLHelper.isExpandedObjNameEnabled(this._context);
            if (bl2) {
                if (string.length() > 128) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_COLUMN_TOO_LONG_EX"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    return false;
                }
            } else if (string.length() > 30) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_COLUMN_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            if (this._editMode) {
                String string2 = ApplyNode.getPredictionFunctionOutput(this._output);
                if (string2.compareTo(string) != 0) {
                    if (this._parent.getOutputColumnNameGenerator().doesNameExist(string)) {
                        throw new ValidationException(DialogsLrb.get("APPLY_OPTION_DUPLICATE_COLUMN_ERROR"));
                    }
                    this._parent.getOutputColumnNameGenerator().removeUniqueName(string2);
                    this._parent.getOutputColumnNameGenerator().addUniqueName(string);
                }
            } else {
                if (this._parent.getOutputColumnNameGenerator().doesNameExist(string)) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_DUPLICATE_COLUMN_ERROR"));
                }
                this._output.setModel((RefModelType)MetaDataHelper.copyMetadataObject(this._selectModel));
                this._parent.getOutputColumnNameGenerator().addUniqueName(string);
            }
            ApplyNode.setPredictionFunctionParameters(this._output, parameters);
            this._dirty = true;
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    public ApplyOutputColumnsType.OutputColumn getOutput() {
        return this._output;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return this._editMode ? DialogsLrb.get("APPLY_OUTPUT_DIALOG_EDIT_TITLE") : DialogsLrb.get("APPLY_OUTPUT_DIALOG_ADD_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "apply_output";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(350, 350));
    }
}

