/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.beans.PropertyChangeSupport;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyModelsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionNameType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;

public class ApplyWizardModel
extends WizardModel {
    private volatile boolean _wizardIsCancelled;
    private Context _context;
    private ApplyModelsPanel _parent;
    private List<AbstractNode> _availModelNodes;
    private AbstractNode _selectedModelNode;
    private List<RefModelType> _availModels;
    private List<RefModelType> _selectedModels;
    private ApplyOutputColumnsType _applyOutputColumns;
    private ApplyNode.Parameters _mostLikelyParam;
    private ApplyNode.Parameters _mostLikelyDetailsParam;
    private ApplyNode.Parameters _mostLikelyBoundsParam;
    private ApplyNode.Parameters _mostLikelyDistanceParam;
    private ApplyNode.Parameters _topNParam;
    private ApplyNode.Parameters _specificParam;
    private List<Object> _specificValues;
    private ApplyNode.Parameters _specificDetailsParam;
    private ApplyNode.Parameters _specificBoundsParam;
    private ApplyNode.Parameters _specificDistanceParam;
    private boolean partitionNameSelected;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private static final BigInteger TOPN_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);

    public ApplyWizardModel(ApplyModelsPanel applyModelsPanel, Context context, ApplyOutputColumnsType applyOutputColumnsType) {
        this._context = context;
        this._parent = applyModelsPanel;
        this._applyOutputColumns = applyOutputColumnsType;
        ApplyNode applyNode = (ApplyNode)this._parent.getData();
        this._availModelNodes = applyNode.findApplyModelNodes();
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public ApplyModelsPanel getParent() {
        return this._parent;
    }

    public ApplyOutputColumnsType getApplyOutputColumns() {
        return this._applyOutputColumns;
    }

    public List<AbstractNode> getAvailModelNodes() {
        return this._availModelNodes;
    }

    public void setSelectedModelNode(AbstractNode abstractNode) {
        this._selectedModelNode = abstractNode;
        this._availModels = null;
        this._selectedModels = null;
    }

    public AbstractNode getSelectedModelNode() {
        return this._selectedModelNode;
    }

    public List<RefModelType> getAvailModels() {
        if (this._availModels == null) {
            this._availModels = new ArrayList<RefModelType>();
            ModelProvider modelProvider = (ModelProvider)((Object)this._selectedModelNode);
            List<RefModelType> list = modelProvider.getOutputModels();
            for (RefModelType refModelType : list) {
                if (!refModelType.isUseForOutput()) continue;
                this._availModels.add(refModelType);
            }
        }
        return this._availModels;
    }

    public void setSelectedModels(List<RefModelType> list) {
        this._selectedModels = list;
    }

    public List<RefModelType> getSelectedModels() {
        return this._selectedModels;
    }

    public void setMostLikelyParam(ApplyNode.Parameters parameters) {
        this._mostLikelyParam = parameters;
    }

    public ApplyNode.Parameters getMostLikelyParam() {
        this._mostLikelyParam = null;
        RefModelType refModelType = this._selectedModels.get(0);
        if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION || refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION || refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
            this._mostLikelyParam = new ApplyNode.Prediction(null, "None", null);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
            this._mostLikelyParam = new ApplyNode.ClusterId(null);
        } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
            this._mostLikelyParam = new ApplyNode.FeatureId(null);
        }
        return this._mostLikelyParam;
    }

    public void setMostLikelyDetailsParam(ApplyNode.Parameters parameters) {
        this._mostLikelyDetailsParam = parameters;
    }

    public ApplyNode.Parameters getMostLikelyDetailsParam() {
        block3: {
            block1: {
                RefModelType refModelType;
                block4: {
                    block2: {
                        this._mostLikelyDetailsParam = null;
                        ApplyNode applyNode = (ApplyNode)this.getParent().getData();
                        if (!applyNode.is12gDB()) break block1;
                        refModelType = this._selectedModels.get(0);
                        if (refModelType.getMiningFunction() != MiningFunctionType.CLASSIFICATION && refModelType.getMiningFunction() != MiningFunctionType.ANOMALY_DETECTION && refModelType.getMiningFunction() != MiningFunctionType.REGRESSION) break block2;
                        this._mostLikelyDetailsParam = new ApplyNode.PredictionDetails(false, null, null, true, new BigInteger("5"), ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ABS.value(), null);
                        break block3;
                    }
                    if (refModelType.getMiningFunction() != MiningFunctionType.CLUSTERING) break block4;
                    this._mostLikelyDetailsParam = new ApplyNode.ClusterDetails(null, null, true, new BigInteger("5"), ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ABS.value(), null);
                    break block3;
                }
                if (refModelType.getMiningFunction() != MiningFunctionType.FEATURE_EXTRACTION) break block3;
                this._mostLikelyDetailsParam = new ApplyNode.FeatureDetails(null, null, true, new BigInteger("5"), ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ABS.value(), null);
                break block3;
            }
            for (RefModelType refModelType : this._selectedModels) {
                if (refModelType.getMiningAlgorithm() != MiningAlgorithmType.DECISION_TREE) continue;
                this._mostLikelyDetailsParam = new ApplyNode.PredictionDetails(false, null, null, true, null, null, null);
                break;
            }
        }
        return this._mostLikelyDetailsParam;
    }

    public void setMostLikelyBoundsParam(ApplyNode.Parameters parameters) {
        this._mostLikelyBoundsParam = parameters;
    }

    public ApplyNode.Parameters getMostLikelyBoundsParam() {
        this._mostLikelyBoundsParam = null;
        for (RefModelType refModelType : this._selectedModels) {
            if (refModelType.getMiningAlgorithm() != MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) continue;
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                this._mostLikelyBoundsParam = new ApplyNode.ClassPredictionBounds(null, null, null, null, null);
            }
            if (refModelType.getMiningFunction() != MiningFunctionType.REGRESSION) break;
            this._mostLikelyBoundsParam = new ApplyNode.RegressPredictionBounds(null, null, null);
            break;
        }
        return this._mostLikelyBoundsParam;
    }

    public void setTopNParam(ApplyNode.Parameters parameters) {
        this._topNParam = parameters;
    }

    public ApplyNode.Parameters getTopNParam() {
        this._topNParam = null;
        RefModelType refModelType = null;
        for (RefModelType refModelType2 : this._selectedModels) {
            if (!refModelType2.isIsModelBuilt()) continue;
            refModelType = refModelType2;
            break;
        }
        BigInteger bigInteger = TOPN_VALUE;
        int n = 0;
        if (this._selectedModels.get(0).getMiningFunction() == MiningFunctionType.CLASSIFICATION || this._selectedModels.get(0).getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
            if (refModelType != null) {
                Vector<Object> vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                n = vector.size();
            }
            if (this._selectedModels.get(0).getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                if (this._selectedModels.size() > 1) {
                    this._topNParam = new ApplyNode.PredictionSet(true, bigInteger, n, false, null, false, null, null, "None", null);
                }
                if (this._selectedModels.size() == 1) {
                    boolean bl = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), this._selectedModels.get(0));
                    this._topNParam = new ApplyNode.PredictionSet(true, bigInteger, n, false, null, false, null, null, bl ? "Model" : "None", null);
                }
            } else {
                this._topNParam = new ApplyNode.PredictionSet(true, bigInteger, n, false, null, false, null, null, "None", null);
            }
        } else if (this._selectedModels.get(0).getMiningFunction() == MiningFunctionType.CLUSTERING) {
            if (refModelType != null) {
                Vector<Object> vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
                n = vector.size();
            }
            this._topNParam = new ApplyNode.ClusterSet(true, bigInteger, n, false, null, null);
        } else if (this._selectedModels.get(0).getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
            if (refModelType != null) {
                Vector<Object> vector = ApplyNode.getFeatureIds(this.getContext(), refModelType);
                n = vector.size();
            }
            this._topNParam = new ApplyNode.FeatureSet(true, bigInteger, n, false, null, null);
        }
        return this._topNParam;
    }

    public void setSpecificParam(ApplyNode.Parameters parameters) {
        this._specificParam = parameters;
    }

    public ApplyNode.Parameters getSpecificParam() {
        this._specificParam = null;
        RefModelType refModelType = null;
        int n = 0;
        for (RefModelType refModelType2 : this._selectedModels) {
            if (refModelType2.isIsModelBuilt()) {
                refModelType = refModelType2;
            }
            ++n;
        }
        if (refModelType != null && n == 1) {
            Vector<Object> vector;
            if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                vector = new Vector();
                vector.add(ApplyNode.TYPICAL_STR);
                vector.add(ApplyNode.OUTLIER_STR);
                this._specificParam = new ApplyNode.PredictionProbability(null, vector, null);
            } else if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                vector = ApplyNode.getPredictionValues(this.getContext(), refModelType.getSchema(), refModelType.getName());
                this._specificParam = new ApplyNode.PredictionProbability(null, vector, null);
            } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                vector = ApplyNode.getClusterIds(this.getContext(), refModelType.getSchema(), refModelType.getName());
                this._specificParam = new ApplyNode.ClusterProbability(null, vector, null);
            } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                vector = ApplyNode.getFeatureIds(this.getContext(), refModelType);
                this._specificParam = new ApplyNode.FeatureValue(null, vector, null);
            }
        }
        return this._specificParam;
    }

    public void setSpecificValues(List<Object> list) {
        this._specificValues = list;
    }

    public List<Object> getSpecificValues() {
        return this._specificValues;
    }

    /*
     * WARNING - void declaration
     */
    public boolean generateOutputColumns() {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        Object object6;
        ApplyNode.ApplyOutputColumnNameGenerator applyOutputColumnNameGenerator = this._parent.getOutputColumnNameGenerator();
        if (this._selectedModels == null) {
            this._selectedModels = this.getAvailModels();
            this.getMostLikelyParam();
        } else if (this._mostLikelyParam == null && this._topNParam == null && this._specificParam == null && !this.isPartitionNameSelected()) {
            this.getMostLikelyParam();
        }
        if (this._mostLikelyParam != null) {
            for (RefModelType refModelType : this._selectedModels) {
                String string;
                String string2;
                String string3;
                Object object7;
                object6 = new ApplyOutputColumnsType.OutputColumn();
                object6.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                ApplyOutputColumnsType.OutputColumn number2 = new ApplyOutputColumnsType.OutputColumn();
                number2.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                object5 = null;
                object42 = null;
                object3 = null;
                object2 = null;
                ApplyNode.PredictionCost predictionCost = null;
                object = null;
                boolean bl = false;
                if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION || refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                    object5 = applyOutputColumnNameGenerator.GenerateColumnName("PRED", refModelType.getName(), null, true);
                    object42 = applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), null, true);
                    object2 = new ApplyNode.PredictionProbability(null, null, (String)object42);
                    bl = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType);
                    if (bl) {
                        object = new ApplyOutputColumnsType.OutputColumn();
                        object.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                        object3 = applyOutputColumnNameGenerator.GenerateColumnName("PCST", refModelType.getName(), null, true);
                        predictionCost = new ApplyNode.PredictionCost(null, null, (String)object3, "Model", null);
                    }
                } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                    object5 = applyOutputColumnNameGenerator.GenerateColumnName("CLID", refModelType.getName(), null, true);
                    object42 = applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), null, true);
                    object2 = new ApplyNode.ClusterProbability(null, null, (String)object42);
                } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                    object5 = applyOutputColumnNameGenerator.GenerateColumnName("FEID", refModelType.getName(), null, true);
                    object42 = applyOutputColumnNameGenerator.GenerateColumnName("FVAL", refModelType.getName(), null, true);
                    object2 = new ApplyNode.FeatureValue(null, null, (String)object42);
                } else if (refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
                    object5 = applyOutputColumnNameGenerator.GenerateColumnName("PRED", refModelType.getName(), null, true);
                }
                this._mostLikelyParam.setColumn((String)object5);
                if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                    ((ApplyNode.Prediction)this._mostLikelyParam).setUseCostType(bl ? "Model" : "None");
                }
                ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)object6, this._mostLikelyParam);
                this._applyOutputColumns.getOutputColumn().add(object6);
                if (object42 != null) {
                    ApplyNode.setPredictionFunctionParameters(number2, (ApplyNode.Parameters)object2);
                    this._applyOutputColumns.getOutputColumn().add(number2);
                }
                if (object3 != null) {
                    ApplyNode.setPredictionFunctionParameters(object, predictionCost);
                    this._applyOutputColumns.getOutputColumn().add(object);
                }
                if (this._mostLikelyDetailsParam != null) {
                    object7 = new ApplyOutputColumnsType.OutputColumn();
                    object7.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                    string3 = null;
                    if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION || refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION || refModelType.getMiningFunction() == MiningFunctionType.REGRESSION) {
                        string3 = applyOutputColumnNameGenerator.GenerateColumnName("PDET", refModelType.getName(), null, true);
                    } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                        string3 = applyOutputColumnNameGenerator.GenerateColumnName("CDET", refModelType.getName(), null, true);
                    } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                        string3 = applyOutputColumnNameGenerator.GenerateColumnName("FDET", refModelType.getName(), null, true);
                    }
                    this._mostLikelyDetailsParam.setColumn(string3);
                    ApplyNode.setPredictionFunctionParameters(object7, this._mostLikelyDetailsParam);
                    this._applyOutputColumns.getOutputColumn().add(object7);
                }
                if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING && this._mostLikelyDistanceParam != null) {
                    object7 = new ApplyOutputColumnsType.OutputColumn();
                    object7.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                    string3 = applyOutputColumnNameGenerator.GenerateColumnName("CDST", refModelType.getName(), null, true);
                    this._mostLikelyDistanceParam.setColumn(string3);
                    ApplyNode.setPredictionFunctionParameters(object7, this._mostLikelyDistanceParam);
                    this._applyOutputColumns.getOutputColumn().add(object7);
                }
                if (refModelType.getMiningAlgorithm() != MiningAlgorithmType.GENERALIZED_LINEAR_MODEL || this._mostLikelyBoundsParam == null) continue;
                if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                    object7 = null;
                    string3 = null;
                    string3 = new ApplyOutputColumnsType.OutputColumn();
                    string3.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                    string2 = applyOutputColumnNameGenerator.GenerateColumnName("PBLW", refModelType.getName(), null, true);
                    object7 = new ApplyNode.ClassPredictionLowerBounds(null, null, null, string2);
                    ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)string3, (ApplyNode.Parameters)object7);
                    this._applyOutputColumns.getOutputColumn().add(string3);
                    string3 = new ApplyOutputColumnsType.OutputColumn();
                    string3.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                    string = applyOutputColumnNameGenerator.GenerateColumnName("PBUP", refModelType.getName(), null, true);
                    object7 = new ApplyNode.ClassPredictionUpperBounds(null, null, null, string);
                    ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)string3, (ApplyNode.Parameters)object7);
                    this._applyOutputColumns.getOutputColumn().add(string3);
                    continue;
                }
                if (refModelType.getMiningFunction() != MiningFunctionType.REGRESSION) continue;
                object7 = null;
                string3 = null;
                string3 = new ApplyOutputColumnsType.OutputColumn();
                string3.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                string2 = applyOutputColumnNameGenerator.GenerateColumnName("PBLW", refModelType.getName(), null, true);
                object7 = new ApplyNode.RegressPredictionLowerBounds(null, string2);
                ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)string3, (ApplyNode.Parameters)object7);
                this._applyOutputColumns.getOutputColumn().add(string3);
                string3 = new ApplyOutputColumnsType.OutputColumn();
                string3.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                string = applyOutputColumnNameGenerator.GenerateColumnName("PBUP", refModelType.getName(), null, true);
                object7 = new ApplyNode.RegressPredictionUpperBounds(null, string);
                ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)string3, (ApplyNode.Parameters)object7);
                this._applyOutputColumns.getOutputColumn().add(string3);
            }
        }
        if (this._topNParam != null) {
            Iterator<RefModelType> iterator = (ApplyNode.DefaultPredictionSet)this._topNParam;
            boolean bl = ((ApplyNode.DefaultPredictionSet)((Object)iterator)).isUseCutOff();
            object6 = ((ApplyNode.DefaultPredictionSet)((Object)iterator)).getCutOff();
            BigInteger bigInteger = ((ApplyNode.DefaultPredictionSet)((Object)iterator)).getTopN();
            for (Object object42 : this._selectedModels) {
                object3 = new ApplyOutputColumnsType.OutputColumn();
                object3.setModel((RefModelType)MetaDataHelper.copyMetadataObject(object42));
                object2 = null;
                boolean bl2 = false;
                if (object42.getMiningFunction() == MiningFunctionType.CLASSIFICATION || object42.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                    bl2 = ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), object42);
                    object2 = applyOutputColumnNameGenerator.GenerateColumnName("PSET", object42.getName(), null, true);
                    if (bl2) {
                        ((ApplyNode.PredictionSet)this._topNParam).setUseCostType("Model");
                        ((ApplyNode.PredictionSet)this._topNParam).setUseCostCutOff(bl);
                        ((ApplyNode.PredictionSet)this._topNParam).setCostCutOff((Double)object6);
                    } else {
                        ((ApplyNode.PredictionSet)this._topNParam).setUseCostType("None");
                        ((ApplyNode.PredictionSet)this._topNParam).setUseCostCutOff(false);
                        ((ApplyNode.PredictionSet)this._topNParam).setCostCutOff(null);
                    }
                } else if (object42.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                    object2 = applyOutputColumnNameGenerator.GenerateColumnName("CSET", object42.getName(), null, true);
                } else if (object42.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                    object2 = applyOutputColumnNameGenerator.GenerateColumnName("FSET", object42.getName(), null, true);
                }
                this._topNParam.setColumn((String)object2);
                ((ApplyNode.DefaultPredictionSet)this._topNParam).setUseTopN(bigInteger != null);
                ((ApplyNode.DefaultPredictionSet)this._topNParam).setTopN(bigInteger);
                ((ApplyNode.DefaultPredictionSet)this._topNParam).setUseCutOff(bl);
                ((ApplyNode.DefaultPredictionSet)this._topNParam).setCutOff((Double)object6);
                ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)object3, this._topNParam);
                this._applyOutputColumns.getOutputColumn().add(object3);
            }
        }
        if (this.isPartitionNameSelected()) {
            for (RefModelType refModelType : this._selectedModels) {
                object6 = ApplyNode.isPartitionedModel((BuildNodeType)this._selectedModelNode.getData(), refModelType.getName());
                if (!((ApplyNode.PartitionResult)object6).isModelFound() || !((ApplyNode.PartitionResult)object6).isModelPartitioned()) continue;
                ApplyOutputColumnsType.OutputColumn outputColumn = new ApplyOutputColumnsType.OutputColumn();
                outputColumn.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                object5 = this._parent.getOutputColumnNameGenerator().GenerateColumnName("PARTNM", refModelType.getName(), null, false);
                object42 = new PartitionNameType();
                object3 = new PartitionNameType.Column();
                object3.setName((String)object5);
                object42.setColumn((PartitionNameType.Column)object3);
                outputColumn.setPartitionName((PartitionNameType)object42);
                this._applyOutputColumns.getOutputColumn().add(outputColumn);
            }
        }
        if (this._specificParam != null) {
            for (RefModelType refModelType : this._selectedModels) {
                for (Object e : this._specificValues) {
                    Object object8;
                    void var5_18;
                    object5 = new ApplyOutputColumnsType.OutputColumn();
                    object5.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                    object42 = null;
                    if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                        object42 = applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), e.toString(), true);
                        object3 = (ApplyNode.PredictionProbability)this._specificParam;
                        ((ApplyNode.DefaultPredictionProbability)object3).setSelectedTarget(e);
                        ((ApplyNode.DefaultPredictionProbability)object3).setColumn((String)object42);
                    } else if (refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                        void var5_16;
                        if (ApplyNode.TYPICAL_STR.equals(e)) {
                            Integer n = ApplyNode.TYPICAL;
                        }
                        if (ApplyNode.OUTLIER_STR.equals(var5_16)) {
                            Integer n = ApplyNode.OUTLIER;
                        }
                        object42 = applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), var5_18.toString(), true);
                        object3 = (ApplyNode.PredictionProbability)this._specificParam;
                        ((ApplyNode.DefaultPredictionProbability)object3).setSelectedTarget(var5_18);
                        ((ApplyNode.DefaultPredictionProbability)object3).setColumn((String)object42);
                    } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                        object42 = applyOutputColumnNameGenerator.GenerateColumnName("PROB", refModelType.getName(), e.toString(), true);
                        object3 = (ApplyNode.ClusterProbability)this._specificParam;
                        ((ApplyNode.ClusterProbability)object3).setClusterId(e);
                        ((ApplyNode.DefaultParameters)object3).setColumn((String)object42);
                    } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                        object42 = applyOutputColumnNameGenerator.GenerateColumnName("FVAL", refModelType.getName(), e.toString(), true);
                        object3 = (ApplyNode.FeatureValue)this._specificParam;
                        ((ApplyNode.FeatureValue)object3).setFeatureId(e);
                        ((ApplyNode.DefaultParameters)object3).setColumn((String)object42);
                    }
                    ApplyNode.setPredictionFunctionParameters(object5, this._specificParam);
                    this._applyOutputColumns.getOutputColumn().add(object5);
                    if (this._specificDetailsParam != null) {
                        object5 = new ApplyOutputColumnsType.OutputColumn();
                        object5.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                        object42 = null;
                        if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION || refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                            object42 = applyOutputColumnNameGenerator.GenerateColumnName("PDET", refModelType.getName(), var5_18.toString(), true);
                        } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                            object42 = applyOutputColumnNameGenerator.GenerateColumnName("CDET", refModelType.getName(), var5_18.toString(), true);
                        } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                            object42 = applyOutputColumnNameGenerator.GenerateColumnName("FDET", refModelType.getName(), var5_18.toString(), true);
                        }
                        object3 = (ApplyNode.DefaultPredictionDetails)this._specificDetailsParam;
                        ((ApplyNode.DefaultPredictionDetails)object3).setSelectedTarget(var5_18);
                        ((ApplyNode.DefaultPredictionDetails)object3).setColumn((String)object42);
                        ApplyNode.setPredictionFunctionParameters(object5, this._specificDetailsParam);
                        this._applyOutputColumns.getOutputColumn().add(object5);
                    }
                    if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING && this._specificDistanceParam != null) {
                        object5 = new ApplyOutputColumnsType.OutputColumn();
                        object5.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                        object42 = null;
                        object42 = applyOutputColumnNameGenerator.GenerateColumnName("CDST", refModelType.getName(), var5_18.toString(), true);
                        object3 = (ApplyNode.ClusterDistance)this._specificDistanceParam;
                        ((ApplyNode.ClusterDistance)object3).setClusterId(var5_18);
                        ((ApplyNode.DefaultParameters)object3).setColumn((String)object42);
                        ApplyNode.setPredictionFunctionParameters(object5, this._specificDistanceParam);
                        this._applyOutputColumns.getOutputColumn().add(object5);
                    }
                    if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                        if (ApplyNode.doesModelCostExist((ApplyNode)this._parent.getData(), refModelType)) {
                            object3 = null;
                            object2 = null;
                            object8 = null;
                            object8 = new ApplyOutputColumnsType.OutputColumn();
                            object8.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                            object3 = applyOutputColumnNameGenerator.GenerateColumnName("PCST", refModelType.getName(), var5_18.toString(), true);
                            object2 = new ApplyNode.PredictionCost(var5_18.toString(), null, (String)object3, "Model", null);
                            ApplyNode.setPredictionFunctionParameters(object8, (ApplyNode.Parameters)object2);
                            this._applyOutputColumns.getOutputColumn().add(object8);
                        }
                        if (this._specificBoundsParam == null || refModelType.getMiningAlgorithm() != MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) continue;
                        object3 = null;
                        object2 = null;
                        object2 = new ApplyOutputColumnsType.OutputColumn();
                        object2.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                        object8 = applyOutputColumnNameGenerator.GenerateColumnName("PBLW", refModelType.getName(), var5_18.toString(), true);
                        object3 = new ApplyNode.ClassPredictionLowerBounds(null, var5_18.toString(), null, (String)object8);
                        ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)object2, (ApplyNode.Parameters)object3);
                        this._applyOutputColumns.getOutputColumn().add(object2);
                        object2 = new ApplyOutputColumnsType.OutputColumn();
                        object2.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                        object = applyOutputColumnNameGenerator.GenerateColumnName("PBUP", refModelType.getName(), var5_18.toString(), true);
                        object3 = new ApplyNode.ClassPredictionUpperBounds(null, var5_18.toString(), null, (String)object);
                        ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)object2, (ApplyNode.Parameters)object3);
                        this._applyOutputColumns.getOutputColumn().add(object2);
                        continue;
                    }
                    if (refModelType.getMiningFunction() != MiningFunctionType.REGRESSION || this._specificBoundsParam == null) continue;
                    object3 = null;
                    object2 = null;
                    object2 = new ApplyOutputColumnsType.OutputColumn();
                    object2.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                    object8 = applyOutputColumnNameGenerator.GenerateColumnName("PBLW", refModelType.getName(), var5_18.toString(), true);
                    object3 = new ApplyNode.RegressPredictionLowerBounds(null, (String)object8);
                    ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)object2, (ApplyNode.Parameters)object3);
                    this._applyOutputColumns.getOutputColumn().add(object2);
                    object2 = new ApplyOutputColumnsType.OutputColumn();
                    object2.setModel((RefModelType)MetaDataHelper.copyMetadataObject(refModelType));
                    object = applyOutputColumnNameGenerator.GenerateColumnName("PBUP", refModelType.getName(), var5_18.toString(), true);
                    object3 = new ApplyNode.RegressPredictionUpperBounds(null, (String)object);
                    ApplyNode.setPredictionFunctionParameters((ApplyOutputColumnsType.OutputColumn)object2, (ApplyNode.Parameters)object3);
                    this._applyOutputColumns.getOutputColumn().add(object2);
                }
            }
        }
        return true;
    }

    public void setMostLikelyDistanceParam(ApplyNode.Parameters parameters) {
        this._mostLikelyDistanceParam = parameters;
    }

    public ApplyNode.Parameters getMostLikelyDistanceParam() {
        this._mostLikelyDistanceParam = null;
        ApplyNode applyNode = (ApplyNode)this.getParent().getData();
        if (applyNode.is12gDB()) {
            for (RefModelType refModelType : this._selectedModels) {
                if (refModelType.getMiningFunction() != MiningFunctionType.CLUSTERING) continue;
                this._mostLikelyDistanceParam = new ApplyNode.ClusterDistance(null, null, null);
                break;
            }
        }
        return this._mostLikelyDistanceParam;
    }

    public void setSpecificDetailsParam(ApplyNode.Parameters parameters) {
        this._specificDetailsParam = parameters;
    }

    public ApplyNode.Parameters getSpecificDetailsParam() {
        this._specificDetailsParam = null;
        ApplyNode applyNode = (ApplyNode)this.getParent().getData();
        if (applyNode.is12gDB()) {
            RefModelType refModelType = this._selectedModels.get(0);
            if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION || refModelType.getMiningFunction() == MiningFunctionType.ANOMALY_DETECTION) {
                this._specificDetailsParam = new ApplyNode.PredictionDetails(false, null, null, true, new BigInteger("5"), ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ABS.value(), null);
            } else if (refModelType.getMiningFunction() == MiningFunctionType.CLUSTERING) {
                this._specificDetailsParam = new ApplyNode.ClusterDetails(null, null, true, new BigInteger("5"), ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ABS.value(), null);
            } else if (refModelType.getMiningFunction() == MiningFunctionType.FEATURE_EXTRACTION) {
                this._specificDetailsParam = new ApplyNode.FeatureDetails(null, null, true, new BigInteger("5"), ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ABS.value(), null);
            }
        }
        return this._specificDetailsParam;
    }

    public void setSpecificBoundsParam(ApplyNode.Parameters parameters) {
        this._specificBoundsParam = parameters;
    }

    public ApplyNode.Parameters getSpecificBoundsParam() {
        this._specificBoundsParam = null;
        ApplyNode applyNode = (ApplyNode)this.getParent().getData();
        if (applyNode.is12gDB()) {
            for (RefModelType refModelType : this._selectedModels) {
                if (refModelType.getMiningAlgorithm() != MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) continue;
                if (refModelType.getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                    this._specificBoundsParam = new ApplyNode.ClassPredictionBounds(null, null, null, null, null);
                }
                if (refModelType.getMiningFunction() != MiningFunctionType.REGRESSION) break;
                this._specificBoundsParam = new ApplyNode.RegressPredictionBounds(null, null, null);
                break;
            }
        }
        return this._specificBoundsParam;
    }

    public void setSpecificDistanceParam(ApplyNode.Parameters parameters) {
        this._specificDistanceParam = parameters;
    }

    public ApplyNode.Parameters getSpecificDistanceParam() {
        this._specificDistanceParam = null;
        ApplyNode applyNode = (ApplyNode)this.getParent().getData();
        if (applyNode.is12gDB()) {
            for (RefModelType refModelType : this._selectedModels) {
                if (refModelType.getMiningFunction() != MiningFunctionType.CLUSTERING) continue;
                this._specificDistanceParam = new ApplyNode.ClusterDistance(null, null, null);
                break;
            }
        }
        return this._specificDistanceParam;
    }

    public boolean isPartitionNameSelected() {
        return this.partitionNameSelected;
    }

    public void setPartitionNameSelected(boolean bl) {
        this.partitionNameSelected = bl;
    }
}

