/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerShuttlePanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.SingleColumnTableModel;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.SampleNode;
import oracle.dmt.dataminer.workflow.xmlschema.ASSOAGGREGATES;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class ModelARAggregatePanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(ModelARAggregatePanel.class.getName());
    private JButton _remIncAntecedentBtn;
    private JButton _addIncAntecedentBtn;
    private AbstractBuildNode node;
    private Context _context;
    private Map<String, CommonSettingDataObject> stateMap;
    private BuildNodeType nodeDataCopy;
    private SingleColumnTableModel<String> tableModel;
    private boolean dirty;
    private boolean bInitialized;
    private boolean bPIMode;
    private DataMinerTablePanel aggregationTablePanel;
    private JLabel lblHeader;

    public ModelARAggregatePanel(PropertyModel propertyModel, Map<String, CommonSettingDataObject> map) {
        super(null);
        this.bPIMode = true;
        this.stateMap = map;
        this._context = this.getContext(propertyModel);
        this.node = this.getTargetNode(propertyModel);
        this.nodeDataCopy = (BuildNodeType)this.node.getData();
        this.tableModel = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
        this.addAncestorListener(new PIAncestorListener(this));
        this.initComponents();
        this.launchLoading(false);
    }

    public ModelARAggregatePanel(AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, Context context, Map<String, CommonSettingDataObject> map) {
        this.bPIMode = false;
        this.node = abstractBuildNode;
        this._context = context;
        this.stateMap = map;
        this.nodeDataCopy = buildNodeType;
        this.tableModel = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
        this.initComponents();
        this.launchLoading(false);
    }

    public void setStateMap(Map<String, CommonSettingDataObject> map) {
        this.stateMap = map;
    }

    public void reload(PropertyModel propertyModel) {
        this.bPIMode = true;
        this._context = this.getContext(propertyModel);
        this.node = this.getTargetNode(propertyModel);
        this.nodeDataCopy = (BuildNodeType)this.node.getData();
        this.launchLoading(true);
    }

    private void launchLoading(boolean bl) {
        this.initUIComponents();
        this.aggregationTablePanel.getTable().setModel((TableModel)((Object)this.tableModel));
        LoadUI loadUI = new LoadUI(bl);
        loadUI.execute();
    }

    private AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildNodeType) {
            return (AbstractBuildNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    public void initUIComponents() {
        this.lblHeader.setText(AlgSettingsLrb.get("ASSO_FILTER_AGGREGATION_TEXT"));
    }

    public void processItemChanged() {
        List<String> list = this.getItemsFromTable(this.getAggregationTablePanel().getTable());
        for (Map.Entry<String, CommonSettingDataObject> entry : this.stateMap.entrySet()) {
            CommonSettingDataObject commonSettingDataObject = entry.getValue();
            if (list.size() > 0) {
                ASSOAGGREGATES aSSOAGGREGATES = new ASSOAGGREGATES();
                for (String string : list) {
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName(string);
                    attributeType.setDataType("");
                    attributeType.setStatus(AttributeStatus.VALID);
                    aSSOAGGREGATES.getAttribute().add(attributeType);
                }
                commonSettingDataObject.setValue("ASSO_AGGREGATES", aSSOAGGREGATES);
            } else {
                commonSettingDataObject.setValue("ASSO_AGGREGATES", null);
            }
            commonSettingDataObject.setApplyFilter(false);
            commonSettingDataObject.finish();
            commonSettingDataObject.apply();
        }
    }

    private void createStateMap() {
        AbstractDataNode abstractDataNode = this.node.findBuildDataNode(this.node.getModel());
        List list = ((AssociationBuildNodeType)this.nodeDataCopy).getModels().getAprioriModel();
        if (list == null || list.size() < 1) {
            return;
        }
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.nodeDataCopy;
        CommonSettingDataObject commonSettingDataObject = new CommonSettingDataObject(this._context, null, (ModelType)list.get(0), (BuildNodeType)associationBuildNodeType, abstractDataNode, this.getLocale());
        try {
            commonSettingDataObject.loadSettingsForPI();
            commonSettingDataObject.setLoaded(true);
            this.stateMap.put(((AprioriModelType)list.get(0)).getId(), commonSettingDataObject);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)"Error", (String)exception.getMessage(), null);
        }
    }

    public List<String> getItemsFromTable(DataMinerTable dataMinerTable) {
        SingleColumnTableModel singleColumnTableModel = (SingleColumnTableModel)((Object)dataMinerTable.getModel());
        ArrayList<String> arrayList = new ArrayList<String>(singleColumnTableModel.getSrcData());
        return arrayList;
    }

    public void removeSelectedRowsFromTable(DataMinerTable dataMinerTable) {
        if (dataMinerTable.getSelectedRowCount() > 0) {
            int n;
            SingleColumnTableModel singleColumnTableModel = (SingleColumnTableModel)((Object)dataMinerTable.getModel());
            int[] nArray = dataMinerTable.getSelectedRowsInModel();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < nArray.length; ++n) {
                String string = (String)singleColumnTableModel.getSrcData().get(nArray[n]);
                arrayList.add(string);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                int n2 = singleColumnTableModel.getSrcData().indexOf(arrayList.get(n));
                singleColumnTableModel.removeRow(n2);
            }
            this.setDirty(true);
        }
    }

    private void fillTableModelFromState(CommonSettingDataObject commonSettingDataObject, SingleColumnTableModel<String> singleColumnTableModel, String string) {
        List list;
        if (commonSettingDataObject == null) {
            return;
        }
        ASSOAGGREGATES aSSOAGGREGATES = (ASSOAGGREGATES)commonSettingDataObject.getModelSettingObjectValue(string);
        if (aSSOAGGREGATES != null && (list = aSSOAGGREGATES.getAttribute()) != null) {
            for (AttributeType attributeType : list) {
                singleColumnTableModel.addRow(attributeType.getName());
            }
        }
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void initUI(boolean bl) {
        CommonSettingDataObject commonSettingDataObject = null;
        Iterator<Map.Entry<String, CommonSettingDataObject>> iterator = this.stateMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, CommonSettingDataObject> entry = iterator.next();
            commonSettingDataObject = entry.getValue();
        }
        if (!bl) {
            this._remIncAntecedentBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
            this._remIncAntecedentBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_REMOVE"));
            this._remIncAntecedentBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelARAggregatePanel.this.removeSelectedRowsFromTable(ModelARAggregatePanel.this.aggregationTablePanel.getTable());
                    if (ModelARAggregatePanel.this.bPIMode) {
                        ModelARAggregatePanel.this.processItemChanged();
                    }
                }
            });
            this._addIncAntecedentBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
            this._addIncAntecedentBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADD"));
            this._addIncAntecedentBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    String string = AlgSettingsLrb.get("ASSO_FILTER_AGGREGATE_SHUTTLE_TITLE");
                    String string2 = AlgSettingsLrb.get("ASSO_FILTER_AGGREGATE_SHUTTLE_HELP");
                    AbstractDataNode abstractDataNode = ModelARAggregatePanel.this.node.findBuildDataNode(ModelARAggregatePanel.this.node.getModel());
                    SingleColumnTableModel singleColumnTableModel = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
                    SingleColumnTableModel singleColumnTableModel2 = new SingleColumnTableModel(CoreCommonLrb.get((String)"ITEM"));
                    if (abstractDataNode instanceof DataSourceNode || abstractDataNode instanceof SampleNode || abstractDataNode instanceof DataProvider) {
                        if (abstractDataNode instanceof DataSourceNode) {
                            object5 = (DataSourceNode)abstractDataNode;
                            object4 = ((DataSourceNode)object5).getAttributes();
                        } else if (abstractDataNode instanceof SampleNode) {
                            object5 = (SampleNode)abstractDataNode;
                            object4 = ((SampleNode)object5).getAttributes();
                        } else {
                            object5 = abstractDataNode;
                            object4 = object5.getAttributes();
                        }
                        object5 = object4.getAttribute();
                        object3 = object5.iterator();
                        while (object3.hasNext()) {
                            object2 = (AttributeType)object3.next();
                            if (!DatabaseMetadataUtils.isNumericType(object2.getDataType()) && !DatabaseMetadataUtils.isBinaryNumericType(object2.getDataType())) continue;
                            String string3 = object2.getName();
                            if (StringUtils.isNotEmpty((String)object2.getAlias())) {
                                string3 = object2.getAlias();
                            }
                            object = ModelARAggregatePanel.this.aggregationTablePanel.getTable();
                            boolean bl = false;
                            for (int i = 0; i < object.getModel().getRowCount(); ++i) {
                                if (!object.getModel().getValueAt(i, 0).equals(string3)) continue;
                                singleColumnTableModel2.addRow(string3);
                                bl = true;
                                break;
                            }
                            if (bl || !ModelARAggregatePanel.this.isValidItem(string3)) continue;
                            singleColumnTableModel.addRow(string3);
                        }
                    }
                    if (((DialogHelper)(object2 = new DialogHelper((DialogDisplayable)(object3 = new DataMinerShuttlePanel(string, string2, (DataMinerShuttlePanel.ShuttleData)(object4 = new DataMinerShuttlePanel.ShuttleData(CoreCommonLrb.get((String)"AVAILABLE"), singleColumnTableModel)), (DataMinerShuttlePanel.ShuttleData)(object5 = new DataMinerShuttlePanel.ShuttleData(CoreCommonLrb.get((String)"SELECTED"), singleColumnTableModel2))))))).showAsDialog(ModelARAggregatePanel.this)) {
                        boolean bl = false;
                        object = ((DataMinerShuttlePanel)object3).getSelected();
                        ModelARAggregatePanel.this.tableModel.setSrcData(object);
                        ModelARAggregatePanel.this.setDirty(true);
                        ModelARAggregatePanel.this.aggregationTablePanel.setup((TableModel)((Object)ModelARAggregatePanel.this.tableModel), AlgSettingsLrb.get("ASSO_FILTER_AGGREGATE"), 0);
                        if (ModelARAggregatePanel.this.bPIMode) {
                            ModelARAggregatePanel.this.processItemChanged();
                        }
                    }
                }
            });
            this.aggregationTablePanel.addControlBarComponents(this._addIncAntecedentBtn, this._remIncAntecedentBtn);
        }
        this.tableModel.setSrcData(new ArrayList());
        this.fillTableModelFromState(commonSettingDataObject, this.tableModel, "ASSO_AGGREGATES");
        this.aggregationTablePanel.setup((TableModel)((Object)this.tableModel), AlgSettingsLrb.get("ASSO_FILTER_AGGREGATE"), 0);
        this.bInitialized = true;
    }

    private boolean isValidItem(String string) {
        String string2;
        AttributeType attributeType;
        Object object;
        if (this.nodeDataCopy.getCaseAttributes() != null) {
            object = this.nodeDataCopy.getCaseAttributes().getAttribute();
            attributeType = object.iterator();
            while (attributeType.hasNext()) {
                string2 = (AttributeType)attributeType.next();
                String string3 = string2.getName();
                if (string2.getAlias() != null) {
                    string3 = string2.getAlias();
                }
                if (!string3.equals(string)) continue;
                return false;
            }
        }
        if ((object = (AssociationBuildNodeType)this.nodeDataCopy).getItemID() != null) {
            attributeType = object.getItemID();
            string2 = attributeType.getName();
            if (attributeType.getAlias() != null) {
                string2 = attributeType.getAlias();
            }
            if (string2.equals(string)) {
                return false;
            }
        }
        return true;
    }

    public void enableControls(boolean bl) {
        if (this.bInitialized) {
            this._addIncAntecedentBtn.setEnabled(bl);
            this._remIncAntecedentBtn.setEnabled(bl);
        }
    }

    public DataMinerTablePanel getAggregationTablePanel() {
        return this.aggregationTablePanel;
    }

    private void initComponents() {
        this.lblHeader = new JLabel();
        this.aggregationTablePanel = new DataMinerTablePanel();
        this.lblHeader.setText("Aggregates");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHeader, -2, 722, -2).addComponent(this.aggregationTablePanel, -1, 744, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lblHeader).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aggregationTablePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private boolean reload;

        public LoadUI(boolean bl) {
            super(ModelARAggregatePanel.this, null, ModelARAggregatePanel.this.aggregationTablePanel.getTable());
            this.reload = false;
            this.reload = bl;
        }

        @Override
        protected Void doInBackground() throws Exception {
            ModelARAggregatePanel.this.createStateMap();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ModelARAggregatePanel.this.initUI(this.reload);
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)ModelARAggregatePanel.this.nodeDataCopy;
            AttributeType attributeType = associationBuildNodeType.getItemID();
            ModelARAggregatePanel.this.enableControls(attributeType != null);
        }

        @Override
        protected void onFailureOnSuccess(Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

