/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.TableChooserAndViewerPane;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;

public class DataSourceWizardModel
extends WizardModel {
    private static final Logger LOGGER = Logger.getLogger(DataSourceWizardModel.class.getName());
    private final PropertyChangeSupport propertyChangeSupport;
    protected boolean tableExists;
    private boolean isDbVersion12andUp;
    private boolean includeAllAvailableAttributes;
    private volatile boolean wizardIsCancelled;
    protected Table selectedTable;
    protected List<AttributeType> selectedColumns;
    protected List<AttributeType> availableColumns;
    private Context context;
    private Component parent;
    private AbstractDataNode node;
    private TableChooserAndViewerPane tableSelectionStep;
    private JButton jsonSettingBtn;
    private List<String> isJSONConstraintColumns;
    private DataGuideSettingsType dataGuideSettings;
    private Map<String, JSONColumnsType.Attribute> modifiedJSONColumns;

    public DataSourceWizardModel(Component component, Context context, AbstractDataNode abstractDataNode) {
        this.context = context;
        this.parent = component;
        this.node = abstractDataNode;
        this.tableExists = true;
        this.selectedColumns = new ArrayList<AttributeType>();
        this.availableColumns = new ArrayList<AttributeType>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public boolean isDatabaseVersion12andUp() {
        return this.isDbVersion12andUp;
    }

    public void setJsonSettingBtn(JButton jButton) {
        this.jsonSettingBtn = jButton;
    }

    public void setDatabaseVersion12andUp(boolean bl) {
        this.isDbVersion12andUp = bl;
    }

    public JButton getJsonSettingBtn() {
        return this.jsonSettingBtn;
    }

    public void setModifiedJSONColumns(Map<String, JSONColumnsType.Attribute> map) {
        this.modifiedJSONColumns = map;
    }

    public Map<String, JSONColumnsType.Attribute> getModifiedJSONColumns() {
        return this.modifiedJSONColumns;
    }

    public void setDataGuideSettings(DataGuideSettingsType dataGuideSettingsType) {
        this.dataGuideSettings = dataGuideSettingsType;
    }

    public DataGuideSettingsType getDataGuideSettings() {
        return this.dataGuideSettings;
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this.wizardIsCancelled;
        this.wizardIsCancelled = bl;
        this.propertyChangeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    public void setTableSelectionStep(TableChooserAndViewerPane tableChooserAndViewerPane) {
        this.tableSelectionStep = tableChooserAndViewerPane;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public AbstractDataNode getNode() {
        return this.node;
    }

    public Component getParent() {
        return this.parent;
    }

    public void setSelectedTable(Table table) {
        this.selectedTable = table;
    }

    public Table getSelectedTable() {
        return this.selectedTable;
    }

    public List<AttributeType> getSelectedColumns() {
        return this.selectedColumns;
    }

    public void close() {
        if (this.tableSelectionStep != null) {
            try {
                this.tableSelectionStep.close();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public void setSelectedColumns(List<AttributeType> list) {
        this.selectedColumns = list;
    }

    public List<AttributeType> getAvailableColumns() {
        return this.availableColumns;
    }

    public void setAvailableColumns(List<AttributeType> list) {
        this.availableColumns = list;
    }

    public void loadDefaultSelectedColumns() {
        this.selectedColumns.clear();
        for (AttributeType attributeType : this.availableColumns) {
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType())) {
                this.selectedColumns.add(attributeType);
                continue;
            }
            if (DatabaseMetadataUtils.isJSONTypeSupported(attributeType.getDataType())) {
                this.selectedColumns.add(attributeType);
                continue;
            }
            attributeType.setStatus(AttributeStatus.INVALID);
        }
        this.removeSelectedAttrs(this.availableColumns, this.selectedColumns);
    }

    protected void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    public Map<String, AttributeType> getSelectedColumnsHash() {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : this.selectedColumns) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        return hashMap;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public void setTableExists(boolean bl) {
        this.tableExists = bl;
    }

    public void setJsonColumns(List<String> list) {
        this.isJSONConstraintColumns = list;
    }

    public List<String> getJsonColumns() {
        return this.isJSONConstraintColumns;
    }

    public boolean isIncludeAllAvailableAttributes() {
        return this.includeAllAvailableAttributes;
    }

    public void setIncludeAllAvailableAttributes(boolean bl) {
        this.includeAllAvailableAttributes = bl;
    }
}

