/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.math.BigInteger;
import java.util.Vector;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;

public class PredictionFunctionsHelper {
    public static final String SUPPLEMENTAL_DATA = "<SUPPLEMENTAL_DATA>";
    public static final String TARGET_COLUMN = "<TARGET_COLUMN>";
    public static final String ANOMALY_VALUE = "<ANOMALY_VALUE>";
    public static final String INPUT_LIST = "<INPUT_LIST>";
    public static final String PARTITION_EXPERSSIONS = "<PARTITION_EXPERSSIONS>";
    public static final String PREDICTION_COLUMN_NAME = "<PREDICTION_COLUMN_NAME>";
    public static final String PREDICTION_DETAILS = "<CLASS_VALUE> <TOP_N> <SORT_ORDER> ";
    public static final String PREDICTION_SET = "<TOP_N> <CUT_OFF> ";
    public static final String PREDICTION_PROBABILITY = "<CLASS_VALUE> ";
    public static final String CLUSTERS_NUMBER = "<CLUSTERS_NUMBER>";
    public static final String CLUSTERS_PROBABILITY = "<CLUSTERS_PROBABILITY>";
    public static final String CLUSTER_SET = "<CLUSTER_SET>";
    public static final String CLUSTERS_DISTANCE = "<CLUSTERS_DISTANCE>";
    public static final String CLUSTERS_DETAILS = "<CLUSTERS_DETAILS>";
    public static final String FEATURES_NUMBER = "<FEATURES_NUMBER>";
    public static final String FEATURE_VALUE = "<FEATURE_VALUE>";
    public static final String FEATURE_DETAILS = "<FEATURE_DETAILS>";
    public static final String FEATURE_SET = "<FEATURE_SET>";
    public static final String ALL = DialogsLrb.get("APPLY_OPTION_ALL");
    public static final BigInteger TOPN_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private static Vector<Object> anomalyTargets = new Vector();

    static {
        anomalyTargets.add(0);
        anomalyTargets.add(1);
    }

    public static class FeatureSet
    extends DefaultPredictionSet {
        public FeatureSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, String string) {
            super(bl, bigInteger, n, bl2, d, string);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CAST(FEATURE_SET(INTO <FEATURE_SET> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) AS ODMR_FEATURE_SET_NUMVD) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class FeatureDetails
    extends DefaultPredictionDetails {
        public FeatureDetails(Object object, Vector<Object> vector, boolean bl, BigInteger bigInteger, String string, String string2) {
            super(true, object, vector, bl, bigInteger, string, string2);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FEATURE_DETAILS(INTO <FEATURE_DETAILS> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._useTarget) {
                if (this._selectedTarget != null) {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_FEATURE_ID") + " " + this._selectedTarget);
                } else {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_FEATURE_ID_MOST_LIKELY"));
                }
            }
            if (this._sort != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_DETAILS_SORT") + " " + this._sort);
            }
            if (this._useTopN) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_DETAILS_TOP_N") + " " + this._topN.toString());
            }
            return stringBuffer.toString();
        }
    }

    public static class FeatureValue
    extends DefaultParameters {
        private Object _featureId;
        private Vector<Object> _featureIds;

        public FeatureValue(Object object, Vector<Object> vector, String string) {
            super(string);
            this._featureId = object;
            this._featureIds = vector;
        }

        public Vector<Object> getFeatureIds() {
            return this._featureIds;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._featureId != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_FEATURE_ID") + " " + this._featureId.toString());
            } else {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_FEATURE_ID_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        public void setFeatureId(Object object) {
            this._featureId = object;
        }

        public Object getFeatureId() {
            return this._featureId;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FEATURE_VALUE(INTO <FEATURE_VALUE> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class FeatureId
    extends DefaultParameters {
        public FeatureId(String string) {
            super(string);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FEATURE_ID(INTO <FEATURES_NUMBER> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class AnomalyPredictionSet
    extends DefaultPredictionSet {
        public AnomalyPredictionSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, boolean bl3, Double d2, String string) {
            super(bl, bigInteger, n, bl2, d, string);
            this._costCutOff = d2;
            this._useCostCutOff = bl3;
        }

        @Override
        public void validate() throws ValidationException {
            if (!(this._useTopN || this._useCutOff || this._useCostCutOff)) {
                throw new ValidationException(DialogsLrb.get("APPLY_OPTION_TOPN_CUTOFF_NULL_ERROR"));
            }
            if (this._useCutOff) {
                if (this._cutOff == null) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
                if (this._cutOff <= 0.0 || this._cutOff > 1.0) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._topN != null) {
                if (this._topN.intValue() < Integer.MAX_VALUE) {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + this._topN.toString());
                } else {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + ALL);
                }
            }
            if (this._useCutOff && this._cutOff != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_PROB_CUTOFF") + " " + this._cutOff.toString());
            }
            return stringBuffer.toString();
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder("CAST(PREDICTION_SET ( OF ANOMALY ");
            stringBuilder.append(PredictionFunctionsHelper.PREDICTION_SET);
            String string = "ODMR_PREDICTION_SET_NUM_N";
            stringBuilder.append(" USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) AS " + string + ") \"" + this.getColumn() + "\"\n");
            String string2 = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string2;
        }

        @Override
        public void setCostCutOff(Double d) {
            this._costCutOff = d;
        }
    }

    public static class AnomalyPredictionDetails
    extends DefaultPredictionDetails {
        public AnomalyPredictionDetails(boolean bl, Object object, boolean bl2, BigInteger bigInteger, String string, String string2) {
            super(bl, object, null, bl2, bigInteger, string, string2);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder("PREDICTION_DETAILS( OF ANOMALY <ANOMALY_VALUE> ");
            stringBuilder.append("USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }

        @Override
        public Vector<Object> getTargetValues() {
            return anomalyTargets;
        }
    }

    public static class AnomalyPredictionProbability
    extends DefaultPredictionProbability {
        public AnomalyPredictionProbability(Object object, String string) {
            super(object, anomalyTargets, string);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder("PREDICTION_PROBABILITY( OF ANOMALY ");
            stringBuilder.append(PredictionFunctionsHelper.PREDICTION_PROBABILITY);
            stringBuilder.append("USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class AnomalyPrediction
    extends DefaultParameters {
        public AnomalyPrediction(String string) {
            super(string);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder("PREDICTION( OF ANOMALY ");
            stringBuilder.append("USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class ClusterProbability
    extends DefaultParameters {
        private Object _clusterId;
        private Vector<Object> _clusterIds;

        public ClusterProbability(Object object, Vector<Object> vector, String string) {
            super(string);
            this._clusterId = object;
            this._clusterIds = vector;
        }

        public Vector<Object> getClusterIds() {
            return this._clusterIds;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._clusterId != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID") + " " + this._clusterId.toString());
            } else {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        public void setClusterId(Object object) {
            this._clusterId = object;
        }

        public Object getClusterId() {
            return this._clusterId;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CLUSTER_PROBABILITY(INTO <CLUSTERS_PROBABILITY> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class ClusterDistance
    extends DefaultParameters {
        private Object _clusterId;
        private Vector<Object> _clusterIds;

        public ClusterDistance(Object object, Vector<Object> vector, String string) {
            super(string);
            this._clusterId = object;
            this._clusterIds = vector;
        }

        public Vector<Object> getClusterIds() {
            return this._clusterIds;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._clusterId != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID") + " " + this._clusterId.toString());
            } else {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        public void setClusterId(Object object) {
            this._clusterId = object;
        }

        public Object getClusterId() {
            return this._clusterId;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CLUSTER_DISTANCE(INTO <CLUSTERS_DISTANCE> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class ClusterDetails
    extends DefaultPredictionDetails {
        public ClusterDetails(Object object, Vector<Object> vector, boolean bl, BigInteger bigInteger, String string, String string2) {
            super(true, object, vector, bl, bigInteger, string, string2);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CLUSTER_DETAILS(INTO <CLUSTERS_DETAILS> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._useTarget) {
                if (this._selectedTarget != null) {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID") + " " + this._selectedTarget);
                } else {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_CLUSTER_ID_MOST_LIKELY"));
                }
            }
            if (this._sort != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_DETAILS_SORT") + " " + this._sort);
            }
            if (this._useTopN) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_DETAILS_TOP_N") + " " + this._topN.toString());
            }
            return stringBuffer.toString();
        }
    }

    public static class ClusterSet
    extends DefaultPredictionSet {
        public ClusterSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, String string) {
            super(bl, bigInteger, n, bl2, d, string);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CAST(CLUSTER_SET(INTO <CLUSTER_SET> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) AS ODMR_CLUSTER_SET_NUMPD) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class ClusterId
    extends DefaultParameters {
        public ClusterId(String string) {
            super(string);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CLUSTER_ID(INTO <CLUSTERS_NUMBER> USING  <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class PredictionSet
    extends DefaultPredictionSet {
        protected String _useCostType;
        protected CostMatrixType _costMatrix;
        protected String _miningType;
        protected String _dataType;

        public PredictionSet(String string, String string2, boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, boolean bl3, Double d2, String string3, String string4, CostMatrixType costMatrixType) {
            super(bl, bigInteger, n, bl2, d, string3);
            this._useCostType = string4;
            this._costMatrix = costMatrixType;
            this._costCutOff = d2;
            this._useCostCutOff = bl3;
            this._miningType = string2;
            this._dataType = string;
        }

        @Override
        public void validate() throws ValidationException {
            if (!(this._useTopN || this._useCutOff || this._useCostCutOff)) {
                throw new ValidationException(DialogsLrb.get("APPLY_OPTION_TOPN_CUTOFF_NULL_ERROR"));
            }
            if (this._useCostType.compareTo("Model") == 0) {
                if (this._useCostCutOff) {
                    if (this._costCutOff == null) {
                        throw new ValidationException(DialogsLrb.get("APPLY_OPTION_COST_CUTOFF_ERROR"));
                    }
                    if (this._costCutOff <= 0.0) {
                        throw new ValidationException(DialogsLrb.get("APPLY_OPTION_COST_CUTOFF_ERROR"));
                    }
                }
            } else if (this._useCutOff) {
                if (this._cutOff == null) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
                if (this._cutOff <= 0.0 || this._cutOff > 1.0) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._topN != null) {
                if (this._topN.intValue() < Integer.MAX_VALUE) {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + this._topN.toString());
                } else {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + ALL);
                }
            }
            if (this._useCostType.compareTo("Model") == 0) {
                if (this._useCostCutOff && this._costCutOff != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_COST_CUTOFF") + " " + this._costCutOff.toString());
                }
            } else if (this._useCutOff && this._cutOff != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_PROB_CUTOFF") + " " + this._cutOff.toString());
            }
            return stringBuffer.toString();
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder("CAST(PREDICTION_SET ( FOR <TARGET_COLUMN> ");
            stringBuilder.append(PredictionFunctionsHelper.PREDICTION_SET);
            String string = null;
            boolean bl2 = bl = this._useCostType.compareTo("Model") == 0;
            string = this._miningType.equals("Categorical") ? (bl ? "ODMR_PREDICTION_SET_CAT_COSTPD" : "ODMR_PREDICTION_SET_CATPD") : (bl ? ("BINARY_DOUBLE".equals(this._dataType) ? "ODMR_PREDICTION_SET_NUM_COSTD" : ("BINARY_FLOAT".equals(this._dataType) ? "ODMR_PREDICTION_SET_NUM_COSTF" : "ODMR_PREDICTION_SET_NUM_COSTN")) : ("BINARY_DOUBLE".equals(this._dataType) ? "ODMR_PREDICTION_SET_NUM_D" : ("BINARY_FLOAT".equals(this._dataType) ? "ODMR_PREDICTION_SET_NUM_F" : "ODMR_PREDICTION_SET_NUM_N")));
            if (bl) {
                stringBuilder.append("COST MODEL AUTO ");
            }
            stringBuilder.append(" USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) AS " + string + ") \"" + this.getColumn() + "\"\n");
            String string2 = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string2;
        }

        public void setUseCostType(String string) {
            this._useCostType = string;
        }

        @Override
        public String getUseCostType() {
            return this._useCostType;
        }

        public void setCostMatrix(CostMatrixType costMatrixType) {
            this._costMatrix = costMatrixType;
        }

        public CostMatrixType getCostMatrix() {
            return this._costMatrix;
        }
    }

    public static class DefaultPredictionSet
    implements Parameters {
        protected BigInteger _topN;
        protected int _maxN;
        protected Double _cutOff;
        protected String _column;
        protected boolean _useTopN;
        protected boolean _useCutOff;
        protected Double _costCutOff;
        protected boolean _useCostCutOff;

        public DefaultPredictionSet(boolean bl, BigInteger bigInteger, int n, boolean bl2, Double d, String string) {
            this._topN = bigInteger;
            this._maxN = n;
            this._cutOff = d;
            this._column = string;
            this._useTopN = bl;
            this._useCutOff = bl2;
        }

        public void setUseCostCutOff(boolean bl) {
            this._useCostCutOff = bl;
        }

        public boolean isUseCostCutOff() {
            return this._useCostCutOff;
        }

        public void setCostCutOff(Double d) {
            this._costCutOff = d;
        }

        public Double getCostCutOff() {
            return this._costCutOff;
        }

        public String getUseCostType() {
            return "None";
        }

        @Override
        public void validate() throws ValidationException {
            if (!this._useTopN && !this._useCutOff) {
                throw new ValidationException(DialogsLrb.get("APPLY_OPTION_TOPN_CUTOFF_NULL_ERROR"));
            }
            if (this._useCutOff) {
                if (this._cutOff == null) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
                if (this._cutOff <= 0.0 || this._cutOff > 1.0) {
                    throw new ValidationException(DialogsLrb.get("APPLY_OPTION_CUTOFF_ERROR"));
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._topN != null) {
                if (this._topN.intValue() < Integer.MAX_VALUE) {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + this._topN.toString());
                } else {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TOP_N") + " " + ALL);
                }
            }
            if (this._cutOff != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_PROB_CUTOFF") + " " + this._cutOff.toString());
            }
            return stringBuffer.toString();
        }

        public BigInteger getTopN() {
            return this._topN;
        }

        public void setTopN(BigInteger bigInteger) {
            this._topN = bigInteger;
        }

        public Double getCutOff() {
            return this._cutOff;
        }

        public void setCutOff(Double d) {
            this._cutOff = d;
        }

        public int getMaxN() {
            return this._maxN;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        public void setUseTopN(boolean bl) {
            this._useTopN = bl;
        }

        public boolean isUseTopN() {
            return this._useTopN;
        }

        public void setUseCutOff(boolean bl) {
            this._useCutOff = bl;
        }

        public boolean isUseCutOff() {
            return this._useCutOff;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            return null;
        }

        @Override
        public Attributes getAttributes(DynamicNode dynamicNode) {
            return new Attributes();
        }
    }

    public static class PredictionProbability
    extends DefaultPredictionProbability {
        public PredictionProbability(Object object, Vector<Object> vector, String string) {
            super(object, vector, string);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder("PREDICTION_PROBABILITY( FOR <TARGET_COLUMN> ");
            stringBuilder.append(PredictionFunctionsHelper.PREDICTION_PROBABILITY);
            stringBuilder.append("USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class DefaultPredictionProbability
    implements Parameters {
        protected Object _selectedTarget;
        protected Vector<Object> _targetValues;
        protected String _column;

        public DefaultPredictionProbability(Object object, Vector<Object> vector, String string) {
            this._selectedTarget = object;
            this._targetValues = vector;
            this._column = string;
        }

        public Vector<Object> getTargetValues() {
            return this._targetValues;
        }

        @Override
        public void validate() throws ValidationException {
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._selectedTarget != null) {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TARGET") + " " + this._selectedTarget);
            } else {
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TARGET_MOST_LIKELY"));
            }
            return stringBuffer.toString();
        }

        public void setSelectedTarget(Object object) {
            this._selectedTarget = object;
        }

        public Object getSelectedTarget() {
            return this._selectedTarget;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            return null;
        }

        @Override
        public Attributes getAttributes(DynamicNode dynamicNode) {
            return new Attributes();
        }
    }

    public static class PredictionDetails
    extends DefaultPredictionDetails {
        public PredictionDetails(boolean bl, Object object, Vector<Object> vector, boolean bl2, BigInteger bigInteger, String string, String string2) {
            super(bl, object, vector, bl2, bigInteger, string, string2);
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder("PREDICTION_DETAILS( FOR <TARGET_COLUMN> ");
            stringBuilder.append(PredictionFunctionsHelper.PREDICTION_DETAILS);
            stringBuilder.append("USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }
    }

    public static class DefaultPredictionDetails
    implements Parameters {
        protected boolean _useTarget;
        protected Object _selectedTarget;
        protected Vector<Object> _targetValues;
        protected BigInteger _topN;
        protected boolean _useTopN;
        protected Vector<String> _sortValues;
        protected String _sort;
        protected String _column;

        public DefaultPredictionDetails(boolean bl, Object object, Vector<Object> vector, boolean bl2, BigInteger bigInteger, String string, String string2) {
            this._useTarget = bl;
            this._selectedTarget = object;
            this._targetValues = vector;
            this._topN = bigInteger;
            this._useTopN = bl2;
            this._sort = string;
            this._column = string2;
            this._sortValues = new Vector();
            this._sortValues.add(ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ABS.value());
            this._sortValues.add(ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.ASC.value());
            this._sortValues.add(ServerConstants.ApplyPredictionDetailsSort.PREDICTION_DETAILS_SORT_OPTION.DESC.value());
        }

        public Vector<Object> getTargetValues() {
            return this._targetValues;
        }

        @Override
        public void validate() throws ValidationException {
            if (this._useTopN && (this._topN == null || this._topN.intValue() <= 0)) {
                throw new ValidationException(DialogsLrb.get("APPLY_OPTION_MAX_LEN_ATTRS_ERROR"));
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._useTarget) {
                if (this._selectedTarget != null) {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TARGET") + " " + this._selectedTarget);
                } else {
                    stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_TARGET_MOST_LIKELY"));
                }
            }
            if (this._sort != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_DETAILS_SORT") + " " + this._sort);
            }
            if (this._useTopN) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NodeMessagesLrb.get("APPLY_PREDICTION_DETAILS_TOP_N") + " " + this._topN.toString());
            }
            return stringBuffer.toString();
        }

        public void setSelectedTarget(Object object) {
            this._selectedTarget = object;
        }

        public Object getSelectedTarget() {
            return this._selectedTarget;
        }

        public void setUseTopN(boolean bl) {
            this._useTopN = bl;
        }

        public boolean isUseTopN() {
            return this._useTopN;
        }

        public BigInteger getTopN() {
            return this._topN;
        }

        public void setTopN(BigInteger bigInteger) {
            this._topN = bigInteger;
        }

        public String getSort() {
            return this._sort;
        }

        public void setSort(String string) {
            this._sort = string;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            return null;
        }

        @Override
        public Attributes getAttributes(DynamicNode dynamicNode) {
            return new Attributes();
        }

        public Vector<String> getSortValues() {
            return this._sortValues;
        }

        public void setUseTarget(boolean bl) {
            this._useTarget = bl;
        }

        public boolean isUseTarget() {
            return this._useTarget;
        }
    }

    public static class Prediction
    extends DefaultParameters {
        protected String _useCostType;
        protected CostMatrixType _costMatrix;

        public Prediction(String string, String string2, CostMatrixType costMatrixType) {
            super(string);
            this._useCostType = string2;
            this._costMatrix = costMatrixType;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            StringBuilder stringBuilder = new StringBuilder("PREDICTION( FOR <TARGET_COLUMN> ");
            if (this._useCostType.compareTo("Model") == 0) {
                stringBuilder.append("COST MODEL AUTO ");
            }
            stringBuilder.append("USING <INPUT_LIST>)\n    OVER (<PARTITION_EXPERSSIONS>    ) \"" + this.getColumn() + "\"\n");
            String string = StringUtils.getReplacedString(stringBuilder.toString(), PredictionFunctionsHelper.PARTITION_EXPERSSIONS, DynamicApplyHelper.generatePartitionsExpression(dynamicNode.getDynamicNodeBaseSettingsType()));
            return string;
        }

        public void setUseCostType(String string) {
            this._useCostType = string;
        }

        public String getUseCostType() {
            return this._useCostType;
        }

        public void setCostMatrix(CostMatrixType costMatrixType) {
            this._costMatrix = costMatrixType;
        }

        public CostMatrixType getCostMatrix() {
            return this._costMatrix;
        }
    }

    public static class DefaultParameters
    implements Parameters {
        protected String _column;

        public DefaultParameters(String string) {
            this._column = string;
        }

        @Override
        public void validate() throws ValidationException {
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public void setColumn(String string) {
            this._column = string;
        }

        @Override
        public String getColumn() {
            return this._column;
        }

        @Override
        public String generateCode(DynamicNode dynamicNode) {
            return null;
        }

        @Override
        public Attributes getAttributes(DynamicNode dynamicNode) {
            return new Attributes();
        }
    }

    public static interface Parameters {
        public void validate() throws ValidationException;

        public String toString();

        public String getColumn();

        public void setColumn(String var1);

        public String generateCode(DynamicNode var1);

        public Attributes getAttributes(DynamicNode var1);
    }
}

