/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AggregationAttributesTablePanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONStructureAddAggregationPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class AddAggregationColumnPanel
extends DialogDisplayer<AbstractNode> {
    private static String GROUP_BY_TITLE = DialogsLrb.get("JSON_ADD_AGGREGATION_GROUP_BY_TITLE");
    private JSONQueryEditorPanel _parent;
    private JSONStructureAddAggregationPanel jsonStructurePanel;
    private AggregationAttributesTablePanel _enclosingPanel;
    private AggregationElementsExType newAggregationElements;
    private AggregationElementsExType previousAggregationElements;
    private JLabel jLabelGroupBy;
    private JLabel jLblWarning;
    private JPanel jPanelContainer;

    public AddAggregationColumnPanel(Context context, AbstractDataNode abstractDataNode, JSONQueryEditorPanel jSONQueryEditorPanel, AggregationAttributesTablePanel aggregationAttributesTablePanel, AggregationElementsExType aggregationElementsExType, AggregationElementsExType aggregationElementsExType2) {
        super(context, abstractDataNode);
        assert (context != null) : "Context must not be null.";
        this._parent = jSONQueryEditorPanel;
        this._enclosingPanel = aggregationAttributesTablePanel;
        this.newAggregationElements = aggregationElementsExType;
        this.previousAggregationElements = aggregationElementsExType2;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jPanelContainer = new JPanel();
        this.jLabelGroupBy = new JLabel();
        this.jLblWarning = new JLabel();
        this.jPanelContainer.setLayout(new BorderLayout());
        this.jLabelGroupBy.setText("Group By: ");
        this.jLblWarning.setText("Warning:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanelContainer, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabelGroupBy, GroupLayout.Alignment.TRAILING, -1, 748, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLblWarning, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLabelGroupBy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelContainer, -1, 258, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLblWarning, -2, 25, -2)));
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("JSON_QUERY_AGGREGATION_EDIT_AGGREGATIONS_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "jsqon_query_aggregation_add_aggregation";
    }

    @Override
    public void initRes() {
        String string = "";
        GroupingElementExType groupingElementExType = this._parent.getGroupingElement();
        if (groupingElementExType != null && groupingElementExType.getAttributes() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (groupingElementExType.getAttributes().getAttribute() != null) {
                for (AttributeExType attributeExType : groupingElementExType.getAttributes().getAttribute()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(attributeExType.getName());
                }
                for (AttributeExType attributeExType : groupingElementExType.getAttributes().getJSONAttribute()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(attributeExType.getDBName());
                }
                if (stringBuilder.length() > 0) {
                    string = GROUP_BY_TITLE + " " + stringBuilder.toString();
                }
            }
        }
        this.jLabelGroupBy.setText(string);
        this.updateWarning(this.previousAggregationElements);
    }

    public JSONQueryEditorPanel getJSONQueryEditorPanel() {
        return this._parent;
    }

    public void updateWarning(AggregationElementsExType aggregationElementsExType) {
        this.jLblWarning.setVisible(false);
    }

    @Override
    public void initUI() {
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)jSONQueryNode.findParentNode());
        AttributeType attributeType = this._parent.getJSONSourceColumn();
        DataGuideInfoType dataGuideInfoType = dataGuideProvider.getJSONAttrDataGuideInfoType(attributeType);
        JSONColumnsType.Attribute attribute = new JSONColumnsType.Attribute();
        attribute.setName(attributeType.getName());
        attribute.setDataGuideInfo(dataGuideInfoType);
        this.jsonStructurePanel = new JSONStructureAddAggregationPanel(this.getContext(), jSONQueryNode, attributeType, attribute, this.newAggregationElements, this.previousAggregationElements, true);
        this.jPanelContainer.add((Component)this.jsonStructurePanel, "Center");
        this.jsonStructurePanel.setEnclosingPanel(this);
    }

    @Override
    protected boolean doWork() {
        boolean bl = true;
        String string = null;
        for (AggregationElementsExType.AggregationElement aggregationElement : this.newAggregationElements.getAggregationElement()) {
            if (aggregationElement.getOutput() == null) {
                bl = false;
                string = JSONQueryEditorPanel.AGGREGATION_ERROR_OUTPUT;
                break;
            }
            if (aggregationElement.getAggregationFunction() != null) continue;
            bl = false;
            string = JSONQueryEditorPanel.AGGREGATION_ERROR_FUNCTION;
            break;
        }
        if (null != string) {
            MessageDialog.error((Component)Ide.getMainWindow(), string, (String)JSONQueryEditorPanel.ERROR_TITLE, null);
        }
        return bl;
    }
}

