/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.NameChangeListener;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.RelationalAttributesType;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public class PreviewColumnsPanel
extends AbstractPanel<JSONQueryNode> {
    private List<NameChangeListener> _nameChangeListeners = new ArrayList<NameChangeListener>();
    private JSONQueryEditorPanel _parent;
    private OutputColumnsTableModel _tableModel;
    private Date last_updated = null;
    private JPanel jColumnPanel;
    private DataMinerTablePanel columnTablePanel;

    public PreviewColumnsPanel(Context context, JSONQueryEditorPanel jSONQueryEditorPanel) {
        super(context, null);
        assert (context != null) : "Context must not be null.";
        this._parent = jSONQueryEditorPanel;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.columnTablePanel = new DataMinerTablePanel();
        this.jColumnPanel.setLayout(new BorderLayout());
        this.jColumnPanel.add(this.columnTablePanel);
        JToggleButton jToggleButton = new JToggleButton(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH"), DataMinerIcons.get(Icons.SHOW_JSON_PATH));
        jToggleButton.setToolTipText(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH_TOOLTIP"));
        jToggleButton.setSelected(true);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                PreviewColumnsPanel.this.showJSONPaths(jToggleButton.isSelected());
            }
        });
        this.columnTablePanel.addControlBarComponents(jToggleButton);
        this.setupTable();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (PreviewColumnsPanel.this.last_updated == null || PreviewColumnsPanel.this._parent.isDirty() && PreviewColumnsPanel.this._parent.getLastUpdatedTime().after(PreviewColumnsPanel.this.last_updated)) {
                    PreviewColumnsPanel.this.reload();
                }
            }
        });
    }

    public void addNameChangeListener(NameChangeListener nameChangeListener) {
        this._nameChangeListeners.add(nameChangeListener);
    }

    private void setupTable() {
        this._tableModel = new OutputColumnsTableModel(this._parent.getJSONSourceColumn(), this._parent.getRelationalDataSource(), this._parent.getJSONAttributes(), this._parent.getRelationalAttributes(), this._parent.getAggregationElements(), this._parent.getGroupingElement());
        String string = DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_NUM_COLS");
        String string2 = MessageFormat.format(string, this._tableModel.getRowCount());
        this.columnTablePanel.getTable().setFixedColumns(1, 250);
        this.columnTablePanel.setup((TableModel)((Object)this._tableModel), string2, this._tableModel.NAME_COLUMN, true);
        this.columnTablePanel.getTable().autoSizeColumnsToFit();
        TableColumn tableColumn = this.columnTablePanel.getTable().getFullColumnModel().getColumn(this._tableModel.NAME_COLUMN);
        tableColumn.setCellRenderer(new CustomCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png")));
        tableColumn = this.columnTablePanel.getTable().getFullColumnModel().getColumn(this._tableModel.NAME_COLUMN);
        tableColumn.setCellEditor(new DBObjectNameEditor(this.getContext()));
    }

    private void showJSONPaths(boolean bl) {
        this._tableModel.showFullPath(bl);
    }

    public void reload() {
        this._tableModel.refreshModel(this._parent.getJSONSourceColumn(), this._parent.getRelationalDataSource(), this._parent.getJSONAttributes(), this._parent.getRelationalAttributes(), this._parent.getAggregationElements(), this._parent.getGroupingElement());
        String string = DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_NUM_COLS");
        String string2 = MessageFormat.format(string, this._tableModel.getRowCount());
        this.columnTablePanel.setTitle(string2);
        this.columnTablePanel.getTable().autoSizeColumnsToFit();
        this.last_updated = this._parent.getLastUpdatedTime() == null ? new Date() : this._parent.getLastUpdatedTime();
    }

    private void initComponents() {
        this.jColumnPanel = new JPanel();
        this.jColumnPanel.setName("jColumnPanel");
        this.jColumnPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jColumnPanel, -1, 785, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jColumnPanel, -1, 499, Short.MAX_VALUE).addContainerGap()));
    }

    private static class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;

        public CustomCellRenderer(Icon icon, Icon icon2) {
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertRowIndexToModel(n);
            TableModel tableModel = jTable.getModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (tableModel instanceof OutputColumnsTableModel) {
                OutputColumnsTableModel outputColumnsTableModel = (OutputColumnsTableModel)((Object)tableModel);
                attributeStatus = (AttributeStatus)outputColumnsTableModel.getValueAt(n3, outputColumnsTableModel.ATTR_STATUS);
            }
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }

    private static class OutputColumnItem {
        private Object _sourceObject;
        private String _name;
        private String _orgDataType;
        private String _tgtDataType;
        private String _source;
        private String _fullPath;
        private String _shortPath;
        private String _aggregFunction;
        private String _groupByFull;
        private String _groupByShort;
        private String _subGroupByFull;
        private String _subGroupByShort;
        private AttributeStatus _status;

        public OutputColumnItem(Object object, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, AttributeStatus attributeStatus) {
            this._sourceObject = object;
            this._name = string;
            this._orgDataType = string2;
            this._tgtDataType = string3;
            this._source = string4;
            this._fullPath = string5;
            this._shortPath = string6;
            this._groupByFull = string8;
            this._groupByShort = string9;
            this._aggregFunction = string7;
            this._subGroupByFull = string10;
            this._subGroupByShort = string11;
            this._status = attributeStatus;
        }

        public Object getSourceObject() {
            return this._sourceObject;
        }

        public String getName() {
            return this._name;
        }

        public String getOrgDataType() {
            return this._orgDataType;
        }

        public String getTgtDataType() {
            return this._tgtDataType;
        }

        public String getSource() {
            return this._source;
        }

        public String getFullPath() {
            return this._fullPath;
        }

        public String getShortPath() {
            return this._shortPath;
        }

        public String getAggregFunction() {
            return this._aggregFunction;
        }

        public String getGroupByFull() {
            return this._groupByFull;
        }

        public String getGroupByShort() {
            return this._groupByShort;
        }

        public String getSubGroupByFull() {
            return this._subGroupByFull;
        }

        public String getSubGroupByShort() {
            return this._subGroupByShort;
        }

        public void setTgtDataType(String string) {
            this._tgtDataType = string;
        }

        public AttributeStatus getStatus() {
            return this._status;
        }
    }

    private class OutputColumnsTableModel
    extends SimpleBaseTableModel {
        private AttributeType _JSONSourceColumn = null;
        private String _relationalDataSource = null;
        private JSONAttributesType _JSONAttributes = null;
        private RelationalAttributesType _relationalAttributes = null;
        private AggregationElementsExType _aggregationElements = null;
        private GroupingElementExType _groupingElements = null;
        private List<OutputColumnItem> _srcData = new ArrayList<OutputColumnItem>();
        private boolean _showFullPath = true;
        private String[] _columnNames = new String[]{DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_NAME"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_TYPE"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_SOURCE"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_JSON_PATH"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_AGGREG"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_GROUPBY"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_SUBGROUPBY")};
        private int _COL_INDEX = 0;
        public final int NAME_COLUMN = this._COL_INDEX++;
        public final int DATA_TYPE_COLUMN = this._COL_INDEX++;
        public final int SOURCE_COLUMN = this._COL_INDEX++;
        public final int JSON_PATH_COLUMN = this._COL_INDEX++;
        public final int AGGREG_COLUMN = this._COL_INDEX++;
        public final int GROUPBY_COLUMN = this._COL_INDEX++;
        public final int SUBGROUPBY_COLUMN = this._COL_INDEX++;
        public final int ORG_DATA_TYPE = this._COL_INDEX++;
        public final int ATTR_STATUS = this._COL_INDEX++;

        public OutputColumnsTableModel(AttributeType attributeType, String string, JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType) {
            this._JSONSourceColumn = attributeType;
            this._relationalDataSource = string;
            this._JSONAttributes = jSONAttributesType;
            this._relationalAttributes = relationalAttributesType;
            this._aggregationElements = aggregationElementsExType;
            this._groupingElements = groupingElementExType;
            this.init();
            this.setRowCount(this._srcData.size());
            this.setColumnIdentifiers(this.getColumnNames());
            this.setColumnCount(this.getColumnNames().length);
        }

        private String getShortPath(String string) {
            String string2 = string;
            int n = string.lastIndexOf(".");
            if (n >= 0) {
                string2 = string.substring(n + 1, string.length());
            }
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        private void init() {
            String string;
            Object object;
            String string2;
            Object object2;
            Object object3;
            Object object42;
            Object object5;
            Object object622;
            GroupingElementExType.Attributes object7;
            this._srcData.clear();
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this._JSONAttributes != null) {
                object7 = new ArrayList();
                for (Object object622 : this._JSONAttributes.getJSONAttribute()) {
                    if (!"ARRAY".equals(object622.getDataType()) || !Boolean.FALSE.equals(object622.isUnnest())) continue;
                    object7.add(object622);
                }
                for (Object object622 : this._JSONAttributes.getJSONAttribute()) {
                    boolean bl = true;
                    for (JSONAttributeType jSONAttributeType : object7) {
                        if (object622.getPath().equals(jSONAttributeType.getPath()) || object622.getPath().indexOf(jSONAttributeType.getPath()) != 0) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    if ("ARRAY".equals(object622.getDataType())) {
                        void var8_27;
                        bl = false;
                        object5 = object622.getPath();
                        Object object6 = object622;
                        if (Boolean.FALSE.equals(object622.isUnnest())) {
                            bl = true;
                        } else {
                            bl = true;
                            object5 = object5 + "[*]";
                            for (Object object42 : this._JSONAttributes.getJSONAttribute()) {
                                if (object622.getPath().equals(object42.getPath()) || object42.getPath().indexOf(object622.getPath() + ".") != 0) continue;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                JSONAttributeType jSONAttributeType = new JSONAttributeType();
                                jSONAttributeType.setDBDataType("VARCHAR2");
                                jSONAttributeType.setDBName(object622.getDBName());
                                jSONAttributeType.setDataType(object622.getDataType());
                                jSONAttributeType.setPath((String)object5);
                                jSONAttributeType.setStatus(object622.getStatus());
                                jSONAttributeType.setUnnest(object622.isUnnest());
                            }
                        }
                        if (!bl) continue;
                        object3 = (List)treeMap.get(object5);
                        if (object3 == null) {
                            object3 = new ArrayList();
                            treeMap.put(object5, object3);
                        }
                        object3.add(var8_27);
                        continue;
                    }
                    if ("OBJECT".equals(object622.getDataType())) continue;
                    object5 = (List)treeMap.get(object622.getPath());
                    if (object5 == null) {
                        object5 = new ArrayList();
                        treeMap.put(object622.getPath(), object5);
                    }
                    object5.add(object622);
                }
            }
            if (this._relationalAttributes != null) {
                object7 = this._relationalAttributes.getAttribute().iterator();
                while (object7.hasNext()) {
                    void string5;
                    object2 = (AttributeExType)object7.next();
                    object622 = object2.getAlias() != null ? object2.getAlias() : object2.getName();
                    List arrayList2 = (List)treeMap.get(object622);
                    if (arrayList2 == null) {
                        ArrayList string3 = new ArrayList();
                        treeMap.put(object622, string3);
                    }
                    string5.add(object2);
                }
            }
            if (this._aggregationElements != null) {
                object7 = this._aggregationElements.getAggregationElement().iterator();
                while (object7.hasNext()) {
                    object2 = (AggregationElementsExType.AggregationElement)object7.next();
                    object622 = (List)treeMap.get(object2.getJSONAttribute().getPath());
                    if (object622 == null) {
                        object622 = new ArrayList();
                        treeMap.put(object2.getJSONAttribute().getPath(), object622);
                    }
                    object622.add(object2);
                }
            }
            if (this._groupingElements != null && (object7 = this._groupingElements.getAttributes()) != null) {
                block6: for (Object object622 : object7.getAttribute()) {
                    arrayList.add(object622);
                    String object9 = object622.getAlias() != null ? object622.getAlias() : object622.getName();
                    object5 = (List)treeMap.get(object9);
                    if (object5 == null) {
                        object5 = new ArrayList<Object>();
                        object5.add(object622);
                        treeMap.put(object9, object5);
                        continue;
                    }
                    boolean bl = false;
                    object3 = new ArrayList(object5);
                    object42 = object3.iterator();
                    while (object42.hasNext()) {
                        string2 = (String)object42.next();
                        if (string2 instanceof AttributeExType) {
                            object = (AttributeExType)string2;
                            String string3 = string = object.getAlias() != null ? object.getAlias() : object.getName();
                            if (string.equals(object9)) {
                                bl = true;
                                continue block6;
                            }
                        }
                        if (bl) continue;
                        object5.add(object622);
                    }
                }
                block8: for (Object object622 : object7.getJSONAttribute()) {
                    arrayList.add(object622);
                    String entry = object622.getPath();
                    object5 = (List)treeMap.get(entry);
                    if (object5 == null) {
                        object5 = new ArrayList();
                        object5.add(object622);
                        treeMap.put(entry, object5);
                        continue;
                    }
                    boolean bl = false;
                    object3 = new ArrayList(object5);
                    object42 = object3.iterator();
                    while (object42.hasNext()) {
                        string2 = (String)object42.next();
                        if (string2 instanceof JSONAttributeType && (object = (JSONAttributeType)string2).getDBName().equals(object622.getDBName())) {
                            bl = true;
                            continue block8;
                        }
                        if (bl) continue;
                        object5.add(object622);
                    }
                }
            }
            object7 = null;
            object2 = null;
            if (!arrayList.isEmpty()) {
                void var6_14;
                object622 = "";
                String string4 = "";
                for (Object e : arrayList) {
                    void var6_19;
                    if (e instanceof AttributeExType) {
                        object3 = (AttributeExType)e;
                        object42 = object3.getName();
                        if (((String)object622).length() > 0) {
                            object622 = (String)object622 + ", ";
                        }
                        object622 = (String)object622 + (String)object42;
                        if (var6_14.length() > 0) {
                            String string5 = (String)var6_14 + ", ";
                        }
                        JSONAttributeType jSONAttributeType = object42;
                        continue;
                    }
                    if (!(e instanceof JSONAttributeType)) continue;
                    object3 = (JSONAttributeType)e;
                    object42 = object3.getPath();
                    if (((String)object622).length() > 0) {
                        object622 = (String)object622 + ", ";
                    }
                    object622 = (String)object622 + (String)object42;
                    if (var6_14.length() > 0) {
                        String string6 = (String)var6_14 + ", ";
                    }
                    String string7 = (String)var6_19 + this.getShortPath((String)object42);
                }
                object2 = object622;
                object7 = var6_14;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                object5 = (List)entry.getValue();
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    Object object8;
                    object3 = iterator.next();
                    object42 = null;
                    string2 = null;
                    object = null;
                    string = null;
                    String string8 = null;
                    String string9 = null;
                    String string10 = null;
                    GroupingElementExType.Attributes attributes = null;
                    Object object9 = null;
                    String string11 = null;
                    String string12 = null;
                    AttributeStatus attributeStatus = null;
                    if (object3 instanceof AttributeExType) {
                        object8 = (AttributeExType)object3;
                        object42 = object8.getAlias() != null ? object8.getAlias() : object8.getName();
                    } else if (object3 instanceof JSONAttributeType) {
                        object8 = (JSONAttributeType)object3;
                        object42 = object8.getDBName();
                    } else if (object3 instanceof AggregationElementsExType.AggregationElement) {
                        object8 = (AggregationElementsExType.AggregationElement)object3;
                        object42 = object8.getOutput().getName();
                    }
                    if (object3 instanceof AttributeExType) {
                        object8 = (AttributeExType)object3;
                        string2 = object8.getDataType();
                        object = object8.getNewDataType();
                    } else if (object3 instanceof JSONAttributeType) {
                        object8 = (JSONAttributeType)object3;
                        string2 = DatabaseMetadataUtils.convertJSONAttrType(object8.getDataType());
                        object = object8.getDBDataType();
                        if (("ARRAY".equals(object8.getDataType()) || "OBJECT".equals(object8.getDataType())) && Boolean.FALSE.equals(object8.isUnnest())) {
                            object = DatabaseMetadataUtils.getJSONDataType((String)object, "JSON");
                        }
                    } else if (object3 instanceof AggregationElementsExType.AggregationElement) {
                        object8 = (AggregationElementsExType.AggregationElement)object3;
                        string2 = DatabaseMetadataUtils.convertJSONAttrType(object8.getJSONAttribute().getDataType());
                        object = object8.getOutput().getDataType();
                    }
                    if (object3 instanceof AttributeExType) {
                        object8 = (AttributeExType)object3;
                        string = object8.getName();
                    } else if (object3 instanceof JSONAttributeType) {
                        string = this._JSONSourceColumn.getName();
                    } else if (object3 instanceof AggregationElementsExType.AggregationElement) {
                        string = this._JSONSourceColumn.getName();
                    }
                    if (object3 instanceof AttributeExType) {
                        string8 = null;
                        string9 = null;
                    } else if (object3 instanceof JSONAttributeType) {
                        object8 = (JSONAttributeType)object3;
                        string8 = object8.getPath();
                        string9 = this.getShortPath(string8);
                    } else if (object3 instanceof AggregationElementsExType.AggregationElement) {
                        object8 = (AggregationElementsExType.AggregationElement)object3;
                        string8 = object8.getJSONAttribute().getPath();
                        string9 = this.getShortPath(string8);
                    }
                    if (object3 instanceof AttributeExType) {
                        string10 = null;
                    } else if (object3 instanceof JSONAttributeType) {
                        string10 = null;
                    } else if (object3 instanceof AggregationElementsExType.AggregationElement) {
                        object8 = (AggregationElementsExType.AggregationElement)object3;
                        string10 = object8.getAggregationFunction();
                    }
                    if (object3 instanceof AttributeExType) {
                        string11 = null;
                        string12 = null;
                    } else if (object3 instanceof JSONAttributeType) {
                        string11 = null;
                        string12 = null;
                    } else if (object3 instanceof AggregationElementsExType.AggregationElement) {
                        object8 = new StringBuilder();
                        StringBuilder stringBuilder = new StringBuilder();
                        AggregationElementsExType.AggregationElement aggregationElement = (AggregationElementsExType.AggregationElement)object3;
                        if (aggregationElement.getSubGroupBy() != null && aggregationElement.getSubGroupBy().getAttributes() != null && !aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute().isEmpty()) {
                            for (JSONAttributeType jSONAttributeType : aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute()) {
                                String string13 = jSONAttributeType.getPath();
                                if (((StringBuilder)object8).length() > 0) {
                                    ((StringBuilder)object8).append(", ");
                                }
                                ((StringBuilder)object8).append(string13);
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(", ");
                                }
                                stringBuilder.append(this.getShortPath(string13));
                            }
                        }
                        string11 = ((StringBuilder)object8).toString();
                        string12 = stringBuilder.toString();
                        if (object2 != null) {
                            object9 = object2;
                        }
                        if (object7 != null) {
                            attributes = object7;
                        }
                    }
                    if (object3 instanceof AttributeExType) {
                        object8 = (AttributeExType)object3;
                        attributeStatus = object8.getStatus();
                    } else if (object3 instanceof JSONAttributeType) {
                        object8 = (JSONAttributeType)object3;
                        attributeStatus = object8.getStatus();
                    } else if (object3 instanceof AggregationElementsExType.AggregationElement) {
                        object8 = (AggregationElementsExType.AggregationElement)object3;
                        attributeStatus = object8.getJSONAttribute().getStatus();
                    }
                    this._srcData.add(new OutputColumnItem(object3, (String)object42, string2, (String)object, string, string8, string9, string10, (String)object9, (String)attributes, string11, string12, attributeStatus));
                }
            }
        }

        protected String[] getColumnNames() {
            return this._columnNames;
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData.isEmpty()) {
                return DialogsLrb.get("JSON_QUERY_LOADING");
            }
            if (n >= this._srcData.size()) {
                return "";
            }
            OutputColumnItem outputColumnItem = this._srcData.get(n);
            String string = null;
            if (n2 == this.NAME_COLUMN) {
                string = outputColumnItem.getName();
            } else if (n2 == this.DATA_TYPE_COLUMN) {
                string = outputColumnItem.getTgtDataType();
            } else if (n2 == this.SOURCE_COLUMN) {
                string = outputColumnItem.getSource();
            } else if (n2 == this.JSON_PATH_COLUMN) {
                string = this._showFullPath ? outputColumnItem.getFullPath() : outputColumnItem.getShortPath();
            } else if (n2 == this.AGGREG_COLUMN) {
                string = outputColumnItem.getAggregFunction();
            } else if (n2 == this.GROUPBY_COLUMN) {
                string = this._showFullPath ? outputColumnItem.getGroupByFull() : outputColumnItem.getGroupByShort();
            } else if (n2 == this.SUBGROUPBY_COLUMN) {
                string = this._showFullPath ? outputColumnItem.getSubGroupByFull() : outputColumnItem.getSubGroupByShort();
            } else if (n2 == this.ORG_DATA_TYPE) {
                string = outputColumnItem.getOrgDataType();
            } else if (n2 == this.ATTR_STATUS) {
                string = outputColumnItem.getStatus();
            } else assert (false) : "Out of bounds column when accessing items";
            return string != null ? string : "";
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == this.DATA_TYPE_COLUMN || n2 == this.NAME_COLUMN) {
                OutputColumnItem outputColumnItem = this._srcData.get(n);
                Object object2 = outputColumnItem.getSourceObject();
                if (n2 == this.DATA_TYPE_COLUMN) {
                    if (object2 instanceof AttributeExType) {
                        AttributeExType attributeExType = (AttributeExType)object2;
                        attributeExType.setNewDataType((String)object);
                    } else if (object2 instanceof JSONAttributeType) {
                        JSONAttributeType jSONAttributeType = (JSONAttributeType)object2;
                        jSONAttributeType.setDBDataType((String)object);
                    } else if (object2 instanceof AggregationElementsExType.AggregationElement) {
                        AggregationElementsExType.AggregationElement aggregationElement = (AggregationElementsExType.AggregationElement)object2;
                        aggregationElement.getOutput().setDataType((String)object);
                    }
                    outputColumnItem.setTgtDataType((String)object);
                } else if (n2 == this.NAME_COLUMN) {
                    Object object3;
                    Object object4;
                    outputColumnItem = this._srcData.get(n);
                    Vector<AttributeType> vector = new Vector<AttributeType>();
                    for (int i = 0; i < this._srcData.size(); ++i) {
                        if (i == n) continue;
                        object4 = this._srcData.get(i);
                        object3 = new AttributeType();
                        object3.setName(((OutputColumnItem)object4).getName());
                        object3.setAlias(((OutputColumnItem)object4).getName());
                        object3.setDataType(((OutputColumnItem)object4).getTgtDataType());
                        vector.add((AttributeType)object3);
                    }
                    String string = null;
                    object4 = this._srcData.get(n).getName();
                    object3 = this._srcData.get(n).getName();
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (object4 != null && StringUtils.isDoubleQuotedString(string)) {
                        object4 = StringUtils.addDoubleQuotes((String)object4);
                    }
                    if (object4 != null && ((String)object4).equals(string)) {
                        return;
                    }
                    if (string.length() != 0) {
                        if (!StringUtils.isDoubleQuotedString(string)) {
                            string = string.toUpperCase();
                        }
                        if (!AttributeNameValidator.validateAttributeName(string, vector, PreviewColumnsPanel.this._context, true)) {
                            return;
                        }
                    } else if (object4 != null && ((String)object4).length() != 0 && !AttributeNameValidator.validateAttributeName((String)object3, vector, PreviewColumnsPanel.this._context, true)) {
                        return;
                    }
                    string = string != null && string.length() == 0 ? null : StringUtils.trimDoubleQuotes(string);
                    if (object2 instanceof AttributeExType) {
                        for (NameChangeListener nameChangeListener : PreviewColumnsPanel.this._nameChangeListeners) {
                            nameChangeListener.relColNameChanged((String)object4, string);
                        }
                    } else if (object2 instanceof JSONAttributeType) {
                        JSONAttributeType jSONAttributeType = (JSONAttributeType)object2;
                        for (NameChangeListener nameChangeListener : PreviewColumnsPanel.this._nameChangeListeners) {
                            nameChangeListener.jsonColNameChanged(jSONAttributeType.getPath(), (String)object4, string);
                        }
                    } else if (object2 instanceof AggregationElementsExType.AggregationElement) {
                        AggregationElementsExType.AggregationElement aggregationElement = (AggregationElementsExType.AggregationElement)object2;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (aggregationElement.getSubGroupBy() != null && aggregationElement.getSubGroupBy().getAttributes() != null) {
                            for (NameChangeListener nameChangeListener : aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute()) {
                                arrayList.add(nameChangeListener.getPath());
                            }
                        }
                        for (NameChangeListener nameChangeListener : PreviewColumnsPanel.this._nameChangeListeners) {
                            nameChangeListener.aggColNameChanged(aggregationElement.getJSONAttribute().getPath(), aggregationElement.getAggregationFunction(), arrayList, (String)object4, string);
                        }
                    }
                    PreviewColumnsPanel.this._parent.getNameGenerator().rename((String)object4, string);
                    this.refreshModel();
                }
                PreviewColumnsPanel.this._parent.setPreviewDirty(true);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == this.NAME_COLUMN;
        }

        public void showFullPath(boolean bl) {
            this._showFullPath = bl;
            this.fireTableDataChanged();
        }

        private void refreshModel() {
            this._JSONAttributes = PreviewColumnsPanel.this._parent.getJSONAttributes();
            this._relationalAttributes = PreviewColumnsPanel.this._parent.getRelationalAttributes();
            this._aggregationElements = PreviewColumnsPanel.this._parent.getAggregationElements();
            this._groupingElements = PreviewColumnsPanel.this._parent.getGroupingElement();
            this.init();
            this.fireTableDataChanged();
        }

        public void refreshModel(AttributeType attributeType, String string, JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType) {
            this._JSONSourceColumn = attributeType;
            this._relationalDataSource = string;
            this._JSONAttributes = jSONAttributesType;
            this._relationalAttributes = relationalAttributesType;
            this._aggregationElements = aggregationElementsExType;
            this._groupingElements = groupingElementExType;
            this.init();
            this.fireTableDataChanged();
        }
    }
}

