/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.utils.HTMLStringUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileModeSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileStatisticsTableModel;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.data.StatsisticSelection;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.profile.WorkflowDataProfileNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.transformations.WorkflowTransformNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.search.SearchField;

public class StatisticsPIComponentPanel
extends PIComponentPanel
implements StatsisticSelection {
    private StatsSelection _currentStatsSelection;
    private StatsSelection _previousStatsSelection;
    private JLabel _restoreDefaults;
    private StatisticsSelectionObject _statsDescriptionObj;
    protected PropertyModel _propertyModel;
    private int[] _selectedRows;
    private DataMinerTablePanel dataMinerTablePanel;

    public StatisticsPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getTargetNode(propertyModel);
        this.initComponents();
        if (abstractDataNode instanceof DataProfileNode || abstractDataNode instanceof TransformationNode) {
            this._statsDescriptionObj = new StatisticsSelectionObject(this);
        } else assert (false) : "Error in StatisticsPIComponentPanel";
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE));
    }

    private DataMinerTable getTable() {
        return this.dataMinerTablePanel.getTable();
    }

    private SearchField getSearchField() {
        return this.dataMinerTablePanel.getSearchField();
    }

    @Override
    public boolean isStatsSelected(String string) {
        if (string.equals(StatisticsSelectionObject.HISTOGRAM)) {
            return this._currentStatsSelection.isHistogram();
        }
        if (string.equals(StatisticsSelectionObject.PERCENT_DISTINCT)) {
            return this._currentStatsSelection.isPercentdistinct();
        }
        if (string.equals(StatisticsSelectionObject.PERCENT_NULL)) {
            return this._currentStatsSelection.isPercentnull();
        }
        if (string.equals(StatisticsSelectionObject.MAX)) {
            return this._currentStatsSelection.isMax();
        }
        if (string.equals(StatisticsSelectionObject.MIN)) {
            return this._currentStatsSelection.isMin();
        }
        if (string.equals(StatisticsSelectionObject.AVG)) {
            return this._currentStatsSelection.isAvg();
        }
        if (string.equals(StatisticsSelectionObject.STDDEV)) {
            return this._currentStatsSelection.isStd();
        }
        if (string.equals(StatisticsSelectionObject.VARIANCE)) {
            return this._currentStatsSelection.isVar();
        }
        if (string.equals(StatisticsSelectionObject.KURTOSIS)) {
            return this._currentStatsSelection.isKurtosis();
        }
        if (string.equals(StatisticsSelectionObject.MEDIAN)) {
            return this._currentStatsSelection.isMedian();
        }
        if (string.equals(StatisticsSelectionObject.MODE_SAMPLED)) {
            return this._currentStatsSelection.isModesampled();
        }
        if (string.equals(StatisticsSelectionObject.MODE_ALL)) {
            return this._currentStatsSelection.isModeall();
        }
        if (string.equals(StatisticsSelectionObject.SKEWNESS)) {
            return this._currentStatsSelection.isSkewness();
        }
        if (string.equals("MODE_FUNCTION")) {
            return this._currentStatsSelection.isMode();
        }
        assert (false);
        return false;
    }

    public void restoreDefaultStats() {
        this._currentStatsSelection.setHistogram(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.HISTOGRAM));
        this._currentStatsSelection.setPercentdistinct(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.PERCENT_DISTINCT));
        this._currentStatsSelection.setPercentnull(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.PERCENT_NULL));
        this._currentStatsSelection.setMax(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MAX));
        this._currentStatsSelection.setMin(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MIN));
        this._currentStatsSelection.setAvg(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.AVG));
        this._currentStatsSelection.setStd(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.STDDEV));
        this._currentStatsSelection.setVar(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.VARIANCE));
        this._currentStatsSelection.setKurtosis(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.KURTOSIS));
        this._currentStatsSelection.setMedian(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MEDIAN));
        this._currentStatsSelection.setModesampled(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MODE_SAMPLED));
        this._currentStatsSelection.setModeall(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.MODE_ALL));
        this._currentStatsSelection.setSkewness(StatisticsSelectionObject.getDefaultStatsValue(StatisticsSelectionObject.SKEWNESS));
        this._currentStatsSelection.setMode(StatisticsSelectionObject.getDefaultStatsValue("MODE_FUNCTION"));
        this.updateStatsSelection();
    }

    @Override
    public void setSelectedStatistic(String string, Boolean bl) {
        if (HTMLStringUtils.isHtmlHyperLink(string)) {
            if ((string = HTMLStringUtils.unWrapInHtml(string)).equals(StatisticsSelectionObject.MODE_SAMPLED) || string.equals(StatisticsSelectionObject.MODE_ALL)) {
                this._currentStatsSelection.setMode(bl);
                this.updateStatsSelection();
            }
            return;
        }
        if (string.equals(StatisticsSelectionObject.PERCENT_DISTINCT)) {
            this._currentStatsSelection.setPercentdistinct(bl);
            if (bl.booleanValue()) {
                this._currentStatsSelection.setPercentnull(bl);
            }
        } else if (string.equals(StatisticsSelectionObject.PERCENT_NULL)) {
            this._currentStatsSelection.setPercentnull(bl);
        }
        if (string.equals(StatisticsSelectionObject.HISTOGRAM)) {
            this._currentStatsSelection.setHistogram(bl);
        }
        if (string.equals(StatisticsSelectionObject.MAX)) {
            this._currentStatsSelection.setMax(bl);
        }
        if (string.equals(StatisticsSelectionObject.MIN)) {
            this._currentStatsSelection.setMin(bl);
        }
        if (string.equals(StatisticsSelectionObject.AVG)) {
            this._currentStatsSelection.setAvg(bl);
        }
        if (string.equals(StatisticsSelectionObject.STDDEV)) {
            this._currentStatsSelection.setStd(bl);
        }
        if (string.equals(StatisticsSelectionObject.VARIANCE)) {
            this._currentStatsSelection.setVar(bl);
        }
        if (string.equals(StatisticsSelectionObject.KURTOSIS)) {
            this._currentStatsSelection.setKurtosis(bl);
        }
        if (string.equals(StatisticsSelectionObject.MEDIAN)) {
            this._currentStatsSelection.setMedian(bl);
        }
        if (string.equals(StatisticsSelectionObject.MODE_SAMPLED)) {
            this._currentStatsSelection.setModesampled(bl);
        }
        if (string.equals(StatisticsSelectionObject.MODE_ALL)) {
            this._currentStatsSelection.setModeall(bl);
        }
        if (string.equals(StatisticsSelectionObject.SKEWNESS)) {
            this._currentStatsSelection.setSkewness(bl);
        }
        if (string.equals("MODE_FUNCTION")) {
            this._currentStatsSelection.setMode(bl);
        }
        this.updateStatsSelection();
    }

    public void setStatsSelection(AbstractDataNode abstractDataNode) {
        if (abstractDataNode instanceof DataProfileNode) {
            DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractDataNode.getData();
            this._currentStatsSelection = null != dataProfileNodeType.getStatsSelection() ? this.copyStatsSelection(dataProfileNodeType.getStatsSelection()) : StatisticsSelectionObject.createDefaultStatsSelection();
            this._previousStatsSelection = this.copyStatsSelection(this._currentStatsSelection);
        } else if (abstractDataNode instanceof TransformationNode) {
            TransformationNodeType transformationNodeType = (TransformationNodeType)abstractDataNode.getData();
            this._currentStatsSelection = null != transformationNodeType.getStatsSelection() ? this.copyStatsSelection(transformationNodeType.getStatsSelection()) : StatisticsSelectionObject.createDefaultStatsSelection();
            this._previousStatsSelection = this.copyStatsSelection(this._currentStatsSelection);
        }
    }

    private StatsSelection copyStatsSelection(StatsSelection statsSelection) {
        StatsSelection statsSelection2 = new StatsSelection();
        statsSelection2.setHistogram(Boolean.valueOf(statsSelection.isHistogram()));
        statsSelection2.setPercentdistinct(Boolean.valueOf(statsSelection.isPercentdistinct()));
        statsSelection2.setPercentnull(Boolean.valueOf(statsSelection.isPercentnull()));
        statsSelection2.setMax(Boolean.valueOf(statsSelection.isMax()));
        statsSelection2.setMin(Boolean.valueOf(statsSelection.isMin()));
        statsSelection2.setAvg(Boolean.valueOf(statsSelection.isAvg()));
        statsSelection2.setStd(Boolean.valueOf(statsSelection.isStd()));
        statsSelection2.setVar(Boolean.valueOf(statsSelection.isVar()));
        statsSelection2.setKurtosis(Boolean.valueOf(statsSelection.isKurtosis()));
        statsSelection2.setMedian(Boolean.valueOf(statsSelection.isMedian()));
        statsSelection2.setModesampled(Boolean.valueOf(statsSelection.isModesampled()));
        statsSelection2.setModeall(Boolean.valueOf(statsSelection.isModeall()));
        statsSelection2.setMode(Boolean.valueOf(statsSelection.isMode()));
        statsSelection2.setSkewness(Boolean.valueOf(statsSelection.isSkewness()));
        return statsSelection2;
    }

    protected AbstractDataNode getNode(PropertyModel propertyModel) {
        Node node = this.getTargetNode(propertyModel);
        if (node == null || !(node instanceof DataProfileNode) && !(node instanceof TransformationNode)) {
            return null;
        }
        AbstractDataNode abstractDataNode = (AbstractDataNode)node;
        return abstractDataNode;
    }

    public void initUI(PropertyModel propertyModel) {
        this._propertyModel = propertyModel;
        this.setStatsSelection(this.getNode(propertyModel));
        this._statsDescriptionObj.createStatsDescriptionMap();
        this._restoreDefaults = new JLabel(HTMLStringUtils.wrapInHtml(StatisticsSelectionObject.RESTORE_DEFAULTS_LINK));
        this._restoreDefaults.setToolTipText(StatisticsSelectionObject.RESTORE_DEFAULTS_LINK_TOOLTIP);
        this._restoreDefaults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && StatisticsPIComponentPanel.this.isWritable()) {
                    StatisticsPIComponentPanel.access$002(StatisticsPIComponentPanel.this, StatisticsPIComponentPanel.this.getTable().getSelectedRowsInModel());
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)StatisticsSelectionObject.RESTORE_DEFAULT_SETTINGS_CONFIRM_MSG, (String)StatisticsSelectionObject.RESTORE_DEFAULT_SETTINGS_CONFIRM_TITLE, null)) {
                        StatisticsPIComponentPanel.this.restoreDefaultStats();
                        StatisticsPIComponentPanel.this._statsDescriptionObj.createFilteredStatisticsTableModel(StatisticsPIComponentPanel.this.getSearchField().getText(), StatisticsPIComponentPanel.this._statsDescriptionObj.getStatistics());
                    }
                }
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(this._restoreDefaults);
        DataProfileStatisticsTableModel dataProfileStatisticsTableModel = new DataProfileStatisticsTableModel(this._statsDescriptionObj.getStatistics(), StatisticsSelectionObject.getColNames(), this);
        this._statsDescriptionObj.setupStatisticsTable(dataProfileStatisticsTableModel);
        this.addMouseListener();
        this._statsDescriptionObj.setupSearchField();
    }

    private void addMouseListener() {
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1 && StatisticsPIComponentPanel.this.isWritable()) {
                    boolean bl;
                    boolean bl2;
                    DataProfileModeSelectionPanel dataProfileModeSelectionPanel;
                    DialogHelper dialogHelper;
                    String string;
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    int n3 = jTable.convertColumnIndexToModel(n2);
                    int n4 = jTable.convertRowIndexToModel(n);
                    TableModel tableModel = jTable.getModel();
                    String string2 = tableModel.getColumnName(n3);
                    if (string2.equals(StatisticsSelectionObject.getColNames().elementAt(1)) && ((string = (String)tableModel.getValueAt(n4, n3)).equals(HTMLStringUtils.wrapInHtml(StatisticsSelectionObject.MODE_SAMPLED)) || string.equals(HTMLStringUtils.wrapInHtml(StatisticsSelectionObject.MODE_ALL))) && (dialogHelper = new DialogHelper(dataProfileModeSelectionPanel = new DataProfileModeSelectionPanel(bl2 = StatisticsPIComponentPanel.this.isStatsSelected(StatisticsSelectionObject.MODE_SAMPLED)))).showAsDialog(StatisticsPIComponentPanel.this) && bl2 != (bl = dataProfileModeSelectionPanel.isSampledMode())) {
                        StatisticsPIComponentPanel.this.toggleModeSelection(bl);
                        StatisticsPIComponentPanel.this.updateStatsSelection();
                    }
                }
            }
        });
    }

    private void toggleModeSelection(boolean bl) {
        if (bl) {
            this._currentStatsSelection.setModeall(Boolean.valueOf(false));
            this._currentStatsSelection.setModesampled(Boolean.valueOf(true));
        } else {
            this._currentStatsSelection.setModeall(Boolean.valueOf(true));
            this._currentStatsSelection.setModesampled(Boolean.valueOf(false));
        }
    }

    private void updateStatsSelection() {
        ComplexProperty complexProperty = new ComplexProperty(DataProfileNode.STATS_SELECTION, this._currentStatsSelection);
        complexProperty.setOldData(this._previousStatsSelection);
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getTargetNode(this._propertyModel);
        if (this._propertyModel instanceof WorkflowDataProfileNodePropertyProxyModel) {
            WorkflowDataProfileNodePropertyProxyModel workflowDataProfileNodePropertyProxyModel = (WorkflowDataProfileNodePropertyProxyModel)this._propertyModel;
            workflowDataProfileNodePropertyProxyModel.setValueAt(DataProfileNode.STATS_SELECTION, abstractDataNode, complexProperty, workflowDataProfileNodePropertyProxyModel.getRowMapping("STATS_SELECTION"));
        } else if (this._propertyModel instanceof WorkflowTransformNodePropertyProxyModel) {
            WorkflowTransformNodePropertyProxyModel workflowTransformNodePropertyProxyModel = (WorkflowTransformNodePropertyProxyModel)this._propertyModel;
            workflowTransformNodePropertyProxyModel.setValueAt(TransformationNode.STATS_SELECTION, abstractDataNode, complexProperty, workflowTransformNodePropertyProxyModel.getRowMapping("STATS_SELECTION"));
        }
    }

    public void updateUI(PropertyModel propertyModel) {
        this._restoreDefaults.setEnabled(this.isWritable());
        this._propertyModel = propertyModel;
        this.setStatsSelection(this.getNode(propertyModel));
        this._statsDescriptionObj.createStatsDescriptionMap();
        int[] nArray = this.getTable().getSelectedRowsInModel();
        this._statsDescriptionObj.createFilteredStatisticsTableModel(this.getSearchField().getText(), this._statsDescriptionObj.getStatistics());
        if (null != nArray && nArray.length > 0) {
            this.getTable().setSelectedRowsInModel(nArray);
        } else if (null != this._selectedRows && this._selectedRows.length > 0) {
            this.getTable().setSelectedRowsInModel(nArray);
        }
    }

    @Override
    public DataMinerTablePanel getDataMinerTablePanel() {
        return this.dataMinerTablePanel;
    }

    @Override
    public boolean isReadOnly() {
        return !this.isWritable();
    }

    static /* synthetic */ int[] access$002(StatisticsPIComponentPanel statisticsPIComponentPanel, int[] nArray) {
        statisticsPIComponentPanel._selectedRows = nArray;
        return nArray;
    }
}

