/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.TypeCellEditor;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ExtensibleBuildNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public class RBuildNode
extends ExtensibleBuildNode {
    public RBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        RBuildNodeType rBuildNodeType = (RBuildNodeType)this.getData();
        RBuildNodeType.Models models = new RBuildNodeType.Models();
        rBuildNodeType.setModels(models);
        rBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_R_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        RBuildNodeType rBuildNodeType = (RBuildNodeType)this.getData();
        RBuildNodeType.Models models = rBuildNodeType.getModels();
        if (!MetaDataHelper.hasAtLeastOneCaseId((BuildNodeType)rBuildNodeType)) {
            this.addMessage("BUILD_NO_CASEID", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (models.getRModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getRModel())) {
                bl3 = false;
            }
            if (bl3 && rBuildNodeType.getCaseAttributes().getAttribute().isEmpty()) {
                bl3 = false;
            }
            if (this.isSupervisedBuildNode()) {
                HashMap hashMap = new HashMap();
                models.getRModel().forEach(rModelType -> hashMap.put(rModelType.getId(), rModelType));
                if (this.isClassification()) {
                    boolean bl4;
                    List list = rBuildNodeType.getResults().getClassificationResult();
                    ExtensibleBuildNodeType.Results results = new ExtensibleBuildNodeType.Results();
                    results.setGenAccuracyMetrics(rBuildNodeType.getResults().isGenAccuracyMetrics());
                    results.setGenConfusionMatrix(rBuildNodeType.getResults().isGenConfusionMatrix());
                    results.setGenLift(rBuildNodeType.getResults().isGenLift());
                    results.setGenROC(rBuildNodeType.getResults().isGenROC());
                    for (MiningResultType miningResultType : list) {
                        if (!hashMap.containsKey(miningResultType.getModelId())) continue;
                        ClassificationResultType classificationResultType = (ClassificationResultType)MetaDataHelper.copyMetadataObject(miningResultType);
                        results.getClassificationResult().add(classificationResultType);
                    }
                    boolean bl5 = bl4 = results.getClassificationResult().size() != rBuildNodeType.getResults().getClassificationResult().size();
                    if (bl4) {
                        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
                        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
                        ComplexProperty complexProperty = new ComplexProperty("classTestResults", results);
                        complexProperty.setOldData(rBuildNodeType.getResults());
                        arrayList.add(complexProperty);
                        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
                    }
                } else if (this.isRegression()) {
                    boolean bl6;
                    List list = rBuildNodeType.getResults().getRegressionResult();
                    ExtensibleBuildNodeType.Results results = new ExtensibleBuildNodeType.Results();
                    results.setGenAccuracyMetrics(rBuildNodeType.getResults().isGenAccuracyMetrics());
                    results.setGenResiduals(rBuildNodeType.getResults().isGenResiduals());
                    for (MiningResultType miningResultType : list) {
                        if (!hashMap.containsKey(miningResultType.getModelId())) continue;
                        RegressionResultType regressionResultType = (RegressionResultType)MetaDataHelper.copyMetadataObject(miningResultType);
                        results.getRegressionResult().add(regressionResultType);
                    }
                    boolean bl7 = bl6 = results.getRegressionResult().size() != rBuildNodeType.getResults().getRegressionResult().size();
                    if (bl6) {
                        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
                        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
                        ComplexProperty complexProperty = new ComplexProperty("regrTestResults", results);
                        complexProperty.setOldData(rBuildNodeType.getResults());
                        arrayList.add(complexProperty);
                        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
                    }
                }
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_MODEL_ICON"));
    }

    @Override
    public String getHelpTopic() {
        return "r_node";
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_MODEL_ICON"));
    }

    @Override
    public List<? extends ModelType> getModels() {
        ArrayList arrayList = new ArrayList();
        RBuildNodeType rBuildNodeType = (RBuildNodeType)this.getData();
        RBuildNodeType.Models models = rBuildNodeType.getModels();
        if (models != null) {
            arrayList.addAll(models.getRModel());
        }
        return arrayList;
    }

    @Override
    protected String getModelTemplatePath() {
        return "workflow_r_build_model.sql";
    }

    @Override
    protected String generateSpecificModelSettingsCode(ModelType modelType, Version version) {
        Object object;
        RModelType.ScoreFunctions scoreFunctions;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES (''ALGO_EXTENSIBLE_LANG'', ''R'')'); \n");
        RModelType rModelType = (RModelType)modelType;
        RModelType.BuildFunctions buildFunctions = rModelType.getBuildFunctions();
        if (buildFunctions != null) {
            stringBuilder.append(this.generateInsertModelSettingCode("RALG_BUILD_FUNCTION", buildFunctions.getPrimaryFunction()));
            scoreFunctions = buildFunctions.getSettings();
            if (scoreFunctions != null && StringUtils.isNotEmpty((String)(object = scoreFunctions.getModelSettingODM().stream().map(modelSettingODMType -> {
                if (TypeCellEditor.NUMBER_PAIR.getName().equals(modelSettingODMType.getType())) {
                    return String.format("%s AS %s", modelSettingODMType.getValue(), modelSettingODMType.getName());
                }
                return String.format("''''%s'''' AS %s", modelSettingODMType.getValue(), modelSettingODMType.getName());
            }).collect(Collectors.joining(","))))) {
                object = String.format("SELECT %s FROM DUAL", object);
                stringBuilder.append(this.generateInsertModelSettingCode("RALG_BUILD_PARAMETER", object));
            }
        }
        if ((scoreFunctions = rModelType.getScoreFunctions()) != null) {
            stringBuilder.append(this.generateInsertModelSettingCode("RALG_SCORE_FUNCTION", scoreFunctions.getPrimaryFunction()));
            stringBuilder.append(this.generateInsertModelSettingCode("RALG_WEIGHT_FUNCTION", scoreFunctions.getSecondaryFunction()));
        }
        if ((object = rModelType.getDetailFunction()) != null) {
            stringBuilder.append(this.generateInsertModelSettingCode("RALG_DETAILS_FUNCTION", object.getPrimaryFunction()));
            RModelType.DetailFunction.Output output = object.getOutput();
            if (output != null) {
                String string = output.getColumn().stream().map(column -> {
                    String string = "";
                    switch (column.getType()) {
                        case VARCHAR_2: {
                            string = String.format("CAST(''''a'''' AS VARCHAR(%s)) %s", column.getLength(), column.getName());
                            break;
                        }
                        case NUMBER: {
                            string = String.format("1 %s", column.getName());
                        }
                    }
                    return string;
                }).collect(Collectors.joining(","));
                if (StringUtils.isNotEmpty((String)string)) {
                    string = String.format("SELECT %s FROM DUAL", string);
                }
                stringBuilder.append(this.generateInsertModelSettingCode("RALG_DETAILS_FORMAT", string));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String generateAutoDataPreparationCode(List<MiningAttributeType> list) {
        return "";
    }

    @Override
    public Map<String, String> getAdditionalModelCodeTemplateReplacements(Context context, ModelType modelType) {
        Map<String, String> map = Collections.emptyMap();
        if (this.isSupervisedBuildNode()) {
            SupervisedBuildNode supervisedBuildNode = null;
            if (this.isClassification()) {
                supervisedBuildNode = new ClassificationBuildNode("", this.getData(), this.getContext());
            } else if (this.isRegression()) {
                supervisedBuildNode = new RegressionBuildNode("", this.getData(), this.getContext());
            } else assert (false) : "The supervised node is not supported yet.";
            map = ((AbstractBuildNode)supervisedBuildNode).getAdditionalModelCodeTemplateReplacements(context, modelType);
        }
        return map;
    }
}

