/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterOutputColumnsType;
import oracle.ide.Context;

public final class RowFilterNode
extends AbstractTransformNode
implements DataConsumer,
ApplyChainNode {
    public static final String ROWFILTER_ATTRIBUTES = "RowFilterAttributes";
    public static final String ROWFILTER_FILTER = "rowFilter";

    public RowFilterNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        RowFilterOutputColumnsType rowFilterOutputColumnsType = new RowFilterOutputColumnsType();
        rowFilterNodeType.setOutputColumns(rowFilterOutputColumnsType);
        rowFilterNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_ROW_FILTER_NODE_NAME");
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        for (AttributeType attributeType : rowFilterNodeType.getOutputColumns().getAttribute()) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            attributeType2.setAlias(null);
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            attributeType2.setStatus(attributeType.getStatus());
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    public List<AbstractNode> findDataNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    @Override
    public boolean validate(boolean bl) {
        Object object4;
        Object object2;
        Object object32;
        boolean bl2 = super.validate(bl);
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        boolean bl3 = false;
        boolean bl4 = false;
        RowFilterOutputColumnsType rowFilterOutputColumnsType = (RowFilterOutputColumnsType)MetaDataHelper.copyMetadataObject(rowFilterNodeType.getOutputColumns());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<AbstractNode> list = this.findDataNodes();
        for (AbstractNode object52 : list) {
            if (!(object52 instanceof DataProvider)) continue;
            for (Object object32 : ((DataProvider)((Object)object52)).getAttributes().getAttribute()) {
                String string = object32.getAlias();
                object2 = (string != null && string.trim().length() > 0 ? string : object32.getName()) + "." + object32.getDataType();
                hashMap.put((String)object2, object32);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Object object4 : rowFilterOutputColumnsType.getAttribute()) {
            object32 = object4.getName() + "." + object4.getDataType();
            AttributeType attributeType = (AttributeType)hashMap.get(object32);
            if (attributeType == null) {
                if (list.size() > 0) {
                    arrayList.add(object4);
                    bl = true;
                } else {
                    object4.setStatus(AttributeStatus.INVALID);
                    if (!bl3) {
                        this.addMessage("ROW_FILTER_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                        bl3 = true;
                    }
                    bl2 = false;
                }
                bl4 = true;
                continue;
            }
            if (!object4.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            object4.setStatus(AttributeStatus.VALID);
            bl4 = true;
        }
        if (arrayList.size() > 0) {
            rowFilterOutputColumnsType.getAttribute().removeAll(arrayList);
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Object object32 : rowFilterOutputColumnsType.getAttribute()) {
            String string = object32.getName() + "." + object32.getDataType();
            hashMap2.put(string, object32);
        }
        object4 = new ArrayList();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            for (AttributeType attributeType : ((DataProvider)((Object)abstractNode)).getAttributes().getAttribute()) {
                String string = attributeType.getName() + "." + attributeType.getDataType();
                AttributeType attributeType2 = (AttributeType)hashMap2.get(string);
                if (attributeType2 != null) continue;
                AttributeType attributeType3 = new AttributeType();
                attributeType3.setAlias(attributeType.getAlias());
                attributeType3.setDataType(attributeType.getDataType());
                attributeType3.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                attributeType3.setName(attributeType.getName());
                attributeType3.setStatus(attributeType.getStatus());
                object4.add(attributeType3);
            }
        }
        if (object4.size() > 0) {
            rowFilterOutputColumnsType.getAttribute().addAll(object4);
            bl = true;
            bl4 = true;
        }
        object32 = new ArrayList();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl4) {
            object2 = new ComplexProperty(ROWFILTER_ATTRIBUTES, rowFilterOutputColumnsType);
            ((ComplexProperty)object2).setOldData(rowFilterNodeType.getOutputColumns());
            object32.add(object2);
        }
        object2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        ((ComplexProperty)object2).setOldData(this.getSQLExpression());
        object32.add(object2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object32);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        boolean bl5 = SQLHelper.isExtendedTypeEnabled(this.getContext());
        DatabaseMetadataUtils.convertExtendedTypes(rowFilterNodeType.getOutputColumns().getAttribute(), bl5);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        List<AbstractNode> list = this.findDataNodes();
        if (list.size() < 1) {
            this.addMessage("ROW_FILTER_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (rowFilterNodeType.getOutputColumns().getAttribute().size() == 0) {
            this.addMessage("ROW_FILTER_NO_OUTPUT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public String generateSQLExpression() {
        StringBuffer stringBuffer = new StringBuffer(32000);
        StringBuffer stringBuffer2 = new StringBuffer(32000);
        StringBuffer stringBuffer3 = new StringBuffer(32000);
        StringBuffer stringBuffer4 = new StringBuffer("{INPUT_SOURCE}");
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        for (AttributeType attributeType : rowFilterNodeType.getOutputColumns().getAttribute()) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append("\"" + attributeType.getName() + "\"");
            if (attributeType.getAlias() == null || attributeType.getAlias().length() == 0) {
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer2.append(" \"" + attributeType.getAlias() + "\"\n");
        }
        if (rowFilterNodeType.getFilter() != null && rowFilterNodeType.getFilter().trim().length() > 0) {
            stringBuffer3.append(rowFilterNodeType.getFilter());
        }
        stringBuffer.append("SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "\n");
        stringBuffer.append(stringBuffer2 + "\n");
        stringBuffer.append("FROM\n");
        stringBuffer.append(stringBuffer4 + "\n");
        if (stringBuffer3.length() > 0) {
            stringBuffer.append("WHERE\n");
            stringBuffer.append(stringBuffer3);
        }
        return this.wrapExpressionInWithClause(stringBuffer.toString());
    }

    @Override
    public void setProperty(String string, Object object) {
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        if (string.equals(ROWFILTER_ATTRIBUTES)) {
            RowFilterOutputColumnsType rowFilterOutputColumnsType = (RowFilterOutputColumnsType)object;
            rowFilterNodeType.setOutputColumns(rowFilterOutputColumnsType);
        } else if (string.equals(ROWFILTER_FILTER)) {
            String string2 = (String)object;
            rowFilterNodeType.setFilter(string2);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                rowFilterNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                rowFilterNodeType.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(ROWFILTER_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(ROWFILTER_FILTER)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        if (string.equals(ROWFILTER_ATTRIBUTES)) {
            return rowFilterNodeType.getOutputColumns();
        }
        if (string.equals(ROWFILTER_FILTER)) {
            return rowFilterNodeType.getFilter();
        }
        if (string.equals("SQL_EXPRESSION")) {
            return rowFilterNodeType.getSQLExpression();
        }
        return super.getProperty(string);
    }

    @Override
    public String getHelpTopic() {
        return "rowfilter_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_ROW_FILTER_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_ROW_FILTER_ICON"));
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        RowFilterOutputColumnsType rowFilterOutputColumnsType = rowFilterNodeType.getOutputColumns();
        RowFilterOutputColumnsType rowFilterOutputColumnsType2 = (RowFilterOutputColumnsType)MetaDataHelper.copyMetadataObject(rowFilterOutputColumnsType);
        List list = rowFilterOutputColumnsType2.getAttribute();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (attributeType2 == null || attributeType.getName().equals(attributeType2.getName()) && attributeType.getDataType().equals(attributeType2.getDataType())) continue;
            String string = attributeType.getName();
            AttributeType attributeType3 = null;
            if (attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty()) {
                attributeType3 = new AttributeType();
                attributeType3.setName(attributeType.getAlias());
                attributeType3.setAlias(null);
                attributeType3.setDataType(attributeType2.getDataType());
                attributeType3.setDataTypeQualifier(attributeType2.getDataTypeQualifier());
                attributeType3.setStatus(AttributeStatus.VALID);
                string = attributeType.getAlias();
            } else {
                attributeType3 = attributeType;
            }
            attributeType.setName(attributeType2.getName());
            attributeType.setDataType(attributeType2.getDataType());
            attributeType.setDataTypeQualifier(attributeType2.getDataTypeQualifier());
            hashMap.put(string, attributeType3);
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), ROWFILTER_ATTRIBUTES, rowFilterOutputColumnsType2);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public DataGuideType getJSONAttrDataGuide(AttributeType attributeType, Integer n) {
        AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        boolean bl = false;
        for (AttributeType attributeType3 : rowFilterNodeType.getOutputColumns().getAttribute()) {
            if (attributeType3.getAlias() != null && !attributeType3.getAlias().trim().isEmpty()) {
                if (attributeType.getName().compareToIgnoreCase(attributeType3.getAlias()) != 0) continue;
                attributeType2.setName(attributeType3.getName());
                bl = true;
                break;
            }
            if (attributeType.getName().compareToIgnoreCase(attributeType3.getName()) != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            return super.getJSONAttrDataGuide(attributeType2, n);
        }
        return null;
    }

    @Override
    public DataGuideInfoType getJSONAttrDataGuideInfoType(AttributeType attributeType) {
        AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this.getData();
        for (AttributeType attributeType3 : rowFilterNodeType.getOutputColumns().getAttribute()) {
            if (attributeType3.getAlias() == null || attributeType3.getAlias().trim().isEmpty() || attributeType.getName().compareToIgnoreCase(attributeType3.getAlias()) != 0) continue;
            attributeType2.setName(attributeType3.getName());
            break;
        }
        return super.getJSONAttrDataGuideInfoType(attributeType2);
    }

    public static class RowFilterOutputColumnNameGenerator {
        private boolean isExpandedObjNameEnabled;
        private HashMap<String, Boolean> _columnNames = new HashMap();
        private static final int MAXIMUM = 30;
        private static final int MAXIMUM_EX = 128;

        public RowFilterOutputColumnNameGenerator(Context context, RowFilterOutputColumnsType rowFilterOutputColumnsType) {
            this.isExpandedObjNameEnabled = SQLHelper.isExpandedObjNameEnabled(context);
            for (AttributeType attributeType : rowFilterOutputColumnsType.getAttribute()) {
                String string = attributeType.getAlias() == null ? attributeType.getName() : attributeType.getAlias();
                this._columnNames.put(string, Boolean.TRUE);
            }
        }

        public boolean doesNameExist(String string) {
            Boolean bl = this._columnNames.get(string);
            return bl != null;
        }

        public void addUniqueName(String string) {
            this._columnNames.put(string, Boolean.TRUE);
        }

        public void removeUniqueName(String string) {
            this._columnNames.remove(string);
        }

        public void removeUniqueName(AttributeType attributeType) {
            String string = attributeType.getAlias() == null ? attributeType.getName() : attributeType.getAlias();
            this.removeUniqueName(string);
        }

        public void removeAllUniqueNames() {
            this._columnNames.clear();
        }

        private String getUniqueName(String string) {
            String string2 = string;
            int n = 0;
            while (this._columnNames.containsKey(string2)) {
                string2 = string + ++n;
                int n2 = string2.length();
                if (n2 <= (this.isExpandedObjNameEnabled ? 128 : 30)) continue;
                int n3 = n2 - (this.isExpandedObjNameEnabled ? 128 : 30);
                string2 = string.substring(0, string.length() - n3) + n;
            }
            return string2;
        }

        public String GenerateColumnName(String string, boolean bl) {
            String string2 = this.getUniqueName(string);
            if (bl) {
                this._columnNames.put(string2, Boolean.TRUE);
            }
            return string2;
        }
    }
}

