/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ColumnFilterPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private JCheckBox jAttrDependencyCheckBox;
    private JCheckBox jAttrImportanceCheckBox;
    private JCheckBox jAutoFilterCheckBox;
    private JCheckBox jAutoRemoveCheckBox;
    private JCheckBox jConstantPercentCheckBox;
    private JSpinner jConstantPercentSpinner;
    private JCheckBox jDataQualityCheckBox;
    private JCheckBox jImportanceCheckBox;
    private JSpinner jImportanceSpinner;
    private JCheckBox jNullPercentCheckBox;
    private JSpinner jNullPercentSpinner;
    private JSpinner jSampleSizeSpinner;
    private JCheckBox jSamplingCheckBox;
    private JComboBox jSamplingTypeComboBox;
    private JLabel jSamplingTypeLabel;
    private JLabel jStratifiedCutoffLabel;
    private JSpinner jStratifiedCutoffSpinner;
    private JCheckBox jTopNCheckBox;
    private JSpinner jTopNSpinner;
    private JCheckBox jUniquePercentCheckBox;
    private JSpinner jUniquePercentSpinner;
    private JRadioButton systemSamplingRadioButton;
    private JRadioButton userSamplingRadioButton;

    public ColumnFilterPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.setHelpID("preferences_transforms_filter_col");
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_DATA_QUALITY"), this.jDataQualityCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_NULL_PERCENT"), this.jNullPercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_UNIQUE_PERCENT"), this.jUniquePercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_CONSTANT_PERCENT"), this.jConstantPercentCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_ATTR_IMPORTANCE"), this.jAttrImportanceCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_ATTR_DEPENDENCY"), this.jAttrDependencyCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_AI_CUT_OFF"), this.jImportanceCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_AI_TOPN"), this.jTopNCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING"), this.jSamplingCheckBox);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_TECHNIQUE"), this.jSamplingTypeLabel);
        hashMap.put(DialogsLrb.get("COLUMN_FILTER_SETTING_STRATIFIED_CUTOFF"), this.jStratifiedCutoffLabel);
        hashMap.put(DialogsLrb.get("SAMPLING_SYSTEM"), this.systemSamplingRadioButton);
        hashMap.put(DialogsLrb.get("SAMPLING_USER"), this.userSamplingRadioButton);
        UIResourceHelper.setComponentText(hashMap);
        this.jSamplingTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.SamplingType.toHuman((String)"System"), ServerConstants.SamplingType.toHuman((String)"Random"), ServerConstants.SamplingType.toHuman((String)"Stratified")}));
    }

    @Override
    public void initUI() {
        this.jAutoFilterCheckBox.setVisible(false);
        this.jAutoRemoveCheckBox.setVisible(false);
        this.systemSamplingRadioButton.addActionListener(new SystemSamplingListener());
        this.userSamplingRadioButton.addActionListener(new UserSamplingListener());
        this.jSamplingCheckBox.addActionListener(new SamplingCheckBoxListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.systemSamplingRadioButton);
        buttonGroup.add(this.userSamplingRadioButton);
    }

    private void enableControls() {
        boolean bl = this.jDataQualityCheckBox.isSelected();
        boolean bl2 = this.jAttrImportanceCheckBox.isSelected();
        this.jNullPercentCheckBox.setEnabled(bl);
        this.jUniquePercentCheckBox.setEnabled(bl);
        this.jConstantPercentCheckBox.setEnabled(bl);
        this.jNullPercentSpinner.setEnabled(bl && this.jNullPercentCheckBox.isSelected());
        this.jUniquePercentSpinner.setEnabled(bl && this.jUniquePercentCheckBox.isSelected());
        this.jConstantPercentSpinner.setEnabled(bl && this.jConstantPercentCheckBox.isSelected());
        this.jImportanceCheckBox.setEnabled(bl2);
        this.jTopNCheckBox.setEnabled(bl2);
        this.jImportanceSpinner.setEnabled(bl2 && this.jImportanceCheckBox.isSelected());
        this.jTopNSpinner.setEnabled(bl2 && this.jTopNCheckBox.isSelected());
        this.jSamplingTypeComboBox.setEnabled(bl2);
        this.jStratifiedCutoffSpinner.setEnabled(bl2);
        this.jSampleSizeSpinner.setEnabled(this.jSamplingCheckBox.isSelected());
        this.jAttrDependencyCheckBox.setEnabled(this.jAttrImportanceCheckBox.isSelected());
        this.systemSamplingRadioButton.setEnabled(this.jSamplingCheckBox.isSelected());
        this.userSamplingRadioButton.setEnabled(this.jSamplingCheckBox.isSelected());
        this.jSampleSizeSpinner.setEnabled(this.jSamplingCheckBox.isSelected() && this.userSamplingRadioButton.isSelected());
    }

    public void onEntry(TraversableContext traversableContext) {
        ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this.jAutoFilterCheckBox.setSelected(columnFilterPreferenceSettings.getAutomaticFilter());
        this.jAutoRemoveCheckBox.setSelected(columnFilterPreferenceSettings.getAutomaticRemoveAttrs());
        this.jNullPercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseNullsPercent());
        this.jNullPercentSpinner.setValue(columnFilterPreferenceSettings.getNullsPercentValue());
        this.jUniquePercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseUniquePercent());
        this.jUniquePercentSpinner.setValue(columnFilterPreferenceSettings.getUniquePercentValue());
        this.jConstantPercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseConstantPercent());
        this.jConstantPercentSpinner.setValue(columnFilterPreferenceSettings.getConstantPercentValue());
        this.jImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUseCuttoff());
        this.jImportanceSpinner.setValue(columnFilterPreferenceSettings.getCutOffValue());
        this.jTopNCheckBox.setSelected(columnFilterPreferenceSettings.getUseTopN());
        this.jTopNSpinner.setValue(columnFilterPreferenceSettings.getTopNValue());
        this.jSamplingTypeComboBox.setSelectedItem(ServerConstants.SamplingType.toHuman((String)columnFilterPreferenceSettings.getSamplingType()));
        this.jStratifiedCutoffSpinner.setValue(columnFilterPreferenceSettings.getStratifiedCutoff());
        this.jSamplingCheckBox.setSelected(columnFilterPreferenceSettings.getUseSampling());
        this.jSampleSizeSpinner.setValue(columnFilterPreferenceSettings.getSamplingNumberOfRows());
        this.userSamplingRadioButton.setSelected(columnFilterPreferenceSettings.getUserSampling());
        this.systemSamplingRadioButton.setSelected(columnFilterPreferenceSettings.getSystemSampling());
        this.jDataQualityCheckBox.setSelected(columnFilterPreferenceSettings.getUseDataQuality());
        this.jAttrImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUse122AttrImportance());
        this.jAttrDependencyCheckBox.setSelected(columnFilterPreferenceSettings.getUseAttrDependency());
        this.enableControls();
        this.jSamplingTypeComboBoxActionPerformed(null);
    }

    public void onExit(TraversableContext traversableContext) {
        ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        columnFilterPreferenceSettings.setAutomaticFilter(this.jAutoFilterCheckBox.isSelected());
        columnFilterPreferenceSettings.setAutomaticRemoveAttrs(this.jAutoRemoveCheckBox.isSelected());
        columnFilterPreferenceSettings.setUseNullsPercent(this.jNullPercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setNullsPercentValue((Double)this.jNullPercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseUniquePercent(this.jUniquePercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setUniquePercentValue((Double)this.jUniquePercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseConstantPercent(this.jConstantPercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setConstantPercentValue((Double)this.jConstantPercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseCuttoff(this.jImportanceCheckBox.isSelected());
        columnFilterPreferenceSettings.setCutOffValue((Double)this.jImportanceSpinner.getValue());
        columnFilterPreferenceSettings.setUseTopN(this.jTopNCheckBox.isSelected());
        columnFilterPreferenceSettings.setTopNValue((Integer)this.jTopNSpinner.getValue());
        columnFilterPreferenceSettings.setSamplingType(ServerConstants.SamplingType.toSchema((String)this.jSamplingTypeComboBox.getSelectedItem().toString()));
        columnFilterPreferenceSettings.setStratifiedCutoff((Integer)this.jStratifiedCutoffSpinner.getValue());
        columnFilterPreferenceSettings.setUseSampling(this.jSamplingCheckBox.isSelected());
        columnFilterPreferenceSettings.setSystemSampling(this.systemSamplingRadioButton.isSelected());
        columnFilterPreferenceSettings.setUserSampling(this.userSamplingRadioButton.isSelected());
        columnFilterPreferenceSettings.setSamplingNumberOfRows((Integer)this.jSampleSizeSpinner.getValue());
        columnFilterPreferenceSettings.setUseDataQuality(this.jDataQualityCheckBox.isSelected());
        columnFilterPreferenceSettings.setUseAttrImportance(this.jAttrImportanceCheckBox.isSelected());
        columnFilterPreferenceSettings.setUseAttrDependency(this.jAttrDependencyCheckBox.isSelected());
    }

    private static ColumnFilterPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ColumnFilterPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }

    private void initComponents() {
        this.jStratifiedCutoffLabel = new JLabel();
        this.jSamplingTypeComboBox = new JComboBox();
        this.jSamplingTypeLabel = new JLabel();
        this.jAutoFilterCheckBox = new JCheckBox();
        this.jAutoRemoveCheckBox = new JCheckBox();
        this.jDataQualityCheckBox = new JCheckBox();
        this.jNullPercentCheckBox = new JCheckBox();
        this.jNullPercentSpinner = new JSpinner();
        this.jUniquePercentCheckBox = new JCheckBox();
        this.jUniquePercentSpinner = new JSpinner();
        this.jConstantPercentCheckBox = new JCheckBox();
        this.jConstantPercentSpinner = new JSpinner();
        this.jAttrImportanceCheckBox = new JCheckBox();
        this.jImportanceCheckBox = new JCheckBox();
        this.jImportanceSpinner = new JSpinner();
        this.jTopNCheckBox = new JCheckBox();
        this.jTopNSpinner = new JSpinner();
        this.jSamplingCheckBox = new JCheckBox();
        this.jSampleSizeSpinner = new JSpinner();
        this.jStratifiedCutoffSpinner = new JSpinner();
        this.jAttrDependencyCheckBox = new JCheckBox();
        this.systemSamplingRadioButton = new JRadioButton();
        this.userSamplingRadioButton = new JRadioButton();
        this.jStratifiedCutoffLabel.setText("Stratified Cutoff");
        this.jStratifiedCutoffLabel.setName("jStratifiedCutoffLabel");
        this.jSamplingTypeComboBox.setName("jSamplingTypeComboBox");
        this.jSamplingTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jSamplingTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jSamplingTypeLabel.setText("Sampling Technique:");
        this.jSamplingTypeLabel.setName("jSamplingTypeLabel");
        this.jAutoFilterCheckBox.setText("Automatic Filterings");
        this.jAutoFilterCheckBox.setName("jAutoFilterCheckBox");
        this.jAutoFilterCheckBox.setOpaque(false);
        this.jAutoRemoveCheckBox.setText("Remove Missing Input Automatically");
        this.jAutoRemoveCheckBox.setName("jAutoRemoveCheckBox");
        this.jAutoRemoveCheckBox.setOpaque(false);
        this.jDataQualityCheckBox.setText("Data Quality");
        this.jDataQualityCheckBox.setName("jDataQualityCheckBox");
        this.jDataQualityCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jDataQualityCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentCheckBox.setText("% Nulls less than or equal");
        this.jNullPercentCheckBox.setName("jNullPercentCheckBox");
        this.jNullPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jNullPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jNullPercentSpinner.setName("jNullPercentSpinner");
        this.jUniquePercentCheckBox.setText("% Unique less than or equal");
        this.jUniquePercentCheckBox.setName("jUniquePercentCheckBox");
        this.jUniquePercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jUniquePercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jUniquePercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jUniquePercentSpinner.setName("jUniquePercentSpinner");
        this.jConstantPercentCheckBox.setText("% Constant less than or equal");
        this.jConstantPercentCheckBox.setName("jConstantPercentCheckBox");
        this.jConstantPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jConstantPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jConstantPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jConstantPercentSpinner.setName("jConstantPercentSpinner");
        this.jAttrImportanceCheckBox.setText("Attribute Importance");
        this.jAttrImportanceCheckBox.setName("jAttrImportanceCheckBox");
        this.jAttrImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jAttrImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceCheckBox.setText("Importance Cutoff");
        this.jImportanceCheckBox.setName("jImportanceCheckBox");
        this.jImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceSpinner.setModel(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.1));
        this.jImportanceSpinner.setName("jImportanceSpinner");
        this.jTopNCheckBox.setText("Top N");
        this.jTopNCheckBox.setName("jTopNCheckBox");
        this.jTopNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jTopNCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTopNSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1));
        this.jTopNSpinner.setName("jTopNSpinner");
        this.jSamplingCheckBox.setText("Sampling");
        this.jSamplingCheckBox.setName("jSamplingCheckBox");
        this.jSampleSizeSpinner.setModel(new SpinnerNumberModel((Number)2000, Integer.valueOf(1), null, (Number)1000));
        this.jSampleSizeSpinner.setName("jSampleSizeSpinner");
        this.jStratifiedCutoffSpinner.setModel(new SpinnerNumberModel((Number)10, null, null, (Number)1));
        this.jStratifiedCutoffSpinner.setName("jStratifiedCutoffSpinner");
        this.jAttrDependencyCheckBox.setText("Attribute Dependency");
        this.jAttrDependencyCheckBox.setEnabled(false);
        this.jAttrDependencyCheckBox.setName("jAttrDependencyCheckBox");
        this.jAttrDependencyCheckBox.setOpaque(false);
        this.systemSamplingRadioButton.setText("jRadioButton1");
        this.systemSamplingRadioButton.setName("systemSamplingRadioButton");
        this.userSamplingRadioButton.setText("jRadioButton2");
        this.userSamplingRadioButton.setName("userSamplingRadioButton");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAutoFilterCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jSamplingCheckBox, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAutoRemoveCheckBox, -2, 242, -2).addComponent(this.jDataQualityCheckBox, -2, 170, -2).addComponent(this.jAttrImportanceCheckBox, -2, 169, -2).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jImportanceCheckBox, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jImportanceSpinner, -2, 170, -2)).addComponent(this.systemSamplingRadioButton).addGroup(groupLayout.createSequentialGroup().addComponent(this.userSamplingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSampleSizeSpinner, -2, 170, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jUniquePercentCheckBox, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jUniquePercentSpinner, -2, 170, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jConstantPercentCheckBox, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jConstantPercentSpinner, -2, 170, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jNullPercentCheckBox, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jNullPercentSpinner, -2, 170, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTopNCheckBox, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTopNSpinner, -2, 170, -2)).addComponent(this.jAttrDependencyCheckBox).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSamplingTypeLabel).addComponent(this.jStratifiedCutoffLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSamplingTypeComboBox, GroupLayout.Alignment.TRAILING, -2, 170, -2).addComponent(this.jStratifiedCutoffSpinner, GroupLayout.Alignment.TRAILING, -2, 170, -2)))))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAutoRemoveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDataQualityCheckBox).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNullPercentCheckBox).addComponent(this.jNullPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUniquePercentCheckBox).addComponent(this.jUniquePercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConstantPercentCheckBox).addComponent(this.jConstantPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jAttrImportanceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportanceCheckBox).addComponent(this.jImportanceSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTopNCheckBox).addComponent(this.jTopNSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAttrDependencyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSamplingTypeLabel).addComponent(this.jSamplingTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStratifiedCutoffLabel).addComponent(this.jStratifiedCutoffSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSamplingCheckBox).addGap(6, 6, 6).addComponent(this.systemSamplingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userSamplingRadioButton).addComponent(this.jSampleSizeSpinner)).addContainerGap(12, Short.MAX_VALUE)));
    }

    private void jDataQualityCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jNullPercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.jUniquePercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.jConstantPercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.enableControls();
    }

    private void jAttrImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jImportanceCheckBox.setSelected(this.jAttrImportanceCheckBox.isSelected());
        this.jTopNCheckBox.setSelected(this.jAttrImportanceCheckBox.isSelected());
        this.jAttrDependencyCheckBox.setSelected(this.jAttrImportanceCheckBox.isSelected());
        this.enableControls();
    }

    private void jNullPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jUniquePercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jConstantPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jTopNCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jSamplingTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = this.jSamplingTypeComboBox.getSelectedItem().toString();
        boolean bl = false;
        if ("System".equals(ServerConstants.SamplingType.toSchema((String)string))) {
            bl = true;
        }
        this.jStratifiedCutoffLabel.setVisible(bl);
        this.jStratifiedCutoffSpinner.setVisible(bl);
    }

    public static class ColumnFilterPreferenceSettings
    extends DataMinerPreferenceSettings {
        private static final String DATA_KEY = "oracle.dmt.dataminer.workflow.ColumnFilterPreferenceSettings";
        private static final String USER_SAMPLING_KEY = "userSampling";
        private static final String SYSTEM_SAMPLING_KEY = "systemSampling";
        private static final String SAMPLING_TYPE = "System";
        private static final String USE_ATTRIBUTE_IMPORTANCE_KEY = "UseAttributeImportance";
        private static final String AUTOMATIC_FILTER_KEY = "AutomaticFilter";
        private static final String AUTOMATIC_REMOVE_ATTRIBUTES_KEY = "AutomaticRemoveAttributes";
        private static final String USE_DATA_QUALITY_KEY = "UseDataQuality";
        private static final String USE_ATTRIBUTE_DEPENDENCY_KEY = "UseAttributeDependency";
        private static final String USE_NULLS_PERCENT_KEY = "UseNullsPercent";
        private static final String USE_UNIQUE_PERCENT_KEY = "UseUniquePercent";
        private static final String USE_CONSTANT_PERCENT_KEY = "UseConstantPercent";
        private static final String USE_CUTTOFF_KEY = "UseCuttoff";
        private static final String USE_TOPN_KEY = "UseTopN";
        private static final String SAMPLING_TYPE_KEY = "SamplingType";
        private static final String STRATIFIED_CUTOFF_KEY = "StratifiedCutoff";
        private static final String USE_SAMPLING_KEY = "UseSampling";
        private static final String SAMPLING_NUMBER_OF_ROWS_KEY = "SamplingNumberOfRows";
        private static final String NULLS_PERCENT_KEY = "NullsPercent";
        private static final String UNIQUE_PERCENT_KEY = "UniquePercent";
        private static final String CONSTANT_PERCENT_KEY = "ConstantPercent";
        private static final String CUT_OFF_KEY = "CutOff";
        private static final String TOPN_KEY = "TopN";
        private static final boolean _AUTO_FILTER = false;
        private static final boolean _AUTO_REMOVE_ATTRS = true;
        private static final boolean _USE_DATA_QUALITY = true;
        private static final boolean _USE_122_ATTR_IMPORTANCE = true;
        private static final boolean _USE_ORIGINAL_ATTR_IMPORTANCE = false;
        private static final boolean _USE_ATTR_DEPENDENCY = false;
        private static final boolean _USE_NULLS_PERCENT = true;
        private static final boolean _USE_UNIQUE_PERCENT = true;
        private static final boolean _USE_CONSTANT_PERCENT = true;
        private static final boolean _USE_CUT_OFF = true;
        private static final boolean _USE_TOP_N = true;
        private static final boolean _USE_SAMPLING = true;
        private static final double _NULLS_PERCENT = 95.0;
        private static final double _UNIQUE_PERCENT = 95.0;
        private static final double _CONSTANT_PERCENT = 95.0;
        private static final double _CUT_OFF = 0.0;
        private static final int _TOP_N = 100;
        private static final int _STRATIFIED_CUTOFF = 10;
        private static final int _NUMBER_OF_ROWS = 10000;

        public static ColumnFilterPreferenceSettings getInstance() {
            return ColumnFilterPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        }

        private ColumnFilterPreferenceSettings(HashStructure hashStructure) {
            super(hashStructure);
        }

        public static ColumnFilterPreferenceSettings getInstance(PropertyStorage propertyStorage) {
            return new ColumnFilterPreferenceSettings(ColumnFilterPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        public void setAutomaticFilter(boolean bl) {
            this._hash.putBoolean(AUTOMATIC_FILTER_KEY, bl);
        }

        public boolean getAutomaticFilter() {
            return this._hash.getBoolean(AUTOMATIC_FILTER_KEY, false);
        }

        public void setAutomaticRemoveAttrs(boolean bl) {
            this._hash.putBoolean(AUTOMATIC_REMOVE_ATTRIBUTES_KEY, bl);
        }

        public boolean getAutomaticRemoveAttrs() {
            return this._hash.getBoolean(AUTOMATIC_REMOVE_ATTRIBUTES_KEY, true);
        }

        public boolean getUseDataQuality() {
            return this._hash.getBoolean(USE_DATA_QUALITY_KEY, true);
        }

        public void setUseDataQuality(boolean bl) {
            this._hash.putBoolean(USE_DATA_QUALITY_KEY, bl);
        }

        public boolean getUse122AttrImportance() {
            return this._hash.getBoolean(USE_ATTRIBUTE_IMPORTANCE_KEY, true);
        }

        public boolean getUseOriginalAttrImportance() {
            return this._hash.getBoolean(USE_ATTRIBUTE_IMPORTANCE_KEY, false);
        }

        public void setUseAttrImportance(boolean bl) {
            this._hash.putBoolean(USE_ATTRIBUTE_IMPORTANCE_KEY, bl);
        }

        public boolean getUseAttrDependency() {
            return this._hash.getBoolean(USE_ATTRIBUTE_DEPENDENCY_KEY, false);
        }

        public void setUseAttrDependency(boolean bl) {
            this._hash.putBoolean(USE_ATTRIBUTE_DEPENDENCY_KEY, bl);
        }

        public boolean getUseNullsPercent() {
            return this._hash.getBoolean(USE_NULLS_PERCENT_KEY, true);
        }

        public void setUseNullsPercent(boolean bl) {
            this._hash.putBoolean(USE_NULLS_PERCENT_KEY, bl);
        }

        public boolean getUseUniquePercent() {
            return this._hash.getBoolean(USE_UNIQUE_PERCENT_KEY, true);
        }

        public void setUseUniquePercent(boolean bl) {
            this._hash.putBoolean(USE_UNIQUE_PERCENT_KEY, bl);
        }

        public boolean getUseConstantPercent() {
            return this._hash.getBoolean(USE_CONSTANT_PERCENT_KEY, true);
        }

        public void setUseConstantPercent(boolean bl) {
            this._hash.putBoolean(USE_CONSTANT_PERCENT_KEY, bl);
        }

        public boolean getUseCuttoff() {
            return this._hash.getBoolean(USE_CUTTOFF_KEY, true);
        }

        public void setUseCuttoff(boolean bl) {
            this._hash.putBoolean(USE_CUTTOFF_KEY, bl);
        }

        public boolean getUseTopN() {
            return this._hash.getBoolean(USE_TOPN_KEY, true);
        }

        public void setUseTopN(boolean bl) {
            this._hash.putBoolean(USE_TOPN_KEY, bl);
        }

        public String getSamplingType() {
            return this._hash.getString(SAMPLING_TYPE_KEY, SAMPLING_TYPE);
        }

        public void setSamplingType(String string) {
            this._hash.putString(SAMPLING_TYPE_KEY, string);
        }

        public int getStratifiedCutoff() {
            return this._hash.getInt(STRATIFIED_CUTOFF_KEY, 10);
        }

        public void setStratifiedCutoff(int n) {
            this._hash.putInt(STRATIFIED_CUTOFF_KEY, n);
        }

        public boolean getUseSampling() {
            return this._hash.getBoolean(USE_SAMPLING_KEY, true);
        }

        public void setUseSampling(boolean bl) {
            this._hash.putBoolean(USE_SAMPLING_KEY, bl);
        }

        public int getSamplingNumberOfRows() {
            return this._hash.getInt(SAMPLING_NUMBER_OF_ROWS_KEY, 10000);
        }

        public void setSamplingNumberOfRows(int n) {
            this._hash.putInt(SAMPLING_NUMBER_OF_ROWS_KEY, n);
        }

        public void removeSamplingNumberOfRows() {
            this._hash.remove(SAMPLING_NUMBER_OF_ROWS_KEY);
        }

        public double getNullsPercentValue() {
            return this._hash.getDouble(NULLS_PERCENT_KEY, 95.0);
        }

        public void setNullsPercentValue(double d) {
            this._hash.putDouble(NULLS_PERCENT_KEY, d);
        }

        public void removeNullsPercentValue() {
            this._hash.remove(NULLS_PERCENT_KEY);
        }

        public double getUniquePercentValue() {
            return this._hash.getDouble(UNIQUE_PERCENT_KEY, 95.0);
        }

        public void setUniquePercentValue(double d) {
            this._hash.putDouble(UNIQUE_PERCENT_KEY, d);
        }

        public void removeUniquePercentValue() {
            this._hash.remove(UNIQUE_PERCENT_KEY);
        }

        public double getConstantPercentValue() {
            return this._hash.getDouble(CONSTANT_PERCENT_KEY, 95.0);
        }

        public void setConstantPercentValue(double d) {
            this._hash.putDouble(CONSTANT_PERCENT_KEY, d);
        }

        public void removeConstantPercentValue() {
            this._hash.remove(CONSTANT_PERCENT_KEY);
        }

        public double getCutOffValue() {
            return this._hash.getDouble(CUT_OFF_KEY, 0.0);
        }

        public void setCutOffValue(double d) {
            this._hash.putDouble(CUT_OFF_KEY, d);
        }

        public void removeCutOffValue() {
            this._hash.remove(CUT_OFF_KEY);
        }

        public int getTopNValue() {
            return this._hash.getInt(TOPN_KEY, 100);
        }

        public void setTopNValue(int n) {
            this._hash.putInt(TOPN_KEY, n);
        }

        public void removeTopNValue() {
            this._hash.remove(TOPN_KEY);
        }

        public void setUserSampling(boolean bl) {
            this._hash.putBoolean(USER_SAMPLING_KEY, bl);
        }

        public boolean getUserSampling() {
            return this._hash.getBoolean(USER_SAMPLING_KEY, false);
        }

        public void removeUserSampling() {
            this._hash.remove(USER_SAMPLING_KEY);
        }

        public void setSystemSampling(boolean bl) {
            this._hash.putBoolean(SYSTEM_SAMPLING_KEY, bl);
        }

        public boolean getSystemSampling() {
            return this._hash.getBoolean(SYSTEM_SAMPLING_KEY, true);
        }

        public void removeSystemSampling() {
            this._hash.remove(SYSTEM_SAMPLING_KEY);
        }
    }

    private class SamplingCheckBoxListener
    implements ActionListener {
        private SamplingCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnFilterPreferencesPanel.this.systemSamplingRadioButton.setEnabled(ColumnFilterPreferencesPanel.this.jSamplingCheckBox.isSelected());
            ColumnFilterPreferencesPanel.this.userSamplingRadioButton.setEnabled(ColumnFilterPreferencesPanel.this.jSamplingCheckBox.isSelected());
            ColumnFilterPreferencesPanel.this.jSampleSizeSpinner.setEnabled(ColumnFilterPreferencesPanel.this.jSamplingCheckBox.isSelected());
        }
    }

    private class UserSamplingListener
    implements ActionListener {
        private UserSamplingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnFilterPreferencesPanel.this.jSampleSizeSpinner.setEnabled(true);
        }
    }

    private class SystemSamplingListener
    implements ActionListener {
        private SystemSamplingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnFilterPreferencesPanel.this.jSampleSizeSpinner.setEnabled(false);
        }
    }
}

