/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleWorkflowDialog;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.ide.Context;

public class SettingsPanel
extends JPanel {
    private Logger theLogger = Logger.getLogger(this.getClass().getName());
    private Context context;
    private ScheduleWorkflowDialog parent;
    private SchedulerModel model;
    private JSpinner jDaysSpinner;
    private JSpinner jDaysSpinner1;
    private JSpinner jHoursSpinner;
    private JSpinner jHoursSpinner1;
    private JComboBox jJobClassComboBox;
    private JLabel jJobClassLabel;
    private JLabel jJobPriorityLabel;
    private JSlider jJobPrioritySlider;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JCheckBox jMaxFailuresCheckBox;
    private JSpinner jMaxFailuresSpinner;
    private JCheckBox jMaxRunDurationCheckBox;
    private JSpinner jMinsSpinner;
    private JSpinner jMinsSpinner1;
    private JCheckBox jScheduleLimitCheckBox;
    private JComboBox jTimeZoneComboBox;
    private JLabel jTimeZoneLabel;

    public SettingsPanel(Context context, ScheduleWorkflowDialog scheduleWorkflowDialog) {
        this.context = context;
        this.parent = scheduleWorkflowDialog;
        this.model = scheduleWorkflowDialog.getModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        this.jTimeZoneLabel.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_TIME_ZONE_LBL"));
        this.jJobClassLabel.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_JOB_CLASS_LBL"));
        this.jJobPriorityLabel.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_JOB_PRIORITY_LBL"));
        this.jMaxFailuresCheckBox.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_MAX_FAILURES_LBL"));
        this.jMaxRunDurationCheckBox.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_MAX_RUN_DURATION_LBL"));
        this.jScheduleLimitCheckBox.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_SCHEDULE_LIMIT_LBL"));
        this.jLabel1.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_DAYS_LBL"));
        this.jLabel2.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_HOURS_LBL"));
        this.jLabel3.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_MINS_LBL"));
        this.jLabel4.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_DAYS_LBL"));
        this.jLabel5.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_HOURS_LBL"));
        this.jLabel6.setText(DialogsLrb.get("SCHEDULER_ADVANCED_SETTINGS_MINS_LBL"));
    }

    public void initUI() {
        this.jTimeZoneComboBox.setModel(new DefaultComboBoxModel<String>(this.model.getAllTimeZones()));
        this.jTimeZoneComboBox.setSelectedItem(this.model.getTimeZone());
        this.jJobClassComboBox.setModel(new DefaultComboBoxModel<Object>(this.model.getJobClasses().toArray()));
        this.jJobClassComboBox.setSelectedItem(this.model.getJobClass());
        this.jJobPrioritySlider.setModel(new DefaultBoundedRangeModel(this.model.getJobPriority() - 1, 0, 0, 4));
        this.jJobPrioritySlider.setMajorTickSpacing(5);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(0, new JLabel(DialogsLrb.get("SCHEDULER_JOB_PRIORITY_HIGH")));
        hashtable.put(2, new JLabel(DialogsLrb.get("SCHEDULER_JOB_PRIORITY_MEDIUM")));
        hashtable.put(4, new JLabel(DialogsLrb.get("SCHEDULER_JOB_PRIORITY_LOW")));
        this.jJobPrioritySlider.setLabelTable(hashtable);
        this.jMaxFailuresCheckBox.setSelected(this.model.isUseMaxFailures());
        this.jMaxFailuresSpinner.setModel(new SpinnerNumberModel(this.model.getMaxFailures(), 1, 1000, 1));
        this.jMaxRunDurationCheckBox.setSelected(this.model.isUseMaxRunDuration());
        this.jDaysSpinner.setModel(new SpinnerNumberModel(this.model.getMaxRunDurationDays(), 0, 365, 1));
        this.jHoursSpinner.setModel(new SpinnerNumberModel(this.model.getMaxRunDurationHours(), 0, 24, 1));
        this.jMinsSpinner.setModel(new SpinnerNumberModel(this.model.getMaxRunDurationMins(), 0, 60, 1));
        this.jScheduleLimitCheckBox.setSelected(this.model.isUseScheduleLimit());
        this.jDaysSpinner1.setModel(new SpinnerNumberModel(this.model.getScheduleLimitDays(), 0, 365, 1));
        this.jHoursSpinner1.setModel(new SpinnerNumberModel(this.model.getScheduleLimitHours(), 0, 24, 1));
        this.jMinsSpinner1.setModel(new SpinnerNumberModel(this.model.getScheduleLimitMins(), 0, 60, 1));
        this.enableControls();
    }

    private void enableControls() {
        this.jMaxFailuresSpinner.setEnabled(this.jMaxFailuresCheckBox.isSelected());
        this.jDaysSpinner.setEnabled(this.jMaxRunDurationCheckBox.isSelected());
        this.jHoursSpinner.setEnabled(this.jMaxRunDurationCheckBox.isSelected());
        this.jMinsSpinner.setEnabled(this.jMaxRunDurationCheckBox.isSelected());
        this.jDaysSpinner1.setEnabled(this.jScheduleLimitCheckBox.isSelected());
        this.jHoursSpinner1.setEnabled(this.jScheduleLimitCheckBox.isSelected());
        this.jMinsSpinner1.setEnabled(this.jScheduleLimitCheckBox.isSelected());
        this.jJobClassComboBox.setEnabled(this.model.isIsWorkflowJobClassAllowed());
    }

    public String getJobClass() {
        return (String)this.jJobClassComboBox.getSelectedItem();
    }

    public String getTimeZone() {
        return (String)this.jTimeZoneComboBox.getSelectedItem();
    }

    public int getJobPriority() {
        return this.jJobPrioritySlider.getValue() + 1;
    }

    public boolean isUseMaxFailures() {
        return this.jMaxFailuresCheckBox.isSelected();
    }

    public int getMaxFailures() {
        return (Integer)this.jMaxFailuresSpinner.getValue();
    }

    public boolean isUseMaxRunDuration() {
        return this.jMaxRunDurationCheckBox.isSelected();
    }

    public int getMaxRunDurationDays() {
        return (Integer)this.jDaysSpinner.getValue();
    }

    public int getMaxRunDurationHours() {
        return (Integer)this.jHoursSpinner.getValue();
    }

    public int getMaxRunDurationMins() {
        return (Integer)this.jMinsSpinner.getValue();
    }

    public boolean isUseScheduleLimit() {
        return this.jScheduleLimitCheckBox.isSelected();
    }

    public int getScheduleLimitDays() {
        return (Integer)this.jDaysSpinner1.getValue();
    }

    public int getScheduleLimitHours() {
        return (Integer)this.jHoursSpinner1.getValue();
    }

    public int getScheduleLimitMins() {
        return (Integer)this.jMinsSpinner1.getValue();
    }

    private void initComponents() {
        this.jTimeZoneLabel = new JLabel();
        this.jTimeZoneComboBox = new JComboBox();
        this.jJobClassLabel = new JLabel();
        this.jJobClassComboBox = new JComboBox();
        this.jJobPriorityLabel = new JLabel();
        this.jJobPrioritySlider = new JSlider();
        this.jMaxFailuresCheckBox = new JCheckBox();
        this.jMaxFailuresSpinner = new JSpinner();
        this.jMaxRunDurationCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jDaysSpinner = new JSpinner();
        this.jHoursSpinner = new JSpinner();
        this.jMinsSpinner = new JSpinner();
        this.jScheduleLimitCheckBox = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jDaysSpinner1 = new JSpinner();
        this.jHoursSpinner1 = new JSpinner();
        this.jMinsSpinner1 = new JSpinner();
        this.setPreferredSize(new Dimension(430, 300));
        this.jTimeZoneLabel.setLabelFor(this.jTimeZoneComboBox);
        this.jTimeZoneLabel.setText("Time Zone:");
        this.jTimeZoneComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jJobClassLabel.setLabelFor(this.jJobClassComboBox);
        this.jJobClassLabel.setText("Job Class:");
        this.jJobClassComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jJobPriorityLabel.setText("Job Priority:");
        this.jJobPrioritySlider.setPaintLabels(true);
        this.jMaxFailuresCheckBox.setText("Max Failures");
        this.jMaxFailuresCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.jMaxFailuresCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jMaxFailuresCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jMaxRunDurationCheckBox.setText("Max Run Duration");
        this.jMaxRunDurationCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.jMaxRunDurationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jMaxRunDurationCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText("Days:");
        this.jLabel2.setText("Hours:");
        this.jLabel3.setText("Mins:");
        this.jDaysSpinner.setModel(new SpinnerNumberModel((Number)999, null, null, (Number)1));
        this.jHoursSpinner.setModel(new SpinnerNumberModel((Number)999, null, null, (Number)1));
        this.jMinsSpinner.setModel(new SpinnerNumberModel((Number)999, null, null, (Number)1));
        this.jScheduleLimitCheckBox.setText("Schedule Limit");
        this.jScheduleLimitCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.jScheduleLimitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jScheduleLimitCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jLabel4.setText("Days:");
        this.jLabel5.setText("Hours:");
        this.jLabel6.setText("Mins:");
        this.jDaysSpinner1.setModel(new SpinnerNumberModel((Number)999, null, null, (Number)1));
        this.jHoursSpinner1.setModel(new SpinnerNumberModel((Number)999, null, null, (Number)1));
        this.jMinsSpinner1.setModel(new SpinnerNumberModel((Number)999, null, null, (Number)1));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jMaxFailuresSpinner, -2, 121, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jJobPriorityLabel, -1, 67, Short.MAX_VALUE).addComponent(this.jJobClassLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTimeZoneLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTimeZoneComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jJobClassComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jJobPrioritySlider, -1, 327, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMaxRunDurationCheckBox).addComponent(this.jMaxFailuresCheckBox).addComponent(this.jScheduleLimitCheckBox).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jDaysSpinner, -1, 38, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jHoursSpinner, -1, 38, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMinsSpinner, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jDaysSpinner1, -1, 38, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jHoursSpinner1, -1, 38, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMinsSpinner1, -1, 38, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)))))).addGap(0, 249, Short.MAX_VALUE))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTimeZoneLabel).addComponent(this.jTimeZoneComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jJobClassLabel).addComponent(this.jJobClassComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jJobPriorityLabel).addComponent(this.jJobPrioritySlider, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMaxFailuresCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMaxFailuresSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jMaxRunDurationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDaysSpinner, -2, -1, -2).addComponent(this.jHoursSpinner, -2, -1, -2).addComponent(this.jMinsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScheduleLimitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDaysSpinner1, -2, -1, -2).addComponent(this.jHoursSpinner1, -2, -1, -2).addComponent(this.jMinsSpinner1, -2, -1, -2)).addContainerGap(34, Short.MAX_VALUE)));
    }

    private void jMaxFailuresCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jMaxRunDurationCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jScheduleLimitCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }
}

