/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.macros.MacroHandler;
import oracle.ide.macros.MacroValueProvider;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ideimpl.macros.MacroDeclaration;
import oracle.ideimpl.macros.MacroHook;
import oracle.ideimpl.macros.MacrosArb;

public class DeclarativeMacroHandler
implements MacroHandler {
    private String qualifier = null;
    private String qualifierDescription = null;
    private ClassLoader classloader;
    private MacroValueProvider macroHandlerImpl;
    private List<MacroDeclaration> declarations = new ArrayList<MacroDeclaration>();
    private boolean requiresContext;

    public void setClassLoader(ClassLoader loader) {
        this.classloader = loader;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifierDescription(String qualifierDescription) {
        this.qualifierDescription = qualifierDescription;
    }

    @Override
    public String getQualifierDescription() {
        return this.qualifierDescription;
    }

    @Override
    public String getValue(Context context, String name) {
        if (this.classloader == null) {
            throw new UnsupportedOperationException("DeclarativeMacroHandler not properly initialized ... getValue called while classloader is null");
        }
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        List<MacroDeclaration> macros = MacroHook.getMacros(this.qualifier, workspace, project);
        for (MacroDeclaration md : macros) {
            if (!md.getName().equals(name)) continue;
            if (this.macroHandlerImpl == null) {
                String implementationClass = md.getClassName();
                MetaClass metaClass = new MetaClass(this.classloader, implementationClass);
                try {
                    this.macroHandlerImpl = (MacroValueProvider)metaClass.newInstance();
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed to create " + implementationClass + " to handle macro expansion");
                    return null;
                }
            }
            return this.macroHandlerImpl.getValue(context, name);
        }
        return null;
    }

    @Override
    public String getDescription(Context context, String name) {
        List<MacroDeclaration> macros = MacroHook.getMacros(this.qualifier, context.getWorkspace(), context.getProject());
        for (MacroDeclaration md : macros) {
            if (md.getName() == null || !md.getName().equals(name)) continue;
            return md.getDescription();
        }
        return MacrosArb.format("MACRO_UNDEFINED_OR_NOT_VISIBLE_MESSAGE", name);
    }

    @Override
    public List<String> getNames(Context context) {
        List<MacroDeclaration> macros = MacroHook.getMacros(this.qualifier, context.getWorkspace(), context.getProject());
        ArrayList<String> names = new ArrayList<String>();
        for (MacroDeclaration md : macros) {
            names.add(md.getName());
        }
        return names;
    }

    @Override
    public List<String> getPathMacroNames(Context context) {
        List<MacroDeclaration> macros = MacroHook.getMacros(this.qualifier, context.getWorkspace(), context.getProject());
        ArrayList<String> names = new ArrayList<String>();
        for (MacroDeclaration md : macros) {
            if (!md.isPathExpression()) continue;
            names.add(md.getName());
        }
        return names;
    }

    public void addMacroDeclaration(MacroDeclaration md) {
        this.declarations.add(md);
    }

    @Override
    public boolean requiresContext(String name) {
        List<MacroDeclaration> macros = MacroHook.getMacros(this.qualifier, null, null);
        for (MacroDeclaration md : macros) {
            if (md.getName() == null || !md.getName().equals(name)) continue;
            return md.requiresContext();
        }
        return false;
    }
}

