/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.export.wizard.ExportFormatOptionsPanel;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;

public class DbCartDeployDataOptionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES = 0;
    public static int WIZARD = 1;
    private JPanel m_dataDeployPanel = new JPanel();
    private JPanel _dataPanel = new JPanel();
    private TitledPane _dataPane;
    private JLabel _formatTitle = new JLabel(DbCartAddinArb.getString("DATA_FORMAT_TITLE"));
    private JLabel m_labelDeployData = new JLabel();
    private JCheckBox m_chkbxTruncData = new JCheckBox();
    private JCheckBox m_chkbxDisableConstraints = new JCheckBox();
    ExportFormatOptionsPanel m_formatOptions;
    private boolean _isPdb = false;
    private boolean m_showDisableConstraints = false;
    private boolean m_showFormatOptions = false;
    private boolean m_isDataPanelEnabled = false;
    private int m_usage;
    private JLabel _methodLabel = new JLabel(DbCartAddinArb.getString("METHOD"));
    private JComboBox<String> _loadMethodCmp;
    private DefaultComboBoxModel<String> _loadMethodModel;
    private int _loadMethodType = 0;
    private JPanel _targetPanel;
    private Component _cloudStorage;
    public static final int METHOD_AUTO = 0;
    public static final int METHOD_CLOUD_LOAD = 1;
    public static final int METHOD_INSERT = 2;
    public static String METHOD_AUTO_NAME = DbCartAddinArb.getString("METHOD_AUTO");
    public static String METHOD_CLOUD_LOAD_NAME = DbCartAddinArb.getString("METHOD_CLOUD_LOAD");
    public static String METHOD_INSERT_NAME = DbCartAddinArb.getString("METHOD_INSERT");
    private String[] pdbCloudMethods = new String[]{METHOD_AUTO_NAME, METHOD_CLOUD_LOAD_NAME, METHOD_INSERT_NAME};
    boolean m_initComponents = false;

    public DbCartDeployDataOptionPanel() {
        this(WIZARD);
    }

    public DbCartDeployDataOptionPanel(int n) {
        this.m_usage = n;
    }

    public JPanel getPanel() {
        return this.getPanel(null, false, null, null);
    }

    public JPanel getPanel(boolean bl, JPanel jPanel, Component component) {
        if (this.m_showFormatOptions && this.m_formatOptions == null) {
            this.m_formatOptions = new ExportFormatOptionsPanel(BaseDataFormat.CART, "LOADER".toLowerCase());
        }
        return this.getPanel(null, bl, jPanel, component);
    }

    public JPanel getPanel(ExtractDataFormat extractDataFormat, boolean bl, JPanel jPanel, Component component) {
        Object object;
        this._isPdb = bl;
        this._targetPanel = jPanel;
        this._cloudStorage = component;
        this.m_dataDeployPanel = new JPanel(new GridBagLayout());
        if (!this.m_initComponents) {
            this.m_labelDeployData.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("DEPLOY_DATA_OPTION")));
            this.m_chkbxTruncData.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("TRUNCATE_DATA")));
            this.m_chkbxTruncData.setMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("TRUNCATE_DATA")));
            this.m_chkbxTruncData.setToolTipText(DbCartAddinArb.getString("TRUNCATE_DATA_TIP"));
            this.m_chkbxDisableConstraints.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("DISABLE_CONSTRAINTS")));
            this.m_chkbxDisableConstraints.setMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("DISABLE_CONSTRAINTS")));
            this.m_chkbxDisableConstraints.setToolTipText(DbCartAddinArb.getString("DISABLE_CONSTRAINTS_TIP"));
            this.m_initComponents = true;
            this._loadMethodCmp = new JComboBox();
            this._methodLabel.setLabelFor(this._loadMethodCmp);
            this._loadMethodModel = new DefaultComboBoxModel<String>(this.pdbCloudMethods);
            this._loadMethodCmp.setModel(this._loadMethodModel);
            this._loadMethodCmp.setSelectedIndex(1);
            object = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        DbCartDeployDataOptionPanel.this.changeLoadMethod(DbCartDeployDataOptionPanel.this._loadMethodCmp.getSelectedIndex());
                    }
                }
            };
            this._loadMethodCmp.addItemListener((ItemListener)object);
        }
        this.m_chkbxDisableConstraints.setSelected(extractDataFormat != null ? extractDataFormat.isDisableConstraints() : true);
        this.m_chkbxTruncData.setSelected(extractDataFormat != null ? extractDataFormat.isTruncate() : false);
        object = new JPanel();
        ((Container)object).setLayout(new GridBagLayout());
        int n = 0;
        ((Container)object).add((Component)this.m_chkbxTruncData, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        if (this.m_showDisableConstraints) {
            ((Container)object).add((Component)this.m_chkbxDisableConstraints, new GridBagConstraints(0, ++n, 0, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        }
        if (bl) {
            ((Container)object).add((Component)this._methodLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 2, new Insets(16, 8, 0, 0), 0, 0));
            ((Container)object).add(this._loadMethodCmp, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 8, 0, 8), 0, 0));
            this._methodLabel.setVisible(false);
            this._loadMethodCmp.setVisible(false);
            if (component != null) {
                ((Container)object).add(component, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 18, 2, new Insets(16, 8, 0, 8), 0, 0));
            }
            if (jPanel != null) {
                ((Container)object).add((Component)jPanel, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 18, 2, new Insets(16, 8, 0, 8), 0, 0));
            }
        }
        if (this.m_showFormatOptions) {
            this._dataPanel = null;
            if (extractDataFormat == null) {
                this.m_formatOptions = new ExportFormatOptionsPanel(BaseDataFormat.CART, "LOADER".toLowerCase());
                this._dataPanel = this.m_formatOptions.getFormatPanel();
            } else {
                this.m_formatOptions = new ExportFormatOptionsPanel((BaseDataFormat)extractDataFormat);
                this._dataPanel = this.m_formatOptions.getFormatPanel(extractDataFormat);
            }
            this._dataPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this._dataPane = new TitledPane((Component)this._formatTitle, (Component)this._dataPanel);
            this.m_formatOptions.getFormatLabel().setVisible(!bl);
            this.m_formatOptions.getFormatComponent().setVisible(!bl);
            ((Container)object).add((Component)this._dataPane, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 18, 2, new Insets(16, 8, 0, 0), 0, 0));
        }
        JPanel jPanel2 = new JPanel();
        ((Container)object).add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)object, "Center");
        TitledPane titledPane = new TitledPane((Component)this.m_labelDeployData, (Component)jPanel3);
        this.m_dataDeployPanel.setLayout(new BorderLayout());
        this.m_dataDeployPanel.add((Component)titledPane, "Center");
        return this.m_dataDeployPanel;
    }

    public void changeLoadMethod(int n) {
        this._loadMethodType = n;
        this.enableFormatOptions(this.m_isDataPanelEnabled && this._loadMethodType != 2);
        this.enableDataTransfer(this.m_isDataPanelEnabled && this._loadMethodType != 2);
    }

    private void enableFormatOptions(boolean bl) {
        this._formatTitle.setEnabled(bl);
        if (this._dataPane != null) {
            UIUtils.enableComponent((Component)this._dataPane, (boolean)bl);
        }
    }

    private void enableDataTransfer(boolean bl) {
    }

    private void enableCloudStorage(boolean bl) {
        if (this._cloudStorage != null) {
            UIUtils.enableComponent((Component)this._cloudStorage, (boolean)bl);
        }
    }

    private void enableMethodOptions(boolean bl) {
        this._methodLabel.setEnabled(bl);
        this._loadMethodCmp.setEnabled(bl);
    }

    public int getLoadMethod() {
        if (this._loadMethodCmp != null) {
            return this._loadMethodCmp.getSelectedIndex();
        }
        return 0;
    }

    public boolean getChkbxTruncData() {
        return this.m_chkbxTruncData.isSelected();
    }

    public void setChkbxTruncData(boolean bl) {
        this.m_chkbxTruncData.setSelected(bl);
    }

    public boolean getChkbxDisableConstraints() {
        return this.m_chkbxDisableConstraints.isSelected();
    }

    public void setChkbxDisableConstraints(boolean bl) {
        this.m_chkbxDisableConstraints.setSelected(bl);
    }

    public void showDisableConstraints(boolean bl) {
        this.m_showDisableConstraints = bl;
    }

    public void showFormatOptions(boolean bl) {
        this.m_showFormatOptions = bl;
    }

    public ExtractDataFormat getFormatProperties() {
        return this.m_formatOptions.getFormatProperties();
    }

    public void enableOptions(boolean bl, boolean bl2, boolean bl3) {
        this.m_isDataPanelEnabled = bl;
        this.m_labelDeployData.setEnabled(bl);
        this.m_chkbxTruncData.setEnabled(bl);
        this.m_chkbxDisableConstraints.setEnabled(bl);
        this.enableMethodOptions(bl);
        this._loadMethodType = this._loadMethodCmp.getSelectedIndex();
        if (this._targetPanel != null) {
            this.enableDataTransfer(bl && this._loadMethodType != 2);
        }
        if (this._cloudStorage != null) {
            this.enableCloudStorage(bl2 && this._loadMethodType != 2);
        }
        this.enableFormatOptions(bl && this._loadMethodType != 2);
        this.enableDataTransfer(bl && this._loadMethodType != 2);
        this._formatTitle.setEnabled(bl && this._loadMethodType != 2);
        if (this.m_formatOptions != null) {
            this.enableFormatOptions(bl3 && this._loadMethodType != 2);
            this.m_formatOptions.getFormatComponent().setEnabled(false);
        }
    }
}

