/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployJson;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportGenDbmsCloud;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.extract.DbmsCloudResources;
import oracle.dbtools.raptor.extract.DeployPdbAPI;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerRunner;
import oracle.dbtools.raptor.oviewer.base.ProcessMonitor;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.ZipOutputHandler;
import oracle.ide.util.IdeUtil;

public class DbCartDeployPdbCloud
extends ExportAPI {
    public static final int METHOD_AUTO = 0;
    public static final int METHOD_CLOUD_LOAD = 1;
    public static final int METHOD_INSERT = 2;
    public static final int INSERT_LIMIT = 10000;
    private int _loadMethodDeploy;
    private String _cloudLocation;
    private String _credential;
    private Connection _destConn;
    private String _destConnName;
    private String _destSchema;
    private ImportDataFormat _dboImportDataFormat;
    private ZipOutputHandler _zipper;
    private String _cartName;
    private String _controlFileName;
    private String _dataFileName;
    private String _zipFilePath;
    private CSVFormatter _pdbFormatter;
    private DeployPdbAPI _deployPdbAPI;
    public static final String countRows1 = "select count(*) from ";
    public static final String countRows2 = " where rownum < INSERT_LIMIT";

    protected boolean isDeployPdbCloud() {
        return true;
    }

    public void setLoadMethod(int n) {
        this._loadMethodDeploy = n;
    }

    public void setCloudLocation(String string) {
        this._cloudLocation = string;
    }

    public void setCredential(String string) {
        this._credential = string;
    }

    public void setDestConn(String string) {
        this._destConnName = string;
        try {
            this._destConn = Connections.getInstance().getConnection(string);
        }
        catch (Exception exception) {
            Logger.warn(ExportAPI.class, (Throwable)exception);
            this.eLogException(exception);
        }
    }

    public void setDestSchemaName(String string) {
        this._destSchema = string;
    }

    public void setZipFilePath(String string) {
        this._zipFilePath = string;
    }

    public void setCartName(String string) {
        this._cartName = string;
    }

    protected String getELoggerName() {
        return DbCartAddinArb.getString("DEPLOY_CLOUD_TOOL");
    }

    protected ExitCode start() {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        this._deployPdbAPI = new DeployPdbAPI(this._destConnName, this.getELogger());
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this._destConnName, null, (String)this._destSchema, (String)"sd_deploy");
        URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)this._cartName);
        AsynchronousViewerRunner asynchronousViewerRunner = new AsynchronousViewerRunner(uRL2, true);
        this._deployPdbAPI.setMonitor((ProcessMonitor)asynchronousViewerRunner);
        exitCode = this._deployPdbAPI.startDeploy(this._cartName, this._zipFilePath, this._destSchema, this._cloudLocation, this._credential);
        if (exitCode != ExitCode.EXIT_SEVERE) {
            if (!this._deployPdbAPI.insertDeployOperationMeta(1, new File(this._zipFilePath).getName(), "BUILD")) {
                MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                messageDetailsDialog.showErrorDialog(DbmsCloudResources.getString((String)"DBMS_CLOUD_INSTALL_ERROR") + "\n" + exitCode.getShortMessage() + "\n" + exitCode.getMessage(), this._deployPdbAPI.getLogAsText());
                return this._deployPdbAPI.getExitCode();
            }
        } else {
            MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
            messageDetailsDialog.showErrorDialog(DbmsCloudResources.getString((String)"DBMS_CLOUD_INSTALL_ERROR") + "\n" + exitCode.getShortMessage() + "\n" + exitCode.getMessage(), this._deployPdbAPI.getLogAsText());
        }
        return exitCode;
    }

    public String getTaskConnectionName() {
        return this._destConnName + this._cartName.toString();
    }

    protected void finish() {
        if (!this.isCancel()) {
            this._deployPdbAPI.setProgressUpdater(this.getProgressUpdater());
            try {
                this.getELogger().finished();
                this._deployPdbAPI.updateDeployOperationMeta(1, "BUILD", DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this._deployPdbAPI.getDeployExitCode())), this.getELogger().getLogName(), null, null);
            }
            catch (Exception exception) {
                Logger.warn(ExportAPI.class, (Throwable)exception);
                this.eLogException(exception);
            }
            this._deployPdbAPI.executeDeploy();
            this._deployPdbAPI.finish();
        }
    }

    protected void taskCancelledProcess() {
        if (this._deployPdbAPI != null) {
            this._deployPdbAPI.cancelled();
        }
    }

    protected void taskFailedProcess() {
        if (this._deployPdbAPI != null) {
            this._deployPdbAPI.failed();
        }
    }

    protected String getDDL(ExtractObject extractObject, int n) {
        if (n == 2 && extractObject.isTypeDataFile()) {
            if (extractObject.isTypeDataFileExternalTable()) {
                return "";
            }
            ImportProperties importProperties = extractObject.getImportProperties();
            importProperties.put(ImportKeys.IS_SOURCE_DBO, (Object)false);
            importProperties.put(ImportKeys.IS_EXISTING_TABLE, (Object)true);
            ImportGenDbmsCloud importGenDbmsCloud = new ImportGenDbmsCloud(importProperties);
            importGenDbmsCloud.start();
            return importGenDbmsCloud.getCreateTableStatementWithComments(extractObject.getTableName()).trim();
        }
        return super.getDDL(extractObject, n);
    }

    protected void exportDataList(int n) {
        this._zipper = this.getGenOutputStream().getZipper();
        this._dboImportDataFormat = new ImportDataFormat(BaseDataFormat.CART, BaseDataFormat.CSV);
        this._dboImportDataFormat.setDelimiter(this.getDataFormat().getDelimiter());
        this._dboImportDataFormat.setEnclosureLeft(this.getDataFormat().getEnclosureLeft());
        this._dboImportDataFormat.setEnclosureRight(this.getDataFormat().getEnclosureRight());
        this._dboImportDataFormat.setRecordTerminator(this.getDataFormat().getRecordTerminator());
        this._dboImportDataFormat.setEncoding(IdeUtil.getIdeEncoding());
        List list = this.getListModel().getList(n);
        for (ExtractObject extractObject : list) {
            try {
                String string = ExtractResources.getString((String)"OPERATION_BUILD") + " " + ExtractListModel.getListTypeName((int)n) + " " + extractObject.getTableName();
                this.taskProgress(string);
                if (this.isCancel()) break;
                DBObject dBObject = extractObject.getDBObject();
                String string2 = extractObject.getExternalTableName();
                String string3 = extractObject.isTypeDataFile() ? "TABLE" : dBObject.getObjectType();
                ExtractScript extractScript = extractObject.getScript(112);
                this.getTargetFormat().setDataFormatExtension("csv");
                if (extractScript == null) {
                    this.getGenOutputStream().startObject(string2, "DATA_" + string3);
                } else {
                    this.getGenOutputStream().startObject(string2, "DATA_" + string3, extractScript.getType(), extractScript.getPath());
                }
                this._dataFileName = this.getGenOutputStream().getCurrentFileName();
                this._controlFileName = this.getControlFileName();
                this._pdbFormatter = new CSVFormatter(){
                    boolean rowWritten = false;

                    public void start() throws IOException {
                        super.start();
                        this.rowWritten = false;
                    }

                    public void endRow() throws IOException {
                        super.endRow();
                        this.rowWritten = true;
                    }

                    public void end() throws IOException {
                        super.end();
                        if (!this.rowWritten) {
                            return;
                        }
                        this._zipper.closeEntry();
                    }
                };
                if (extractObject.isTypeDBO() && !extractObject.isEmptySelect()) {
                    this.doDataFile(extractObject);
                }
                this._zipper.openEntry(this._controlFileName);
                this.write(this.getControl(extractObject));
                this._zipper.closeEntry();
                this.exportScript(extractObject, 113);
            }
            catch (Exception exception) {
                Logger.warn(ExportAPI.class, (Throwable)exception);
                this.eLogException(exception);
            }
        }
        if (list.size() > 0 && this._pdbFormatter != null) {
            this._pdbFormatter.finishExport();
        }
    }

    public void doDataFile(ExtractObject extractObject) throws Exception {
        Object var2_2 = null;
        this.taskProgress();
        try {
            this.taskProgress();
            DBObject dBObject = extractObject.getDBObject();
            String string = extractObject.getExternalTableName();
            String string2 = extractObject.isTypeDataFile() ? "TABLE" : dBObject.getObjectType();
            this.initDataExport(extractObject, (ResultsFormatter)this._pdbFormatter);
            if (!extractObject.isEmptySelect()) {
                this.writeDataUsingFormatter(extractObject);
                this._zipper.closeEntry();
            }
            this._pdbFormatter.finishExport();
        }
        catch (IOException iOException) {
            Logger.warn(ExportAPI.class, (Throwable)iOException);
            this.eLogException(iOException);
        }
    }

    protected String getControl(ExtractObject extractObject) {
        block23: {
            ImportProperties importProperties = null;
            ImportGenDbmsCloud importGenDbmsCloud = null;
            String string = null;
            try {
                String string2;
                Object object;
                DBObject dBObject = extractObject.getDBObject();
                string = extractObject.getFinalWhere();
                if (this._loadMethodDeploy == 2 || this._loadMethodDeploy == 0 && this.getRelativeSize(dBObject, string) < 10000) break block23;
                this.setProg(DbCartAddinArb.getString("EXTRACT_PROGRESS") + " " + extractObject.getExternalTableName());
                Boolean bl = false;
                Boolean bl2 = false;
                Boolean bl3 = false;
                if (extractObject.isTypeDBO()) {
                    importProperties = new ImportProperties();
                    importProperties.put(ImportKeys.IS_SOURCE_DBO, (Object)true);
                    importProperties.put(ImportKeys.TABLE_NAME, (Object)dBObject.getObjectName());
                    bl3 = true;
                } else {
                    importProperties = extractObject.getImportProperties();
                    importProperties.put(ImportKeys.IS_SOURCE_DBO, (Object)false);
                    importProperties.put(ImportKeys.TABLE_NAME, (Object)extractObject.getExternalTableName());
                    bl = importProperties.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
                    bl2 = bl == false;
                }
                importGenDbmsCloud = new ImportGenDbmsCloud(importProperties);
                importProperties.put(ImportKeys.CONNECTION_NAME, (Object)this._destConnName);
                importProperties.put(ImportKeys.OBJECT_SCHEMA, (Object)this._destSchema);
                importProperties.put(ImportKeys.IS_EXISTING_TABLE, (Object)true);
                GenericTable genericTable = null;
                if (bl3.booleanValue()) {
                    genericTable = new GenericTable(Connections.getInstance().getConnection(dBObject.getConnectionName()), dBObject.getSchemaName(), dBObject.getObjectName());
                } else {
                    genericTable = new GenericTable();
                    genericTable.setTableName((String)importProperties.get(ImportKeys.TABLE_NAME));
                }
                URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this._destConnName, null, (String)this._destSchema, (String)"TABLE");
                URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)extractObject.getExternalTableName());
                DBObject dBObject2 = new DBObject(uRL2);
                importProperties.put(ImportKeys.DBOBJECT, (Object)dBObject2);
                importProperties.put(ImportKeys.IS_SOURCE_OSS, (Object)true);
                if (extractObject.isTypeDBO()) {
                    importProperties.put(ImportKeys.IMPORT_DATA_FORMAT, (Object)this._dboImportDataFormat);
                    importProperties.put(ImportKeys.MISSING_FIELDS, (Object)0);
                }
                importProperties.put(ImportKeys.USE_VALIDATE, (Object)false);
                importProperties.put(ImportKeys.USE_VALIDATE_LIMIT, (Object)false);
                importProperties.put(ImportKeys.VALIDATE_LIMIT, (Object)0);
                importProperties.put(ImportKeys.DROP_STAGING_TABLE, (Object)false);
                Boolean bl4 = importProperties.getValueBoolean(ImportKeys.IS_COPY_LOG);
                Boolean bl5 = importProperties.getValueBoolean(ImportKeys.IS_COPY_BAD);
                Boolean bl6 = importProperties.getValueBoolean(ImportKeys.IS_DROP_BAD_AND_LOG);
                importProperties.put(ImportKeys.IS_COPY_LOG, (Object)false);
                importProperties.put(ImportKeys.IS_COPY_BAD, (Object)false);
                importProperties.put(ImportKeys.IS_DROP_BAD_AND_LOG, (Object)false);
                importGenDbmsCloud.start();
                DbCartDeployJson dbCartDeployJson = new DbCartDeployJson();
                dbCartDeployJson.start();
                dbCartDeployJson.addString("isSourceDBO", bl3.toString());
                dbCartDeployJson.addString("isSourceCloudFile", bl.toString());
                dbCartDeployJson.addString("isSourceLocalFile", bl2.toString());
                if (bl3.booleanValue()) {
                    dbCartDeployJson.addString("dataFileName", bl3 != false ? this._dataFileName : ((LoadFile)importProperties.get(ImportKeys.LOAD_FILE)).getName());
                    dbCartDeployJson.addString("dataFileCredential", this._credential);
                } else if (bl2.booleanValue()) {
                    object = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
                    dbCartDeployJson.addString("dataFileName", object.getShortName());
                    String string3 = object.getName();
                    string3 = string3.replace("\\", "\\\\");
                    dbCartDeployJson.addString("dataFilePath", string3);
                    dbCartDeployJson.addString("dataFileCredential", this._credential);
                } else {
                    dbCartDeployJson.addString("dataFilePath", (String)importProperties.get(ImportKeys.OSS_PATH));
                    dbCartDeployJson.addString("dataFileCredential", (String)importProperties.get(ImportKeys.OSS_CREDENTIAL));
                }
                if (this._cloudLocation != null) {
                    dbCartDeployJson.addString("targetStorageLocation", this._cloudLocation);
                }
                if (this._credential != null) {
                    dbCartDeployJson.addString("targetCredential", this._credential);
                }
                dbCartDeployJson.addString("targetConnection", Connections.getDisplayName((String)this._destConnName));
                dbCartDeployJson.addString("targetSchema", this._destSchema);
                object = bl3 != false || bl2 != false;
                dbCartDeployJson.addString("actionUploadPutData", ((Boolean)object).toString());
                int n = importProperties.getValueInteger(ImportKeys.LOAD_METHOD);
                if (n == -1) {
                    n = 5;
                }
                if (n == 5) {
                    dbCartDeployJson.addString("actionCopyData", Boolean.TRUE.toString());
                } else if (n == 2) {
                    dbCartDeployJson.addString("actionExternalTable", Boolean.TRUE.toString());
                    dbCartDeployJson.addString("actionValidateData", Boolean.TRUE.toString());
                    string2 = importGenDbmsCloud.getColumnsAsString();
                    dbCartDeployJson.addString("TargetColumns", string2);
                    dbCartDeployJson.addString("isValidateLimit", importProperties.getValueBoolean(ImportKeys.USE_VALIDATE_LIMIT).toString());
                    dbCartDeployJson.addString("validateLimit", importProperties.getValueInteger(ImportKeys.VALIDATE_LIMIT).toString());
                } else if (n == 0) {
                    dbCartDeployJson.addString("actionInsert", Boolean.TRUE.toString());
                }
                dbCartDeployJson.addString("dataFields", importGenDbmsCloud.getFields(" ", false, true));
                dbCartDeployJson.addString("dataCloudFormat", importGenDbmsCloud.getFormat());
                dbCartDeployJson.addString("targetTable", (String)importProperties.get(ImportKeys.TABLE_NAME));
                dbCartDeployJson.addString("actionDropData", ((Boolean)object).toString());
                dbCartDeployJson.addString("actionCopyLog", bl4.toString());
                dbCartDeployJson.addString("actionCopyBad", bl5.toString());
                dbCartDeployJson.addString("actionDropBadAndLog", bl6.toString());
                dbCartDeployJson.addString("dataFileFormat", ((ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT)).getFormat());
                string2 = "";
                String string4 = "";
                if (bl3.booleanValue()) {
                    for (Column column : genericTable.getColumns()) {
                        string2 = string2 + string4 + column.getName();
                        string4 = ",";
                    }
                } else {
                    LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
                    for (LoadField loadField : loadFile.getFields()) {
                        string2 = string2 + string4 + loadField.getName();
                        string4 = ",";
                    }
                }
                dbCartDeployJson.addObject("displayFileFormat", this.getDataFormatForBad((ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT), string2));
                return dbCartDeployJson.end();
            }
            catch (Exception exception) {
                Logger.warn(ExportAPI.class, (Throwable)exception);
                this.eLogException(exception);
            }
        }
        return "";
    }

    private String getDataFormatForBad(ImportDataFormat importDataFormat, String string) {
        DbCartDeployJson dbCartDeployJson = new DbCartDeployJson();
        dbCartDeployJson.start();
        dbCartDeployJson.addString("fmtFields", string);
        dbCartDeployJson.addString("dataFileFormat", importDataFormat.getFormat());
        dbCartDeployJson.addString("fmtDelimiter", importDataFormat.getDelimiter());
        dbCartDeployJson.addString("fmtEnclosureLeft", importDataFormat.getEnclosureLeft().replace("\"", "\\\""));
        dbCartDeployJson.addString("fmtEnclosureRight", importDataFormat.getEnclosureRight().replace("\"", "\\\""));
        dbCartDeployJson.addString("fmtEncoding", importDataFormat.getEncoding());
        dbCartDeployJson.addString("fmtTerminator", importDataFormat.getRecordTerminator());
        return dbCartDeployJson.end();
    }

    private String getControlFileName() {
        String string = this.getGenOutputStream().getCurrentFileName();
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        String string2 = n != -1 ? string.substring(0, n) : string;
        return string2 + ".ctl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRelativeSize(DBObject dBObject, String string) {
        String string2 = "0";
        String string3 = dBObject.getSchemaName();
        if (string3 == null) {
            string3 = "";
        } else if (!string3.isEmpty()) {
            string3 = string3 + DBUtil.addDoubleQuote((String)string3) + ".";
        }
        String string4 = countRows1 + string3 + DBUtil.addDoubleQuote((String)dBObject.getObjectName()) + " " + string;
        Connection connection = dBObject.getConnection();
        try {
            if (Connections.getInstance().lock(connection)) {
                string2 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string4, Collections.EMPTY_MAP);
            }
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
        return string2 != null ? Integer.valueOf(string2) : 0;
    }
}

