/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.readers.DataReaderUtils;
import oracle.dbtools.raptor.data.writers.ImportGenDbmsCloud;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.DbCartCopy;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.dialogs.databasecopy.DatabaseCopyArb;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class DbCartDeployPdbCloudResearch
extends DbCartCopy {
    public static final int METHOD_AUTO = 0;
    public static final int METHOD_CLOUD_LOAD = 1;
    public static final int METHOD_INSERT = 2;
    public static final int INSERT_LIMIT = 10000;
    private int _loadMethod;
    private String _cloudLocation;
    private String _credential;
    private ExtractDataFormat _dataFormat;
    private TargetFormat _targetFormat;
    public static final String countRows1 = "select count(*) from ";
    public static final String countRows2 = " where rownum < INSERT_LIMIT";

    public void setLoadMethod(int n) {
        this._loadMethod = n;
    }

    public void setCloudLocation(String string) {
        this._cloudLocation = string;
    }

    public void setCredential(String string) {
        this._credential = string;
    }

    public void setDataFormat(ExtractDataFormat extractDataFormat) {
        this._dataFormat = extractDataFormat;
    }

    protected String getELoggerName() {
        return DbCartAddinArb.getString("DEPLOY_CLOUD_TOOL");
    }

    public void databaseCopyData() {
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(7, 104, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(5, 104, this.getDestinationConn());
        }
        this.getExtractListAndCopyData(8, this.getSourceConn(), this.getDestinationConn(), 0);
        this.getExtractListAndExecuteDDL(3, 0, this.getDestinationConn());
        if (this.isTruncateData()) {
            this.getExtractListAndExecuteDDL(6, 104, this.getDestinationConn());
        }
    }

    protected void getExtractListAndCopyData(int n, Connection connection, Connection connection2, int n2) {
        if (n != 8) {
            super.getExtractListAndCopyData(n, connection, connection2, n2);
            return;
        }
        ImportProperties importProperties = null;
        ImportGenDbmsCloud importGenDbmsCloud = null;
        ImportWriteStream importWriteStream = null;
        Object var8_8 = null;
        String string = null;
        boolean bl = false;
        List list = null;
        long l = 0L;
        list = this.m_listModel.getList(n, new int[]{103});
        boolean bl2 = false;
        String string2 = null;
        DataMover dataMover = null;
        try {
            for (ExtractObject extractObject : list) {
                Object object;
                ImportDataFormat importDataFormat;
                this.checkCancelled();
                DBObject dBObject = extractObject.getDBObject();
                string2 = extractObject.getFinalWhere();
                if (this._loadMethod == 2 || this._loadMethod == 0 && this.getRelativeSize(dBObject, string2) < 10000) {
                    dataMover = new DataMover(extractObject.getSourceConn(), connection2, this.m_ignoreAllErrors);
                    dataMover.setLogFile(this.m_out);
                    if (dBObject.getObjectType().equalsIgnoreCase("VIEW")) continue;
                    this.setProg(DatabaseCopyArb.getString((String)"MOVING_DATA") + " " + dBObject.getObjectName());
                    if (!bl2) {
                        this.lineStart();
                        bl2 = true;
                    }
                    this.log(CopyPanelArb.getString((String)"MOVING_DATA_MESSAGE") + dBObject.getObjectName());
                    String string3 = null;
                    boolean bl3 = true;
                    if (bl3 && !dataMover.move(dBObject, extractObject.getColumns(), string3, string2, string, n2, true)) {
                        this.cancel();
                        this.checkCancelled();
                        break;
                    }
                    this.lineEnd();
                    continue;
                }
                this.log(" ");
                this.log("*************************************************************");
                this.log("We should do cloud load for me! " + dBObject.getObjectName());
                this.setProg(DbCartAddinArb.getString("EXTRACT_PROGRESS") + " " + dBObject.getObjectName());
                long l2 = System.currentTimeMillis();
                importProperties = extractObject.isTypeDBO() ? new ImportProperties() : extractObject.getImportProperties();
                importGenDbmsCloud = new ImportGenDbmsCloud(importProperties);
                this.flushLog();
                if (importWriteStream == null) {
                    importWriteStream = new ImportWriteStream(this.getELoggerName(), this._targetFormat.getEncoding());
                }
                importProperties.put(ImportKeys.IMPORT_WRITE_STREAM, importWriteStream);
                importGenDbmsCloud.putWriteStream(importWriteStream);
                boolean bl4 = importProperties.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
                File file = null;
                String string4 = null;
                String string5 = "csv";
                long l3 = 0L;
                if (extractObject.isTypeDBO()) {
                    extractObject.setListModel(this.m_listModel);
                    extractObject.isExtractMetaData(false);
                    this._dataFormat.setFormat(BaseDataFormat.CSV);
                    this.m_listModel.setDataFormat(this._dataFormat);
                    String string6 = DataReaderUtils.getTempName((String)dBObject.getObjectName()) + "." + string5;
                    importDataFormat = new TargetFormat();
                    importDataFormat.setSaveAsType(0);
                    importDataFormat.setSaveAs(string6);
                    string4 = this._cloudLocation.endsWith("/") ? this._cloudLocation + string6 : this._cloudLocation + "/" + string6;
                    object = new ExportAPI();
                    object.setTargetFormat((TargetFormat)importDataFormat);
                    object.setExtractListModel(this.m_listModel);
                    if (importDataFormat.getSaveAsType() == 4) {
                        // empty if block
                    }
                    file = new File(string6);
                    try {
                        l = file.length();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    l3 = System.currentTimeMillis();
                } else if (!bl4) {
                    LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
                    file = new File(loadFile.getName());
                    importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
                    string5 = importDataFormat.getFormat();
                    object = DataReaderUtils.getTempName((String)loadFile.getShortName()) + "." + string5;
                    string4 = this._cloudLocation.endsWith("/") ? this._cloudLocation + (String)object : this._cloudLocation + "/" + (String)object;
                } else {
                    string4 = extractObject.getUrl().toString();
                }
                long l4 = 0L;
                if (extractObject.isTypeDBO() || !bl4) {
                    this.setProg(DbCartAddinArb.getString("PUT_PROGRESS") + " " + dBObject.getObjectName());
                    this.checkCancelled();
                    object = new FileInputStream(file);
                    l4 = System.currentTimeMillis();
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getMessage());
                    }
                    if (extractObject.isTypeDBO()) {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getMessage());
                            try {
                                file.deleteOnExit();
                            }
                            catch (Exception exception2) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getMessage());
                            }
                        }
                    }
                }
                this.checkCancelled();
                object = Connections.getInstance().getConnectionName(connection2);
                importProperties.put(ImportKeys.CONNECTION_NAME, object);
                importProperties.put(ImportKeys.TABLE_NAME, (Object)dBObject.getObjectName());
                String string7 = this.getDestinationSchemaName();
                importProperties.put(ImportKeys.OBJECT_SCHEMA, (Object)string7);
                importProperties.put(ImportKeys.IS_EXISTING_TABLE, (Object)true);
                GenericTable genericTable = new GenericTable();
                genericTable.setTableName(dBObject.getObjectName());
                URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)object, null, (String)string7, (String)"TABLE");
                URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)dBObject.getObjectName());
                DBObject dBObject2 = new DBObject(uRL2);
                importProperties.put(ImportKeys.DBOBJECT, (Object)dBObject2);
                importProperties.put(ImportKeys.IS_SOURCE_OSS, (Object)true);
                importProperties.put(ImportKeys.OSS_CREDENTIAL, (Object)this._credential);
                importProperties.put(ImportKeys.OSS_PATH, (Object)string4);
                ImportDataFormat importDataFormat2 = null;
                if (extractObject.isTypeDBO()) {
                    importDataFormat2 = new ImportDataFormat(BaseDataFormat.CART, string5);
                    importDataFormat2.setDelimiter(this._dataFormat.getDelimiter());
                    importDataFormat2.setRecordTerminator(this._dataFormat.getRecordTerminator());
                    importDataFormat2.setEnclosureLeft(this._dataFormat.getEnclosureLeft());
                    importDataFormat2.setEnclosureLeft(this._dataFormat.getEnclosureRight());
                    importProperties.put(ImportKeys.IMPORT_DATA_FORMAT, (Object)importDataFormat2);
                    importProperties.put(ImportKeys.MISSING_FIELDS, (Object)0);
                }
                importProperties.put(ImportKeys.LOAD_METHOD, (Object)5);
                importProperties.put(ImportKeys.USE_VALIDATE, (Object)false);
                importProperties.put(ImportKeys.USE_VALIDATE_LIMIT, (Object)false);
                importProperties.put(ImportKeys.VALIDATE_LIMIT, (Object)0);
                importProperties.put(ImportKeys.DROP_STAGING_TABLE, (Object)false);
                importProperties.put(ImportKeys.IS_COPY_LOG, (Object)false);
                importProperties.put(ImportKeys.IS_COPY_BAD, (Object)false);
                importProperties.put(ImportKeys.IS_DROP_BAD_AND_LOG, (Object)false);
                importGenDbmsCloud.start();
                long l5 = System.currentTimeMillis();
                long l6 = 0L;
                if (extractObject.isTypeDBO() || !bl4) {
                    this.setProg(DbCartAddinArb.getString("DELETE_PROGRESS") + " " + dBObject.getObjectName());
                    l6 = System.currentTimeMillis();
                }
                long l7 = System.currentTimeMillis();
                if (l3 != 0L) {
                    this.log(DbCartAddinArb.format("EXTRACT_SIZE", l) + this.getTerm());
                    this.log(DbCartAddinArb.format("EXTRACT_TIME", l3 - l2) + this.getTerm());
                }
                if (l4 != 0L) {
                    this.log(DbCartAddinArb.format("PUT_TIME", l4 - l3) + this.getTerm());
                }
                this.log(DbCartAddinArb.format("COPY_TIME", l5 - l4) + this.getTerm());
                if (l6 != 0L) {
                    this.log(DbCartAddinArb.format("DELETE_TIME", l6 - l5) + this.getTerm());
                }
                this.log(DbCartAddinArb.format("LOAD_TIME", l7 - l2) + this.getTerm());
                this.flushLog();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRelativeSize(DBObject dBObject, String string) {
        String string2 = "0";
        String string3 = dBObject.getSchemaName();
        if (string3 == null) {
            string3 = "";
        } else if (!string3.isEmpty()) {
            string3 = string3 + DBUtil.addDoubleQuote((String)string3) + ".";
        }
        String string4 = countRows1 + string3 + DBUtil.addDoubleQuote((String)dBObject.getObjectName()) + " " + string;
        Connection connection = dBObject.getConnection();
        try {
            if (Connections.getInstance().lock(connection)) {
                string2 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string4, Collections.EMPTY_MAP);
            }
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
        return string2 != null ? Integer.valueOf(string2) : 0;
    }
}

