/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.dbcart.DBCartReorderableTableModel;
import oracle.dbtools.dbcart.DbCartAddin;
import oracle.dbtools.dbcart.DbCartListReorderableTableWithTitleBar;
import oracle.dbtools.dbcart.DbCartPanel;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractReconciler;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;

public class DbCartUtil {
    private static String _dbName;
    private static final Logger LOGGER;

    public static OracleConnection getConnection(String string) throws DBException {
        OracleConnection oracleConnection = string.startsWith("IdeConnections%23") ? (OracleConnection)Connections.getInstance().getConnection(string) : (OracleConnection)Connections.getInstance().getConnection("IdeConnections%23" + string);
        if (oracleConnection == null) {
            _dbName = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), (String)_dbName, (boolean)false);
            oracleConnection = (OracleConnection)Connections.getInstance().getConnection(_dbName);
        }
        return oracleConnection;
    }

    public static DbCartPanel getPanel() {
        return (DbCartPanel)DbCartAddin.getDbCartWindow().getGUI();
    }

    public static DBCartReorderableTableModel getTableModel() {
        return DbCartUtil.getPanel().getTableModel();
    }

    public static DBCartReorderableTableModel getTableModel(String string) {
        return DbCartUtil.getPanel().getTableModel(string);
    }

    public static ExtractReconciler getReconciler() {
        return DbCartUtil.getTableModel().getExtractListModel().getReconciler();
    }

    public static DbCartListReorderableTableWithTitleBar<?> getTabPage() {
        return DbCartUtil.getPanel().getSelectedTabPage();
    }

    public static String getTabPageName() {
        return DbCartUtil.getPanel().getSelectedTabPageName();
    }

    public static void setTabPageName(String string) {
        DbCartUtil.getPanel().setSelectedTabPageName(string);
    }

    public static List<ExtractObject> validateUniqueObjects(List<ExtractObject> list, boolean bl) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : list) {
            for (ExtractObject extractObject2 : list) {
                if (extractObject == extractObject2 || arrayList.contains(extractObject2) || !extractObject.getDBObject().getObjectName().equals(extractObject2.getDBObject().getObjectName()) || !extractObject.getDBObject().getObjectType().equals(extractObject2.getDBObject().getObjectType())) continue;
                if (bl) {
                    if (!extractObject.getDBObject().getSchemaName().equals(extractObject2.getDBObject().getSchemaName())) continue;
                    arrayList.add(extractObject);
                    arrayList.add(extractObject2);
                    continue;
                }
                arrayList.add(extractObject);
                arrayList.add(extractObject2);
            }
        }
        return arrayList;
    }

    public static boolean isSingleSchema(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (DbCartUtil.getTableModel(string) == null) {
            return true;
        }
        return DbCartUtil.isSingleSchema(DbCartUtil.getTableModel(string).getIncludedDBORows());
    }

    public static boolean isSingleSchema(List<ExtractObject> list) {
        String string = "";
        for (ExtractObject extractObject : list) {
            if (extractObject.getDBObject().getSchemaName().equals(string)) continue;
            if (string.length() == 0) {
                string = extractObject.getDBObject().getSchemaName();
                continue;
            }
            return false;
        }
        return true;
    }

    public static Version getHighestVersion(List<ExtractObject> list) {
        Connection exception;
        Connection connection2 = null;
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (ExtractObject object : list) {
            try {
                exception = Connections.getInstance().getConnection(object.getSourceConnName());
                if (arrayList.contains(exception)) continue;
                arrayList.add(exception);
            }
            catch (Exception exception2) {
                LOGGER.warning(exception2.getMessage());
            }
        }
        for (Connection connection : arrayList) {
            try {
                exception = RaptorVersionTracker.getDbVersion((Connection)connection);
                if (connection2 != null && connection2.compareTo((Version)exception) >= 0) continue;
                connection2 = exception;
            }
            catch (Exception exception3) {
                LOGGER.warning(exception3.getMessage());
            }
        }
        return connection2;
    }

    public static boolean isCartFileType(URL uRL) {
        String string = URLFileSystem.getSuffix((URL)uRL);
        return string.equals(".csv") || string.equals(".dsv") || string.equals(".tsv") || string.equals(".txt");
    }

    static {
        LOGGER = Logger.getLogger(DbCartUtil.class.getName());
    }
}

