/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.headless;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.config.DbCartUserCopyConfig;
import oracle.dbtools.dbcart.headless.DbCartCommand;
import oracle.dbtools.dbcart.headless.DbCartHeadlessResources;
import oracle.dbtools.raptor.databasecopy.DbCartCopy;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class DbCartCopyCommand
extends DbCartCommand {
    private boolean _doReplaceDest;
    private boolean _truncData;
    private String _targetConnName;
    private char[] _connPwd;

    public DbCartCopyCommand(HeadlessCore headlessCore) {
        super(DbCartCommand.Type.COPY, headlessCore);
    }

    @Override
    public String getHelpKey() {
        return "HELP_STRING_CART_COPY";
    }

    @Override
    public void getConfig() throws InvalidCommandArgumentException {
        try {
            URL uRL = new File(this.getConfigXML()).toURI().toURL();
            this._config = new DbCartUserCopyConfig(DbCartUserCopyConfig.importFrom(uRL));
            this.validateConfig(uRL, "copy_tool");
            Boolean bl = this._config.getBoolean("DDL_DROP");
            this._doReplaceDest = bl != null ? bl : false;
            bl = this._config.getBoolean("DATA_TRUNCATE");
            this._truncData = bl != null ? bl : false;
            this._targetConnName = this._config.getString("CONN_NAME");
            if (this._targetConnName == null || this._targetConnName.length() == 0) {
                throw new InvalidCommandArgumentException(DbCartAddinArb.getString("XML_CONN_ERROR_MESSAGE4"));
            }
            if (Connections.getInstance().getConnection(this._targetConnName) == null) {
                throw new InvalidCommandArgumentException(DbCartAddinArb.format("XML_CONN_ERROR_MESSAGE3", this._targetConnName));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            throw new InvalidCommandArgumentException(DbCartAddinArb.format("UNABLE_TO_OPEN_FILE", this.getConfigXML()));
        }
        catch (DBException dBException) {
            throw new InvalidCommandArgumentException(DbCartAddinArb.getString("XML_CONN_ERROR_MESSAGE4"));
        }
    }

    @Override
    public void validate() throws InvalidCommandArgumentException {
        this.validateCart();
        if (this.isAnyDataFileRows()) {
            throw new InvalidCommandArgumentException(DbCartHeadlessResources.getString("NO_DATA_FILES"));
        }
    }

    @Override
    public void doCommand() {
        DbCartCopy dbCartCopy = new DbCartCopy();
        dbCartCopy.isCopyDDL(this.isAnyDDLRows());
        dbCartCopy.isCopyData(this.isAnyDataRows());
        dbCartCopy.isNotReplaceDest(!this._doReplaceDest);
        dbCartCopy.isReplaceDest(this._doReplaceDest);
        dbCartCopy.isTruncateData(this._truncData);
        dbCartCopy.setTargetConnection(this._targetConnName);
        dbCartCopy.setExtractObjectList(this._extractObjects);
        dbCartCopy.isUseLogger(this.getLogFile() != null && this.getLogFile().length() > 0);
        dbCartCopy.setDbCartCopyHeadless();
    }
}

