/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.headless;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.dbcart.headless.DbCartCommand;
import oracle.dbtools.dbcart.headless.DbCartCopyCommand;
import oracle.dbtools.dbcart.headless.DbCartDeployCloudCommand;
import oracle.dbtools.dbcart.headless.DbCartExportCommand;
import oracle.dbtools.dbcart.headless.DbCartHeadlessResources;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;

public class DbCartProcessor
implements HeadlessCommandProcessor {
    private DbCartCommand _cmd;

    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headlessCore, String ... stringArray) throws InvalidCommandArgumentException {
        if (stringArray.length == 0) {
            headlessCore.printMessage(new String[]{DbCartHeadlessResources.getString("USAGE_STRING")});
        } else {
            if ("EXPORT".equalsIgnoreCase(stringArray[0])) {
                this._cmd = new DbCartExportCommand(headlessCore);
            } else if ("CLOUD".equalsIgnoreCase(stringArray[0])) {
                this._cmd = new DbCartDeployCloudCommand(headlessCore);
            } else if ("COPY".equalsIgnoreCase(stringArray[0])) {
                this._cmd = new DbCartCopyCommand(headlessCore);
            } else {
                headlessCore.printErrorMessage(new String[]{DbCartHeadlessResources.format("INVALID_COMMAND", stringArray[0]), DbCartHeadlessResources.getString("USAGE_STRING")});
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_COMMAND", stringArray[0]));
            }
            this.parseDefinition(stringArray);
            if (this._cmd.isHelp()) {
                headlessCore.printMessage(new String[]{DbCartHeadlessResources.getString(this._cmd.getHelpKey())});
            } else {
                this._cmd.validateParse();
                this._cmd.handleLog();
                this._cmd.getCart();
                this._cmd.getConfig();
                this._cmd.validate();
                return new DbCartHeadlessTask(this._cmd);
            }
        }
        return null;
    }

    public String getUsageString() {
        return DbCartHeadlessResources.getString("USAGE_STRING");
    }

    private void parseDefinition(String[] stringArray) throws InvalidCommandArgumentException {
        List<String> list = this.expandDefinition(stringArray);
        String string = null;
        ArrayList<String> arrayList = null;
        for (String string2 : list) {
            if (string2.startsWith("-")) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                } else {
                    this.processItem(string, arrayList);
                    arrayList.clear();
                }
                string = string2.substring(1);
                continue;
            }
            if (arrayList == null) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION", string2));
            }
            arrayList.add(string2);
        }
        if (string != null) {
            this.processItem(string, arrayList);
        }
    }

    private List<String> expandDefinition(String[] stringArray) throws InvalidCommandArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while (n < stringArray.length) {
            String string;
            if ("-DEFFILE".equalsIgnoreCase(string = stringArray[n++])) {
                if (n >= stringArray.length) {
                    throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_COMMAND", string));
                }
                String string2 = stringArray[n++];
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        if (!string3.equals("") && !string3.startsWith("#")) {
                            Deque<String> deque = this.tokenizeLine(string3);
                            StringBuilder stringBuilder = null;
                            while (!deque.isEmpty()) {
                                String string4 = deque.pop();
                                if (stringBuilder != null) {
                                    if (string4.equals("\"")) {
                                        if (!deque.isEmpty() && deque.peek().equals("\"")) {
                                            deque.pop();
                                            stringBuilder.append("\"");
                                            continue;
                                        }
                                        arrayList.add(stringBuilder.toString());
                                        stringBuilder = null;
                                        continue;
                                    }
                                    stringBuilder.append(string4);
                                    continue;
                                }
                                if (string4.equals("\"")) {
                                    stringBuilder = new StringBuilder();
                                    continue;
                                }
                                if (string4.equals(" ")) continue;
                                arrayList.add(string4);
                            }
                            if (stringBuilder != null) {
                                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_COMMAND", string3));
                            }
                        }
                        string3 = bufferedReader.readLine();
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_COMMAND", string2));
                }
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private Deque<String> tokenizeLine(String string) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayDeque.addLast(stringTokenizer.nextToken());
        }
        return arrayDeque;
    }

    private void processItem(String string, List<String> list) throws InvalidCommandArgumentException {
        if ("CART".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._cmd.setCartXML(list.get(0));
        } else if ("CONFIG".equalsIgnoreCase(string) || "CFG".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._cmd.setConfigXML(list.get(0));
        } else if ("LOGFILE".equalsIgnoreCase(string) || "LOG".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._cmd.setLogFile(list.get(0));
        } else if ("HELP".equalsIgnoreCase(string) || "H".equalsIgnoreCase(string)) {
            if (list.size() != 0) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this._cmd.isHelp(true);
        } else if (!this._cmd.processToolItem(string, list)) {
            throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION", string));
        }
    }

    private static class DbCartHeadlessTask
    extends HeadlessTask<Void> {
        private DbCartCommand cmd;

        DbCartHeadlessTask(DbCartCommand dbCartCommand) {
            super(dbCartCommand.getType().toString());
            this.cmd = dbCartCommand;
        }

        protected Void doWork() throws TaskException {
            this.cmd.doCommand();
            return null;
        }
    }
}

