/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import oracle.dbtools.dbcart.DBCartReorderableTableModel;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.tools.IDbCartTool;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.MessageDialog;

public abstract class DbCartTool
implements IDbCartTool,
Controller {
    private static final Logger LOGGER = Logger.getLogger(DbCartTool.class.getName());
    protected String _type;
    protected int _group;
    protected IdeAction _action;
    public static final int FILE = 0;
    public static final int CART = 1;
    public static final int NAV = 2;
    public static final int UTILITY = 3;
    protected boolean _isEnabled = true;
    protected boolean _isEnabledInit = false;

    public DbCartTool(String string, int n) {
        this._type = string;
        this._group = n;
    }

    @Override
    public void toolWillEnable() {
        this.enableIfCurrentCart();
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public int getGroup() {
        return this._group;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean isAlwaysEnabled() {
        return false;
    }

    public boolean isAnyCartEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this._isEnabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this._isEnabledInit) {
            if (this._isEnabled != bl) {
                this._isEnabled = bl;
                this._action.setEnabled(bl);
            }
        } else {
            this._isEnabledInit = true;
            this._isEnabled = bl;
            this._action.setEnabled(bl);
        }
    }

    public boolean validateObjects() {
        return this.validateObjects(false);
    }

    public boolean validateObjects(boolean bl) {
        ArrayList<ExtractObject> arrayList;
        ArrayList<ExtractObject> arrayList2 = arrayList = bl ? DbCartUtil.getTableModel().getIncludedObjectRows(true) : DbCartUtil.getTableModel().getIncludedDBORows(true);
        if (!arrayList.isEmpty()) {
            try {
                if (!DbCartUtil.getReconciler().reconcileExistence(arrayList)) {
                    MessageDialog.error((Component)DbCartUtil.getPanel(), (Object)DbCartAddinArb.getString("NOT_EXISTS_ERROR"), (String)DbCartAddinArb.getString("CART_ERROR"), (String)"f1_dbcartnotexists_html");
                    return false;
                }
            }
            catch (ExecutionException executionException) {
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getMessage());
            }
            return true;
        }
        return false;
    }

    public boolean setCombo(String string, JComboBox jComboBox) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = jComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(jComboBox.getItemAt(i))) continue;
            if (jComboBox.getSelectedIndex() != i) {
                jComboBox.setSelectedIndex(i);
            }
            return true;
        }
        return false;
    }

    protected void enableIfAnyCart() {
        this.enableIfAnyCart(false);
    }

    protected void enableIfAnyCart(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        ArrayList<DBCartReorderableTableModel> arrayList = DbCartUtil.getPanel().getTableModels();
        if (bl) {
            for (DBCartReorderableTableModel dBCartReorderableTableModel : arrayList) {
                if (dBCartReorderableTableModel.isIncludedEmpty()) continue;
                bl3 = true;
                bl2 = false;
            }
        } else {
            for (DBCartReorderableTableModel dBCartReorderableTableModel : arrayList) {
                if (dBCartReorderableTableModel.isEmpty()) continue;
                bl3 = true;
                bl2 = false;
            }
        }
        if (bl2) {
            bl3 = false;
        }
        this.setEnabled(bl3);
    }

    protected void enableIfCurrentCart() {
        this.enableIfCurrentCart(false);
    }

    protected void enableIfCurrentCart(boolean bl) {
        if (!bl) {
            this.setEnabled(DbCartUtil.getTableModel() != null && !DbCartUtil.getTableModel().isEmpty());
        } else {
            this.setEnabled(DbCartUtil.getTableModel() != null && !DbCartUtil.getTableModel().isAnyFileRows() && DbCartUtil.getTableModel().isAnyDDLOrDataRows());
        }
    }
}

