/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWAction;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Vector;
import oracle.AWAction.AWAction;
import oracle.AWAction.Alter;
import oracle.AWAction.Attach;
import oracle.AWAction.BuildDatabase;
import oracle.AWAction.Commit;
import oracle.AWAction.Create;
import oracle.AWAction.Delete;
import oracle.AWAction.Detach;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AWHandlerBase;
import oracle.sql.CLOB;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Interaction {
    private AWConnection m_connection;
    private Vector m_actions = new Vector(0);
    private String m_result;

    public AWConnection getConnection() {
        return this.m_connection;
    }

    public void setConnection(AWConnection aWConnection) {
        this.m_connection = aWConnection;
    }

    public void addAWAction(AWAction aWAction) {
        this.m_actions.add(aWAction);
    }

    public void removeAWAction(AWAction aWAction) {
        this.m_actions.remove(aWAction);
    }

    public void removeAllAWActions() {
        this.m_actions.removeAllElements();
    }

    public Vector getAWActions() {
        return this.m_actions;
    }

    public String getResult() {
        return this.m_result;
    }

    public AWAction createAction(String string) {
        AWAction aWAction = null;
        if (string.equalsIgnoreCase("Alter")) {
            aWAction = new Alter(this);
        }
        if (string.equalsIgnoreCase("Attach")) {
            aWAction = new Attach(this);
        }
        if (string.equalsIgnoreCase("Commit")) {
            aWAction = new Commit(this);
        }
        if (string.equalsIgnoreCase("Create")) {
            aWAction = new Create(this);
        }
        if (string.equalsIgnoreCase("Delete")) {
            aWAction = new Delete(this);
        }
        if (string.equalsIgnoreCase("Detach")) {
            aWAction = new Detach(this);
        }
        if (string.equalsIgnoreCase("BuildDatabase")) {
            aWAction = new BuildDatabase(this);
        }
        if (aWAction == null) {
            throw new AWException("AWXML-ERR-NUM-700001", new Object[]{string});
        }
        this.m_actions.add(aWAction);
        return aWAction;
    }

    public void execute() {
        if (this.m_connection != null && this.m_actions != null) {
            boolean bl = false;
            this.m_connection.executeCommand("aw attach sys.awxml last");
            String string = this.m_connection.executeCommand("show exists('SYS.AWXML!START_DEFFERED_MODE')");
            Double d = string.equalsIgnoreCase("YES") ? new Double(10.2) : new Double(10.1);
            Iterator iterator = this.m_actions.iterator();
            while (iterator.hasNext()) {
                AWAction aWAction = (AWAction)iterator.next();
                if (d >= 10.2) {
                    if (aWAction instanceof Create && !bl) {
                        this.m_connection.executeCommand("call START_DEFFERED_MODE");
                        bl = true;
                    }
                    if (aWAction instanceof Detach && bl) {
                        this.m_connection.executeCommand("call STOP_DEFFERED_MODE");
                        bl = false;
                    }
                }
                aWAction.Execute();
            }
            if (bl) {
                this.m_connection.executeCommand("call STOP_DEFFERED_MODE");
            }
        } else {
            System.out.println("execute not available");
        }
    }

    public static String Execute(CLOB cLOB) {
        String string = "Success";
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            Reader reader = cLOB.getCharacterStream();
            char[] cArray = new char[1024];
            long l = cLOB.length();
            for (long i = 0L; i < l; i += (long)n) {
                n = reader.read(cArray);
                stringBuffer.append(cArray, 0, n);
            }
            String string2 = stringBuffer.toString();
            AWHandlerBase aWHandlerBase = new AWHandlerBase();
            SAXParser sAXParser = new SAXParser();
            sAXParser.setValidationMode(0);
            sAXParser.setContentHandler((ContentHandler)aWHandlerBase);
            sAXParser.setEntityResolver((EntityResolver)aWHandlerBase);
            sAXParser.setDTDHandler((DTDHandler)aWHandlerBase);
            sAXParser.setErrorHandler((ErrorHandler)aWHandlerBase);
            try {
                StringReader stringReader = new StringReader(string2);
                sAXParser.parse((Reader)stringReader);
                aWHandlerBase.ProcessUnResolvedRefs();
                Vector vector = aWHandlerBase.getParsedActions();
                AWConnection aWConnection = new AWConnection();
                Interaction interaction = new Interaction();
                interaction.setConnection(aWConnection);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    AWAction aWAction = (AWAction)iterator.next();
                    aWAction.setOwner(interaction);
                    interaction.addAWAction(aWAction);
                }
                interaction.execute();
                aWConnection.close();
            }
            catch (SAXParseException sAXParseException) {
                System.out.println(sAXParseException.getMessage());
                string = string + " " + sAXParseException.getMessage();
            }
            catch (SAXException sAXException) {
                System.out.println(sAXException.getMessage());
                string = string + " " + sAXException.getMessage();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            string = string + exception.toString();
        }
        return string;
    }

    public static String ExecuteTest(String string, AWConnection aWConnection) {
        String string2 = "Success";
        try {
            AWHandlerBase aWHandlerBase = new AWHandlerBase();
            SAXParser sAXParser = new SAXParser();
            sAXParser.setValidationMode(0);
            sAXParser.setContentHandler((ContentHandler)aWHandlerBase);
            sAXParser.setEntityResolver((EntityResolver)aWHandlerBase);
            sAXParser.setDTDHandler((DTDHandler)aWHandlerBase);
            sAXParser.setErrorHandler((ErrorHandler)aWHandlerBase);
            try {
                StringReader stringReader = new StringReader(string);
                sAXParser.parse((Reader)stringReader);
                aWHandlerBase.ProcessUnResolvedRefs();
                Vector vector = aWHandlerBase.getParsedActions();
                Interaction interaction = new Interaction();
                interaction.setConnection(aWConnection);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    AWAction aWAction = (AWAction)iterator.next();
                    aWAction.setOwner(interaction);
                    interaction.addAWAction(aWAction);
                }
                interaction.execute();
            }
            catch (SAXParseException sAXParseException) {
                System.out.println(sAXParseException.getMessage());
                string2 = "Fail";
            }
            catch (SAXException sAXException) {
                System.out.println(sAXException.getMessage());
                string2 = "Fail";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            string2 = "Fail";
        }
        return string2;
    }

    public String toString() {
        return "Interaction";
    }

    public static String ExecuteBuild(CLOB cLOB) {
        String string = "Success";
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            Reader reader = cLOB.getCharacterStream();
            char[] cArray = new char[1024];
            long l = cLOB.length();
            for (long i = 0L; i < l; i += (long)n) {
                n = reader.read(cArray);
                stringBuffer.append(cArray, 0, n);
            }
            String string2 = stringBuffer.toString();
            AWHandlerBase aWHandlerBase = new AWHandlerBase();
            SAXParser sAXParser = new SAXParser();
            sAXParser.setValidationMode(0);
            sAXParser.setContentHandler((ContentHandler)aWHandlerBase);
            sAXParser.setEntityResolver((EntityResolver)aWHandlerBase);
            sAXParser.setDTDHandler((DTDHandler)aWHandlerBase);
            sAXParser.setErrorHandler((ErrorHandler)aWHandlerBase);
            try {
                StringReader stringReader = new StringReader(string2);
                sAXParser.parse((Reader)stringReader);
                aWHandlerBase.ProcessUnResolvedRefs();
                Vector vector = aWHandlerBase.getParsedActions();
                AWConnection aWConnection = new AWConnection();
                Interaction interaction = new Interaction();
                interaction.setConnection(aWConnection);
                AWAction aWAction = null;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    aWAction = (AWAction)iterator.next();
                    aWAction.setOwner(interaction);
                    interaction.addAWAction(aWAction);
                }
                if (interaction.getAWActions().size() > 1) {
                    throw new AWException("Multiple actions are not allowed in this api");
                }
                if (aWAction == null || !(aWAction instanceof BuildDatabase)) {
                    throw new AWException("Action other than Build requested");
                }
                string = ((BuildDatabase)aWAction).ExecuteBuild();
                aWConnection.close();
            }
            catch (SAXParseException sAXParseException) {
                System.out.println(sAXParseException.getMessage());
                string = string + " " + sAXParseException.getMessage();
            }
            catch (SAXException sAXException) {
                System.out.println(sAXException.getMessage());
                string = string + " " + sAXException.getMessage();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            string = string + exception.toString();
        }
        return string;
    }
}

