/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprCase
extends Expr {
    private ArrayList<Expr> theExprs;
    private boolean theHasElseExpr;

    ExprCase(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, ArrayList<Expr> exprs) {
        super(qcb, sctx, Expr.ExprKind.CASE, location);
        this.theExprs = exprs;
        this.theHasElseExpr = exprs.size() % 2 != 0;
        int elsePos = this.theHasElseExpr ? exprs.size() - 1 : -1;
        for (int i = 0; i < this.theExprs.size(); ++i) {
            Expr e = this.theExprs.get(i);
            if (i % 2 == 0 && i != elsePos) {
                e = ExprPromote.create(null, e, TypeManager.BOOLEAN_QSTN());
                this.theExprs.set(i, e);
            }
            e.addParent(this);
        }
    }

    @Override
    int getNumChildren() {
        return this.theExprs.size();
    }

    int getNumWhenClauses() {
        return this.theExprs.size() / 2;
    }

    boolean hasElseClause() {
        return this.theHasElseExpr;
    }

    Expr getExpr(int i) {
        return this.theExprs.get(i);
    }

    Expr getCondExpr(int i) {
        return this.theExprs.get(i * 2);
    }

    Expr getThenExpr(int i) {
        return this.theExprs.get(i * 2 + 1);
    }

    Expr getElseExpr() {
        return this.theHasElseExpr ? this.theExprs.get(this.theExprs.size() - 1) : null;
    }

    void setExpr(int i, Expr newExpr, boolean destroy) {
        int elsePos;
        this.theExprs.get(i).removeParent(this, destroy);
        int n = elsePos = this.theHasElseExpr ? this.theExprs.size() - 1 : -1;
        if (i % 2 == 0 && i != elsePos) {
            newExpr = ExprPromote.create(null, newExpr, TypeManager.BOOLEAN_QSTN());
        }
        this.theExprs.set(i, newExpr);
        newExpr.addParent(this);
    }

    void removeWhenClause(int i, boolean destroy) {
        this.theExprs.get(i *= 2).removeParent(this, destroy);
        this.theExprs.remove(i);
        this.theExprs.get(i).removeParent(this, destroy);
        this.theExprs.remove(i);
    }

    void removeElseClause(boolean destroy) {
        int i = this.theExprs.size() - 1;
        this.theExprs.get(i).removeParent(this, destroy);
        this.theExprs.remove(i);
    }

    @Override
    ExprType computeType() {
        ExprType type = this.theExprs.get(1).getType();
        for (int i = 3; i < this.theExprs.size(); i += 2) {
            if (!(type = TypeManager.getUnionType(type, this.theExprs.get(i).getType())).isAny()) continue;
            return type;
        }
        if (this.theHasElseExpr) {
            type = TypeManager.getUnionType(type, this.getElseExpr().getType());
        }
        return type;
    }

    @Override
    public boolean mayReturnNULL() {
        for (int i = 1; i < this.theExprs.size(); i += 2) {
            if (!this.theExprs.get(i).mayReturnNULL()) continue;
            return true;
        }
        Expr elseExpr = this.getElseExpr();
        return elseExpr != null && elseExpr.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int num = this.theExprs.size();
        if (this.theHasElseExpr) {
            --num;
        }
        for (int i = 0; i < num; ++i) {
            formatter.indent(sb);
            sb.append("WHEN :\n");
            this.theExprs.get(i).display(sb, formatter);
            sb.append("\n");
            formatter.indent(sb);
            sb.append("THEN :\n");
            this.theExprs.get(i).display(sb, formatter);
            sb.append("\n");
        }
        if (this.theHasElseExpr) {
            formatter.indent(sb);
            sb.append("ELSE :\n");
            this.getElseExpr().display(sb, formatter);
        }
    }
}

