/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.view;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.spatial.mapviewer.model.SpatialComboBoxLoader;
import oracle.dbtools.util.Logger;

public class SpatialDelayedComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private static final String LOADED_KEY = "SpatialDelayedLoadingComboBox-loaded";
    transient SpatialComboBoxLoader _loader;
    private transient Object initVal;
    private boolean initStarted;
    private transient Object currentValue;

    public SpatialDelayedComboBox(String string, Object object, SpatialComboBoxLoader spatialComboBoxLoader) {
        this(string, object, spatialComboBoxLoader, false);
    }

    public SpatialDelayedComboBox(String string, Object object, SpatialComboBoxLoader spatialComboBoxLoader, boolean bl) {
        assert (string != null);
        assert (object != null);
        assert (spatialComboBoxLoader != null);
        this.setName(string);
        this.getEditor().getEditorComponent().setName(string + "_Editor");
        this._loader = spatialComboBoxLoader;
        this.init(object, bl);
    }

    private void init(Object object, boolean bl) {
        this.setModel(new DefaultComboBoxModel<Object>(new Object[]{object}));
        this.setSelectedItem(object);
        this.initVal = object;
        this.initStarted = bl;
        this.addPopupMenuListener(new PopupListener());
        this._loader.init(this, object);
        if (bl) {
            this.startLoader();
        }
    }

    public void restart() {
        this.putClientProperty(LOADED_KEY, Boolean.FALSE);
        this._loader.init(this, true);
        this.addPopupMenuListener(new PopupListener());
    }

    private void startLoader() {
        this.startLoader(false);
    }

    private void startLoader(boolean bl) {
        if (bl) {
            this._loader.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            SpatialDelayedComboBox.this.showPopup();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
        }
        this._loader.start();
    }

    public void populate(List<Object> list, Object object) {
        assert (list != null);
        Object object2 = this.getCurrentValue();
        if (!list.contains(object2)) {
            try {
                list.add(0, object2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logger.ignore(this.getClass(), (Throwable)unsupportedOperationException);
            }
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.setModel(defaultComboBoxModel);
        this.putClientProperty(LOADED_KEY, Boolean.TRUE);
        int n = Math.max(0, defaultComboBoxModel.getIndexOf(object2));
        this.setSelectedIndex(n);
    }

    @Override
    public void setSelectedItem(Object object) {
        if (!Boolean.TRUE.equals(this.getClientProperty(LOADED_KEY))) {
            this.setModel(new DefaultComboBoxModel<Object>(new Object[]{object}));
        }
        this.setSelectedItemSuper(object);
        this.setCurrentValue(object);
    }

    private void setSelectedItemSuper(Object object) {
        super.setSelectedItem(object);
    }

    private void setCurrentValue(Object object) {
        this.currentValue = object;
    }

    private Object getCurrentValue() {
        return this.currentValue;
    }

    private class PopupListener
    implements PopupMenuListener {
        private PopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            if (!Boolean.TRUE.equals(SpatialDelayedComboBox.this.getClientProperty(SpatialDelayedComboBox.LOADED_KEY))) {
                SpatialDelayedComboBox.this.removeAllItems();
                String string = UiResources.get((String)"DelayedLoadingComboBox_LOADING_MSG");
                SpatialDelayedComboBox.this.addItem(string);
                SpatialDelayedComboBox.this.setSelectedItemSuper(string);
                SpatialDelayedComboBox.this.removePopupMenuListener(this);
                SpatialDelayedComboBox.this.startLoader(true);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

