/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import oracle.bali.jle.JLEAutoScroller;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.Cancelable;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.GridSnap;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsToolEvent;
import oracle.bali.jle.tool.BoundsToolListener;
import oracle.bali.jle.tool.BoundsToolValidateEvent;
import oracle.bali.jle.tool.ControlPoint;
import oracle.bali.jle.tool.ControlPointSet;
import oracle.bali.jle.tool.ControlPointTable;
import oracle.bali.jle.tool.DefaultBoundsPainter;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.tool.undo.MoveUndo;
import oracle.bali.jle.tool.undo.ResizeUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.event.ListenerManager;

public class BoundsTool
extends SelectionTool {
    public static final Object REJECT_MOVE_KEY = new StringKey("REJECT_MOVE_KEY");
    public static final Object REJECT_RESIZE_KEY = new StringKey("REJECT_RESIZE_KEY");
    public static final Object MINIMUM_SIZE_KEY = new StringKey("MINIMUM_SIZE_KEY");
    public static final int RESIZE_FLIP = 0;
    public static final int RESIZE_MINIMUM_CONSTRAINED = 1;
    public static final int CONSTRAIN_TO_PARENT = 2;
    public static final int CONSTRAIN_TO_CHILDREN = 8;
    public static final int CONSTRAIN_TO_ITEM_MIN = 16;
    public static final int CONSTRAIN_TO_PARENT_TOPLEFT = 32;
    protected static final Object CONTROL_POINT_SET_KEY = new StringKey("CONTROL_POINT_SET_KEY");
    private ControlPointTable _cpTable = new ControlPointTable();
    private BoundsPainter _painter;
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private transient boolean _autoscrolling;
    private transient int _oldCount;
    private transient ControlPoint _dragCandidate;
    private transient ControlPoint _dragged;
    private transient ControlPoint _undoPoint;
    private transient boolean _dragRejected = false;
    private transient boolean _dragChecked = false;
    private transient boolean _gotPress;
    private int _cpXOff;
    private int _cpYOff;
    private double _cpNearX;
    private double _cpNearY;
    private int _keyMove = 1;
    private transient boolean _didDrag;
    private boolean _postUndo;
    private boolean _constrain;
    private JLECanvas _cursorComp;
    private ListenerManager _listeners;
    private Vector _notMoved;
    private Vector _notResized;
    private int _mode = 0;
    private double _minWidth = 5.0;
    private double _minHeight = 5.0;
    private double _padLeft;
    private double _padRight;
    private double _padUp;
    private double _padDown;
    private boolean _padDirty = true;

    public static boolean isMovable(LayoutItem item) {
        Object result = item.getProperty(REJECT_MOVE_KEY);
        return result == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setMovable(LayoutItem item, boolean movable) {
        if (movable) {
            item.removeProperty(REJECT_MOVE_KEY);
        } else {
            item.putProperty(REJECT_MOVE_KEY, null);
        }
    }

    public static boolean isResizable(LayoutItem item) {
        Object result = item.getProperty(REJECT_RESIZE_KEY);
        return result == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setResizable(LayoutItem item, boolean resizable) {
        if (resizable) {
            item.removeProperty(REJECT_RESIZE_KEY);
        } else {
            item.putProperty(REJECT_RESIZE_KEY, null);
        }
    }

    public static Dimension2D getMinimumSize(LayoutItem item) {
        Object result = item.getProperty(MINIMUM_SIZE_KEY);
        return result == PropertyManager.NOT_FOUND_OBJECT ? null : (Dimension2D)result;
    }

    public static void setMinimumSize(LayoutItem item, double minWidth, double minHeight) {
        item.putProperty(MINIMUM_SIZE_KEY, new Dimension2D.Double(minWidth, minHeight));
    }

    @Override
    public void drawHighlight(Graphics g) {
        int size;
        super.drawHighlight(g);
        JLECanvas canvas = this.getCanvas();
        ControlPoint cp = this._cpTable.firstElement();
        while (cp != null) {
            Point devPoint = canvas.contentToDevice(cp.getX(), cp.getY());
            this._painter.drawControlPoint(g, cp, devPoint.x - this._cpXOff, devPoint.y - this._cpYOff);
            cp = this._cpTable.nextElement();
        }
        if (this._dragged != null && !this._autoscrolling && (size = this.getSelectedItemCount()) > 0) {
            LayoutItem[] items = this.getSelectedItems();
            boolean moving = this._dragged.getType() == 5;
            for (int i = 0; i < items.length; ++i) {
                LayoutItem item = items[i];
                boolean paintMove = true;
                boolean paintResize = true;
                if (moving && this._notMoved != null) {
                    if (this._notMoved.contains(item)) {
                        paintMove = false;
                    }
                } else if (this._notResized != null && this._notResized.contains(item)) {
                    paintResize = false;
                }
                if (!paintMove && !paintResize) continue;
                Rectangle device = ItemUtils.itemToDevice(item.getItemParent(), item.getItemBounds());
                int dx = (int)Math.round((this._endX - this._startX) * canvas.getZoomX() / canvas.getEngineUnitsPerPixelX());
                int dy = (int)Math.round((this._endY - this._startY) * canvas.getZoomY() / canvas.getEngineUnitsPerPixelY());
                if (moving) {
                    device.x += dx;
                    device.y += dy;
                    this._painter.drawMove(g, item, device.x, device.y, device.width, device.height);
                    continue;
                }
                if (this._dragged.isUpper()) {
                    device.y += dy;
                    device.height -= dy;
                } else if (this._dragged.isLower()) {
                    device.height += dy;
                }
                if (this._dragged.isLeft()) {
                    device.x += dx;
                    device.width -= dx;
                } else if (this._dragged.isRight()) {
                    device.width += dx;
                }
                this._painter.drawResize(g, item, device.x, device.y, device.width, device.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop() {
        int i;
        LayoutItem[] items;
        JLECanvas canvas = this.getCanvas();
        try {
            canvas.freezeRepaints();
            items = this.getSelectedItems();
            for (i = 0; i < items.length; ++i) {
                this.processDeselect(items[i]);
            }
        }
        finally {
            canvas.unfreezeRepaints();
        }
        this._cpTable.removeAll();
        items = this.getSelectedItems();
        for (i = 0; i < items.length; ++i) {
            items[i].removeProperty(CONTROL_POINT_SET_KEY);
        }
        this._cursorComp = null;
        canvas.removePropertyChangeListener(this);
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        super.drop();
        this._postUndo = false;
    }

    @Override
    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._postUndo = canvas.hasUndoableEditListeners();
        this._painter = this.getBoundsPainter();
        int width = this._painter.getControlPointWidth();
        int height = this._painter.getControlPointHeight();
        this._cpXOff = width / 2;
        this._cpYOff = height / 2;
        this._cpNearX = (double)this._cpXOff * canvas.getEngineUnitsPerPixelX();
        this._cpNearY = (double)this._cpYOff * canvas.getEngineUnitsPerPixelY();
        this._oldCount = 0;
        this._autoscrolling = false;
        canvas.addPropertyChangeListener(this);
        this._clearPad();
    }

    @Override
    protected void processMousePressed(JLEEvent e) {
        if (!this.isPrimaryMouseEvent(e)) {
            if (this._dragged != null) {
                this._dragRejected = true;
                this._dragCandidate = null;
                this._dragged = null;
                this._didDrag = false;
                this.updateImmediately();
                e.consume();
            }
        } else {
            this._gotPress = true;
        }
        if (e.isConsumed() || !this.isPrimaryMouseEvent(e)) {
            return;
        }
        this._oldCount = this.getSelectedItemCount();
        this._didDrag = false;
        double x = e.getX();
        double y = e.getY();
        ControlPoint cp = this._cpTable.lookup(x, y, this._cpNearX, this._cpNearY);
        LayoutItem clicked = this.getCanvas().getHitItem(x, y);
        if (!(cp != null || clicked != null && BoundsTool.isSelected(clicked))) {
            super.processMousePressed(e);
            if (this.getSelectedItemCount() == 0) {
                this._dragged = null;
                this._dragCandidate = null;
                return;
            }
        }
        this._startX = this._endX = x;
        this._startY = this._endY = y;
        if (cp == null) {
            cp = new ControlPoint(5, x, y, clicked);
        }
        this._dragCandidate = cp;
        e.consume();
    }

    @Override
    protected void processMouseReleased(JLEEvent e) {
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        double x = e.getX();
        double y = e.getY();
        if (this._oldCount == this.getSelectedItemCount() && !this._didDrag && !this._dragRejected) {
            boolean isModified;
            LayoutItem clicked = BoundsTool.getSelectedItemAt(this.getCanvas(), x, y);
            boolean bl = isModified = (e.getModifiers() & 3) != 0;
            if (isModified) {
                if (clicked != null) {
                    this.toggleSelection(clicked);
                }
            } else {
                LayoutItem[] selection = this.getSelectedItems();
                for (int i = 0; i < selection.length; ++i) {
                    LayoutItem curr = selection[i];
                    if (curr == clicked) continue;
                    this.processDeselect(curr);
                }
            }
        }
        if (this._dragged != null && this._didDrag) {
            this._endX = x;
            this._endY = y;
            double dx = this._endX - this._startX;
            double dy = this._endY - this._startY;
            if (this.getSelectedItemCount() > 0) {
                AbstractUndoableEdit edit;
                LayoutItem[] selection = this.getSelectedItems();
                if (dx < 0.0) {
                    if (dx < -this._padLeft) {
                        dx = -this._padLeft;
                        this._endX = this._startX + dx;
                    }
                } else if (dx > this._padRight) {
                    dx = this._padRight;
                    this._endX = this._startX + dx;
                }
                if (dy < 0.0) {
                    if (dy < -this._padUp) {
                        dy = -this._padUp;
                        this._endY = this._startY + dy;
                    }
                } else if (dy > this._padDown) {
                    dy = this._padDown;
                    this._endY = this._startY + dy;
                }
                CompoundEdit compoundEdit = edit = this._postUndo && selection.length > 1 ? new CompoundEdit() : null;
                if (this._dragged.getType() == 5) {
                    selection = ItemUtils.removeChildren(this.getCanvas(), selection);
                    for (int i = 0; i < selection.length; ++i) {
                        LayoutItem curr = selection[i];
                        boolean moved = BoundsTool.processMove(curr, dx, dy, this);
                        if (!this._postUndo || !moved) continue;
                        MoveUndo temp = new MoveUndo(curr, dx, dy, this);
                        if (selection.length > 1) {
                            edit.addEdit(temp);
                            continue;
                        }
                        edit = temp;
                    }
                } else {
                    for (int i = 0; i < selection.length; ++i) {
                        LayoutItem curr = selection[i];
                        this._undoPoint = this._dragged;
                        boolean resized = this.processResize(curr, dx, dy, this._dragged);
                        if (!this._postUndo || !resized) continue;
                        ResizeUndo temp = new ResizeUndo(curr, dx, dy, this._undoPoint, this._dragged, this);
                        if (selection.length > 1) {
                            edit.addEdit(temp);
                            continue;
                        }
                        edit = temp;
                    }
                }
                if (this._postUndo) {
                    if (selection.length > 1) {
                        edit.end();
                    }
                    if (edit != null) {
                        this.getCanvas().processUndoableEditEvent(new UndoableEditEvent(this, edit));
                    }
                }
            }
        }
        this._undoPoint = null;
        this._dragCandidate = null;
        this._dragged = null;
        this._dragRejected = false;
        this._dragChecked = false;
        this._clearPad();
        super.processMouseReleased(e);
    }

    @Override
    protected void processMouseDragged(JLEEvent e) {
        if (e.isConsumed() || !this.isPrimaryMouseEvent(e) || !this._gotPress) {
            return;
        }
        if (this._dragRejected) {
            return;
        }
        if (this._dragCandidate != null) {
            this._dragged = this._dragCandidate;
            this._dragCandidate = null;
        }
        this._didDrag = true;
        if (this._dragged != null) {
            this._autoscrolling = JLEAutoScroller.getJLEAutoScroller().checkAutoScroll(this.getCanvas(), e);
            this._endX = e.getX();
            this._endY = e.getY();
            double dx = this._endX - this._startX;
            double dy = this._endY - this._startY;
            LayoutItem[] items = this.getSelectedItems();
            if (this._padDirty) {
                this._calculatePad(items);
            }
            if (dx < 0.0) {
                if (dx < -this._padLeft) {
                    dx = -this._padLeft;
                    this._endX = this._startX + dx;
                }
            } else if (dx > this._padRight) {
                dx = this._padRight;
                this._endX = this._startX + dx;
            }
            if (dy < 0.0) {
                if (dy < -this._padUp) {
                    dy = -this._padUp;
                    this._endY = this._startY + dy;
                }
            } else if (dy > this._padDown) {
                dy = this._padDown;
                this._endY = this._startY + dy;
            }
            if (this._dragged.getType() == 5) {
                if (!this._dragChecked) {
                    if (!this._checkDragRejection(1, items)) {
                        this._dragRejected = true;
                        this._didDrag = false;
                        return;
                    }
                    this._dragChecked = true;
                }
                JLECanvas canvas = this.getCanvas();
                Cursor dragCursor = this.getBoundsPainter().getMoveCursor();
                if (dragCursor != null && canvas.getCursor() != dragCursor) {
                    this._cursorComp.getGlassComponent().setCursor(dragCursor);
                }
                for (int i = 0; i < items.length; ++i) {
                    LayoutItem curr = items[i];
                    this.fireBoundsToolEvent(5, curr, dx, dy);
                    Rectangle2D device = ItemUtils.parentToContent(curr, curr.getItemBounds());
                    this.addImmediateRect(device.getX() + dx, device.getY() + dy, device.getWidth(), device.getHeight());
                }
            } else {
                if (!this._dragChecked) {
                    if (!this._checkDragRejection(3, items)) {
                        this._dragRejected = true;
                        this._didDrag = false;
                        return;
                    }
                    this._dragChecked = true;
                }
                for (int i = 0; i < items.length; ++i) {
                    LayoutItem curr = items[i];
                    this.fireBoundsToolEvent(6, curr, dx, dy);
                    Rectangle2D device = ItemUtils.parentToContent(curr, curr.getItemBounds());
                    double x = device.getX();
                    double y = device.getY();
                    double width = device.getWidth();
                    double height = device.getHeight();
                    if (this._dragged.isUpper()) {
                        y += dy;
                        height -= dy;
                    } else if (this._dragged.isLower()) {
                        height += dy;
                    }
                    if (this._dragged.isLeft()) {
                        x += dx;
                        width -= dx;
                    } else if (this._dragged.isRight()) {
                        width += dx;
                    }
                    if (width < 0.0) {
                        x += width;
                        width = -width;
                    }
                    if (height < 0.0) {
                        y += height;
                        height = -height;
                    }
                    this.addImmediateRect(x, y, width, height);
                }
            }
            this.updateImmediately();
        } else {
            super.processMouseDragged(e);
        }
    }

    @Override
    protected void processMouseMoved(JLEEvent e) {
        if (this._cursorComp == null) {
            this._cursorComp = this.getCanvas();
            Object canvasTest = this._cursorComp;
            while (canvasTest != null) {
                if ((canvasTest = ((Component)canvasTest).getParent()) == null || !(canvasTest instanceof JLECanvas)) continue;
                this._cursorComp = (JLECanvas)canvasTest;
            }
        }
        int type = 0;
        ControlPoint cp = this._cpTable.lookup(e.getX(), e.getY(), this._cpNearX, this._cpNearY);
        if (cp != null) {
            switch (cp.getType()) {
                case 0: {
                    type = 6;
                    break;
                }
                case 1: {
                    type = 8;
                    break;
                }
                case 2: {
                    type = 7;
                    break;
                }
                case 4: {
                    type = 10;
                    break;
                }
                case 6: {
                    type = 11;
                    break;
                }
                case 8: {
                    type = 4;
                    break;
                }
                case 9: {
                    type = 9;
                    break;
                }
                case 10: {
                    type = 5;
                    break;
                }
            }
        }
        this._cursorComp.getGlassComponent().setCursor(Cursor.getPredefinedCursor(type));
    }

    @Override
    protected void processKeyPressed(JLEEvent e) {
        super.processKeyPressed(e);
        if (e.isConsumed()) {
            return;
        }
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (!this._processMoveKey(e)) break;
                e.consume();
                break;
            }
            case 27: {
                if (this._dragged == null) break;
                this._dragRejected = true;
                this._dragCandidate = null;
                this._dragged = null;
                this._didDrag = false;
                this.updateImmediately();
                e.consume();
            }
        }
    }

    @Override
    public boolean processSelect(LayoutItem item, EventObject selector) {
        if (!super.processSelect(item, selector)) {
            return false;
        }
        if (!BoundsTool.isMovable(item)) {
            if (this._notMoved == null) {
                this._notMoved = new Vector();
            }
            this._notMoved.addElement(item);
        }
        if (!BoundsTool.isResizable(item)) {
            if (this._notResized == null) {
                this._notResized = new Vector();
            }
            this._notResized.addElement(item);
        }
        this.refreshSelection(item);
        return true;
    }

    @Override
    public boolean processDeselect(LayoutItem item, EventObject deselector) {
        if (!super.processDeselect(item, deselector)) {
            return false;
        }
        if (!BoundsTool.isMovable(item)) {
            this._notMoved.removeElement(item);
        }
        if (!BoundsTool.isResizable(item)) {
            this._notResized.removeElement(item);
        }
        this.clearControlPointSet(item);
        this.repaintWithControl(item, 0, 0);
        return true;
    }

    public static boolean processMove(LayoutItem item, double dx, double dy, BoundsTool tool) {
        if (!BoundsTool.isMovable(item)) {
            return false;
        }
        JLECanvas canvas = item.getCanvas();
        AffineTransform trans = item.getItemTransform();
        Dimension2D transDim = canvas.contentToDevice(new Dimension2D.Double(dx, dy));
        transDim = ItemUtils.deviceToItem(item.getItemParent(), transDim);
        AffineTransform newTrans = new AffineTransform();
        newTrans.translate(transDim.getWidth(), transDim.getHeight());
        newTrans.concatenate(trans);
        try {
            item.setItemTransform(newTrans);
        }
        catch (TransformException e) {
            return false;
        }
        if (tool != null) {
            tool.fireBoundsToolEvent(2, item, dx, dy);
        }
        return true;
    }

    public boolean processResize(LayoutItem item, double dx, double dy, ControlPoint cp) {
        if (!BoundsTool.isResizable(item)) {
            return false;
        }
        JLECanvas canvas = this.getCanvas();
        Dimension2D delta = new Dimension2D.Double(dx, dy);
        delta = ItemUtils.deviceToItem(item, canvas.contentToDevice(delta));
        Rectangle2D bounds = item.getItemBounds();
        double deltaHeight = delta.getHeight();
        double deltaWidth = delta.getWidth();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        boolean changeLoc = false;
        if (cp.isUpper()) {
            y += deltaHeight;
            height -= deltaHeight;
            changeLoc = true;
        } else if (cp.isLower()) {
            height += deltaHeight;
        }
        if (cp.isLeft()) {
            x += deltaWidth;
            width -= deltaWidth;
            changeLoc = true;
        } else if (cp.isRight()) {
            width += deltaWidth;
        }
        if (this._dragged != null) {
            this._undoPoint = this._adjustUndoControlPoint(width, height, this._dragged);
        }
        if (item instanceof BaseItem) {
            BaseItem bi = (BaseItem)item;
            bi.setItemBounds(x, y, width, height);
        } else {
            if (changeLoc && width >= 0.0 && height >= 0.0) {
                item.setItemLocation(x, y);
            }
            item.setItemSize(width, height);
        }
        this.fireBoundsToolEvent(4, item, dx, dy);
        return true;
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    public BoundsPainter getBoundsPainter() {
        if (this._painter == null) {
            this._painter = DefaultBoundsPainter.getPainter();
        }
        return this._painter;
    }

    public void setBoundsPainter(BoundsPainter painter) {
        this._painter = painter;
    }

    public void setKeyMoveInterval(int pixels) {
        this._keyMove = pixels;
    }

    public int getKeyMoveInterval() {
        return this._keyMove;
    }

    public Dimension2D getMinimumResize() {
        return new Dimension2D.Double(this._minWidth, this._minHeight);
    }

    public void setMinimumResize(double minimumWidth, double minimumHeight) {
        if (minimumWidth <= 0.0 || minimumHeight <= 0.0) {
            throw new IllegalArgumentException();
        }
        this._minWidth = minimumWidth;
        this._minHeight = minimumHeight;
    }

    public void addBoundsToolListener(BoundsToolListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeBoundsToolListener(BoundsToolListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (JLECanvas.VIEWPORT_LOC_PROPERTY_KEY.equals((Object)property) && this._dragged != null) {
            Point2D point2D = (Point2D)evt.getNewValue();
        }
        super.propertyChange(evt);
    }

    protected boolean fireBoundsToolEvent(int id, LayoutItem item, double dx, double dy) {
        BoundsToolEvent event;
        Enumeration listeners;
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return true;
        }
        boolean cancelable = false;
        switch (id) {
            case 1: 
            case 3: {
                event = new BoundsToolValidateEvent(this, id, item);
                cancelable = true;
                break;
            }
            default: {
                event = new BoundsToolEvent(this, id, item, dx, dy);
            }
        }
        while (listeners.hasMoreElements()) {
            BoundsToolListener listener = (BoundsToolListener)listeners.nextElement();
            switch (id) {
                case 1: {
                    listener.itemMoving(event);
                    break;
                }
                case 2: {
                    listener.itemMoved(event);
                    break;
                }
                case 3: {
                    listener.itemResizing(event);
                    break;
                }
                case 4: {
                    listener.itemResized(event);
                    break;
                }
                case 5: {
                    listener.itemMovePositioning(event);
                    break;
                }
                case 6: {
                    listener.itemResizePositioning(event);
                }
            }
        }
        return cancelable ? !((Cancelable)((Object)event)).isCancelled() : true;
    }

    protected final boolean fireBoundsToolEvent(int id, LayoutItem item) {
        return this.fireBoundsToolEvent(id, item, Double.NaN, Double.NaN);
    }

    @Override
    protected void refreshSelection(LayoutItem item) {
        super.refreshSelection(item);
        if (!BoundsTool.isResizable(item)) {
            return;
        }
        this.clearControlPointSet(item);
        ControlPointSet points = this.fetchControlPointSet(item);
        item.putProperty(CONTROL_POINT_SET_KEY, points);
        Enumeration pointEnum = points.getControlPoints();
        while (pointEnum.hasMoreElements()) {
            ControlPoint cp = (ControlPoint)pointEnum.nextElement();
            this._cpTable.insert(cp);
        }
        this.repaintWithControl(item, 0, 0);
    }

    protected ControlPointSet fetchControlPointSet(LayoutItem item) {
        ControlPoint[] points = new ControlPoint[8];
        Rectangle2D rect = ItemUtils.parentToContent(item, item.getItemBounds());
        int curr = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (x == 1 && y == 1) continue;
                points[curr] = new ControlPoint(1 * x + 4 * y, rect.getX() + (double)x * rect.getWidth() / 2.0, rect.getY() + (double)y * rect.getHeight() / 2.0, item);
                ++curr;
            }
        }
        return new ControlPointSet(points);
    }

    protected final boolean clearControlPointSet(LayoutItem item) {
        Object found = item.removeProperty(CONTROL_POINT_SET_KEY);
        if (found == PropertyManager.NOT_FOUND_OBJECT) {
            return false;
        }
        ControlPointSet set = (ControlPointSet)found;
        Enumeration points = set.getControlPoints();
        while (points.hasMoreElements()) {
            this._cpTable.remove((ControlPoint)points.nextElement());
        }
        return true;
    }

    protected final ControlPointTable getControlPointTable() {
        return this._cpTable;
    }

    protected final void repaintWithControl(LayoutItem item, int extraX, int extraY) {
        Rectangle devRect = ItemUtils.parentToDevice(item, item.getItemBounds());
        JLECanvas canvas = item.getCanvas();
        if (canvas == null && (canvas = this.getCanvas()) == null) {
            return;
        }
        int zoomWidth = (int)Math.ceil((double)(extraX + this._cpXOff) * canvas.getZoomX());
        int zoomHeight = (int)Math.ceil((double)(extraY + this._cpYOff) * canvas.getZoomY());
        devRect.x -= zoomWidth;
        devRect.y -= zoomHeight;
        devRect.width += 2 * zoomWidth + 1;
        devRect.height += 2 * zoomHeight + 1;
        canvas.repaintCanvas(devRect.x, devRect.y, devRect.width, devRect.height);
    }

    private boolean _processMoveKey(JLEEvent e) {
        LayoutItem[] selected = this.getSelectedItems();
        int keyMoveX = this._keyMove;
        int keyMoveY = this._keyMove;
        boolean consume = false;
        if (selected.length > 0) {
            double keyX;
            JLECanvas canvas = this.getCanvas();
            double canvasX = canvas.getEngineUnitsPerPixelX();
            double canvasY = canvas.getEngineUnitsPerPixelY();
            int keyCode = e.getKeyCode();
            double d = keyCode == 38 || keyCode == 40 ? 0.0 : (keyX = keyCode == 37 ? (double)keyMoveX * -canvasX : (double)keyMoveX * canvasX);
            double keyY = keyCode == 37 || keyCode == 39 ? 0.0 : (keyCode == 38 ? (double)keyMoveY * -canvasY : (double)keyMoveY * canvasY);
            AbstractUndoableEdit edit = this._postUndo && selected.length > 1 ? new CompoundEdit() : null;
            for (int i = 0; i < selected.length; ++i) {
                LayoutItem curr = selected[i];
                LayoutItem currParent = curr.getItemParent();
                double actualX = keyX;
                double actualY = keyY;
                GridSnap snap = GridSnap.getGridSnap(currParent);
                if (snap != null) {
                    Dimension2D interval = snap.getGridInterval();
                    interval = ItemUtils.itemToDeviceDouble(currParent, interval);
                    if (actualX < 0.0) {
                        actualX = interval.getWidth() * -canvasX;
                    } else if (actualX > 0.0) {
                        actualX = interval.getWidth() * canvasX;
                    }
                    if (actualY < 0.0) {
                        actualY = interval.getHeight() * -canvasY;
                    } else if (actualY > 0.0) {
                        actualY = interval.getHeight() * canvasY;
                    }
                    keyMoveX = (int)Math.round(interval.getWidth());
                    keyMoveY = (int)Math.round(interval.getHeight());
                }
                boolean moved = BoundsTool.processMove(curr, actualX, actualY, this);
                consume |= moved;
                if (!moved) continue;
                this.repaintWithControl(curr, keyCode == 38 || keyCode == 40 ? 0 : keyMoveX, keyCode == 37 || keyCode == 39 ? 0 : keyMoveY);
                if (!this._postUndo) continue;
                MoveUndo temp = new MoveUndo(curr, actualX, actualY, this);
                if (selected.length > 1) {
                    edit.addEdit(temp);
                    continue;
                }
                edit = temp;
            }
            if (this._postUndo) {
                if (selected.length > 1) {
                    edit.end();
                }
                canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
            }
        }
        return consume;
    }

    private boolean _checkDragRejection(int id, LayoutItem[] items) {
        if (id == 1) {
            items = ItemUtils.removeChildren(this.getCanvas(), items);
        }
        for (int i = 0; i < items.length; ++i) {
            if (this.fireBoundsToolEvent(id, items[i])) continue;
            return false;
        }
        return true;
    }

    private void _clearPad() {
        this._padDirty = true;
        this._padDown = Double.MAX_VALUE;
        this._padUp = Double.MAX_VALUE;
        this._padRight = Double.MAX_VALUE;
        this._padLeft = Double.MAX_VALUE;
    }

    private void _reducePadFromRectangle(double outerWidth, double outerHeight, double innerWidth, double innerHeight) {
        double widthDiff = outerWidth - innerWidth;
        double heightDiff = outerHeight - innerHeight;
        ControlPoint cp = this._dragged;
        if (cp.isLeft()) {
            if (widthDiff < this._padRight) {
                this._padRight = widthDiff;
            }
        } else if (cp.isRight() && widthDiff < this._padLeft) {
            this._padLeft = widthDiff;
        }
        if (cp.isUpper()) {
            if (heightDiff < this._padDown) {
                this._padDown = heightDiff;
            }
        } else if (cp.isLower() && heightDiff < this._padUp) {
            this._padUp = heightDiff;
        }
    }

    private void _padConstrainToParent(LayoutItem[] items) {
        ControlPoint cp = this._dragged;
        boolean isCenter = cp.getType() == 5;
        for (int i = 0; i < items.length; ++i) {
            double parentBottomSpace;
            double parentRightSpace;
            LayoutItem curr = items[i];
            Rectangle2D bounds = curr.getItemBounds();
            Dimension2D parentSize = curr.getItemParent().getItemSize();
            double left = bounds.getX();
            double top = bounds.getY();
            double right = bounds.getRight();
            double bottom = bounds.getBottom();
            if ((isCenter || cp.isLeft()) && left < this._padLeft) {
                this._padLeft = left;
            }
            if ((isCenter || cp.isRight()) && (parentRightSpace = parentSize.getWidth() - right) < this._padRight) {
                this._padRight = parentRightSpace;
            }
            if ((isCenter || cp.isUpper()) && top < this._padUp) {
                this._padUp = top;
            }
            if (!isCenter && !cp.isLower() || !((parentBottomSpace = parentSize.getHeight() - bottom) < this._padDown)) continue;
            this._padDown = parentBottomSpace;
        }
    }

    private void _padConstrainToParentTopLeft(LayoutItem[] items) {
        ControlPoint cp = this._dragged;
        boolean isCenter = cp.getType() == 5;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            Rectangle2D bounds = curr.getItemBounds();
            Dimension2D parentSize = curr.getItemParent().getItemSize();
            double left = bounds.getX();
            double top = bounds.getY();
            double right = bounds.getRight();
            double bottom = bounds.getBottom();
            if ((isCenter || cp.isLeft()) && left < this._padLeft) {
                this._padLeft = left;
            }
            if (!isCenter && !cp.isUpper() || !(top < this._padUp)) continue;
            this._padUp = top;
        }
    }

    private void _padConstrainToChildren(LayoutItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            if (curr.getItemCount() < 1) continue;
            LayoutItem[] children = curr.getItems();
            Dimension2D parentSize = curr.getItemSize();
            Rectangle2D union = children[0].getItemBounds();
            for (int j = 1; j < children.length; ++j) {
                union.add(children[j].getItemBounds());
            }
            this._reducePadFromRectangle(parentSize.getWidth(), parentSize.getHeight(), union.getWidth(), union.getHeight());
        }
    }

    private void _padConstrainToItem(LayoutItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            Dimension2D minSize = BoundsTool.getMinimumSize(curr);
            if (minSize == null) continue;
            Dimension2D currSize = curr.getItemSize();
            this._reducePadFromRectangle(currSize.getWidth(), currSize.getHeight(), minSize.getWidth(), minSize.getHeight());
        }
    }

    private void _padConstrainToGlobalMin(LayoutItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            Dimension2D currSize = curr.getItemSize();
            this._reducePadFromRectangle(currSize.getWidth(), currSize.getHeight(), this._minWidth, this._minHeight);
        }
    }

    private void _calculatePad(LayoutItem[] items) {
        if ((this._mode & 2) != 0) {
            this._padConstrainToParent(items);
        }
        if ((this._mode & 0x20) != 0) {
            this._padConstrainToParentTopLeft(items);
        }
        if ((this._mode & 1) != 0) {
            if ((this._mode & 8) != 0) {
                this._padConstrainToChildren(items);
            }
            if ((this._mode & 0x10) != 0) {
                this._padConstrainToItem(items);
            }
            this._padConstrainToGlobalMin(items);
        }
        this._padDirty = false;
    }

    private ControlPoint _adjustUndoControlPoint(double width, double height, ControlPoint old) {
        boolean flipY;
        boolean flipX = width < 0.0;
        boolean bl = flipY = height < 0.0;
        if (!flipX && !flipY) {
            return old;
        }
        int newType = 0;
        switch (old.getType()) {
            case 5: {
                break;
            }
            case 4: {
                if (!flipX) break;
                newType = 6;
                break;
            }
            case 6: {
                if (!flipX) break;
                newType = 4;
                break;
            }
            case 9: {
                if (!flipY) break;
                newType = 1;
                break;
            }
            case 1: {
                if (!flipY) break;
                newType = 9;
                break;
            }
            case 8: {
                newType = flipX ? (flipY ? 2 : 10) : 0;
                break;
            }
            case 10: {
                newType = flipX ? (flipY ? 0 : 8) : 2;
                break;
            }
            case 0: {
                newType = flipX ? (flipY ? 10 : 2) : 8;
                break;
            }
            case 2: {
                newType = flipX ? (flipY ? 8 : 0) : 10;
            }
        }
        return new ControlPoint(newType, 0.0, 0.0, null);
    }
}

