/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class LocalizedEdit
extends AbstractUndoableEdit {
    @Override
    public final String getPresentationName() {
        return this.getPresentationName(Locale.getDefault());
    }

    @Override
    public final String getUndoPresentationName() {
        return this.getUndoPresentationName(Locale.getDefault());
    }

    @Override
    public final String getRedoPresentationName() {
        return this.getRedoPresentationName(Locale.getDefault());
    }

    public final String getPresentationName(Locale locale) {
        String key = this.getBaseKey();
        if (key == null) {
            return "";
        }
        ResourceBundle bundle = this._getBundle(locale);
        return bundle.getString(key);
    }

    public final String getUndoPresentationName(Locale locale) {
        String key = this.getUndoKey();
        if (key == null) {
            return "";
        }
        ResourceBundle bundle = this._getBundle(locale);
        return bundle.getString(key);
    }

    public final String getRedoPresentationName(Locale locale) {
        String key = this.getRedoKey();
        if (key == null) {
            return "";
        }
        ResourceBundle bundle = this._getBundle(locale);
        return bundle.getString(key);
    }

    public String getBundleClassName() {
        return "oracle.bali.jle.tool.undo.resource.JLEUndoBundle";
    }

    public abstract String getBaseKey();

    public final String getUndoKey() {
        return "UNDO_" + this.getBaseKey();
    }

    public final String getRedoKey() {
        return "REDO_" + this.getBaseKey();
    }

    private ResourceBundle _getBundle(Locale locale) {
        return ResourceBundle.getBundle(this.getBundleClassName(), locale);
    }
}

