/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.test;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.app.cubeddl.CubeParser;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cube.model.Cube;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.db.CubeDimensionList;
import oracle.olap.db.CubeList;
import oracle.olap.db.model.AbstractMappableSchemaObjectWithDesc;

public class CubeUtil {
    private static final String PATH = "c:\\raptor\\trunk\\olap\\src\\oracle\\olap\\app\\cubeddl\\test\\";
    private static final String DATABASE = "adc6141176:1521:omain3";
    private static final String[][] AliasList = new String[][]{{"u", "user"}, {"p", "password"}, {"pwd", "password"}, {"c", "conn"}, {"f", "file"}, {"o", "option"}, {"r", "result"}};
    private static List<CubeDimension> dimensions = new ArrayList<CubeDimension>();
    private static List<Cube> cubes = new ArrayList<Cube>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Run(String[] stringArray) {
        StackTraceElement[] stackTraceElementArray;
        Closeable closeable;
        StackTraceElement[] stackTraceElementArray2;
        String string;
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            if ((string = stringArray[n++]).startsWith("-")) {
                string = string.substring(1, string.length()).toLowerCase();
            }
            string = CubeUtil.LookupAlias(string);
            stackTraceElementArray2 = "";
            if (n < stringArray.length) {
                stackTraceElementArray2 = stringArray[n++];
            }
            if (string.equals("cmd")) {
                stackTraceElementArray2 = CubeUtil.LookupAlias((String)stackTraceElementArray2);
            }
            while (n < stringArray.length && !stringArray[n].startsWith("-")) {
                stackTraceElementArray2 = (String)stackTraceElementArray2 + " " + stringArray[n++];
            }
            hashMap.put(string.toLowerCase(), stackTraceElementArray2.trim());
        }
        String string2 = (String)hashMap.get("user");
        string = (String)hashMap.get("password");
        stackTraceElementArray2 = (String)hashMap.get("conn");
        String string3 = (String)hashMap.get("file");
        String string4 = (String)hashMap.get("option");
        String string5 = (String)hashMap.get("result");
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        hashMap2.put("logSourceSQL".toLowerCase(), false);
        hashMap2.put("skipExecuteSQL".toLowerCase(), false);
        hashMap2.put("logOLAPISQL".toLowerCase(), false);
        String string6 = (String)hashMap.get("sqldev_olap.cache");
        if (string6.equalsIgnoreCase("false")) {
            System.setProperty("sqldev_olap.cache", "false");
        }
        if (string4 != null) {
            String[] stringArray2 = string4.split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                hashMap2.put(stringArray2[i].toLowerCase(), true);
            }
        }
        boolean bl2 = false;
        Object v = hashMap2.get("logSourceSql".toLowerCase());
        if (v != null && v instanceof Boolean && ((Boolean)v).booleanValue()) {
            bl2 = true;
        }
        if (string2 == null || string == null || stackTraceElementArray2 == null) {
            System.out.println("Cube Utility, Usage example");
            System.out.println("cubeutil -user scott -password tiger -conn localhost:1521:orcl -file c.sql");
            return false;
        }
        CubeParser.SetOptions(hashMap2);
        boolean bl3 = true;
        if (((Boolean)hashMap2.get("skipExecuteSQL".toLowerCase())).booleanValue()) {
            bl3 = false;
        }
        DatabaseImpl databaseImpl = new DatabaseImpl();
        if (bl3) {
            try {
                databaseImpl.getConnection(string2, string, (String)stackTraceElementArray2);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                System.exit(1);
            }
        }
        PrintStream printStream = System.out;
        if (string5 != null) {
            closeable = null;
            try {
                closeable = new PrintStream(new FileOutputStream(string5));
                System.setOut((PrintStream)closeable);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                stackTraceElementArray = iOException.getStackTrace();
                System.out.println(stackTraceElementArray.toString());
            }
        }
        closeable = System.in;
        if (string3 != null && string3.trim().length() > 0) {
            closeable = CubeUtil.class.getResourceAsStream(string3);
        }
        String string7 = "ConnStore";
        stackTraceElementArray = stackTraceElementArray2;
        oracle.javatools.db.Database database = null;
        try {
            database = DatabaseFactory.createStandaloneDatabase((String)stackTraceElementArray, (Connection)databaseImpl.getConnection());
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
            System.out.println("Exception occurred: Exception is " + (Object)((Object)dBException));
        }
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)database;
        Logger.getLogger(DBUtil.class.getName()).setLevel(Level.OFF);
        String string8 = null;
        try {
            string8 = databaseImpl.getUser().toUpperCase();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        oracle.javatools.db.Schema schema = new oracle.javatools.db.Schema(string8);
        CubeDimensionList cubeDimensionList = new CubeDimensionList(oracleDatabaseImpl, schema, null);
        CubeList cubeList = new CubeList(oracleDatabaseImpl, schema);
        Object var25_32 = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        String string9 = null;
        do {
            try {
                Object object;
                Object object2;
                Object object3;
                String string10;
                Object object4;
                n2 = ((InputStream)closeable).read();
                if (n2 == 10) {
                    if (stringBuffer.toString().trim().length() == 0) {
                        stringBuffer = new StringBuffer();
                    }
                    if (stringBuffer.toString().trim().startsWith("--")) {
                        stringBuffer = new StringBuffer();
                    }
                }
                if (n2 != 59) {
                    stringBuffer.append((char)n2);
                    continue;
                }
                string9 = stringBuffer.toString();
                string9 = string9.trim();
                while (string9.startsWith("\n")) {
                    string9 = string9.substring(0, string9.length() - 1);
                    string9 = string9.trim();
                }
                stringBuffer = new StringBuffer();
                if (bl2) {
                    System.out.println("SQL>" + string9 + ";");
                }
                if (string9.trim().toUpperCase().startsWith("SELECT")) {
                    object4 = string9.trim().split(" ");
                    string10 = "from";
                    object3 = "";
                    for (int i = 0; i < ((String[])object4).length; ++i) {
                        if (!object4[i].toUpperCase().equals("FROM") || i + 1 >= ((String[])object4).length) continue;
                        string10 = object4[i];
                        object3 = object4[i + 1];
                        break;
                    }
                    object2 = null;
                    try {
                        ResultSetMetaData resultSetMetaData;
                        if (databaseImpl.getConnection() == null) continue;
                        object2 = databaseImpl.getConnection().createStatement();
                        object = object2.executeQuery(string9);
                        String string11 = "";
                        if (object != null && (resultSetMetaData = object.getMetaData()) != null) {
                            int n3;
                            int n4;
                            int n5;
                            int n6 = resultSetMetaData.getColumnCount();
                            for (n5 = 1; n5 <= n6; ++n5) {
                                String string12 = resultSetMetaData.getColumnName(n5);
                                System.out.print(string12);
                                n4 = resultSetMetaData.getColumnDisplaySize(n5);
                                for (n3 = string12.length(); n3 < n4 + 1; ++n3) {
                                    System.out.print(" ");
                                }
                            }
                            System.out.println();
                            for (n5 = 1; n5 <= n6; ++n5) {
                                int n7 = resultSetMetaData.getColumnDisplaySize(n5);
                                for (n4 = 0; n4 < n7; ++n4) {
                                    System.out.print("-");
                                }
                                System.out.print(" ");
                            }
                            System.out.println();
                            while (object.next()) {
                                for (n5 = 1; n5 <= n6; ++n5) {
                                    String string13 = object.getString(n5);
                                    System.out.print(string13);
                                    n4 = resultSetMetaData.getColumnDisplaySize(n5);
                                    for (n3 = string13.length(); n3 < n4 + 1; ++n3) {
                                        System.out.print(" ");
                                    }
                                }
                                System.out.println();
                            }
                        }
                        System.out.println();
                        continue;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        continue;
                    }
                    finally {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                }
                if (string9.trim().toUpperCase().startsWith("INSERT")) {
                    CubeUtil.execDML(databaseImpl, string9);
                    continue;
                }
                if (string9.trim().toUpperCase().startsWith("UPDATE")) {
                    CubeUtil.execDML(databaseImpl, string9);
                    continue;
                }
                if (string9.trim().toUpperCase().startsWith("TRUNCATE")) {
                    CubeUtil.execDML(databaseImpl, string9);
                    continue;
                }
                if (string9.trim().toUpperCase().startsWith("DELETE")) {
                    CubeUtil.execDML(databaseImpl, string9);
                    continue;
                }
                if (string9.trim().equalsIgnoreCase("quit")) {
                    databaseImpl.close();
                    System.exit(0);
                    continue;
                }
                object4 = new Schema(string2);
                string10 = null;
                if (!string9.toUpperCase().startsWith("DROP")) {
                    string10 = CubeUtil.getObject(string9, cubeDimensionList, cubeList);
                }
                object3 = new CubeDDLStatements((SystemObject)string10, (SystemObject)string10, string9);
                object2 = new MetadataContext(database, (CubeDDLStatements)object3);
                ((MetadataContext)object2).setDatabase(databaseImpl);
                ((MetadataContext)object2).setSchema((Schema)object4);
                ((MetadataContext)object2).put("dimensions", dimensions);
                object = new MetadataXML((MetadataContext)object2);
                ((MetadataXML)object).parse();
                if (string9.toLowerCase().startsWith("set")) continue;
                ((MetadataXML)object).executeSQL(bl3);
            }
            catch (Throwable throwable) {
                System.err.println("########## Failed on ##############");
                System.err.println(string9);
                System.err.println("########## Failed on ##############");
                System.err.flush();
                throwable.printStackTrace();
                bl = false;
                break;
            }
        } while (n2 != -1);
        databaseImpl.close();
        System.setOut(printStream);
        return bl;
    }

    private static SystemObject getObject(String string, CubeDimensionList cubeDimensionList, CubeList cubeList) throws DBException, SQLException, IOException, JAXBException {
        String string2;
        AbstractMappableSchemaObjectWithDesc abstractMappableSchemaObjectWithDesc = null;
        if (string.startsWith("SET") || string.startsWith("CREATE")) {
            return abstractMappableSchemaObjectWithDesc;
        }
        if (CubeUtil.getObjectType(string).equals("CUBE DIMENSION") && (abstractMappableSchemaObjectWithDesc = CubeUtil.findDimension(cubeDimensionList, string2 = CubeUtil.getObjectName(string))) == null) {
            dimensions = cubeDimensionList.getCubeDimensions();
            abstractMappableSchemaObjectWithDesc = CubeUtil.findDimension(cubeDimensionList, string2);
        }
        if (CubeUtil.getObjectType(string).equals("CUBE")) {
            string2 = CubeUtil.getObjectName(string);
            boolean bl = false;
            for (Cube cube : cubes) {
                String string3 = cube.getName();
                if (!string3.equalsIgnoreCase(string2)) continue;
                cubeList.build(cube, false);
                bl = true;
                abstractMappableSchemaObjectWithDesc = cube;
                break;
            }
            if (!bl) {
                cubes = cubeList.getCubes();
            }
        }
        return abstractMappableSchemaObjectWithDesc;
    }

    private static CubeDimension findDimension(CubeDimensionList cubeDimensionList, String string) throws DBException, SQLException, IOException, JAXBException {
        for (CubeDimension cubeDimension : dimensions) {
            String string2 = cubeDimension.getName();
            if (!string2.equals(string.toUpperCase())) continue;
            cubeDimensionList.build(cubeDimension, false);
            return cubeDimension;
        }
        return null;
    }

    private static String getObjectType(String string) {
        String string2 = "CUBE";
        if (string.toUpperCase().indexOf(" CUBE DIMENSION ") > 0) {
            string2 = "CUBE DIMENSION";
        } else if (string.toUpperCase().indexOf(" ANALYTIC WORKSPACE ") > 0) {
            string2 = "ANALYTIC WORKSPACE";
        } else if (string.toUpperCase().indexOf(" MEASURE FOLDER ") > 0) {
            string2 = "MEASURE FOLDER";
        }
        return string2;
    }

    private static String getObjectName(String string) {
        String string2 = "";
        String[] stringArray = string.split(" ");
        if (stringArray[0].toUpperCase().startsWith("CREATE") || stringArray[0].toUpperCase().startsWith("ALTER")) {
            string2 = stringArray[2];
            String string3 = stringArray[2].toUpperCase();
            if (stringArray.length > 2 && (string3.equals("DIMENSION") || string3.equals("WORKSPACE") || string3.equals("FOLDER"))) {
                string2 = stringArray[3];
            }
        }
        return string2;
    }

    private static void execDML(Database database, String string) throws Exception {
        database.executeSQL(string);
    }

    private static String LookupAlias(String string) {
        for (int i = 0; i < AliasList.length; ++i) {
            if (!string.equals(AliasList[i][0])) continue;
            return AliasList[i][1];
        }
        return string;
    }

    public static void testCreate() {
        String[] stringArray = new String[]{"-user", "global", "-password", "global", "-conn", DATABASE, "-file", "c:\\raptor\\trunk\\olap\\src\\oracle\\olap\\app\\cubeddl\\test\\\\cubecreate.sql", "-option", "szkipExecuteSQL,logOLAPISQL,lZogPreSQL"};
        CubeUtil.Run(stringArray);
    }

    public static void testDrop() {
        String[] stringArray = new String[]{"-user", "global", "-password", "global", "-conn", DATABASE, "-file", "c:\\dev\\test\\plugin11\\src\\awm\\plugin\\cubedml\\cubedrop.sql", "-option", "szkipExecuteSQL,lZogOLAPISQL"};
        CubeUtil.Run(stringArray);
    }

    public static void testDML() {
        String[] stringArray = new String[]{"-user", "global", "-password", "global", "-conn", DATABASE, "-file", "c:\\dev\\test\\plugin11\\src\\awm\\plugin\\cubedml\\cubedml.sql"};
        CubeUtil.Run(stringArray);
    }

    public static void testSelect() {
        String[] stringArray = new String[]{"-user", "global", "-password", "global", "-conn", DATABASE, "-file", "c:\\dev\\test\\plugin11\\src\\awm\\plugin\\cubedml\\cubeselect.sql"};
        CubeUtil.Run(stringArray);
    }

    public static void testCubeAddMeasure() {
        String[] stringArray = new String[]{"-user", "global", "-password", "global", "-conn", DATABASE, "-file", "c:\\dev\\test\\plugin11\\src\\awm\\plugin\\cubedml\\cube_derived_measure.sql"};
        CubeUtil.Run(stringArray);
    }

    public static void main(String[] stringArray) {
        CubeUtil.testCreate();
    }
}

