/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.util.Map;
import java.util.logging.Logger;
import oracle.olap.app.syntaxparser.ChoiceNode;
import oracle.olap.app.syntaxparser.ChoicePlaceHolderNode;
import oracle.olap.app.syntaxparser.FlatNode;
import oracle.olap.app.syntaxparser.NestedParamProcessor;
import oracle.olap.app.syntaxparser.NodeFlattener;
import oracle.olap.app.syntaxparser.ParseNode;

class FlatListMerger
extends NodeFlattener {
    private static final Logger LOG = Logger.getLogger(FlatListMerger.class.getName());
    FlatNode current;

    public FlatListMerger(FlatNode flatNode, Map<String, ParseNode> map) {
        this.current = flatNode;
        this.paramPatterns = map;
    }

    @Override
    protected NodeFlattener.Handle handleNode(ParseNode parseNode, String string, NodeFlattener.Handle handle) {
        if (handle == null) {
            handle = new NodeFlattener.Handle();
        }
        handle.replacement = parseNode;
        ParseNode parseNode2 = (ParseNode)this.paramPatterns.get(string);
        if (this.current != null && parseNode2 != null && parseNode2.getPatternType() == ParseNode.PatternType.CHOICE) {
            int n = parseNode2.getOffset();
            if (this.current instanceof ChoiceNode && this.current.getParamName().equals(string)) {
                ChoiceNode choiceNode = (ChoiceNode)this.current;
                FlatNode flatNode = choiceNode.getBranch(n);
                this.nestedProcessor = flatNode != null ? new NestedParamProcessor((NodeFlattener)new FlatListMerger(flatNode, this.paramPatterns), string, (Map<String, ParseNode>)this.paramPatterns) : new NestedParamProcessor(new NodeFlattener(string), new ChoicePlaceHolderNode(choiceNode, n), (Map<String, ParseNode>)this.paramPatterns);
                handle.flatNode = this.current;
            } else {
                handle = super.handleNode(parseNode, string, handle);
                FlatNode flatNode = this.current.prev;
                flatNode.linkNext(handle.flatNode);
                if (this.current.matches(parseNode) == 0) {
                    handle.flatNode.linkNext(this.current);
                } else {
                    handle.flatNode.linkNext(this.current.getNext());
                }
                if (handle.flatNode == null) {
                    LOG.severe(String.format("Setting current [%s] to null", this.current));
                }
                this.current = handle.flatNode;
            }
        } else {
            handle = super.handleNode(parseNode, string, handle);
        }
        return handle;
    }

    @Override
    public ParseNode processNode(ParseNode parseNode) {
        return super.processNode(parseNode);
    }

    @Override
    protected void processHandle(NodeFlattener.Handle handle) {
        if (this.current == null) {
            super.processHandle(handle);
            return;
        }
        if (handle == null) {
            return;
        }
        if (this.nestedProcessor == null) {
            if (this.current != null) {
                if (this.current.getNext() == null) {
                    this.prev = this.current;
                }
                this.current = this.current.getNext();
            } else {
                LOG.warning(String.format("Could not merge %s into pattern", handle.flatNode));
            }
        }
        if (this.flatList == null) {
            this.flatList = handle.flatNode;
        }
        if (this.current != null) {
            this.prev = handle.flatNode;
        }
    }
}

