/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.aw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.ide.Ide;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.property.PropertyFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.util.OLAPNameValidator;
import oracle.olap.util.UIStringUtils;

public class NewAWDialog
extends JDialog
implements ActionListener {
    private static final String DEFAULT_OPTION = OLAPArb.get("NEWAW_DEFAULT_TABLESPACE_TEXT");
    private NewAWDialog currentInstance = null;
    private String owner = null;
    private DBObjectProvider prov = null;
    private boolean m_clickedOK = false;
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private JPanel mainPanel;
    private JButton m_btnOK;
    private JButton m_btnCancel;
    private JButton m_btnHelp;
    private DBObjectChooser cmbTablespace;
    private JTextField awName;

    public NewAWDialog(Frame frame, DBObjectProvider dBObjectProvider, String string) {
        super(frame, OLAPArb.get("NEWAW_DIALOG_TITLE"), true);
        this.setName("NewAWDialog");
        this.currentInstance = this;
        this.owner = string;
        this.prov = dBObjectProvider;
        this.initDialog();
        this.initializeFields();
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n3 = Math.max(dimension.width, n3);
        n4 = Math.max(dimension.height, n4);
        if (n2 != n3 || n != n4) {
            this.setSize(n3, n4);
        }
    }

    private void initDialog() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setName("mainPanel");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "olap_new_analytic_workspace");
        this.m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.setName("m_btnOK");
        this.m_btnOK.setActionCommand("OK_ID");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.setName("m_btnCancel");
        this.m_btnCancel.setActionCommand("CANCEL_ID");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.setName("m_btnHelp");
        this.m_btnHelp.setActionCommand("HELP_ID");
        this.m_btnHelp.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_btnOK);
        JLabel jLabel = new JLabel(OLAPArb.get("NEWAW_TABLESPACE_LABEL"));
        JLabel jLabel2 = new JLabel(OLAPArb.get("NEWAW_NAME_LABEL"));
        this.mainPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.awName = new JTextField(1024);
        this.awName.setName("awName");
        this.awName.setMinimumSize(new Dimension(250, 20));
        UIStringUtils.setKeyAdapterToNameField(this.awName);
        this.mainPanel.add((Component)this.awName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 4);
        this.cmbTablespace = new DBObjectChooser(new String[]{"TABLESPACE"});
        this.cmbTablespace.setName("cmbTablespace");
        this.mainPanel.add((Component)this.cmbTablespace, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 4, 0, 4);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.m_btnHelp, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.m_btnOK, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.m_btnCancel, DialogButtonBar.CONSTRAINT_CANCEL);
        this.mainPanel.add((Component)dialogButtonBar, gridBagConstraints);
        this.add(this.mainPanel);
        this.registerKeyboardActions();
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void initializeFields() {
        this.cmbTablespace.setFilter((DBObjectFilter)new PropertyFilter("properties/TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT));
        this.cmbTablespace.setProvider(this.prov);
        this.cmbTablespace.setNullText(DEFAULT_OPTION);
        this.cmbTablespace.setDBObjectID(null);
    }

    public String getAWName() {
        String string = null;
        string = this.awName.getText().trim();
        return string;
    }

    public String getTableSpaceName() {
        String string = null;
        DBObject dBObject = this.cmbTablespace.getDBObject();
        if (dBObject != null) {
            string = dBObject.getName();
        }
        return string;
    }

    public boolean isOKSelected() {
        return this.m_clickedOK;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            if (this.validateFields()) {
                this.m_clickedOK = true;
                this.currentInstance.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.m_clickedOK = false;
            this.currentInstance.setVisible(false);
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.mainPanel);
        }
    }

    private boolean validateFields() {
        boolean bl = true;
        String string = this.getAWName();
        string = string.toUpperCase();
        String string2 = null;
        String string3 = OLAPArb.get("NEWAW_ERROR_TITLE");
        String string4 = null;
        if (!OLAPNameValidator.isNameValid(string, 26)) {
            string2 = OLAPArb.get("NEWAW_ERROR_MSG_INVALID_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
            bl = false;
            return bl;
        }
        Database database = (Database)this.prov;
        DBUtil dBUtil = DBUtil.getInstance((Connection)database.getConnection());
        if (!OLAPNameValidator.isAWNameUnique(string, dBUtil, this.owner)) {
            string2 = OLAPArb.get("NEWAW_ERROR_MSG_DUPLICATE_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
            bl = false;
            return bl;
        }
        return bl;
    }
}

