/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.db.view.DBObjectInitializer;

public class CubeInitializer
implements DBObjectInitializer<Cube> {
    @Override
    public void init(DBObjectProvider dBObjectProvider, Cube cube, Cube cube2) {
        Cube cube3 = cube2;
        if (cube == null) {
            CubeAWUtil.setAWName(cube3);
        }
        cube3.generateDescriptions();
        cube3.setCompressed();
        cube3.setMeasureStorage("SHARED");
        cube3.setSqlCubeStorageType("NUMBER");
        this.createMeasure(dBObjectProvider, cube3);
        this.createBuildSpecification(dBObjectProvider, cube3);
    }

    private void createMeasure(DBObjectProvider dBObjectProvider, Cube cube) {
        if (cube.getMeasures().length == 0) {
            CubeMeasure cubeMeasure = (CubeMeasure)dBObjectProvider.getObjectFactory().newObject(CubeMeasure.class, (DBObject)cube);
            String string = "MEASURE1";
            cubeMeasure.setName(string);
            cubeMeasure.setDefault(true);
            cubeMeasure.setDataType("NUMBER");
            cubeMeasure.setMeasureAllowAutoDataTypeChange(true);
            cubeMeasure.generateDescriptions();
            cube.addMeasure(cubeMeasure);
        }
    }

    private void createBuildSpecification(DBObjectProvider dBObjectProvider, Cube cube) {
        if (cube.getBuildSpecifications().length == 0) {
            CubeBuildSpecification cubeBuildSpecification = (CubeBuildSpecification)dBObjectProvider.getObjectFactory().newObject(CubeBuildSpecification.class, (DBObject)cube);
            String string = "BUILD SPEC LOAD_AND_AGGREGATE(LOAD, SOLVE)";
            cubeBuildSpecification.initBuildSpecification(string);
            cubeBuildSpecification.setIsDefault(true);
            cube.addBuildSpecification(cubeBuildSpecification);
            cubeBuildSpecification = (CubeBuildSpecification)dBObjectProvider.getObjectFactory().newObject(CubeBuildSpecification.class, (DBObject)cube);
            string = String.format("BUILD SPEC %s(CLEAR, LOAD, SOLVE)", "SYS_DEFAULT");
            cubeBuildSpecification.initBuildSpecification(string);
            cube.addBuildSpecification(cubeBuildSpecification);
        }
    }
}

