/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.button.ButtonBar;
import oracle.olap.app.Resources;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.cube.partition.CubeHierarchyOrderDialog;
import oracle.olap.cube.partition.CubePartitionOrderPanel;
import oracle.olap.cube.partition.OrderedPanel;
import oracle.olap.cube.partition.PanelComponentUIHelper;

public class CubeHierarchyOrderPanel
extends JPanel
implements OrderedPanel {
    private Resources resources;
    private FetchIcon fetchIcon;
    private List<String> hierarchyNames;
    private CubeHierarchyOrderDialog parentDialog;
    private JTable hierarchyTable;
    private DefaultTableModel tableModel;
    private int hierarchyCount;

    public CubeHierarchyOrderPanel(CubeHierarchyOrderDialog cubeHierarchyOrderDialog, List<String> list, Resources resources, FetchIcon fetchIcon) {
        this.parentDialog = cubeHierarchyOrderDialog;
        this.hierarchyNames = list;
        this.resources = resources;
        this.fetchIcon = fetchIcon;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.hierarchyCount = this.hierarchyNames.size();
        if (this.hierarchyCount == 0) {
            this.hierarchyCount = 1;
        }
        this.tableModel = new DefaultTableModel(new String[]{this.resources.getString("CUBE.PARTITION.HIERARCHY.ORDER.PANEL_HIERARCHY_NAMES.LABEL")}, this.hierarchyCount);
        this.hierarchyTable = new JTable(this.tableModel);
        int n = 0;
        for (String object2 : this.hierarchyNames) {
            this.hierarchyTable.setValueAt(object2, n, 0);
            ++n;
        }
        this.hierarchyTable.setRowSelectionInterval(0, 0);
        CubePartitionOrderPanel cubePartitionOrderPanel = new CubePartitionOrderPanel(this, this.fetchIcon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.hierarchyTable);
        jPanel.add((Component)new JLabel(this.resources.getString("CUBE.PARTITION.HIERARCHY.ORDER.PANEL_ORDER_INSTRUCTIONS")), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)cubePartitionOrderPanel, "East");
        this.add((Component)jPanel, gridBagConstraints);
        PanelComponentUIHelper panelComponentUIHelper = new PanelComponentUIHelper(this.resources);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        ButtonBar buttonBar = new ButtonBar();
        JButton jButton = panelComponentUIHelper.newJButton("MODELER.CUBE.PARTITION.ORDER_HIERARCHIES.OK.BUTTON");
        JButton jButton2 = panelComponentUIHelper.newJButton("MODELER.CUBE.PARTITION.ORDER_HIERARCHIES.CANCEL.BUTTON");
        buttonBar.add((Component)jButton);
        buttonBar.add((Component)jButton2);
        this.add((Component)buttonBar, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeHierarchyOrderPanel.this.parentDialog.setOrderedHierarchies(CubeHierarchyOrderPanel.this.getOrderedHierarchies());
                CubeHierarchyOrderPanel.this.parentDialog.fieldValueChanged();
                CubeHierarchyOrderPanel.this.parentDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeHierarchyOrderPanel.this.parentDialog.dispose();
            }
        });
    }

    @Override
    public void upArrowSelected() {
        int n = this.hierarchyTable.getSelectedRow();
        if (n == -1 || n == 0) {
            return;
        }
        String string = (String)this.hierarchyTable.getValueAt(n - 1, 0);
        String string2 = (String)this.hierarchyTable.getValueAt(n, 0);
        this.hierarchyTable.setValueAt(string2, n - 1, 0);
        this.hierarchyTable.setValueAt(string, n, 0);
        this.hierarchyTable.setRowSelectionInterval(n - 1, n - 1);
    }

    @Override
    public void downArrowSelected() {
        int n = this.hierarchyTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        if (n >= this.hierarchyCount - 1) {
            return;
        }
        String string = (String)this.hierarchyTable.getValueAt(n + 1, 0);
        String string2 = (String)this.hierarchyTable.getValueAt(n, 0);
        this.hierarchyTable.setValueAt(string2, n + 1, 0);
        this.hierarchyTable.setValueAt(string, n, 0);
        this.hierarchyTable.setRowSelectionInterval(n + 1, n + 1);
    }

    public List<String> getOrderedHierarchies() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.hierarchyCount; ++i) {
            arrayList.add((String)this.hierarchyTable.getValueAt(i, 0));
        }
        return arrayList;
    }
}

