/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.olap.OLAPArb;
import oracle.olap.cubedimension.CubeDimensionRemoveChildDispatcher;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.db.view.ChildObjectEditorPanel2;

public class CubeDimensionHierarchyTableEditorPanel<T extends CubeDimensionHierarchy, P extends CubeDimension>
extends ChildObjectEditorPanel2<T, P> {
    private JLabel m_lblName;
    private DBObjectProvider m_prov;
    private TreeSet<CubeDimensionHierarchy> m_invalidHierarchies = new TreeSet(new DBObjectComparator());
    private DefaultListModel m_selectedObjectListModel;
    private DefaultListModel m_allObjectListModel;
    private JRadioButton m_levelTypeButton;
    private JRadioButton m_valueTypeButton;
    private JCheckBox m_raggedCheckBox;
    private JCheckBox m_skipLevelCheckBox;
    private Shuttle shuttle;
    private JList allObjectList;
    private JList selectedObjectList;
    private boolean isInitializing = false;

    public CubeDimensionHierarchyTableEditorPanel() {
        super("CubeDimensionHierarchyTableEditorPanel", "DIM_HIERARCHY");
        this.layoutComponents();
        CubeDimensionRemoveChildDispatcher cubeDimensionRemoveChildDispatcher = CubeDimensionRemoveChildDispatcher.getInstance();
        cubeDimensionRemoveChildDispatcher.registerObserver(this);
    }

    private void loadHierarchy(CubeDimensionHierarchy cubeDimensionHierarchy) {
        this.loadHierarchyData();
        this.hierarchyTypeAction();
    }

    private void loadHierarchyData() {
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.m_lblName.setEnabled(false);
            this.getNameField().setEnabled(false);
            this.m_selectedObjectListModel.clear();
            this.m_allObjectListModel.clear();
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, ((CubeDimension)this.getUpdatedObject()).getLevels());
            for (CubeDimensionLevel cubeDimensionLevel : arrayList) {
                this.m_allObjectListModel.addElement(cubeDimensionLevel.getName());
            }
        } else {
            String string = ((CubeDimensionHierarchy)this.getChildObject()).getName();
            if (!this.m_invalidHierarchies.contains(this.getChildObject())) {
                // empty if block
            }
            ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
            childNameObjectEditorContext.setEditingState(1);
            this.getNameField().setText(string);
            this.getNameField().setEnabled(true);
            childNameObjectEditorContext.setEditingState(0);
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, ((CubeDimension)this.getUpdatedObject()).getLevels());
            this.m_selectedObjectListModel.clear();
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : ((CubeDimensionHierarchy)this.getChildObject()).getHierarchyLevelsReverse()) {
                CubeDimensionLevel cubeDimensionLevel = cubeDimensionHierarchyLevel.getLevel();
                String string2 = cubeDimensionLevel.getName();
                this.m_selectedObjectListModel.addElement(string2);
                arrayList.remove(cubeDimensionLevel);
            }
            this.m_allObjectListModel.clear();
            for (CubeDimensionLevel cubeDimensionLevel : arrayList) {
                this.m_allObjectListModel.addElement(cubeDimensionLevel.getName());
            }
            this.m_levelTypeButton.setSelected(((CubeDimensionHierarchy)this.getChildObject()).getHierarchyLevelType());
            this.m_valueTypeButton.setSelected(((CubeDimensionHierarchy)this.getChildObject()).getHierarchyValueType());
            boolean bl = ((CubeDimensionHierarchy)this.getChildObject()).isNotSkipLevel();
            this.m_skipLevelCheckBox.setSelected(!bl);
            bl = ((CubeDimensionHierarchy)this.getChildObject()).isNotRagged();
            this.m_raggedCheckBox.setSelected(!bl);
            this.isInitializing = true;
            if (((CubeDimensionHierarchy)this.getChildObject()).getNewObject()) {
                CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
                if (cubeDimension.getDimensionType() != null && cubeDimension.getDimensionType().equalsIgnoreCase("TIME")) {
                    this.m_skipLevelCheckBox.setSelected(false);
                    this.m_raggedCheckBox.setSelected(false);
                }
                this.m_levelTypeButton.setEnabled(true);
                this.m_valueTypeButton.setEnabled(true);
            } else {
                this.m_levelTypeButton.setEnabled(false);
                this.m_valueTypeButton.setEnabled(false);
            }
            this.isInitializing = false;
        }
        this.validate();
        this.repaint();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)this.getChildObject();
        this.commit(cubeDimensionHierarchy);
        CubeDimension cubeDimension = cubeDimensionHierarchy.getCubeDimension();
        if (cubeDimension.findHierarchy(cubeDimensionHierarchy.getName()) == null) {
            cubeDimension.addHierarchy(cubeDimensionHierarchy);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void commit(CubeDimensionHierarchy cubeDimensionHierarchy) throws TraversalException {
        Object object;
        Object object2;
        Object object3;
        super.commitPanel();
        if (this.m_invalidHierarchies.contains(cubeDimensionHierarchy)) {
            this.m_invalidHierarchies.remove(cubeDimensionHierarchy);
        }
        cubeDimensionHierarchy.setHierarchyLevelType(this.m_levelTypeButton.isSelected());
        cubeDimensionHierarchy.setHierarchyValueType(this.m_valueTypeButton.isSelected());
        cubeDimensionHierarchy.setNotSkipLevel(!this.m_skipLevelCheckBox.isSelected());
        cubeDimensionHierarchy.setNotRagged(!this.m_raggedCheckBox.isSelected());
        Enumeration enumeration = this.m_selectedObjectListModel.elements();
        ArrayList<CubeDimensionLevel> arrayList = new ArrayList<CubeDimensionLevel>();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            object2 = ((CubeDimension)this.getUpdatedObject()).findLevel((String)object3);
            arrayList.add((CubeDimensionLevel)object2);
        }
        Collections.reverse(arrayList);
        if (cubeDimensionHierarchy.isChanged(arrayList)) {
            object3 = this.saveHierarchicalLevelVisibility(cubeDimensionHierarchy);
            object2 = new ArrayList();
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
                object2.add(cubeDimensionHierarchyLevel);
            }
            CubeDimension cubeDimension = cubeDimensionHierarchy.getCubeDimension();
            object = object2.iterator();
            while (object.hasNext()) {
                CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = (CubeDimensionHierarchyLevel)object.next();
                cubeDimensionHierarchy.removeHierarchyLevel(cubeDimensionHierarchyLevel);
                cubeDimensionHierarchyLevel.setParent((DBObject)cubeDimension);
            }
            if ((!this.isEditing() || cubeDimensionHierarchy.isChanged(arrayList)) && this.m_levelTypeButton.isSelected()) {
                object = new ArrayList();
                for (CubeDimensionLevel cubeDimensionLevel : arrayList) {
                    void var10_19;
                    void var10_22;
                    Object var10_20 = null;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = (CubeDimensionHierarchyLevel)iterator.next();
                        if (cubeDimensionHierarchyLevel.getLevel() != cubeDimensionLevel) continue;
                        CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel2 = cubeDimensionHierarchyLevel;
                        break;
                    }
                    if (var10_22 == null) {
                        CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = new CubeDimensionHierarchyLevel(cubeDimensionHierarchy, cubeDimensionLevel);
                    } else {
                        var10_22.setLevel(cubeDimensionLevel);
                    }
                    object.add(var10_19);
                }
                cubeDimensionHierarchy.setHierarchyLevels(object.toArray(new CubeDimensionHierarchyLevel[object.size()]));
                this.restoreHierarchicalLevelVisibility(cubeDimensionHierarchy, (Map<String, CubeDimensionAttribute[]>)object3);
            }
        }
        if (this.isEditing() && cubeDimensionHierarchy.getViewName() == null) {
            object3 = (CubeDimensionHierarchy)this.getOriginalChildObject();
            if (object3 != null) {
                object2 = ((CubeDimensionHierarchy)object3).getViewName();
                cubeDimensionHierarchy.setViewName((String)object2);
            } else {
                void var9_18;
                object2 = (CubeDimension)this.getOriginalObject();
                CubeDimensionHierarchy[] cubeDimensionHierarchyArray = ((CubeDimension)object2).getHierarchies();
                object = cubeDimensionHierarchyArray;
                int n = ((CubeDimensionHierarchy[])object).length;
                boolean bl = false;
                while (var9_18 < n) {
                    Object object4 = object[var9_18];
                    if (object4.getName().equalsIgnoreCase(cubeDimensionHierarchy.getName()) && ((CubeDimensionHierarchy)object4).getHierarchyLevelType() == cubeDimensionHierarchy.getHierarchyLevelType()) {
                        cubeDimensionHierarchy.setViewName(((CubeDimensionHierarchy)object4).getViewName());
                        break;
                    }
                    ++var9_18;
                }
            }
        }
    }

    private Map<String, CubeDimensionAttribute[]> saveHierarchicalLevelVisibility(CubeDimensionHierarchy cubeDimensionHierarchy) {
        HashMap<String, CubeDimensionAttribute[]> hashMap = new HashMap<String, CubeDimensionAttribute[]>();
        for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
            hashMap.put(cubeDimensionHierarchyLevel.getLevel().getName(), cubeDimensionHierarchyLevel.getVisibleAttributes());
        }
        return hashMap;
    }

    private void restoreHierarchicalLevelVisibility(CubeDimensionHierarchy cubeDimensionHierarchy, Map<String, CubeDimensionAttribute[]> map) {
        for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchy.getHierarchyLevels()) {
            if (map.get(cubeDimensionHierarchyLevel.getLevel().getName()) == null) continue;
            cubeDimensionHierarchyLevel.setVisibleAttributes(map.get(cubeDimensionHierarchyLevel.getLevel().getName()));
        }
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.m_prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.loadHierarchy((CubeDimensionHierarchy)this.getChildObject());
    }

    private void layoutComponents() {
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"hierarchies"});
        this.m_skipLevelCheckBox = new JCheckBox();
        this.m_skipLevelCheckBox.setName("m_skipLevelCheckBox");
        this.m_raggedCheckBox = new JCheckBox();
        this.m_raggedCheckBox.setName("m_raggedCheckBox");
        this.registerDescriptionFields();
        this.m_lblName = new JLabel();
        this.m_lblName.setName("m_lblName");
        componentFactory.registerComponent(this.m_lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "Name", "name");
        this.m_levelTypeButton = new JRadioButton(OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_LEVEL_BASED"));
        this.m_levelTypeButton.setName("m_levelTypeButton");
        this.m_valueTypeButton = new JRadioButton(OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_VALUE_BASED"));
        this.m_valueTypeButton.setName("m_valueTypeButton");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_levelTypeButton);
        buttonGroup.add(this.m_valueTypeButton);
        componentFactory.registerComponent((AbstractButton)this.m_skipLevelCheckBox, OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_SKIP_LEVEL"), "notSkipLevel");
        componentFactory.registerComponent((AbstractButton)this.m_raggedCheckBox, OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_RAGGED"), "notRagged");
        this.getNameField().setColumns(30);
        this.shuttle = this.createShuttlePanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_PROPERTIES")));
        JPanel jPanel = new JPanel();
        jPanel.setName("nameAndDescriptionPanel");
        jPanel.setLayout(new GridBagLayout());
        int n = 1;
        this.add(new JLabel(OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_TYPE")), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 5), 0, 0));
        this.add(this.m_levelTypeButton, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 5), 0, 0));
        this.add(this.m_valueTypeButton, new GridBagConstraints(2, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 5), 0, 0));
        this.add(new JLabel(OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_DATA_CONSTRAINTS")), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 5), 0, 0));
        this.add(this.m_skipLevelCheckBox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 5), 0, 0));
        this.add(this.m_raggedCheckBox, new GridBagConstraints(2, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 5), 0, 0));
        this.add((Component)this.shuttle, new GridBagConstraints(0, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(1, 5, 0, 5), 0, 0));
        this.m_valueTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CubeDimensionHierarchyTableEditorPanel.this.isInitializing) {
                    CubeDimensionHierarchyTableEditorPanel.this.hierarchyTypeAction();
                }
            }
        });
        this.m_levelTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CubeDimensionHierarchyTableEditorPanel.this.isInitializing) {
                    CubeDimensionHierarchyTableEditorPanel.this.hierarchyTypeAction();
                }
            }
        });
    }

    private void hierarchyTypeAction() {
        boolean bl = this.m_levelTypeButton.isSelected();
        this.shuttle.setEnabled(bl);
        this.allObjectList.setEnabled(bl);
        this.selectedObjectList.setEnabled(bl);
        this.m_raggedCheckBox.setEnabled(bl);
        this.m_skipLevelCheckBox.setEnabled(bl);
        if (this.m_valueTypeButton.isSelected()) {
            this.m_selectedObjectListModel.clear();
            this.m_allObjectListModel.clear();
            for (CubeDimensionLevel cubeDimensionLevel : ((CubeDimension)this.getUpdatedObject()).getLevels()) {
                this.m_allObjectListModel.addElement(cubeDimensionLevel.getName());
            }
        }
    }

    private Shuttle createShuttlePanel() {
        this.m_allObjectListModel = new DefaultListModel();
        this.allObjectList = new JList(this.m_allObjectListModel);
        this.m_selectedObjectListModel = new DefaultListModel();
        this.selectedObjectList = new JList(this.m_selectedObjectListModel);
        Shuttle shuttle = new Shuttle();
        shuttle.setName("shuttle");
        shuttle.setButtonsShown(15);
        ReorderableListPicker reorderableListPicker = new ReorderableListPicker(this.selectedObjectList);
        shuttle.setToPicker((ItemPicker)reorderableListPicker);
        ListPicker listPicker = new ListPicker(this.allObjectList);
        shuttle.setFromPicker((ItemPicker)listPicker);
        String string = OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_AVAIL_LEVELS");
        JLabel jLabel = new JLabel(string);
        jLabel.setName("fromListLabel");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        shuttle.add((Component)jLabel, (Object)"FromHeader");
        jLabel.setLabelFor(listPicker.getList());
        string = OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_SELECTED_LEVELS");
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setName("toListLabel");
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        shuttle.add((Component)jLabel2, (Object)"ToHeader");
        shuttle.setMinimumSize(new Dimension(350, 125));
        jLabel2.setLabelFor(reorderableListPicker.getList());
        shuttle.setEnabled(true);
        this.selectedObjectList.setEnabled(true);
        this.allObjectList.setEnabled(true);
        return shuttle;
    }

    @Override
    public void processRemoveChildEvent(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        CubeDimension cubeDimension;
        if (abstractSchemaObjectWithDesc instanceof CubeDimension && (cubeDimension = (CubeDimension)abstractSchemaObjectWithDesc).getHierarchies().length == 0) {
            this.enableDescriptions(false);
        }
    }

    protected void validateObject() throws TraversalException {
    }
}

