/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.xml.xpath.XPathExpressionException;
import oracle.olap.app.Resources;
import oracle.olap.cubetemplate.ConflictRenameMap;
import oracle.olap.cubetemplate.ImportOptionsPanel;
import oracle.olap.cubetemplate.ObjectPreviewPanel;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TemplatePreprocessor;
import oracle.olap.cubetemplate.TreeNode;
import oracle.olap.cubetemplate.XMLPreviewPanel;
import oracle.xml.parser.v2.XMLParseException;

public class ReadTemplAccessoryPanel
extends JPanel {
    private final String newParent;
    private final String workspace;
    private final Resources resources;
    private final TemplatePreprocessor preprocessor;
    private TemplatePreprocessor parentless;
    private final String AW_NAME = "AW_NAME";
    private final String CUBE_NAME = "CUBE_NAME";
    protected JTabbedPane tabbedPane = new JTabbedPane();
    private ObjectPreviewPanel objPrePanel = null;
    private ImportOptionsPanel importOptsPanel = null;
    private XMLPreviewPanel xmlPrePanel = null;

    public ReadTemplAccessoryPanel(ObjectType objectType, String string, String string2, Resources resources) {
        this.tabbedPane.setName("tabbedPane");
        this.newParent = string2;
        this.workspace = string;
        this.resources = resources;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ConflictRenameMap conflictRenameMap = new ConflictRenameMap();
        if (string != null) {
            hashMap.put("AW_NAME", string);
            conflictRenameMap.addEntry(3, "__AW_NAME__");
            conflictRenameMap.updateEntryWithRename(3, "__AW_NAME__", string);
        } else {
            hashMap.put("AW_NAME", "__AW_NAME__");
        }
        if (string2 != null) {
            hashMap.put("CUBE_NAME", string2);
            conflictRenameMap.addEntry(2, "__CUBE_NAME__");
            conflictRenameMap.updateEntryWithRename(2, "__CUBE_NAME__", string2);
        } else {
            hashMap.put("CUBE_NAME", "__CUBE_NAME__");
        }
        this.preprocessor = new TemplatePreprocessor(hashMap, conflictRenameMap);
        this.jbInit();
        this.setObjectType(objectType);
    }

    public void clear() {
        this.xmlPrePanel.clear();
        this.objPrePanel.clear();
        this.preprocessor.clear();
        this.parentless = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadXML(File[] fileArray) {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        boolean bl = true;
        this.clear();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                fileInputStream = new FileInputStream(fileArray[i]);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                bl = this.loadPreprocessor(inputStreamReader, i == fileArray.length - 1 && bl) && bl;
                continue;
            }
            catch (Exception exception) {
                this.objPrePanel.showError(exception.getLocalizedMessage());
                bl = false;
                continue;
            }
            finally {
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private boolean loadPreprocessor(Reader reader, boolean bl) {
        boolean bl2 = false;
        try {
            TemplatePreprocessor templatePreprocessor = new TemplatePreprocessor(this.preprocessor.getBindMap(), this.preprocessor.getRenameMap());
            templatePreprocessor.preprocessDocument(reader);
            this.setEnabled(templatePreprocessor.is11g());
            bl2 = this.addPreprocessor(templatePreprocessor);
            if (bl && this.parentless != null) {
                bl2 = this.addPreprocessor(this.parentless);
            }
            if (bl2 && bl) {
                this.objPrePanel.configure(this.preprocessor, true);
            }
            if (bl) {
                this.xmlPrePanel.configure(this.preprocessor.getRawXMLTemplate());
            }
        }
        catch (XMLParseException xMLParseException) {
            if (xMLParseException.getMessage().contains("AW_NAME")) {
                this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.MISSING_AW"));
            } else if (xMLParseException.getMessage().contains("CUBE_NAME")) {
                this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.MISSING_CUBE"));
            } else if (xMLParseException.getMessage().contains("--")) {
                this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.DOUBLEDASH", String.valueOf(xMLParseException.getLineNumber())));
            } else {
                this.objPrePanel.showError(xMLParseException.getLocalizedMessage());
            }
        }
        catch (Exception exception) {
            this.objPrePanel.showError(exception.getLocalizedMessage());
        }
        return bl2;
    }

    private boolean addPreprocessor(TemplatePreprocessor templatePreprocessor) throws XPathExpressionException {
        if (templatePreprocessor == null) {
            return true;
        }
        boolean bl = false;
        if (this.preprocessor.isLoaded() && this.preprocessor.getTemplateType() == ObjectType.WORKSPACE) {
            this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.CANT.MERGE.WORKSPACE.TEMPLATES"));
            return false;
        }
        switch (templatePreprocessor.getTemplateType()) {
            case CUBE: 
            case DIMENSION: 
            case MEASURE_FOLDER: {
                boolean bl2 = bl = this.workspace != null;
                if (bl) {
                    this.preprocessor.addTemplate(templatePreprocessor);
                    break;
                }
                this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.MISSING_AW"));
                break;
            }
            case MEASURE: 
            case DERIVED_MEASURE: {
                boolean bl3 = bl = this.newParent != null;
                if (bl) {
                    this.preprocessor.addTemplate(templatePreprocessor, ObjectType.CUBE);
                } else if (this.preprocessor.isLoaded() && this.preprocessor.getObjects(ObjectType.CUBE, null).size() > 0 && this.preprocessor.getTemplateType() != ObjectType.WORKSPACE) {
                    this.preprocessor.addTemplate(templatePreprocessor);
                    bl = true;
                } else if (this.parentless != templatePreprocessor) {
                    bl = true;
                    if (this.parentless == null) {
                        this.parentless = templatePreprocessor;
                    } else {
                        this.parentless.addTemplate(templatePreprocessor);
                    }
                }
                if (bl) break;
                this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.MISSING_CUBE"));
                break;
            }
            case ALL: {
                boolean bl4 = bl = !this.hasPendingRenames(templatePreprocessor);
                if (!bl) {
                    this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.MISSING_CUBE"));
                    break;
                }
                this.preprocessor.addTemplate(templatePreprocessor, ObjectType.ALL);
                break;
            }
            case WORKSPACE: {
                if (this.preprocessor.isLoaded()) {
                    this.objPrePanel.showError(this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.CANT.MERGE.WORKSPACE.TEMPLATES"));
                    bl = false;
                    break;
                }
                this.preprocessor.addTemplate(templatePreprocessor);
                bl = true;
            }
        }
        return bl;
    }

    public boolean loadXml(String[] stringArray) {
        boolean bl = true;
        this.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            bl = this.loadPreprocessor(new StringReader(stringArray[i]), i == stringArray.length - 1 && bl) && bl;
        }
        return bl;
    }

    public boolean modifyIfExists() {
        return this.importOptsPanel.modifyIfExists();
    }

    public boolean includeOLAPDML() {
        return this.importOptsPanel.includeOLAPDML();
    }

    public TemplatePreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        this.tabbedPane.setPreferredSize(new Dimension(400, 200));
        this.objPrePanel = new ObjectPreviewPanel(this.resources);
        this.objPrePanel.setName("objPrePanel");
        this.tabbedPane.addTab(this.resources.getString("READ_FROM_TEMPLATE_DLG.OBJECTS_TAB_TITLE"), this.objPrePanel);
        this.xmlPrePanel = new XMLPreviewPanel(this.resources);
        this.xmlPrePanel.setName("xmlPrePanel");
        this.tabbedPane.addTab(this.resources.getString("READ_FROM_TEMPLATE_DLG.XML_TAB_TITLE"), this.xmlPrePanel);
        this.importOptsPanel = new ImportOptionsPanel(this.resources);
        this.importOptsPanel.setName("importOptsPanel");
        this.tabbedPane.addTab(this.resources.getString("SAVE_TO_TEMPLATE_DLG.OPTIONS_TAB_TITLE"), this.importOptsPanel);
    }

    public void setObjectType(ObjectType objectType) {
        switch (objectType) {
            case WORKSPACE: {
                this.importOptsPanel.setModifyIfExists(false, false);
                break;
            }
            case MEASURE: 
            case DERIVED_MEASURE: {
                this.importOptsPanel.setModifyIfExists(true, false);
                break;
            }
            default: {
                boolean bl;
                try {
                    bl = this.preprocessor.getPartialCubes().size() > 0;
                }
                catch (XPathExpressionException xPathExpressionException) {
                    bl = false;
                }
                this.importOptsPanel.setModifyIfExists(bl, true);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!bl) {
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setEnabledAt(2, false);
        } else {
            this.tabbedPane.setEnabledAt(0, true);
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setEnabledAt(2, true);
        }
        super.setEnabled(bl);
    }

    private boolean hasPendingRenames(TemplatePreprocessor templatePreprocessor) throws XPathExpressionException {
        for (TreeNode treeNode : templatePreprocessor.getPartialCubes()) {
            if (!treeNode.getUserObject().equals("__CUBE_NAME__")) continue;
            return true;
        }
        return false;
    }

    public boolean isMeasuresInserted() {
        return this.parentless != null;
    }
}

