/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.awt.Component;
import java.net.URL;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.olap.dml.editor.OLAPDMLController;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLContextMenu
implements ContextMenuListener {
    private ContextMenu _popup;
    private final String IDE_CONTEXT_MENU_RUN_COMMAND_NAME = "ContextMenuRunCommand";
    private final String IDE_CONTEXT_MENU_DEBUG_COMMAND_NAME = "ContextMenuDebugCommand";
    private final String IDE_CONTEXT_MENU_PROFILE_COMMAND_NAME = "ProfileSelectionCommand";

    public void menuWillShow(ContextMenu contextMenu) {
        this._popup = contextMenu;
        contextMenu.addMenuFilter(new MenuFilter(){

            public boolean accept(Component component) {
                if (!(component instanceof JMenuItem)) {
                    return true;
                }
                if (((JMenuItem)component).getAction() != null && ((JMenuItem)component).getAction() instanceof IdeAction) {
                    Node node;
                    IdeAction ideAction = (IdeAction)((JMenuItem)component).getAction();
                    if (ideAction.getCommandId() == Ide.findCmdID((String)"ContextMenuRunCommand").intValue() || ideAction.getCommandId() == Ide.findOrCreateCmdID((String)"ContextMenuDebugCommand")) {
                        return false;
                    }
                    Context context = OLAPDMLContextMenu.this._popup.getContext();
                    if (context != null && (node = context.getNode()) instanceof OLAPDMLNode && ideAction.getCommandId() == Ide.findOrCreateCmdID((String)"ProfileSelectionCommand")) {
                        return false;
                    }
                }
                return true;
            }
        });
        Context context = contextMenu.getContext();
        View view = context.getView();
        Node node = context.getNode();
        if (node == null) {
            return;
        }
        String string = node.getShortLabel();
        if (string != null && string.toLowerCase().startsWith("anon_block")) {
            return;
        }
        if (!(node instanceof OLAPDMLNode)) {
            return;
        }
        URL uRL = node.getURL();
        if (uRL.toString().toLowerCase().startsWith("sqldev.migration")) {
            return;
        }
        IdeAction ideAction = IdeAction.find((int)OLAPDMLController.COMPILE_COMMAND);
        if (ideAction != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        OLAPDMLController.updateAction(ideAction, (OLAPDMLNode)node);
        OLAPDMLController.updateAction(ideAction, (OLAPDMLNode)node);
        ideAction = IdeAction.find((int)OLAPDMLController.RUN_COMMAND);
        if (ideAction != null) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        }
        OLAPDMLController.updateAction(ideAction, (OLAPDMLNode)node);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

