/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers.language;

import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.parser.plsql.PlsqlTokens;
import oracle.javatools.parser.plsql.SqlKeywords;
import oracle.olap.OLAPArb;

public final class OLAPIStyles {
    public static final String OLAPI_COMMENT_STYLE = "olapi-comment-style";
    public static final String OLAPI_KEYWORD_STYLE = "olapi-keyword-style";
    public static final String OLAPI_IDENTIFIER_STYLE = "olapi-identifier-style";
    public static final String OLAPI_STRING_STYLE = "olapi-string-style";
    public static final String OLAPI_NUMBER_STYLE = "olapi-number-style";
    public static final String OLAPI_BRACE_STYLE = "olapi-brace-style";
    public static final String OLAPI_OPERATOR_STYLE = "olapi-operator-style";
    public static final String[] STYLE_NAMES = new String[]{"olapi-comment-style", "olapi-keyword-style", "olapi-identifier-style", "olapi-string-style", "olapi-number-style", "olapi-brace-style", "olapi-operator-style"};
    public static BaseStyle OLAPIPlainStyle;
    public static BaseStyle OLAPICommentStyle;
    public static BaseStyle OLAPIKeywordStyle;
    public static BaseStyle OLAPIIdentifierStyle;
    public static BaseStyle OLAPIStringStyle;
    public static BaseStyle OLAPINumberStyle;
    public static BaseStyle OLAPIBraceStyle;
    public static BaseStyle OLAPIOperatorStyle;

    public OLAPIStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String string;
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        OLAPIPlainStyle = builtInStyles.plainStyle;
        OLAPICommentStyle = styleRegistry.lookupStyle(OLAPI_COMMENT_STYLE);
        if (OLAPICommentStyle == null) {
            string = OLAPArb.getString("OLAPI_COMMENT_STYLE");
            OLAPICommentStyle = styleRegistry.createStyle(OLAPI_COMMENT_STYLE, string, "base-comment-style");
        }
        if ((OLAPIStringStyle = styleRegistry.lookupStyle(OLAPI_STRING_STYLE)) == null) {
            string = OLAPArb.getString("OLAPI_STRING_STYLE");
            OLAPIStringStyle = styleRegistry.createStyle(OLAPI_STRING_STYLE, string, "base-string-style");
        }
        if ((OLAPIKeywordStyle = styleRegistry.lookupStyle(OLAPI_KEYWORD_STYLE)) == null) {
            string = OLAPArb.getString("OLAPI_KEYWORD_STYLE");
            OLAPIKeywordStyle = styleRegistry.createStyle(OLAPI_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((OLAPIIdentifierStyle = styleRegistry.lookupStyle(OLAPI_IDENTIFIER_STYLE)) == null) {
            string = OLAPArb.getString("OLAPI_IDENTIFIER_STYLE");
            OLAPIIdentifierStyle = styleRegistry.createStyle(OLAPI_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((OLAPINumberStyle = styleRegistry.lookupStyle(OLAPI_NUMBER_STYLE)) == null) {
            string = OLAPArb.getString("OLAPI_NUMBER_STYLE");
            OLAPINumberStyle = styleRegistry.createStyle(OLAPI_NUMBER_STYLE, string, "base-number-style");
        }
        if ((OLAPIBraceStyle = styleRegistry.lookupStyle(OLAPI_BRACE_STYLE)) == null) {
            string = OLAPArb.getString("OLAPI_BRACE_STYLE");
            OLAPIBraceStyle = styleRegistry.createStyle(OLAPI_BRACE_STYLE, string, "base-brace-style");
        }
        if ((OLAPIOperatorStyle = styleRegistry.lookupStyle(OLAPI_OPERATOR_STYLE)) == null) {
            string = OLAPArb.getString("OLAPI_OPERATOR_STYLE");
            OLAPIOperatorStyle = styleRegistry.createStyle(OLAPI_OPERATOR_STYLE, string, "base-operator-style");
        }
    }

    public static String highlightSyntax(String string) {
        List list = LexerToken.parse((String)string, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (LexerToken lexerToken : list) {
            if (lexerToken.type == Token.IDENTIFIER && OLAPIStyles.isKeyword(lexerToken.content)) {
                stringBuilder.append(OLAPIStyles.sugarcoat(lexerToken.content));
                continue;
            }
            stringBuilder.append(lexerToken.content);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String sugarcoat(String string) {
        return "<font color=#005577><b>" + string + "</b></font>";
    }

    public static boolean isKeyword(String string) {
        for (String string2 : SqlKeywords.KW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : SqlKeywords.DW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        for (String string2 : PlsqlTokens.KW_words) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

