/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LineNumberTableRowHeader
extends JComponent {
    private final JTable table;
    private final JScrollPane scrollPane;

    public LineNumberTableRowHeader(JScrollPane jScrollPane, JTable jTable) {
        this.scrollPane = jScrollPane;
        this.table = jTable;
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                LineNumberTableRowHeader.this.repaint();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LineNumberTableRowHeader.this.repaint();
            }
        });
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                LineNumberTableRowHeader.this.repaint();
            }
        });
        this.setPreferredSize(new Dimension(50, 100));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Serializable serializable;
        Point point = this.scrollPane.getViewport().getViewPosition();
        Dimension dimension = this.scrollPane.getViewport().getViewSize();
        if (this.getHeight() < dimension.height) {
            serializable = this.getPreferredSize();
            ((Dimension)serializable).height = dimension.height;
            this.setSize((Dimension)serializable);
            this.setPreferredSize((Dimension)serializable);
        }
        super.paintComponent(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        serializable = graphics.getFontMetrics();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Rectangle rectangle = this.table.getCellRect(i, 0, false);
            boolean bl = this.table.isRowSelected(i);
            if (bl) {
                graphics.setColor(this.table.getSelectionBackground());
                graphics.fillRect(0, rectangle.y, this.getWidth(), rectangle.height);
            }
            if (rectangle.y + rectangle.height - point.y < 0 || rectangle.y >= point.y + dimension.height) continue;
            graphics.setColor(this.table.getGridColor());
            graphics.drawLine(0, rectangle.y + rectangle.height, this.getWidth(), rectangle.y + rectangle.height);
            graphics.setColor(bl ? this.table.getSelectionForeground() : this.getForeground());
            String string = Integer.toString(i + 1);
            graphics.drawString(string, this.getWidth() - ((FontMetrics)serializable).stringWidth(string) - 8, rectangle.y + rectangle.height - ((FontMetrics)serializable).getDescent());
        }
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

