/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.JCheckBoxMenuItemNoClose;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.util.TextHighlighter;

public class SearchTool
implements SearchListener {
    private SearchField searchField;
    private JPopupMenu searchMenu;
    private BasicEditorPane textPane;
    private final TextHighlighter textHighlighter;
    private SearchOptions searchOptions;
    private JScrollPane pane;
    private JPopupMenu notFoundTextPopup;
    private final JCheckBoxMenuItemNoClose[] menuOptions = new JCheckBoxMenuItemNoClose[]{new JCheckBoxMenuItemNoClose(OLAPArb.getString("SEARCHOPTIONS.MATCH_CASE")), new JCheckBoxMenuItemNoClose(OLAPArb.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD")), new JCheckBoxMenuItemNoClose(OLAPArb.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES"))};
    private static final int MATCH_CASE = 0;
    private static final int WHOLE_WORD = 1;
    private static final int HIGHLIGHT_OCCURRENCES = 2;

    public SearchTool(BasicEditorPane basicEditorPane, JScrollPane jScrollPane) {
        this.textPane = basicEditorPane;
        this.pane = jScrollPane;
        OLAPResources oLAPResources = new OLAPResources("/oracle/olap/app/calcfactory/ui/calcs.xml");
        this.searchField = new SearchField();
        this.searchField.setStyle(SearchField.Style.FIND);
        Dimension dimension = new Dimension(225, (int)this.searchField.getPreferredSize().getHeight());
        this.searchField.setMinimumSize(dimension);
        this.searchField.setMaximumSize(dimension);
        this.searchField.setPreferredSize(dimension);
        this.notFoundTextPopup = new JPopupMenu();
        this.searchMenu = new JPopupMenu();
        for (int i = 0; i < this.menuOptions.length; ++i) {
            this.searchMenu.add((JMenuItem)this.menuOptions[i]);
        }
        this.menuOptions[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTool.this.searchOptions.set(OLAPArb.getString("SEARCHOPTIONS.MATCH_CASE"), SearchTool.this.menuOptions[0].isSelected());
            }
        });
        this.menuOptions[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTool.this.searchOptions.set(OLAPArb.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD"), SearchTool.this.menuOptions[1].isSelected());
            }
        });
        this.menuOptions[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTool.this.searchOptions.set(OLAPArb.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES"), SearchTool.this.menuOptions[2].isSelected());
            }
        });
        this.searchField.setCategoriesPopup(this.searchMenu);
        this.searchField.setAutoFind(true);
        this.searchField.setTypingDelay(SearchField.TypingDelay.FAST);
        this.searchField.addSearchListener((SearchListener)this);
        this.searchField.setPopDownAction((Action)new AbstractAction("", new ImageIcon()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTool.this.searchMenu.show((Component)SearchTool.this.searchField, (int)SearchTool.this.searchField.getAlignmentX(), (int)SearchTool.this.searchField.getAlignmentY() + (int)SearchTool.this.searchField.getPreferredSize().getHeight());
            }
        });
        this.searchOptions = new SearchOptions(oLAPResources);
        this.searchOptions.set(OLAPArb.getString("SEARCHOPTIONS.MATCH_CASE"), false);
        this.searchOptions.set(OLAPArb.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD"), false);
        this.searchOptions.set(OLAPArb.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES"), false);
        this.textHighlighter = new TextHighlighter(this.textPane, this.searchOptions, oLAPResources){

            @Override
            public void showPopupMessage(String string) {
                int n;
                int n2 = SearchTool.this.notFoundTextPopup.getSubElements().length;
                if (n2 > 0) {
                    for (n = 0; n < n2; ++n) {
                        SearchTool.this.notFoundTextPopup.remove(0);
                    }
                }
                if ((n = string.indexOf("\n")) > 0) {
                    SearchTool.this.notFoundTextPopup.add(string.substring(0, n - 1));
                    SearchTool.this.notFoundTextPopup.add(string.substring(n + 1, string.length()));
                } else {
                    SearchTool.this.notFoundTextPopup.add(string);
                }
                SearchTool.this.notFoundTextPopup.show((Component)SearchTool.this.searchField, 0, SearchTool.this.searchField.getY() + (int)SearchTool.this.searchField.getPreferredSize().getHeight());
                SearchTool.this.notFoundTextPopup.setBorder(BorderFactory.createLineBorder(new Color(194, 210, 233)));
                MenuElement[] menuElementArray = SearchTool.this.notFoundTextPopup.getSubElements();
                UIManager.put("MenuItem.disabledForeground", Color.BLACK);
                for (int i = 0; i < menuElementArray.length; ++i) {
                    menuElementArray[i].getComponent().setEnabled(false);
                    menuElementArray[i].getComponent().setBackground(new Color(183, 203, 234));
                }
                SearchTool.this.searchField.requestFocus();
            }

            @Override
            public void updateScrollPosition(int n) {
                JScrollBar jScrollBar = SearchTool.this.pane.getVerticalScrollBar();
                double d = (double)n / 100.0;
                double d2 = (double)jScrollBar.getMaximum() * d;
                jScrollBar.setValue((int)d2);
            }
        };
        this.searchField.setPrompt(OLAPArb.getString("DIALOG_FIND"));
    }

    public SearchField getSearchField() {
        return this.searchField;
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this.notFoundTextPopup.setVisible(false);
        try {
            if (searchEvent.isTriggeredByKeypress()) {
                if (!this.searchOptions.getMap().get(OLAPArb.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES")).booleanValue()) {
                    this.textHighlighter.highlightText(new KeyEvent((Component)this.searchField, 0, 0L, 0, 0, ' '), searchEvent.getSearchText());
                } else {
                    this.textHighlighter.highlightAllOccurrences(searchEvent.getSearchText());
                }
            } else if (!this.searchOptions.getMap().get(OLAPArb.getString("SEARCHOPTIONS.HIGHLIGHT_OCCURRENCES")).booleanValue()) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                searchEvent.getDirection();
                if (direction.equals((Object)SearchEvent.Direction.FORWARD)) {
                    this.textHighlighter.highlightText(new ActionEvent(this.searchField, 0, "searchfwd"), searchEvent.getSearchText());
                } else {
                    this.textHighlighter.highlightText(new ActionEvent(this.searchField, 0, "searchbck"), searchEvent.getSearchText());
                }
            } else {
                this.textHighlighter.highlightAllOccurrences(searchEvent.getSearchText());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    public void dispose() {
        this.textHighlighter.dispose();
    }
}

