/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public final class ContentSetKey {
    private final Workspace workspace;
    private final Project project;
    private final String contentSetKey;

    public static ContentSetKey getInstance(Workspace workspace) {
        return new ContentSetKey(workspace, null, null);
    }

    public static ContentSetKey getInstance(Workspace workspace, String contentSetKey) {
        return new ContentSetKey(workspace, null, contentSetKey);
    }

    public static ContentSetKey getInstance(Workspace workspace, Project project) {
        return new ContentSetKey(workspace, project, null);
    }

    public static ContentSetKey getInstance(Workspace workspace, Project project, String contentSetKey) {
        return new ContentSetKey(workspace, project, contentSetKey);
    }

    private ContentSetKey(Workspace workspace, Project project, String contentSetKey) {
        this.workspace = workspace;
        this.project = project;
        this.contentSetKey = contentSetKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentSetKey)) {
            return false;
        }
        ContentSetKey other = (ContentSetKey)o;
        return (this.project == null ? other.project == null : this.project.equals((Object)other.project)) && this.workspace.equals((Object)other.workspace) && (this.contentSetKey == null ? other.contentSetKey == null : this.contentSetKey.equals(other.contentSetKey));
    }

    public int hashCode() {
        int hashCode = 21;
        if (this.project != null) {
            hashCode = 31 * hashCode + this.project.hashCode();
        }
        hashCode = 31 * hashCode + this.workspace.hashCode();
        if (this.contentSetKey != null) {
            hashCode = 31 * hashCode + this.contentSetKey.hashCode();
        }
        return hashCode;
    }
}

