/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.compare.CompareHintListener;

public class CompareHints {
    private static final String KEY_WHITE_SPACE = "white-space";
    private static final String KEY_CHAR_DIFF = "char-diff";
    private static boolean ignoreWhiteSpace = true;
    private static boolean showCharDifferences = false;
    private static List listeners = new ArrayList();

    private CompareHints() {
    }

    public static void addListener(CompareHintListener cl) {
        if (!listeners.contains(cl)) {
            listeners.add(cl);
        }
    }

    public static void removeListener(CompareHintListener cl) {
        listeners.remove(cl);
    }

    public static void setIgnoreWhiteSpace(boolean ignoreWhiteSp) {
        boolean updated = ignoreWhiteSpace != ignoreWhiteSp;
        ignoreWhiteSpace = ignoreWhiteSp;
        if (updated) {
            CompareHints.hintUpdated(KEY_WHITE_SPACE);
        }
    }

    public static boolean isIgnoreWhiteSpace() {
        return ignoreWhiteSpace;
    }

    public static void setShowCharDifferences(boolean showCharDiff) {
        boolean updated = showCharDifferences != showCharDiff;
        showCharDifferences = showCharDiff;
        if (updated) {
            CompareHints.hintUpdated(KEY_CHAR_DIFF);
        }
    }

    public static boolean isShowCharDifferences() {
        return showCharDifferences;
    }

    private static void hintUpdated(String key) {
        for (Object obj : listeners) {
            if (obj == null) continue;
            ((CompareHintListener)obj).CompareHintUpdated(key);
        }
    }
}

