/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.Structure;

public final class ChangeInfo {
    public static final int VALUE_MODIFIED = 0;
    public static final int VALUE_ADDED = 1;
    public static final int PLACEHOLDER_VALUE_ADDED = 2;
    public static final int VALUE_REMOVED = 3;
    public static final int HASH_STRUCTURE = 0;
    public static final int LIST_STRUCTURE = 1;
    public static final int UNKNOWN_STRUCTURE = -1;
    private final int _changeType;
    private final int _parentStructureType;
    private final String _propertyName;
    private final Structure _valueParent;
    private final Object _oldValue;
    private final Object _newValue;

    private ChangeInfo(int changeType, String propertyName, Structure valueParent, Object oldValue, Object newValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        this._changeType = changeType;
        this._parentStructureType = valueParent instanceof HashStructure ? 0 : (valueParent instanceof ListStructure ? 1 : -1);
        this._propertyName = propertyName;
        this._valueParent = valueParent;
        this._oldValue = ChangeInfo.maybeCopyValue(oldValue);
        this._newValue = ChangeInfo.maybeCopyValue(newValue);
    }

    private ChangeInfo(String newPropertyName, int changeType, int parentStructureType, Structure valueParent, Object oldValue, Object newValue) {
        if (newPropertyName == null) {
            throw new IllegalArgumentException();
        }
        this._propertyName = newPropertyName;
        this._changeType = changeType;
        this._parentStructureType = parentStructureType;
        this._valueParent = valueParent;
        this._oldValue = oldValue;
        this._newValue = newValue;
    }

    ChangeInfo replaceName(String newName) {
        return new ChangeInfo(newName, this._changeType, this._parentStructureType, this._valueParent, this._oldValue, this._newValue);
    }

    private static Object maybeCopyValue(Object orig) {
        if (orig instanceof HashStructure) {
            return ((HashStructure)orig).copyTo(null);
        }
        if (orig instanceof ListStructure) {
            return ((ListStructure)orig).copyTo(null);
        }
        return orig;
    }

    static ChangeInfo valueModified(String propertyName, Structure valueParent, Object oldValue, Object newValue) {
        return new ChangeInfo(0, propertyName, valueParent, oldValue, newValue);
    }

    static ChangeInfo valueAdded(String propertyName, Structure valueParent, Object newValue) {
        return new ChangeInfo(1, propertyName, valueParent, null, newValue);
    }

    static ChangeInfo placeholderValueAdded(String propertyName, Structure valueParent, Object newValue) {
        return new ChangeInfo(2, propertyName, valueParent, null, newValue);
    }

    static ChangeInfo valueRemoved(String propertyName, Structure valueParent, Object oldValue) {
        return new ChangeInfo(3, propertyName, valueParent, oldValue, null);
    }

    public int getChangeType() {
        return this._changeType;
    }

    public int getParentStructureType() {
        return this._parentStructureType;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public String getPropertyLocalName() {
        int lastSlash = this._propertyName.lastIndexOf(47);
        return this._propertyName.substring(lastSlash + 1);
    }

    public boolean isEventForList(String listStructureName) {
        if (this._parentStructureType == 0) {
            return this._propertyName.equals(listStructureName);
        }
        return this._parentStructureType == 1 && this._propertyName.startsWith(listStructureName + "/") && this._propertyName.lastIndexOf(47) == listStructureName.length();
    }

    public HashStructure getParentAsHashStructure() {
        return this._parentStructureType == 0 ? (HashStructure)this._valueParent : null;
    }

    public ListStructure getParentAsListStructure() {
        return this._parentStructureType == 1 ? (ListStructure)this._valueParent : null;
    }

    public Object getOldValue() {
        return this._oldValue;
    }

    public Boolean getOldValueAsBoolean() {
        return ChangeInfo.toBoolean(this._oldValue);
    }

    public String getOldValueAsString() {
        return ChangeInfo.toString(this._oldValue);
    }

    public int getOldValueAsInt() {
        return ChangeInfo.toInt(this._oldValue);
    }

    public long getOldValueAsLong() {
        return ChangeInfo.toLong(this._oldValue);
    }

    public float getOldValueAsFloat() {
        return ChangeInfo.toFloat(this._oldValue);
    }

    public double getOldValueAsDouble() {
        return ChangeInfo.toDouble(this._oldValue);
    }

    public URL getOldValueAsURL() {
        return ChangeInfo.toURL(this._oldValue);
    }

    public HashStructure getOldValueAsHashStructure() {
        return ChangeInfo.toHashStructure(this._oldValue);
    }

    public ListStructure getOldValueAsListStructure() {
        return ChangeInfo.toListStructure(this._oldValue);
    }

    public String getNewValueAsString() {
        return ChangeInfo.toString(this._newValue);
    }

    public Object getNewValue() {
        return this._newValue;
    }

    public int getNewValueAsInt() {
        return ChangeInfo.toInt(this._newValue);
    }

    public long getNewValueAsLong() {
        return ChangeInfo.toLong(this._newValue);
    }

    public float getNewValueAsFloat() {
        return ChangeInfo.toFloat(this._newValue);
    }

    public double getNewValueAsDouble() {
        return ChangeInfo.toDouble(this._newValue);
    }

    public Boolean getNewValueAsBoolean() {
        return ChangeInfo.toBoolean(this._newValue);
    }

    public URL getNewValueAsURL() {
        return ChangeInfo.toURL(this._newValue);
    }

    public HashStructure getNewValueAsHashStructure() {
        return ChangeInfo.toHashStructure(this._newValue);
    }

    public ListStructure getNewValueAsListStructure() {
        return ChangeInfo.toListStructure(this._newValue);
    }

    public String toString() {
        switch (this._changeType) {
            case 0: {
                return "VALUE_MODIFIED: name='" + this._propertyName + "', old='" + this.getOldValueAsString() + "', new='" + this.getNewValueAsString() + "'";
            }
            case 1: {
                return "VALUE_ADDED: name='" + this._propertyName + "', new='" + this.getNewValueAsString() + "'";
            }
            case 2: {
                return "PLACEHOLDER_VALUE_ADDED: name='" + this._propertyName + "', new='" + this.getNewValueAsString() + "'";
            }
            case 3: {
                return "VALUE_REMOVED: name='" + this._propertyName + "', old='" + this.getOldValueAsString() + "'";
            }
        }
        return super.toString();
    }

    private static String toString(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    private static int toInt(Object obj) {
        return obj != null ? Integer.parseInt(obj.toString()) : 0;
    }

    private static long toLong(Object obj) {
        return obj != null ? Long.parseLong(obj.toString()) : 0L;
    }

    private static float toFloat(Object obj) {
        return obj != null ? Float.parseFloat(obj.toString()) : 0.0f;
    }

    private static double toDouble(Object obj) {
        return obj != null ? Double.parseDouble(obj.toString()) : 0.0;
    }

    private static URL toURL(Object obj) {
        return obj instanceof URL ? (URL)obj : null;
    }

    private static HashStructure toHashStructure(Object obj) {
        return obj instanceof HashStructure ? (HashStructure)obj : null;
    }

    private static ListStructure toListStructure(Object obj) {
        return obj instanceof ListStructure ? (ListStructure)obj : null;
    }

    private static Boolean toBoolean(Object obj) {
        return obj != null ? Boolean.valueOf(Boolean.parseBoolean(obj.toString())) : null;
    }
}

